package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ScaleTab extends RangeTab {
  internal var scale1: Scale;
  internal var scaleGroup: Group;
  internal var incrementSpinner: Spinner;
  internal var pageIncrementSpinner: Spinner;
  function ScaleTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createControlWidgets__(): void {
    super.createControlWidgets__();
    this.createIncrementGroup__();
    this.createPageIncrementGroup__();
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    scaleGroup = new Group(exampleGroup, 0);
    scaleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    scaleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    scaleGroup.setText__Ljava_lang_String_2("Scale");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (borderButton.getSelection__())
      style |= 2048;
    scale1 = new Scale(scaleGroup, style);
    return;
  }
  public function createIncrementGroup__(): void {
    var incrementGroup: Group = new Group(controlGroup, 0);
    incrementGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    incrementGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Increment"));
    incrementGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    incrementSpinner = new Spinner(incrementGroup, 2048);
    incrementSpinner.setMaximum__I(100000);
    incrementSpinner.setSelection__I(this.getDefaultIncrement__());
    incrementSpinner.setPageIncrement__I(100);
    incrementSpinner.setIncrement__I(1);
    incrementSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    incrementSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ScaleTab$1(this));
    return;
  }
  public function createPageIncrementGroup__(): void {
    var pageIncrementGroup: Group = new Group(controlGroup, 0);
    pageIncrementGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    pageIncrementGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Page_Increment"));
    pageIncrementGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    pageIncrementSpinner = new Spinner(pageIncrementGroup, 2048);
    pageIncrementSpinner.setMaximum__I(100000);
    pageIncrementSpinner.setSelection__I(this.getDefaultPageIncrement__());
    pageIncrementSpinner.setPageIncrement__I(100);
    pageIncrementSpinner.setIncrement__I(1);
    pageIncrementSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    pageIncrementSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ScaleTab$2(this));
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(scale1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Selection", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Scale";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    if (!instance.startup) {
      this.setWidgetIncrement__();
      this.setWidgetPageIncrement__();
    }
    return;
  }
  public override function getDefaultMaximum__(): int {
    return scale1.getMaximum__();
  }
  public override function getDefaultMinimum__(): int {
    return scale1.getMinimum__();
  }
  public override function getDefaultSelection__(): int {
    return scale1.getSelection__();
  }
  public function getDefaultIncrement__(): int {
    return scale1.getIncrement__();
  }
  public function getDefaultPageIncrement__(): int {
    return scale1.getPageIncrement__();
  }
  public function setWidgetIncrement__(): void {
    scale1.setIncrement__I(incrementSpinner.getSelection__());
  }
  public override function setWidgetMaximum__(): void {
    scale1.setMaximum__I(maximumSpinner.getSelection__());
  }
  public override function setWidgetMinimum__(): void {
    scale1.setMinimum__I(minimumSpinner.getSelection__());
  }
  public function setWidgetPageIncrement__(): void {
    scale1.setPageIncrement__I(pageIncrementSpinner.getSelection__());
  }
  public override function setWidgetSelection__(): void {
    scale1.setSelection__I(selectionSpinner.getSelection__());
  }
}
}
