package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import java.lang.JavaArray;
dynamic public class ScrollableTab extends Tab {
  internal var singleButton: Button;
  internal var multiButton: Button;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  function ScrollableTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    singleButton = new Button(styleGroup, 16);
    singleButton.setText__Ljava_lang_String_2("SWT.SINGLE");
    multiButton = new Button(styleGroup, 16);
    multiButton.setText__Ljava_lang_String_2("SWT.MULTI");
    horizontalButton = new Button(styleGroup, 32);
    horizontalButton.setText__Ljava_lang_String_2("SWT.H_SCROLL");
    horizontalButton.setSelection__Z(true);
    verticalButton = new Button(styleGroup, 32);
    verticalButton.setText__Ljava_lang_String_2("SWT.V_SCROLL");
    verticalButton.setSelection__Z(true);
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    var widgets: JavaArray = this.getExampleWidgets__();
    if (widgets.length != 0) {
      singleButton.setSelection__Z((widgets[0].getStyle__() & 4) != 0);
      multiButton.setSelection__Z((widgets[0].getStyle__() & 2) != 0);
      horizontalButton.setSelection__Z((widgets[0].getStyle__() & 256) != 0);
      verticalButton.setSelection__Z((widgets[0].getStyle__() & 512) != 0);
      borderButton.setSelection__Z((widgets[0].getStyle__() & 2048) != 0);
    }
    return;
  }
}
}
