package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.System;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ShellTab extends Tab {
  internal var noParentButton: Button;
  internal var parentButton: Button;
  internal var noTrimButton: Button;
  internal var closeButton: Button;
  internal var titleButton: Button;
  internal var minButton: Button;
  internal var maxButton: Button;
  internal var borderButton_org_eclipse_swt_examples_controlexample_ShellTab: Button;
  internal var resizeButton: Button;
  internal var onTopButton: Button;
  internal var toolButton: Button;
  internal var createButton: Button;
  internal var closeAllButton: Button;
  internal var modelessButton: Button;
  internal var primaryModalButton: Button;
  internal var applicationModalButton: Button;
  internal var systemModalButton: Button;
  internal var imageButton: Button;
  internal var parentStyleGroup: Group;
  internal var modalStyleGroup: Group;
  internal var shellCount: int = 0;
  internal var shells: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(4);
  function ShellTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public function closeAllShells__(): void {
    for (var i: int = 0; i < shellCount; i++) {
      if ((shells[i] !== null) ? (!shells[i].isDisposed__()) : (!shells[i].isDisposed__(), false)) {
        shells[i].dispose__();
      }
    }
    shellCount = 0;
    return;
  }
  public function createButtonSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    if (shellCount >= shells.length) {
      var newShells: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(shells.length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(shells, 0, newShells, 0, shells.length);
      shells = newShells;
    }
    var style: int = 0;
    if (noTrimButton.getSelection__())
      style |= 8;
    if (closeButton.getSelection__())
      style |= 64;
    if (titleButton.getSelection__())
      style |= 32;
    if (minButton.getSelection__())
      style |= 128;
    if (maxButton.getSelection__())
      style |= 1024;
    if (borderButton_org_eclipse_swt_examples_controlexample_ShellTab.getSelection__())
      style |= 2048;
    if (resizeButton.getSelection__())
      style |= 16;
    if (onTopButton.getSelection__())
      style |= 16384;
    if (toolButton.getSelection__())
      style |= 4;
    if (modelessButton.getSelection__())
      style |= 0;
    if (primaryModalButton.getSelection__())
      style |= 32768;
    if (applicationModalButton.getSelection__())
      style |= 65536;
    if (systemModalButton.getSelection__())
      style |= 131072;
    if (noParentButton.getSelection__()) {
      shells[shellCount] = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__I, [style]));
    } else {
      shells[shellCount] = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
    }
    var currentShell: Shell = shells[shellCount];
    var button: Button = new Button(currentShell, 8);
    button.setBounds__IIII(20, 20, 120, 30);
    button.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Button"));
    var close: Button = new Button(currentShell, 8);
    close.setBounds__IIII(160, 20, 120, 30);
    close.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Close"));
    close.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.ShellTab$1(this, currentShell));
    currentShell.setSize__II(300, 100);
    currentShell.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title") + shellCount);
    if (imageButton.getSelection__())
      currentShell.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    if (backgroundImageButton.getSelection__())
      currentShell.setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[3]);
    this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(currentShell);
    currentShell.open__();
    shellCount++;
    return;
  }
  public override function createControlGroup__(): void {
    controlGroup = new Group(tabFolderPage, 0);
    controlGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, true])));
    controlGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    controlGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parameters"));
    styleGroup = new Group(controlGroup, 0);
    styleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    styleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZII, [4, 4, false, false, 1, 3])));
    styleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Decoration_Styles"));
    modalStyleGroup = new Group(controlGroup, 0);
    modalStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    modalStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    modalStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Modal_Styles"));
    otherGroup = new Group(controlGroup, 0);
    otherGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    otherGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    otherGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Other"));
    parentStyleGroup = new Group(controlGroup, 0);
    parentStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256]));
    parentStyleGroup.setLayoutData__Ljava_lang_Object_2(gridData);
    parentStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parent"));
    return;
  }
  public override function createControlWidgets__(): void {
    noParentButton = new Button(parentStyleGroup, 16);
    noParentButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("No_Parent"));
    parentButton = new Button(parentStyleGroup, 16);
    parentButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parent"));
    noTrimButton = new Button(styleGroup, 32);
    noTrimButton.setText__Ljava_lang_String_2("SWT.NO_TRIM");
    closeButton = new Button(styleGroup, 32);
    closeButton.setText__Ljava_lang_String_2("SWT.CLOSE");
    titleButton = new Button(styleGroup, 32);
    titleButton.setText__Ljava_lang_String_2("SWT.TITLE");
    minButton = new Button(styleGroup, 32);
    minButton.setText__Ljava_lang_String_2("SWT.MIN");
    maxButton = new Button(styleGroup, 32);
    maxButton.setText__Ljava_lang_String_2("SWT.MAX");
    borderButton_org_eclipse_swt_examples_controlexample_ShellTab = new Button(styleGroup, 32);
    borderButton_org_eclipse_swt_examples_controlexample_ShellTab.setText__Ljava_lang_String_2("SWT.BORDER");
    resizeButton = new Button(styleGroup, 32);
    resizeButton.setText__Ljava_lang_String_2("SWT.RESIZE");
    onTopButton = new Button(styleGroup, 32);
    onTopButton.setText__Ljava_lang_String_2("SWT.ON_TOP");
    toolButton = new Button(styleGroup, 32);
    toolButton.setText__Ljava_lang_String_2("SWT.TOOL");
    modelessButton = new Button(modalStyleGroup, 16);
    modelessButton.setText__Ljava_lang_String_2("SWT.MODELESS");
    primaryModalButton = new Button(modalStyleGroup, 16);
    primaryModalButton.setText__Ljava_lang_String_2("SWT.PRIMARY_MODAL");
    applicationModalButton = new Button(modalStyleGroup, 16);
    applicationModalButton.setText__Ljava_lang_String_2("SWT.APPLICATION_MODAL");
    systemModalButton = new Button(modalStyleGroup, 16);
    systemModalButton.setText__Ljava_lang_String_2("SWT.SYSTEM_MODAL");
    imageButton = new Button(otherGroup, 32);
    imageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Image"));
    backgroundImageButton = new Button(otherGroup, 32);
    backgroundImageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("BackgroundImage"));
    createButton = new Button(controlGroup, 0);
    var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [128]));
    createButton.setLayoutData__Ljava_lang_Object_2(gridData);
    createButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Create_Shell"));
    closeAllButton = new Button(controlGroup, 0);
    gridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [32]));
    closeAllButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Close_All_Shells"));
    closeAllButton.setLayoutData__Ljava_lang_Object_2(gridData);
    createButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ShellTab$2(this));
    closeAllButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ShellTab$3(this));
    var decorationButtonListener: SelectionListener = new org.eclipse.swt.examples.controlexample.ShellTab$4(this);
    noTrimButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    closeButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    titleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    minButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    maxButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    borderButton_org_eclipse_swt_examples_controlexample_ShellTab.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    resizeButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    applicationModalButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    systemModalButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(decorationButtonListener);
    noParentButton.setSelection__Z(true);
    modelessButton.setSelection__Z(true);
    backgroundImageButton.setSelection__Z(false);
    return;
  }
  public function decorationButtonSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    var widget: Button = Button(event.widget);
    if (widget === applicationModalButton || widget === systemModalButton) {
      if (widget.getSelection__()) {
        closeButton.setSelection__Z(true);
        noTrimButton.setSelection__Z(false);
      }
      return;
    }
    if (widget === closeButton) {
      if (applicationModalButton.getSelection__() || systemModalButton.getSelection__()) {
        closeButton.setSelection__Z(true);
      }
    }
    if (widget.getSelection__() && widget !== noTrimButton) {
      noTrimButton.setSelection__Z(false);
      return;
    }
    if (widget.getSelection__() && widget === noTrimButton) {
      if (applicationModalButton.getSelection__() || systemModalButton.getSelection__()) {
        noTrimButton.setSelection__Z(false);
        return;
      }
      closeButton.setSelection__Z(false);
      titleButton.setSelection__Z(false);
      minButton.setSelection__Z(false);
      maxButton.setSelection__Z(false);
      borderButton_org_eclipse_swt_examples_controlexample_ShellTab.setSelection__Z(false);
      resizeButton.setSelection__Z(false);
      return;
    }
    return;
  }
  public override function getTabText__(): String {
    return "Shell";
  }
}
}
