package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SpinnerTab extends RangeTab {
  internal var spinner1: Spinner;
  internal var spinnerGroup: Group;
  internal var readOnlyButton: Button;
  internal var wrapButton: Button;
  internal var incrementSpinner: Spinner;
  internal var pageIncrementSpinner: Spinner;
  internal var digitsSpinner: Spinner;
  function SpinnerTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createControlWidgets__(): void {
    super.createControlWidgets__();
    this.createIncrementGroup__();
    this.createPageIncrementGroup__();
    this.createDigitsGroup__();
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    spinnerGroup = new Group(exampleGroup, 0);
    spinnerGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    spinnerGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    spinnerGroup.setText__Ljava_lang_String_2("Spinner");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (readOnlyButton.getSelection__())
      style |= 8;
    if (borderButton.getSelection__())
      style |= 2048;
    if (wrapButton.getSelection__())
      style |= 64;
    spinner1 = new Spinner(spinnerGroup, style);
    return;
  }
  public function createIncrementGroup__(): void {
    var incrementGroup: Group = new Group(controlGroup, 0);
    incrementGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    incrementGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Increment"));
    incrementGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    incrementSpinner = new Spinner(incrementGroup, 2048);
    incrementSpinner.setMaximum__I(100000);
    incrementSpinner.setSelection__I(this.getDefaultIncrement__());
    incrementSpinner.setPageIncrement__I(100);
    incrementSpinner.setIncrement__I(1);
    incrementSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    incrementSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.SpinnerTab$1(this));
    return;
  }
  public function createPageIncrementGroup__(): void {
    var pageIncrementGroup: Group = new Group(controlGroup, 0);
    pageIncrementGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    pageIncrementGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Page_Increment"));
    pageIncrementGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    pageIncrementSpinner = new Spinner(pageIncrementGroup, 2048);
    pageIncrementSpinner.setMaximum__I(100000);
    pageIncrementSpinner.setSelection__I(this.getDefaultPageIncrement__());
    pageIncrementSpinner.setPageIncrement__I(100);
    pageIncrementSpinner.setIncrement__I(1);
    pageIncrementSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    pageIncrementSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.SpinnerTab$2(this));
    return;
  }
  public function createDigitsGroup__(): void {
    var digitsGroup: Group = new Group(controlGroup, 0);
    digitsGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    digitsGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Digits"));
    digitsGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    digitsSpinner = new Spinner(digitsGroup, 2048);
    digitsSpinner.setMaximum__I(100000);
    digitsSpinner.setSelection__I(this.getDefaultDigits__());
    digitsSpinner.setPageIncrement__I(100);
    digitsSpinner.setIncrement__I(1);
    digitsSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    digitsSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.SpinnerTab$3(this));
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.SpinnerTab$4(this));
    return tabFolderPage;
  }
  public override function createStyleGroup__(): void {
    orientationButtons = false;
    super.createStyleGroup__();
    readOnlyButton = new Button(styleGroup, 32);
    readOnlyButton.setText__Ljava_lang_String_2("SWT.READ_ONLY");
    wrapButton = new Button(styleGroup, 32);
    wrapButton.setText__Ljava_lang_String_2("SWT.WRAP");
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(spinner1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Selection", "TextLimit", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Spinner";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    readOnlyButton.setSelection__Z((spinner1.getStyle__() & 8) != 0);
    wrapButton.setSelection__Z((spinner1.getStyle__() & 64) != 0);
    if (!instance.startup) {
      this.setWidgetIncrement__();
      this.setWidgetPageIncrement__();
      this.setWidgetDigits__();
    }
    return;
  }
  public override function getDefaultMaximum__(): int {
    return spinner1.getMaximum__();
  }
  public override function getDefaultMinimum__(): int {
    return spinner1.getMinimum__();
  }
  public override function getDefaultSelection__(): int {
    return spinner1.getSelection__();
  }
  public function getDefaultIncrement__(): int {
    return spinner1.getIncrement__();
  }
  public function getDefaultPageIncrement__(): int {
    return spinner1.getPageIncrement__();
  }
  public function getDefaultDigits__(): int {
    return spinner1.getDigits__();
  }
  public function setWidgetIncrement__(): void {
    spinner1.setIncrement__I(incrementSpinner.getSelection__());
  }
  public override function setWidgetMaximum__(): void {
    spinner1.setMaximum__I(maximumSpinner.getSelection__());
  }
  public override function setWidgetMinimum__(): void {
    spinner1.setMinimum__I(minimumSpinner.getSelection__());
  }
  public function setWidgetPageIncrement__(): void {
    spinner1.setPageIncrement__I(pageIncrementSpinner.getSelection__());
  }
  public function setWidgetDigits__(): void {
    spinner1.setDigits__I(digitsSpinner.getSelection__());
  }
  public override function setWidgetSelection__(): void {
    spinner1.setSelection__I(selectionSpinner.getSelection__());
  }
}
}
