package org.eclipse.swt.examples.controlexample {
import java.io.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import java.io.InputStream;
import org.eclipse.swt.graphics.ImageData;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.MovementEvent;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class StyledTextTab extends ScrollableTab {
  internal var styledText: StyledText;
  internal var styledTextGroup: Group;
  internal var styledTextStyleGroup: Group;
  internal var wrapButton: Button;
  internal var readOnlyButton: Button;
  internal var fullSelectionButton: Button;
  internal var boldButton: Button;
  internal var italicButton: Button;
  internal var redButton: Button;
  internal var yellowButton: Button;
  internal var underlineButton: Button;
  internal var strikeoutButton: Button;
  internal var boldImage: Image;
  internal var italicImage: Image;
  internal var redImage: Image;
  internal var yellowImage: Image;
  internal var underlineImage: Image;
  internal var strikeoutImage: Image;
  internal var text: String;
  internal var styleRanges: JavaArray;
  function StyledTextTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public function createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display_1: Display, name: String): Image {
    var sourceStream: InputStream = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.examples.controlexample.ControlExample").getResourceAsStream__Ljava_lang_String_2(name + ".bmp");
    var maskStream: InputStream = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.examples.controlexample.ControlExample").getResourceAsStream__Ljava_lang_String_2(name + "_mask.bmp");
    var source: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__Ljava_io_InputStream_2, [sourceStream]));
    var mask: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__Ljava_io_InputStream_2, [maskStream]));
    var result: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2, [display_1, source, mask]));
    try {
      sourceStream.close__();
      maskStream.close__();
    } catch (e : IOException) {
      e.printStackTrace__();
    }
    return result;
  }
  public override function createControlWidgets__(): void {
    super.createControlWidgets__();
    this.createStyledTextStyleGroup__();
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    styledTextGroup = new Group(exampleGroup, 0);
    styledTextGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    styledTextGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    styledTextGroup.setText__Ljava_lang_String_2("StyledText");
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (singleButton.getSelection__())
      style |= 4;
    if (multiButton.getSelection__())
      style |= 2;
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (wrapButton.getSelection__())
      style |= 64;
    if (readOnlyButton.getSelection__())
      style |= 8;
    if (borderButton.getSelection__())
      style |= 2048;
    if (fullSelectionButton.getSelection__())
      style |= 65536;
    styledText = new StyledText(styledTextGroup, style);
    styledText.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string"));
    styledText.append__Ljava_lang_String_2("\n");
    styledText.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("One_Two_Three"));
    if (text !== null) {
      styledText.setText__Ljava_lang_String_2(text);
      text = null;
    }
    if (styleRanges !== null) {
      styledText.setStyleRanges___3Lorg_eclipse_swt_custom_StyleRange_2(styleRanges);
      styleRanges = null;
    }
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    wrapButton = new Button(styleGroup, 32);
    wrapButton.setText__Ljava_lang_String_2("SWT.WRAP");
    readOnlyButton = new Button(styleGroup, 32);
    readOnlyButton.setText__Ljava_lang_String_2("SWT.READ_ONLY");
    fullSelectionButton = new Button(styleGroup, 32);
    fullSelectionButton.setText__Ljava_lang_String_2("SWT.FULL_SELECTION");
    return;
  }
  public function createStyledTextStyleGroup__(): void {
    styledTextStyleGroup = new Group(controlGroup, 0);
    styledTextStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("StyledText_Styles"));
    styledTextStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [6, false])));
    var data: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256]));
    data.horizontalSpan = 2;
    styledTextStyleGroup.setLayoutData__Ljava_lang_Object_2(data);
    boldImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "bold");
    italicImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "italic");
    redImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "red");
    yellowImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "yellow");
    underlineImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "underline");
    strikeoutImage = this.createBitmapImage__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_String_2(display, "strikeout");
    var label: Label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("StyledText_Style_Instructions"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZII, [4, 16777216, false, false, 6, 1])));
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Bold"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    boldButton = new Button(styledTextStyleGroup, 8);
    boldButton.setImage__Lorg_eclipse_swt_graphics_Image_2(boldImage);
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Underline"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    underlineButton = new Button(styledTextStyleGroup, 8);
    underlineButton.setImage__Lorg_eclipse_swt_graphics_Image_2(underlineImage);
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Foreground_Style"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    redButton = new Button(styledTextStyleGroup, 8);
    redButton.setImage__Lorg_eclipse_swt_graphics_Image_2(redImage);
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Italic"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    italicButton = new Button(styledTextStyleGroup, 8);
    italicButton.setImage__Lorg_eclipse_swt_graphics_Image_2(italicImage);
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Strikeout"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    strikeoutButton = new Button(styledTextStyleGroup, 8);
    strikeoutButton.setImage__Lorg_eclipse_swt_graphics_Image_2(strikeoutImage);
    label = new Label(styledTextStyleGroup, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Background_Style"));
    label.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777224, 16777216, true, false])));
    yellowButton = new Button(styledTextStyleGroup, 8);
    yellowButton.setImage__Lorg_eclipse_swt_graphics_Image_2(yellowImage);
    var styleListener: SelectionListener = new org.eclipse.swt.examples.controlexample.StyledTextTab$1(this);
    var colorListener: SelectionListener = new org.eclipse.swt.examples.controlexample.StyledTextTab$2(this);
    boldButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(styleListener);
    italicButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(styleListener);
    underlineButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(styleListener);
    strikeoutButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(styleListener);
    redButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(colorListener);
    yellowButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(colorListener);
    yellowButton.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$3(this));
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$4(this));
    return tabFolderPage;
  }
  public override function disposeExampleWidgets__(): void {
    if (styledText !== null) {
      styleRanges = styledText.getStyleRanges__();
      text = styledText.getText__();
    }
    super.disposeExampleWidgets__();
    return;
  }
  public override function getCustomEventNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("ExtendedModifyListener", "BidiSegmentListener", "LineBackgroundListener", "LineStyleListener", "PaintObjectListener", "TextChangeListener", "VerifyKeyListener", "WordMovementListener");
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(styledText);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Alignment", "CaretOffset", "DoubleClickEnabled", "Editable", "HorizontalIndex", "HorizontalPixel", "Orientation", "Selection", "Tabs", "Text", "TextLimit", "ToolTipText", "TopIndex", "TopPixel", "WordWrap");
  }
  public override function getTabText__(): String {
    return "StyledText";
  }
  public override function hookCustomListener__Ljava_lang_String_2(eventName: String): void {
    if (eventName === "ExtendedModifyListener") {
      styledText.addExtendedModifyListener__Lorg_eclipse_swt_custom_ExtendedModifyListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$5(this, eventName));
    }
    if (eventName === "BidiSegmentListener") {
      styledText.addBidiSegmentListener__Lorg_eclipse_swt_custom_BidiSegmentListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$6(this, eventName));
    }
    if (eventName === "LineBackgroundListener") {
      styledText.addLineBackgroundListener__Lorg_eclipse_swt_custom_LineBackgroundListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$7(this, eventName));
    }
    if (eventName === "LineStyleListener") {
      styledText.addLineStyleListener__Lorg_eclipse_swt_custom_LineStyleListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$8(this, eventName));
    }
    if (eventName === "PaintObjectListener") {
      styledText.addPaintObjectListener__Lorg_eclipse_swt_custom_PaintObjectListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$9(this, eventName));
    }
    if (eventName === "TextChangeListener") {
      styledText.getContent__().addTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$10(this, eventName));
    }
    if (eventName === "VerifyKeyListener") {
      styledText.addVerifyKeyListener__Lorg_eclipse_swt_custom_VerifyKeyListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$11(this, eventName));
    }
    if (eventName === "WordMovementListener") {
      styledText.addWordMovementListener__Lorg_eclipse_swt_custom_MovementListener_2(new org.eclipse.swt.examples.controlexample.StyledTextTab$12(this, eventName));
    }
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    wrapButton.setSelection__Z((styledText.getStyle__() & 64) != 0);
    readOnlyButton.setSelection__Z((styledText.getStyle__() & 8) != 0);
    fullSelectionButton.setSelection__Z((styledText.getStyle__() & 65536) != 0);
    horizontalButton.setEnabled__Z((styledText.getStyle__() & 2) != 0);
    verticalButton.setEnabled__Z((styledText.getStyle__() & 2) != 0);
    wrapButton.setEnabled__Z((styledText.getStyle__() & 2) != 0);
    return;
  }
}
}
