package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import java.lang.Integer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.FontData;
import java.lang.Boolean__;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;
import java.lang.NumberFormatException;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import java.lang.Class__;
import java.lang.reflect.Method;
import java.lang.reflect.Array__;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Character;
import java.lang.Throwable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.GC;
import java.lang.System;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TypedEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Tab {
  internal var shell: Shell;
  internal var display: Display;
  internal var borderButton: Button;
  internal var enabledButton: Button;
  internal var visibleButton: Button;
  internal var backgroundImageButton: Button;
  internal var popupMenuButton: Button;
  internal var preferredButton: Button;
  internal var tooSmallButton: Button;
  internal var smallButton: Button;
  internal var largeButton: Button;
  internal var fillHButton: Button;
  internal var fillVButton: Button;
  internal var tabFolderPage: Composite;
  internal var exampleGroup: Group;
  internal var controlGroup: Group;
  internal var listenersGroup: Group;
  internal var otherGroup: Group;
  internal var sizeGroup: Group;
  internal var styleGroup: Group;
  internal var colorGroup: Group;
  internal var backgroundModeGroup: Group;
  internal var instance: ControlExample;
  public static const TOO_SMALL_SIZE: int = 10;
  public static const SMALL_SIZE: int = 50;
  public static const LARGE_SIZE: int = 100;
  public static var RTL_SUPPORT_ENABLE: Boolean = Object("win32").equals__Ljava_lang_Object_2(SWT.getPlatform__()) || Object("gtk").equals__Ljava_lang_Object_2(SWT.getPlatform__());
  internal var orientationGroup: Group;
  internal var rtlButton: Button;
  internal var ltrButton: Button;
  internal var defaultOrietationButton: Button;
  public static const IMAGE_SIZE: int = 12;
  public static const FOREGROUND_COLOR: int = 0;
  public static const BACKGROUND_COLOR: int = 1;
  public static const FONT: int = 2;
  internal var colorAndFontTable: Table;
  internal var colorDialog: ColorDialog;
  internal var fontDialog: FontDialog;
  internal var foregroundColor: Color;
  internal var backgroundColor: Color;
  internal var font: Font;
  internal var backgroundModeCombo: Combo;
  internal var backgroundModeImageButton: Button;
  internal var backgroundModeColorButton: Button;
  internal var samplePopup: Boolean = false;
  internal var nameCombo: Combo;
  internal var returnTypeLabel: Label;
  internal var getButton: Button;
  internal var setButton: Button;
  internal var setText: Text;
  internal var getText: Text;
  internal var setGetDialog: Shell;
  internal var eventConsole: Text;
  internal var logging: Boolean = false;
  internal var eventsFilter: JavaArray;
  internal var setFieldsMask: int = 0;
  internal var setFieldsEvent: Event = new Event();
  internal var ignore: Boolean = false;
  public static const DOIT: int = 0x0100;
  public static const DETAIL: int = 0x0200;
  public static const TEXT: int = 0x0400;
  public static const X: int = 0x0800;
  public static const Y: int = 0x1000;
  public static const WIDTH: int = 0x2000;
  public static const HEIGHT: int = 0x4000;
  public static const DETAIL_IME: int = 0;
  public static const DETAIL_ERASE_ITEM: int = 1;
  public static const DETAIL_TRAVERSE: int = 2;
  internal var EVENT_INFO: JavaArray = new JavaArray("[Lorg/eclipse/swt/examples/controlexample/Tab$EventInfo;").values(new Tab$EventInfo("Activate", 26, 0, 0, new Event()), new Tab$EventInfo("Arm", 30, 0, 0, new Event()), new Tab$EventInfo("Close", 21, 256, 0, new Event()), new Tab$EventInfo("Collapse", 18, 0, 0, new Event()), new Tab$EventInfo("Deactivate", 27, 0, 0, new Event()), new Tab$EventInfo("DefaultSelection", 14, 0, 0, new Event()), new Tab$EventInfo("Deiconify", 20, 0, 0, new Event()), new Tab$EventInfo("Dispose", 12, 0, 0, new Event()), new Tab$EventInfo("DragDetect", 29, 0, 0, new Event()), new Tab$EventInfo("EraseItem", 40, 512 | 1, 0, new Event()), new Tab$EventInfo("Expand", 17, 0, 0, new Event()), new Tab$EventInfo("FocusIn", 15, 0, 0, new Event()), new Tab$EventInfo("FocusOut", 16, 0, 0, new Event()), new Tab$EventInfo("HardKeyDown", 33, 0, 0, new Event()), new Tab$EventInfo("HardKeyUp", 34, 0, 0, new Event()), new Tab$EventInfo("Help", 28, 0, 0, new Event()), new Tab$EventInfo("Hide", 23, 0, 0, new Event()), new Tab$EventInfo("Iconify", 19, 0, 0, new Event()), new Tab$EventInfo("KeyDown", 1, 256, 0, new Event()), new Tab$EventInfo("KeyUp", 2, 256, 0, new Event()), new Tab$EventInfo("MeasureItem", 41, 0, 0, new Event()), new Tab$EventInfo("MenuDetect", 35, 2048 | 4096 | 256, 0, new Event()), new Tab$EventInfo("Modify", 24, 0, 0, new Event()), new Tab$EventInfo("MouseDoubleClick", 8, 0, 0, new Event()), new Tab$EventInfo("MouseDown", 3, 0, 0, new Event()), new Tab$EventInfo("MouseEnter", 6, 0, 0, new Event()), new Tab$EventInfo("MouseExit", 7, 0, 0, new Event()), new Tab$EventInfo("MouseHover", 32, 0, 0, new Event()), new Tab$EventInfo("MouseMove", 5, 0, 0, new Event()), new Tab$EventInfo("MouseUp", 4, 0, 0, new Event()), new Tab$EventInfo("MouseWheel", 37, 0, 0, new Event()), new Tab$EventInfo("Move", 10, 0, 0, new Event()), new Tab$EventInfo("Paint", 9, 0, 0, new Event()), new Tab$EventInfo("PaintItem", 42, 0, 0, new Event()), new Tab$EventInfo("Resize", 11, 0, 0, new Event()), new Tab$EventInfo("Selection", 13, 2048 | 4096 | 256, 0, new Event()), new Tab$EventInfo("SetData", 36, 0, 0, new Event()), new Tab$EventInfo("Show", 22, 0, 0, new Event()), new Tab$EventInfo("Traverse", 31, 512 | 2 | 256, 0, new Event()), new Tab$EventInfo("Verify", 25, 1024 | 256, 0, new Event()), new Tab$EventInfo("ImeComposition", 43, 512 | 0 | 1024 | 256, 0, new Event()));
  public static var DETAIL_CONSTANTS: JavaArray = new JavaArray("[[Ljava/lang/String;").values(new JavaArray("[Ljava/lang/String;").values("SWT.COMPOSITION_CHANGED", "SWT.COMPOSITION_OFFSET", "SWT.COMPOSITION_SELECTION"), new JavaArray("[Ljava/lang/String;").values("SWT.SELECTED", "SWT.FOCUSED", "SWT.BACKGROUND", "SWT.FOREGROUND", "SWT.HOT"), new JavaArray("[Ljava/lang/String;").values("SWT.TRAVERSE_NONE", "SWT.TRAVERSE_ESCAPE", "SWT.TRAVERSE_RETURN", "SWT.TRAVERSE_TAB_PREVIOUS", "SWT.TRAVERSE_TAB_NEXT", "SWT.TRAVERSE_ARROW_PREVIOUS", "SWT.TRAVERSE_ARROW_NEXT", "SWT.TRAVERSE_MNEMONIC", "SWT.TRAVERSE_PAGE_PREVIOUS", "SWT.TRAVERSE_PAGE_NEXT"));
  public static var DETAIL_VALUES: JavaArray = new JavaArray("[Ljava/lang/Object;").values("SWT.COMPOSITION_CHANGED", new Integer(new Arguments(java.lang.Integer.Integer__I, [1])), "SWT.COMPOSITION_OFFSET", new Integer(new Arguments(java.lang.Integer.Integer__I, [2])), "SWT.COMPOSITION_SELECTION", new Integer(new Arguments(java.lang.Integer.Integer__I, [3])), "SWT.SELECTED", new Integer(new Arguments(java.lang.Integer.Integer__I, [2])), "SWT.FOCUSED", new Integer(new Arguments(java.lang.Integer.Integer__I, [4])), "SWT.BACKGROUND", new Integer(new Arguments(java.lang.Integer.Integer__I, [8])), "SWT.FOREGROUND", new Integer(new Arguments(java.lang.Integer.Integer__I, [16])), "SWT.HOT", new Integer(new Arguments(java.lang.Integer.Integer__I, [32])), "SWT.TRAVERSE_NONE", new Integer(new Arguments(java.lang.Integer.Integer__I, [0])), "SWT.TRAVERSE_ESCAPE", new Integer(new Arguments(java.lang.Integer.Integer__I, [2])), "SWT.TRAVERSE_RETURN", new Integer(new Arguments(java.lang.Integer.Integer__I, [4])), "SWT.TRAVERSE_TAB_PREVIOUS", new Integer(new Arguments(java.lang.Integer.Integer__I, [8])), "SWT.TRAVERSE_TAB_NEXT", new Integer(new Arguments(java.lang.Integer.Integer__I, [16])), "SWT.TRAVERSE_ARROW_PREVIOUS", new Integer(new Arguments(java.lang.Integer.Integer__I, [32])), "SWT.TRAVERSE_ARROW_NEXT", new Integer(new Arguments(java.lang.Integer.Integer__I, [64])), "SWT.TRAVERSE_MNEMONIC", new Integer(new Arguments(java.lang.Integer.Integer__I, [128])), "SWT.TRAVERSE_PAGE_PREVIOUS", new Integer(new Arguments(java.lang.Integer.Integer__I, [256])), "SWT.TRAVERSE_PAGE_NEXT", new Integer(new Arguments(java.lang.Integer.Integer__I, [512])));
  function Tab(instance: ControlExample) {
    this.instance = instance;
    return;
  }
  public function createControlGroup__(): void {
    controlGroup = new Group(tabFolderPage, 0);
    controlGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, true])));
    controlGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    controlGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parameters"));
    this.createStyleGroup__();
    this.createOtherGroup__();
    this.createSetGetGroup__();
    this.createSizeGroup__();
    this.createColorAndFontGroup__();
    if (this.rtlSupport__()) {
      this.createOrientationGroup__();
    }
    var selectionListener: SelectionListener = new org.eclipse.swt.examples.controlexample.Tab$1(this);
    var children: JavaArray = styleGroup.getChildren__();
    for (var i: int = 0; i < children.length; i++) {
      if (children[i] is Button) {
        var button: Button = Button(children[i]);
        button.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
      } else {
        if (children[i] is Composite) {
          var composite: Composite = Composite(children[i]);
          var grandchildren: JavaArray = composite.getChildren__();
          for (var j: int = 0; j < grandchildren.length; j++) {
            if (grandchildren[j] is Button) {
              var button_1: Button = Button(grandchildren[j]);
              button_1.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
            }
          }
        }
      }
    }
    if (this.rtlSupport__()) {
      rtlButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
      ltrButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
      defaultOrietationButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    }
    return;
  }
  public function createSetGetGroup__(): void {
    var methodNames: JavaArray = this.getMethodNames__();
    if (methodNames !== null) {
      var setGetButton: Button = new Button(otherGroup, 8);
      setGetButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Get"));
      setGetButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, false, false])));
      setGetButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$2(this, methodNames, setGetButton));
    }
    return;
  }
  public function createControlWidgets__(): void {
  }
  public function createColorAndFontGroup__(): void {
    colorGroup = new Group(controlGroup, 0);
    colorGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, true])));
    colorGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    colorGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Colors"));
    colorAndFontTable = new Table(colorGroup, 2048 | 512);
    colorAndFontTable.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZII, [4, 1, true, false, 2, 1])));
    var item: TableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Foreground_Color"));
    colorAndFontTable.setSelection__I(0);
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Background_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Font"));
    var changeButton: Button = new Button(colorGroup, 8);
    changeButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Change"));
    changeButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, false, false])));
    var defaultsButton: Button = new Button(colorGroup, 8);
    defaultsButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Defaults"));
    defaultsButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, false, false])));
    colorDialog = new ColorDialog(new Arguments(org.eclipse.swt.widgets.ColorDialog.ColorDialog__Lorg_eclipse_swt_widgets_Shell_2, [shell]));
    fontDialog = new FontDialog(new Arguments(org.eclipse.swt.widgets.FontDialog.FontDialog__Lorg_eclipse_swt_widgets_Shell_2, [shell]));
    colorAndFontTable.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$3(this));
    changeButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$4(this));
    defaultsButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$5(this));
    shell.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.Tab$6(this));
    return;
  }
  public function changeFontOrColor__I(index: int): void {
    switch (index) {
      case 0 :
        {
          var oldColor: Color = foregroundColor;
          if (oldColor === null) {
            var controls: JavaArray = this.getExampleControls__();
            if (controls.length > 0)
              oldColor = controls[0].getForeground__();
          }
          if (oldColor !== null)
            colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor.getRGB__());
          var rgb: RGB = colorDialog.open__();
          if (rgb === null)
            return;
          oldColor = foregroundColor;
          foregroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb]));
          this.setExampleWidgetForeground__();
          if (oldColor !== null)
            oldColor.dispose__();
        }
        break;
      case 1 :
        {
          var oldColor_1: Color = backgroundColor;
          if (oldColor_1 === null) {
            var controls_1: JavaArray = this.getExampleControls__();
            if (controls_1.length > 0)
              oldColor_1 = controls_1[0].getBackground__();
          }
          if (oldColor_1 !== null)
            colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor_1.getRGB__());
          var rgb_1: RGB = colorDialog.open__();
          if (rgb_1 === null)
            return;
          oldColor_1 = backgroundColor;
          backgroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb_1]));
          this.setExampleWidgetBackground__();
          if (oldColor_1 !== null)
            oldColor_1.dispose__();
        }
        break;
      case 2 :
        {
          var oldFont: Font = font;
          if (oldFont === null) {
            var controls_2: JavaArray = this.getExampleControls__();
            if (controls_2.length > 0)
              oldFont = controls_2[0].getFont__();
          }
          if (oldFont !== null)
            fontDialog.setFontList___3Lorg_eclipse_swt_graphics_FontData_2(oldFont.getFontData__());
          var fontData: FontData = fontDialog.open__();
          if (fontData === null)
            return;
          oldFont = font;
          font = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [display, fontData]));
          this.setExampleWidgetFont__();
          this.setExampleWidgetSize__();
          if (oldFont !== null)
            oldFont.dispose__();
        }
        break;
    }
    return;
  }
  public function createOtherGroup__(): void {
    otherGroup = new Group(controlGroup, 0);
    otherGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    otherGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    otherGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Other"));
    enabledButton = new Button(otherGroup, 32);
    enabledButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Enabled"));
    visibleButton = new Button(otherGroup, 32);
    visibleButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Visible"));
    backgroundImageButton = new Button(otherGroup, 32);
    backgroundImageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("BackgroundImage"));
    popupMenuButton = new Button(otherGroup, 32);
    popupMenuButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("PopupMenu"));
    enabledButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$7(this));
    visibleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$8(this));
    backgroundImageButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$9(this));
    popupMenuButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$10(this));
    enabledButton.setSelection__Z(true);
    visibleButton.setSelection__Z(true);
    backgroundImageButton.setSelection__Z(false);
    popupMenuButton.setSelection__Z(false);
    return;
  }
  public function createBackgroundModeGroup__(): void {
    if (this.getExampleControls__().length == 0)
      return;
    backgroundModeGroup = new Group(controlGroup, 0);
    backgroundModeGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    backgroundModeGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    backgroundModeGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Background_Mode"));
    backgroundModeCombo = new Combo(backgroundModeGroup, 8);
    backgroundModeCombo.setItems___3Ljava_lang_String_2(new JavaArray("[Ljava/lang/String;").values("SWT.INHERIT_NONE", "SWT.INHERIT_DEFAULT", "SWT.INHERIT_FORCE"));
    backgroundModeImageButton = new Button(backgroundModeGroup, 32);
    backgroundModeImageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("BackgroundImage"));
    backgroundModeColorButton = new Button(backgroundModeGroup, 32);
    backgroundModeColorButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("BackgroundColor"));
    backgroundModeCombo.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$11(this));
    backgroundModeImageButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$12(this));
    backgroundModeColorButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$13(this));
    backgroundModeCombo.setText__Ljava_lang_String_2(backgroundModeCombo.getItem__I(0));
    backgroundModeImageButton.setSelection__Z(false);
    backgroundModeColorButton.setSelection__Z(false);
  }
  public function createEditEventDialog__Lorg_eclipse_swt_widgets_Shell_2III(parent: Shell, x: int, y: int, index: int): void {
    var dialog: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [parent, 2144 | 16 | 65536]));
    dialog.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    dialog.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Edit_Event"));
    var label: Label = new Label(dialog, 0);
    label.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Edit_Event_Fields", new JavaArray("[Ljava/lang/String;").values(EVENT_INFO[index].name)));
    var group: Group = new Group(dialog, 0);
    group.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, false])));
    group.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    var fields: int = EVENT_INFO[index].settableFields;
    var eventType: int = EVENT_INFO[index].type;
    setFieldsMask = EVENT_INFO[index].setFields;
    setFieldsEvent = EVENT_INFO[index].event;
    if ((fields & 256) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("doit");
      var doitCombo: Combo = new Combo(group, 8);
      doitCombo.setItems___3Ljava_lang_String_2(new JavaArray("[Ljava/lang/String;").values("", "true", "false"));
      if ((setFieldsMask & 256) != 0)
        doitCombo.setText__Ljava_lang_String_2(Boolean__.toString__Z(setFieldsEvent.doit));
      doitCombo.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      doitCombo.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$14(this, doitCombo, eventType));
    }
    if ((fields & 512) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("detail");
      var detailType: int = fields & 0xFF;
      var detailCombo: Combo = new Combo(group, 8);
      detailCombo.setItems___3Ljava_lang_String_2(DETAIL_CONSTANTS[detailType]);
      detailCombo.add__Ljava_lang_String_2I("", 0);
      detailCombo.setVisibleItemCount__I(detailCombo.getItemCount__());
      if ((setFieldsMask & 512) != 0)
        detailCombo.setText__Ljava_lang_String_2(DETAIL_CONSTANTS[detailType][setFieldsEvent.detail]);
      detailCombo.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      detailCombo.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$15(this, detailCombo, eventType));
    }
    if ((fields & 1024) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("text");
      var textText: Text = new Text(group, 2048);
      if ((setFieldsMask & 1024) != 0)
        textText.setText__Ljava_lang_String_2(setFieldsEvent.text);
      textText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      textText.addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(new org.eclipse.swt.examples.controlexample.Tab$16(this, textText, eventType));
    }
    if ((fields & 2048) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("x");
      var xText: Text = new Text(group, 2048);
      if ((setFieldsMask & 2048) != 0)
        xText.setText__Ljava_lang_String_2(Integer.toString__I(setFieldsEvent.x));
      xText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      xText.addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(new org.eclipse.swt.examples.controlexample.Tab$17(this, xText, eventType));
    }
    if ((fields & 4096) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("y");
      var yText: Text = new Text(group, 2048);
      if ((setFieldsMask & 4096) != 0)
        yText.setText__Ljava_lang_String_2(Integer.toString__I(setFieldsEvent.y));
      yText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      yText.addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(new org.eclipse.swt.examples.controlexample.Tab$18(this, yText, eventType));
    }
    if ((fields & 8192) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("width");
      var widthText: Text = new Text(group, 2048);
      if ((setFieldsMask & 8192) != 0)
        widthText.setText__Ljava_lang_String_2(Integer.toString__I(setFieldsEvent.width));
      widthText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      widthText.addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(new org.eclipse.swt.examples.controlexample.Tab$19(this, widthText, eventType));
    }
    if ((fields & 16384) != 0) {
      new Label(group, 0).setText__Ljava_lang_String_2("height");
      var heightText: Text = new Text(group, 2048);
      if ((setFieldsMask & 16384) != 0)
        heightText.setText__Ljava_lang_String_2(Integer.toString__I(setFieldsEvent.height));
      heightText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
      heightText.addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(new org.eclipse.swt.examples.controlexample.Tab$20(this, heightText, eventType));
    }
    var ok: Button = new Button(dialog, 8);
    ok.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("OK"));
    var data: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__II, [70, -1]));
    data.horizontalAlignment = 131072;
    ok.setLayoutData__Ljava_lang_Object_2(data);
    ok.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$21(this, index, dialog));
    dialog.setDefaultButton__Lorg_eclipse_swt_widgets_Button_2(ok);
    dialog.pack__();
    dialog.setLocation__II(x, y);
    dialog.open__();
    return;
  }
  public function createEventConsolePopup__(): void {
    var popup: Menu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Decorations_2I, [shell, 8]));
    eventConsole.setMenu__Lorg_eclipse_swt_widgets_Menu_2(popup);
    var cut: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [popup, 8]));
    cut.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MenuItem_Cut"));
    cut.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.Tab$22(this));
    var copy: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [popup, 8]));
    copy.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MenuItem_Copy"));
    copy.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.Tab$23(this));
    var paste: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [popup, 8]));
    paste.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MenuItem_Paste"));
    paste.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.Tab$24(this));
    new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [popup, 2]));
    var selectAll: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [popup, 8]));
    selectAll.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MenuItem_SelectAll"));
    selectAll.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.Tab$25(this));
    return;
  }
  public function createExampleGroup__(): void {
    exampleGroup = new Group(tabFolderPage, 0);
    exampleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    exampleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    return;
  }
  public function createExampleWidgets__(): void {
  }
  public function createListenerSelectionDialog__(): void {
    var dialog: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [shell, 2144 | 16 | 65536]));
    dialog.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Select_Listeners"));
    dialog.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, false])));
    var table: Table = new Table(dialog, 2048 | 512 | 32);
    var data: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808]));
    data.verticalSpan = 3;
    table.setLayoutData__Ljava_lang_Object_2(data);
    for (var i: int = 0; i < EVENT_INFO.length; i++) {
      var item: TableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [table, 0]));
      item.setText__Ljava_lang_String_2(EVENT_INFO[i].name);
      item.setChecked__Z(eventsFilter[i]);
    }
    var customNames: JavaArray = this.getCustomEventNames__();
    for (var i_1: int = 0; i_1 < customNames.length; i_1++) {
      var item_1: TableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [table, 0]));
      item_1.setText__Ljava_lang_String_2(customNames[i_1]);
      item_1.setChecked__Z(eventsFilter[EVENT_INFO.length + i_1]);
    }
    var selectAll: Button = new Button(dialog, 8);
    selectAll.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Select_All"));
    selectAll.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256])));
    selectAll.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$26(this, table, customNames));
    var deselectAll: Button = new Button(dialog, 8);
    deselectAll.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Deselect_All"));
    deselectAll.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256])));
    deselectAll.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$27(this, table, customNames));
    var editEvent: Button = new Button(dialog, 8);
    editEvent.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Edit_Event"));
    editEvent.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 2])));
    editEvent.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$28(this, editEvent, table, dialog));
    editEvent.setEnabled__Z(false);
    table.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$29(this, table, editEvent, dialog));
    new Label(dialog, 0);
    var ok: Button = new Button(dialog, 8);
    ok.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("OK"));
    dialog.setDefaultButton__Lorg_eclipse_swt_widgets_Button_2(ok);
    ok.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256])));
    ok.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$30(this, table, customNames, dialog));
    dialog.pack__();
    var bounds: Rectangle = dialog.getBounds__();
    var trim: Rectangle = dialog.computeTrim__IIII(0, 0, 0, 0);
    var clientArea: Rectangle = display.getClientArea__();
    if (bounds.height > clientArea.height) {
      dialog.setSize__II(bounds.width, clientArea.height - trim.height);
    }
    dialog.setLocation__II(bounds.x, clientArea.y);
    dialog.open__();
    while (!dialog.isDisposed__()) {
      if (!display.readAndDispatch__())
        display.sleep__();
    }
    return;
  }
  public function createListenersGroup__(): void {
    listenersGroup = new Group(tabFolderPage, 0);
    listenersGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [3, false])));
    listenersGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZII, [4, 4, true, true, 2, 1])));
    listenersGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Listeners"));
    var listenersButton: Button = new Button(listenersGroup, 8);
    listenersButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Select_Listeners"));
    listenersButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$31(this));
    var listenCheckbox: Button = new Button(listenersGroup, 32);
    listenCheckbox.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Listen"));
    listenCheckbox.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$32(this, listenCheckbox));
    var clearButton: Button = new Button(listenersGroup, 8);
    clearButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Clear"));
    clearButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [128])));
    clearButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$33(this));
    var customEventCount: int = this.getCustomEventNames__().length;
    eventsFilter = new JavaArray("[Z").lengths(EVENT_INFO.length + customEventCount);
    for (var i: int = 0; i < EVENT_INFO.length + customEventCount; i++) {
      eventsFilter[i] = true;
    }
    eventConsole = new Text(listenersGroup, 2048 | 2 | 512 | 256);
    var data: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808]));
    data.horizontalSpan = 3;
    data.heightHint = 80;
    eventConsole.setLayoutData__Ljava_lang_Object_2(data);
    this.createEventConsolePopup__();
    eventConsole.addKeyListener__Lorg_eclipse_swt_events_KeyListener_2(new org.eclipse.swt.examples.controlexample.Tab$34(this));
    return;
  }
  public function getMethodNames__(): JavaArray {
    return null;
  }
  public function createSetGetDialog___3Ljava_lang_String_2(methodNames: JavaArray): Shell {
    var dialog: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [shell, 2144 | 16 | 0]));
    dialog.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, false])));
    dialog.setText__Ljava_lang_String_2(this.getTabText__() + " " + ControlExample.getResourceString__Ljava_lang_String_2("Set_Get"));
    nameCombo = new Combo(dialog, 8);
    nameCombo.setItems___3Ljava_lang_String_2(methodNames);
    nameCombo.setText__Ljava_lang_String_2(methodNames[0]);
    nameCombo.setVisibleItemCount__I(methodNames.length);
    nameCombo.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, false, false])));
    nameCombo.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$35(this));
    returnTypeLabel = new Label(dialog, 0);
    returnTypeLabel.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 1, false, false])));
    setButton = new Button(dialog, 8);
    setButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 1, false, false])));
    setButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$36(this));
    setText = new Text(dialog, 4 | 2048);
    setText.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, false, false])));
    getButton = new Button(dialog, 8);
    getButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 1, false, false])));
    getButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.Tab$37(this));
    getText = new Text(dialog, 2 | 2048 | 8 | 256 | 512);
    var data: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true]));
    data.widthHint = 240;
    data.heightHint = 200;
    getText.setLayoutData__Ljava_lang_Object_2(data);
    this.resetLabels__();
    dialog.setDefaultButton__Lorg_eclipse_swt_widgets_Button_2(setButton);
    dialog.pack__();
    dialog.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.Tab$38(this));
    return dialog;
  }
  public function resetLabels__(): void {
    var methodRoot: String = nameCombo.getText__();
    returnTypeLabel.setText__Ljava_lang_String_2(this.parameterInfo__Ljava_lang_String_2(methodRoot));
    setButton.setText__Ljava_lang_String_2(this.setMethodName__Ljava_lang_String_2(methodRoot));
    getButton.setText__Ljava_lang_String_2("get" + methodRoot);
    setText.setText__Ljava_lang_String_2("");
    getText.setText__Ljava_lang_String_2("");
    this.getValue__();
    setText.setFocus__();
  }
  public function setMethodName__Ljava_lang_String_2(methodRoot: String): String {
    return "set" + methodRoot;
  }
  public function parameterInfo__Ljava_lang_String_2(methodRoot: String): String {
    var typeName: String = null;
    var returnType: Class__ = this.getReturnType__Ljava_lang_String_2(methodRoot);
    var isArray: Boolean = returnType.isArray__();
    if (isArray) {
      typeName = returnType.getComponentType__().getName__();
    } else {
      typeName = returnType.getName__();
    }
    var typeNameString: String = typeName;
    var index: int = Object(typeName).lastIndexOf__I(46);
    if (index != -1 && index + 1 < Object(typeName).length__())
      typeNameString = Object(typeName).substring__I(index + 1);
    var info: String = ControlExample.getResourceString__Ljava_lang_String_2("Info_" + typeNameString + (isArray ? "A" : ""));
    if (isArray) {
      typeNameString += "[]";
    }
    return ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Parameter_Info", new JavaArray("[Ljava/lang/Object;").values(typeNameString, info));
  }
  public function getValue__(): void {
    var methodName: String = "get" + nameCombo.getText__();
    getText.setText__Ljava_lang_String_2("");
    var widgets: JavaArray = this.getExampleWidgets__();
    for (var i: int = 0; i < widgets.length; i++) {
      try {
        var method: Method = Object(widgets[i]).getClass__().getMethod__Ljava_lang_String_2_3Ljava_lang_Class_2(methodName, null);
        var result: Object = method.invoke__Ljava_lang_Object_2_3Ljava_lang_Object_2(widgets[i], null);
        if (result === null) {
          getText.append__Ljava_lang_String_2("null");
        } else if (Object(result).getClass__().isArray__()) {
          var length: int = Array__.getLength__Ljava_lang_Object_2(result);
          if (length == 0) {
            getText.append__Ljava_lang_String_2(java.lang.System.stringValueOf(Object(result).getClass__().getComponentType__()) + "[0]");
          }
          for (var j: int = 0; j < length; j++) {
            getText.append__Ljava_lang_String_2(Object(Array__.get__Ljava_lang_Object_2I(result, j)).toString__() + "\n");
          }
        } else {
          getText.append__Ljava_lang_String_2(Object(result).toString__());
        }
      } catch (e : Exception) {
        getText.append__Ljava_lang_String_2(e.toString__());
      }
      if (i + 1 < widgets.length) {
        getText.append__Ljava_lang_String_2("\n\n");
      }
    }
    return;
  }
  public function getReturnType__Ljava_lang_String_2(methodRoot: String): Class__ {
    var returnType: Class__ = null;
    var methodName: String = "get" + methodRoot;
    var widgets: JavaArray = this.getExampleWidgets__();
    try {
      var method: Method = Object(widgets[0]).getClass__().getMethod__Ljava_lang_String_2_3Ljava_lang_Class_2(methodName, null);
      returnType = method.getReturnType__();
    } catch (e : Exception) {
    }
    return returnType;
  }
  public function setValue__(): void {
    var methodRoot: String = nameCombo.getText__();
    var returnType: Class__ = this.getReturnType__Ljava_lang_String_2(methodRoot);
    var methodName: String = this.setMethodName__Ljava_lang_String_2(methodRoot);
    var value: String = setText.getText__();
    var widgets: JavaArray = this.getExampleWidgets__();
    for (var i: int = 0; i < widgets.length; i++) {
      try {
        var method: Method = Object(widgets[i]).getClass__().getMethod__Ljava_lang_String_2_3Ljava_lang_Class_2(methodName, new JavaArray("[Ljava/lang/Class;").values(returnType));
        var typeName: String = returnType.getName__();
        var parameter: JavaArray = null;
        if (Object(value).equals__Ljava_lang_Object_2("null")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(null);
        } else if (Object(typeName).equals__Ljava_lang_Object_2("int")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(new Integer(new Arguments(java.lang.Integer.Integer__Ljava_lang_String_2, [value])));
        } else if (Object(typeName).equals__Ljava_lang_Object_2("long")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(new Long(new Arguments(java.lang.Long.Long__Ljava_lang_String_2, [value])));
        } else if (Object(typeName).equals__Ljava_lang_Object_2("char")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(Object(value).length__() == 1 ? new Character(Object(value).charAt__I(0)) : new Character(0));
        } else if (Object(typeName).equals__Ljava_lang_Object_2("boolean")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(new Boolean__(new Arguments(java.lang.Boolean__.Boolean____Ljava_lang_String_2, [value])));
        } else if (Object(typeName).equals__Ljava_lang_Object_2("java.lang.String")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(value);
        } else if (Object(typeName).equals__Ljava_lang_Object_2("org.eclipse.swt.graphics.Point")) {
          var xy: JavaArray = this.split__Ljava_lang_String_2C(value, 44);
          parameter = new JavaArray("[Ljava/lang/Object;").values(new Point(new Integer(new Arguments(java.lang.Integer.Integer__Ljava_lang_String_2, [xy[0]])).intValue__(), new Integer(new Arguments(java.lang.Integer.Integer__Ljava_lang_String_2, [xy[1]])).intValue__()));
        } else if (Object(typeName).equals__Ljava_lang_Object_2("[I")) {
          var strings: JavaArray = this.split__Ljava_lang_String_2C(value, 44);
          var ints: JavaArray = new JavaArray("[I").lengths(strings.length);
          for (var j: int = 0; j < strings.length; j++) {
            ints[j] = new Integer(new Arguments(java.lang.Integer.Integer__Ljava_lang_String_2, [strings[j]])).intValue__();
          }
          parameter = new JavaArray("[Ljava/lang/Object;").values(ints);
        } else if (Object(typeName).equals__Ljava_lang_Object_2("[Ljava.lang.String;")) {
          parameter = new JavaArray("[Ljava/lang/Object;").values(this.split__Ljava_lang_String_2C(value, 44));
        } else {
          parameter = this.parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName, value, widgets[i]);
        }
        method.invoke__Ljava_lang_Object_2_3Ljava_lang_Object_2(widgets[i], parameter);
      } catch (e : Exception) {
        var cause: Throwable = e.getCause__();
        var message: String = e.getMessage__();
        getText.setText__Ljava_lang_String_2(e.toString__());
        if (cause !== null)
          getText.append__Ljava_lang_String_2(", cause=\n" + cause.toString__());
        if (message !== null)
          getText.append__Ljava_lang_String_2(", message=\n" + message);
      }
    }
    return;
  }
  public function parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName: String, value: String, widget: Widget): JavaArray {
    return new JavaArray("[Ljava/lang/Object;").values(value);
  }
  public function createOrientationGroup__(): void {
    orientationGroup = new Group(controlGroup, 0);
    orientationGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    orientationGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    orientationGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Orientation"));
    defaultOrietationButton = new Button(orientationGroup, 16);
    defaultOrietationButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Default"));
    defaultOrietationButton.setSelection__Z(true);
    ltrButton = new Button(orientationGroup, 16);
    ltrButton.setText__Ljava_lang_String_2("SWT.LEFT_TO_RIGHT");
    rtlButton = new Button(orientationGroup, 16);
    rtlButton.setText__Ljava_lang_String_2("SWT.RIGHT_TO_LEFT");
  }
  public function createSizeGroup__(): void {
    sizeGroup = new Group(controlGroup, 0);
    sizeGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    sizeGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    sizeGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Size"));
    preferredButton = new Button(sizeGroup, 16);
    preferredButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Preferred"));
    tooSmallButton = new Button(sizeGroup, 16);
    tooSmallButton.setText__Ljava_lang_String_2(10 + " X " + 10);
    smallButton = new Button(sizeGroup, 16);
    smallButton.setText__Ljava_lang_String_2(50 + " X " + 50);
    largeButton = new Button(sizeGroup, 16);
    largeButton.setText__Ljava_lang_String_2(100 + " X " + 100);
    fillHButton = new Button(sizeGroup, 32);
    fillHButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Fill_X"));
    fillVButton = new Button(sizeGroup, 32);
    fillVButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Fill_Y"));
    var selectionListener: SelectionAdapter = new org.eclipse.swt.examples.controlexample.Tab$39(this);
    preferredButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    tooSmallButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    smallButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    largeButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    fillHButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    fillVButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    preferredButton.setSelection__Z(true);
  }
  public function createStyleGroup__(): void {
    styleGroup = new Group(controlGroup, 0);
    styleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    styleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    styleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Styles"));
  }
  public function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    shell = tabFolder.getShell__();
    display = shell.getDisplay__();
    tabFolderPage = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [tabFolder, 0]));
    tabFolderPage.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, false])));
    this.createExampleGroup__();
    this.createControlGroup__();
    this.createListenersGroup__();
    this.createExampleWidgets__();
    this.hookExampleWidgetListeners__();
    this.createControlWidgets__();
    this.createBackgroundModeGroup__();
    this.setExampleWidgetState__();
    return tabFolderPage;
  }
  public function setExampleWidgetPopupMenu__(): void {
    var controls: JavaArray = this.getExampleControls__();
    for (var i: int = 0; i < controls.length; i++) {
      var control: Control = controls[i];
      control.addListener__ILorg_eclipse_swt_widgets_Listener_2(35, new org.eclipse.swt.examples.controlexample.Tab$40(this, control));
    }
    return;
  }
  public function specialPopupMenuItems__Lorg_eclipse_swt_widgets_Menu_2Lorg_eclipse_swt_widgets_Event_2(menu: Menu, event: Event): void {
  }
  public function disposeExampleWidgets__(): void {
    var widgets: JavaArray = this.getExampleWidgets__();
    for (var i: int = 0; i < widgets.length; i++) {
      widgets[i].dispose__();
    }
    return;
  }
  public function colorImage__Lorg_eclipse_swt_graphics_Color_2(color: Color): Image {
    var image: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display, 12, 12]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [image]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    var bounds: Rectangle = image.getBounds__();
    gc.fillRectangle__IIII(0, 0, bounds.width, bounds.height);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(2));
    gc.drawRectangle__IIII(0, 0, bounds.width - 1, bounds.height - 1);
    gc.dispose__();
    return image;
  }
  public function fontImage__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): Image {
    var image: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display, 12, 12]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [image]));
    var bounds: Rectangle = image.getBounds__();
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(1));
    gc.fillRectangle__IIII(0, 0, bounds.width, bounds.height);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(2));
    gc.drawRectangle__IIII(0, 0, bounds.width - 1, bounds.height - 1);
    var data: JavaArray = font_1.getFontData__();
    var style: int = data[0].getStyle__();
    switch (style) {
      case 0 :
        gc.drawLine__IIII(3, 3, 3, 8);
        gc.drawLine__IIII(4, 3, 7, 8);
        gc.drawLine__IIII(8, 3, 8, 8);
        break;
      case 1 :
        gc.drawLine__IIII(3, 2, 3, 9);
        gc.drawLine__IIII(4, 2, 4, 9);
        gc.drawLine__IIII(5, 2, 7, 2);
        gc.drawLine__IIII(5, 3, 8, 3);
        gc.drawLine__IIII(5, 5, 7, 5);
        gc.drawLine__IIII(5, 6, 7, 6);
        gc.drawLine__IIII(5, 8, 8, 8);
        gc.drawLine__IIII(5, 9, 7, 9);
        gc.drawLine__IIII(7, 4, 8, 4);
        gc.drawLine__IIII(7, 7, 8, 7);
        break;
      case 2 :
        gc.drawLine__IIII(6, 2, 8, 2);
        gc.drawLine__IIII(7, 3, 4, 8);
        gc.drawLine__IIII(3, 9, 5, 9);
        break;
      case 1 | 2 :
        gc.drawLine__IIII(5, 2, 8, 2);
        gc.drawLine__IIII(5, 3, 8, 3);
        gc.drawLine__IIII(6, 4, 4, 7);
        gc.drawLine__IIII(7, 4, 5, 7);
        gc.drawLine__IIII(3, 8, 6, 8);
        gc.drawLine__IIII(3, 9, 6, 9);
        break;
    }
    gc.dispose__();
    return image;
  }
  public function getCustomEventNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").lengths(0);
  }
  public function getDefaultStyle__(): int {
    if (ltrButton !== null && ltrButton.getSelection__()) {
      return 33554432;
    }
    if (rtlButton !== null && rtlButton.getSelection__()) {
      return 67108864;
    }
    return 0;
  }
  public function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").lengths(0);
  }
  public function getExampleControls__(): JavaArray {
    var widgets: JavaArray = this.getExampleWidgets__();
    var controls: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
    for (var i: int = 0; i < widgets.length; i++) {
      if (widgets[i] is Control) {
        var newControls: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(controls.length + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(controls, 0, newControls, 0, controls.length);
        controls = newControls;
        controls[controls.length - 1] = Control(widgets[i]);
      }
    }
    return controls;
  }
  public function getExampleWidgetItems__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Item;").lengths(0);
  }
  public function getShortTabText__(): String {
    return this.getTabText__();
  }
  public function getTabText__(): String {
    return "";
  }
  public function hookExampleWidgetListeners__(): void {
    if (logging) {
      var widgets: JavaArray = this.getExampleWidgets__();
      for (var i: int = 0; i < widgets.length; i++) {
        this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(widgets[i]);
      }
      var exampleItems: JavaArray = this.getExampleWidgetItems__();
      for (var i_1: int = 0; i_1 < exampleItems.length; i_1++) {
        this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(exampleItems[i_1]);
      }
      var customNames: JavaArray = this.getCustomEventNames__();
      for (var i_2: int = 0; i_2 < customNames.length; i_2++) {
        if (eventsFilter[EVENT_INFO.length + i_2]) {
          this.hookCustomListener__Ljava_lang_String_2(customNames[i_2]);
        }
      }
    }
    return;
  }
  public function hookCustomListener__Ljava_lang_String_2(eventName: String): void {
  }
  public function hookListeners__Lorg_eclipse_swt_widgets_Widget_2(widget: Widget): void {
    if (logging) {
      var listener: Listener = new org.eclipse.swt.examples.controlexample.Tab$41(this);
      for (var i: int = 0; i < EVENT_INFO.length; i++) {
        if (eventsFilter[i]) {
          widget.addListener__ILorg_eclipse_swt_widgets_Listener_2(EVENT_INFO[i].type, listener);
        }
      }
    }
    return;
  }
  public function log__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var i: int = 0;
    while (i < EVENT_INFO.length) {
      if (EVENT_INFO[i].type == event.type)
        break;
      i++;
    }
    var toString: String = EVENT_INFO[i].name + " [" + event.type + "]: ";
    switch (event.type) {
      case 1 :
      case 2 :
        toString += new KeyEvent(event).toString__();
        break;
      case 3 :
      case 4 :
      case 5 :
      case 6 :
      case 7 :
      case 8 :
      case 37 :
      case 32 :
        toString += new MouseEvent(event).toString__();
        break;
      case 9 :
        toString += new PaintEvent(event).toString__();
        break;
      case 10 :
      case 11 :
        toString += new ControlEvent(event).toString__();
        break;
      case 12 :
        toString += new DisposeEvent(event).toString__();
        break;
      case 13 :
      case 14 :
        toString += new SelectionEvent(event).toString__();
        break;
      case 15 :
      case 16 :
        toString += new FocusEvent(event).toString__();
        break;
      case 17 :
      case 18 :
        toString += new TreeEvent(event).toString__();
        break;
      case 19 :
      case 20 :
      case 21 :
      case 26 :
      case 27 :
        toString += new ShellEvent(event).toString__();
        break;
      case 22 :
      case 23 :
        toString += (event.widget is Menu) ? new MenuEvent(event).toString__() : event.toString__();
        break;
      case 24 :
        toString += new ModifyEvent(event).toString__();
        break;
      case 25 :
        toString += new VerifyEvent(event).toString__();
        break;
      case 28 :
        toString += new HelpEvent(event).toString__();
        break;
      case 30 :
        toString += new ArmEvent(event).toString__();
        break;
      case 31 :
        toString += new TraverseEvent(event).toString__();
        break;
      case 33 :
      case 34 :
      case 29 :
      case 35 :
      case 36 :
      default :
        toString += event.toString__();
    }
    this.log__Ljava_lang_String_2(toString);
    var mask: int = EVENT_INFO[i].setFields;
    if (!ignore && mask != 0) {
      var setFieldsEvent_1: Event = EVENT_INFO[i].event;
      if ((mask & 256) != 0)
        event.doit = setFieldsEvent_1.doit;
      if ((mask & 512) != 0)
        event.detail = setFieldsEvent_1.detail;
      if ((mask & 1024) != 0)
        event.text = setFieldsEvent_1.text;
      if ((mask & 2048) != 0)
        event.x = setFieldsEvent_1.x;
      if ((mask & 4096) != 0)
        event.y = setFieldsEvent_1.y;
      if ((mask & 8192) != 0)
        event.width = setFieldsEvent_1.width;
      if ((mask & 16384) != 0)
        event.height = setFieldsEvent_1.height;
      eventConsole.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Returning"));
      ignore = true;
      this.log__Lorg_eclipse_swt_widgets_Event_2(event);
      ignore = false;
    }
    return;
  }
  public function log__Ljava_lang_String_2(string: String): void {
    if (!eventConsole.isDisposed__()) {
      eventConsole.append__Ljava_lang_String_2(string);
      eventConsole.append__Ljava_lang_String_2("\n");
    }
    return;
  }
  public function log__Ljava_lang_String_2Lorg_eclipse_swt_events_TypedEvent_2(eventName: String, event: TypedEvent): void {
    this.log__Ljava_lang_String_2(eventName + ": " + event.toString__());
    return;
  }
  public function recreateExampleWidgets__(): void {
    this.disposeExampleWidgets__();
    this.createExampleWidgets__();
    this.hookExampleWidgetListeners__();
    this.setExampleWidgetState__();
    return;
  }
  public function resetColorsAndFonts__(): void {
    var oldColor: Color = foregroundColor;
    foregroundColor = null;
    this.setExampleWidgetForeground__();
    if (oldColor !== null)
      oldColor.dispose__();
    oldColor = backgroundColor;
    backgroundColor = null;
    this.setExampleWidgetBackground__();
    if (oldColor !== null)
      oldColor.dispose__();
    var oldFont: Font = font;
    font = null;
    this.setExampleWidgetFont__();
    this.setExampleWidgetSize__();
    if (oldFont !== null)
      oldFont.dispose__();
    return;
  }
  public function rtlSupport__(): Boolean {
    return RTL_SUPPORT_ENABLE;
  }
  public function setExampleGroupBackgroundColor__(): void {
    if (backgroundModeGroup === null)
      return;
    exampleGroup.setBackground__Lorg_eclipse_swt_graphics_Color_2(backgroundModeColorButton.getSelection__() ? display.getSystemColor__I(9) : null);
  }
  public function setExampleGroupBackgroundImage__(): void {
    if (backgroundModeGroup === null)
      return;
    exampleGroup.setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(backgroundModeImageButton.getSelection__() ? instance.images[4] : null);
  }
  public function setExampleGroupBackgroundMode__(): void {
    if (backgroundModeGroup === null)
      return;
    var modeString: String = backgroundModeCombo.getText__();
    var mode: int = 0;
    if (Object(modeString).equals__Ljava_lang_Object_2("SWT.INHERIT_DEFAULT"))
      mode = 1;
    if (Object(modeString).equals__Ljava_lang_Object_2("SWT.INHERIT_FORCE"))
      mode = 2;
    exampleGroup.setBackgroundMode__I(mode);
  }
  public function setExampleWidgetBackground__(): void {
    if (colorAndFontTable === null)
      return;
    var controls: JavaArray = this.getExampleControls__();
    if (!instance.startup) {
      for (var i: int = 0; i < controls.length; i++) {
        controls[i].setBackground__Lorg_eclipse_swt_graphics_Color_2(backgroundColor);
      }
    }
    var color: Color = backgroundColor;
    if (controls.length == 0)
      return;
    if (color === null)
      color = controls[0].getBackground__();
    var item: TableItem = colorAndFontTable.getItem__I(1);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
  }
  public function setExampleWidgetEnabled__(): void {
    var controls: JavaArray = this.getExampleControls__();
    for (var i: int = 0; i < controls.length; i++) {
      controls[i].setEnabled__Z(enabledButton.getSelection__());
    }
    return;
  }
  public function setExampleWidgetFont__(): void {
    if (colorAndFontTable === null)
      return;
    var controls: JavaArray = this.getExampleControls__();
    if (!instance.startup) {
      for (var i: int = 0; i < controls.length; i++) {
        controls[i].setFont__Lorg_eclipse_swt_graphics_Font_2(font);
      }
    }
    var ft: Font = font;
    if (controls.length == 0)
      return;
    if (ft === null)
      ft = controls[0].getFont__();
    var item: TableItem = colorAndFontTable.getItem__I(2);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.fontImage__Lorg_eclipse_swt_graphics_Font_2(ft));
    item.setFont__Lorg_eclipse_swt_graphics_Font_2(ft);
    colorAndFontTable.layout__();
  }
  public function setExampleWidgetForeground__(): void {
    if (colorAndFontTable === null)
      return;
    var controls: JavaArray = this.getExampleControls__();
    if (!instance.startup) {
      for (var i: int = 0; i < controls.length; i++) {
        controls[i].setForeground__Lorg_eclipse_swt_graphics_Color_2(foregroundColor);
      }
    }
    var color: Color = foregroundColor;
    if (controls.length == 0)
      return;
    if (color === null)
      color = controls[0].getForeground__();
    var item: TableItem = colorAndFontTable.getItem__I(0);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
  }
  public function setExampleWidgetSize__(): void {
    var size: int = -1;
    if (preferredButton === null)
      return;
    if (preferredButton.getSelection__())
      size = -1;
    if (tooSmallButton.getSelection__())
      size = 10;
    if (smallButton.getSelection__())
      size = 50;
    if (largeButton.getSelection__())
      size = 100;
    var controls: JavaArray = this.getExampleControls__();
    for (var i: int = 0; i < controls.length; i++) {
      var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__II, [size, size]));
      gridData.grabExcessHorizontalSpace = fillHButton.getSelection__();
      gridData.grabExcessVerticalSpace = fillVButton.getSelection__();
      gridData.horizontalAlignment = fillHButton.getSelection__() ? 4 : 16384;
      gridData.verticalAlignment = fillVButton.getSelection__() ? 4 : 128;
      controls[i].setLayoutData__Ljava_lang_Object_2(gridData);
    }
    tabFolderPage.layout___3Lorg_eclipse_swt_widgets_Control_2(controls);
    return;
  }
  public function setExampleWidgetState__(): void {
    this.setExampleWidgetBackground__();
    this.setExampleWidgetForeground__();
    this.setExampleWidgetFont__();
    if (!instance.startup) {
      this.setExampleWidgetEnabled__();
      this.setExampleWidgetVisibility__();
      this.setExampleGroupBackgroundMode__();
      this.setExampleGroupBackgroundColor__();
      this.setExampleGroupBackgroundImage__();
      this.setExampleWidgetBackgroundImage__();
      this.setExampleWidgetPopupMenu__();
      this.setExampleWidgetSize__();
    }
    return;
  }
  public function setExampleWidgetVisibility__(): void {
    var controls: JavaArray = this.getExampleControls__();
    for (var i: int = 0; i < controls.length; i++) {
      controls[i].setVisible__Z(visibleButton.getSelection__());
    }
    return;
  }
  public function setExampleWidgetBackgroundImage__(): void {
    if (backgroundImageButton !== null && backgroundImageButton.isDisposed__())
      return;
    var controls: JavaArray = this.getExampleControls__();
    for (var i: int = 0; i < controls.length; i++) {
      controls[i].setBackgroundImage__Lorg_eclipse_swt_graphics_Image_2(backgroundImageButton.getSelection__() ? instance.images[3] : null);
    }
    return;
  }
  public function split__Ljava_lang_String_2C(string: String, ch: uint): JavaArray {
    var result: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(0);
    var start: int = 0;
    var length: int = Object(string).length__();
    while (start < length) {
      var end: int = Object(string).indexOf__II(ch, start);
      if (end == -1)
        end = length;
      var substr: String = Object(string).substring__II(start, end);
      var newResult: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(result.length + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, newResult, 0, result.length);
      newResult[result.length] = substr;
      result = newResult;
      start = end + 1;
    }
    return result;
  }
}
}
