package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TabFolderTab extends Tab {
  internal var tabFolder1: TabFolder;
  internal var tabFolderGroup: Group;
  internal var topButton: Button;
  internal var bottomButton: Button;
  public static var TabItems1: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("TabItem1_0"), ControlExample.getResourceString__Ljava_lang_String_2("TabItem1_1"), ControlExample.getResourceString__Ljava_lang_String_2("TabItem1_2"));
  function TabFolderTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    tabFolderGroup = new Group(exampleGroup, 0);
    tabFolderGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    tabFolderGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    tabFolderGroup.setText__Ljava_lang_String_2("TabFolder");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (topButton.getSelection__())
      style |= 128;
    if (bottomButton.getSelection__())
      style |= 1024;
    if (borderButton.getSelection__())
      style |= 2048;
    tabFolder1 = new TabFolder(tabFolderGroup, style);
    for (var i: int = 0; i < TabItems1.length; i++) {
      var item: TabItem = new TabItem(new Arguments(org.eclipse.swt.widgets.TabItem.TabItem__Lorg_eclipse_swt_widgets_TabFolder_2I, [tabFolder1, 0]));
      item.setText__Ljava_lang_String_2(TabItems1[i]);
      item.setToolTipText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Tooltip", new JavaArray("[Ljava/lang/String;").values(TabItems1[i])));
      var content: Text = new Text(tabFolder1, 64 | 2);
      content.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("TabItem_content") + ": " + i);
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(content);
    }
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    topButton = new Button(styleGroup, 16);
    topButton.setText__Ljava_lang_String_2("SWT.TOP");
    topButton.setSelection__Z(true);
    bottomButton = new Button(styleGroup, 16);
    bottomButton.setText__Ljava_lang_String_2("SWT.BOTTOM");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgetItems__(): JavaArray {
    return tabFolder1.getItems__();
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(tabFolder1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Selection", "SelectionIndex", "ToolTipText");
  }
  public override function setMethodName__Ljava_lang_String_2(methodRoot: String): String {
    return (Object(methodRoot).equals__Ljava_lang_Object_2("SelectionIndex")) ? "setSelection" : "set" + methodRoot;
  }
  public override function parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName: String, value: String, widget: Widget): JavaArray {
    if (Object(value).equals__Ljava_lang_Object_2(""))
      return new JavaArray("[Ljava/lang/Object;").values(new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(0));
    if (Object(typeName).equals__Ljava_lang_Object_2("org.eclipse.swt.widgets.TabItem")) {
      var item: TabItem = this.findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TabItem_2(value, (TabFolder(widget)).getItems__());
      if (item !== null)
        return new JavaArray("[Ljava/lang/Object;").values(item);
    }
    if (Object(typeName).equals__Ljava_lang_Object_2("[Lorg.eclipse.swt.widgets.TabItem;")) {
      var values: JavaArray = this.split__Ljava_lang_String_2C(value, 44);
      var items: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(values.length);
      for (var i: int = 0; i < values.length; i++) {
        items[i] = this.findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TabItem_2(values[i], (TabFolder(widget)).getItems__());
      }
      return new JavaArray("[Ljava/lang/Object;").values(items);
    }
    return super.parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName, value, widget);
  }
  public function findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TabItem_2(value: String, items: JavaArray): TabItem {
    for (var i: int = 0; i < items.length; i++) {
      var item: TabItem = items[i];
      if (Object(item.getText__()).equals__Ljava_lang_Object_2(value))
        return item;
    }
    return null;
  }
  public override function getShortTabText__(): String {
    return "TF";
  }
  public override function getTabText__(): String {
    return "TabFolder";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    topButton.setSelection__Z((tabFolder1.getStyle__() & 128) != 0);
    bottomButton.setSelection__Z((tabFolder1.getStyle__() & 1024) != 0);
    borderButton.setSelection__Z((tabFolder1.getStyle__() & 2048) != 0);
  }
}
}
