package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TextTab extends ScrollableTab {
  internal var text: Text;
  internal var textGroup: Group;
  internal var wrapButton: Button;
  internal var readOnlyButton: Button;
  internal var passwordButton: Button;
  internal var searchButton: Button;
  internal var iconCancelButton: Button;
  internal var iconSearchButton: Button;
  internal var leftButton: Button;
  internal var centerButton: Button;
  internal var rightButton: Button;
  function TextTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    textGroup = new Group(exampleGroup, 0);
    textGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    textGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    textGroup.setText__Ljava_lang_String_2("Text");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (singleButton.getSelection__())
      style |= 4;
    if (multiButton.getSelection__())
      style |= 2;
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (wrapButton.getSelection__())
      style |= 64;
    if (readOnlyButton.getSelection__())
      style |= 8;
    if (passwordButton.getSelection__())
      style |= 4194304;
    if (searchButton.getSelection__())
      style |= 128;
    if (iconCancelButton.getSelection__())
      style |= 256;
    if (iconSearchButton.getSelection__())
      style |= 512;
    if (borderButton.getSelection__())
      style |= 2048;
    if (leftButton.getSelection__())
      style |= 16384;
    if (centerButton.getSelection__())
      style |= 16777216;
    if (rightButton.getSelection__())
      style |= 131072;
    text = new Text(textGroup, style);
    text.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string") + "\n" + ControlExample.getResourceString__Ljava_lang_String_2("One_Two_Three"));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    wrapButton = new Button(styleGroup, 32);
    wrapButton.setText__Ljava_lang_String_2("SWT.WRAP");
    readOnlyButton = new Button(styleGroup, 32);
    readOnlyButton.setText__Ljava_lang_String_2("SWT.READ_ONLY");
    passwordButton = new Button(styleGroup, 32);
    passwordButton.setText__Ljava_lang_String_2("SWT.PASSWORD");
    searchButton = new Button(styleGroup, 32);
    searchButton.setText__Ljava_lang_String_2("SWT.SEARCH");
    iconCancelButton = new Button(styleGroup, 32);
    iconCancelButton.setText__Ljava_lang_String_2("SWT.ICON_CANCEL");
    iconSearchButton = new Button(styleGroup, 32);
    iconSearchButton.setText__Ljava_lang_String_2("SWT.ICON_SEARCH");
    var alignmentGroup: Composite = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [styleGroup, 0]));
    var layout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    layout.marginWidth = layout.marginHeight = 0;
    alignmentGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout);
    alignmentGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808])));
    leftButton = new Button(alignmentGroup, 16);
    leftButton.setText__Ljava_lang_String_2("SWT.LEFT");
    centerButton = new Button(alignmentGroup, 16);
    centerButton.setText__Ljava_lang_String_2("SWT.CENTER");
    rightButton = new Button(alignmentGroup, 16);
    rightButton.setText__Ljava_lang_String_2("SWT.RIGHT");
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.TextTab$1(this));
    return tabFolderPage;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(text);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("DoubleClickEnabled", "EchoChar", "Editable", "Message", "Orientation", "Selection", "Tabs", "Text", "TextLimit", "ToolTipText", "TopIndex");
  }
  public override function getTabText__(): String {
    return "Text";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    wrapButton.setSelection__Z((text.getStyle__() & 64) != 0);
    readOnlyButton.setSelection__Z((text.getStyle__() & 8) != 0);
    passwordButton.setSelection__Z((text.getStyle__() & 4194304) != 0);
    searchButton.setSelection__Z((text.getStyle__() & 128) != 0);
    leftButton.setSelection__Z((text.getStyle__() & 16384) != 0);
    centerButton.setSelection__Z((text.getStyle__() & 16777216) != 0);
    rightButton.setSelection__Z((text.getStyle__() & 131072) != 0);
    if ((text.getStyle__() & 128) != 0) {
      iconCancelButton.setSelection__Z((text.getStyle__() & 256) != 0);
      iconSearchButton.setSelection__Z((text.getStyle__() & 512) != 0);
      horizontalButton.setSelection__Z(false);
      verticalButton.setSelection__Z(false);
    } else {
      iconCancelButton.setSelection__Z(false);
      iconSearchButton.setSelection__Z(false);
      horizontalButton.setSelection__Z((text.getStyle__() & 256) != 0);
      verticalButton.setSelection__Z((text.getStyle__() & 512) != 0);
    }
    passwordButton.setEnabled__Z((text.getStyle__() & 4) != 0);
    searchButton.setEnabled__Z((text.getStyle__() & 4) != 0);
    iconCancelButton.setEnabled__Z((text.getStyle__() & 128) != 0);
    iconSearchButton.setEnabled__Z((text.getStyle__() & 128) != 0);
    wrapButton.setEnabled__Z((text.getStyle__() & 2) != 0);
    horizontalButton.setEnabled__Z((text.getStyle__() & 2) != 0);
    verticalButton.setEnabled__Z((text.getStyle__() & 2) != 0);
    return;
  }
}
}
