package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Item;
import java.lang.System;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ToolBarTab extends Tab {
  internal var imageToolBar: ToolBar;
  internal var textToolBar: ToolBar;
  internal var imageTextToolBar: ToolBar;
  internal var imageToolBarGroup: Group;
  internal var textToolBarGroup: Group;
  internal var imageTextToolBarGroup: Group;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var flatButton: Button;
  internal var shadowOutButton: Button;
  internal var wrapButton: Button;
  internal var rightButton: Button;
  internal var comboChildButton: Button;
  function ToolBarTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    imageToolBarGroup = new Group(exampleGroup, 0);
    imageToolBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    imageToolBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imageToolBarGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Image_ToolBar"));
    textToolBarGroup = new Group(exampleGroup, 0);
    textToolBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    textToolBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    textToolBarGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Text_ToolBar"));
    imageTextToolBarGroup = new Group(exampleGroup, 0);
    imageTextToolBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    imageTextToolBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imageTextToolBarGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("ImageText_ToolBar"));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (flatButton.getSelection__())
      style |= 8388608;
    if (wrapButton.getSelection__())
      style |= 64;
    if (borderButton.getSelection__())
      style |= 2048;
    if (shadowOutButton.getSelection__())
      style |= 8;
    if (rightButton.getSelection__())
      style |= 131072;
    imageToolBar = new ToolBar(imageToolBarGroup, style);
    var item: ToolItem = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 2]));
    item.setToolTipText__Ljava_lang_String_2("SWT.SEPARATOR");
    if (comboChildButton.getSelection__()) {
      var combo: Combo = new Combo(imageToolBar, 0);
      combo.setItems___3Ljava_lang_String_2(new JavaArray("[Ljava/lang/String;").values("250", "500", "750"));
      combo.setText__Ljava_lang_String_2(combo.getItem__I(0));
      combo.pack__();
      item.setWidth__I(combo.getSize__().x);
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(combo);
    }
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageToolBar, 4]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setToolTipText__Ljava_lang_String_2("SWT.DROP_DOWN");
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new ToolBarTab$DropDownSelectionListener(this));
    textToolBar = new ToolBar(textToolBarGroup, style);
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 8]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Push"));
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 8]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Push"));
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 16]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 16]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 32]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Check"));
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 16]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 16]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 2]));
    item.setToolTipText__Ljava_lang_String_2("SWT.SEPARATOR");
    if (comboChildButton.getSelection__()) {
      var combo_1: Combo = new Combo(textToolBar, 0);
      combo_1.setItems___3Ljava_lang_String_2(new JavaArray("[Ljava/lang/String;").values("250", "500", "750"));
      combo_1.setText__Ljava_lang_String_2(combo_1.getItem__I(0));
      combo_1.pack__();
      item.setWidth__I(combo_1.getSize__().x);
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(combo_1);
    }
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [textToolBar, 4]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Drop_Down"));
    item.setToolTipText__Ljava_lang_String_2("SWT.DROP_DOWN");
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new ToolBarTab$DropDownSelectionListener(this));
    imageTextToolBar = new ToolBar(imageTextToolBarGroup, style);
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Push"));
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Push"));
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Check"));
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Radio"));
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 2]));
    item.setToolTipText__Ljava_lang_String_2("SWT.SEPARATOR");
    if (comboChildButton.getSelection__()) {
      var combo_2: Combo = new Combo(imageTextToolBar, 0);
      combo_2.setItems___3Ljava_lang_String_2(new JavaArray("[Ljava/lang/String;").values("250", "500", "750"));
      combo_2.setText__Ljava_lang_String_2(combo_2.getItem__I(0));
      combo_2.pack__();
      item.setWidth__I(combo_2.getSize__().x);
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(combo_2);
    }
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [imageTextToolBar, 4]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Drop_Down"));
    item.setToolTipText__Ljava_lang_String_2("SWT.DROP_DOWN");
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new ToolBarTab$DropDownSelectionListener(this));
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    comboChildButton = new Button(otherGroup, 32);
    comboChildButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Combo_child"));
    comboChildButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ToolBarTab$1(this));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    horizontalButton = new Button(styleGroup, 16);
    horizontalButton.setText__Ljava_lang_String_2("SWT.HORIZONTAL");
    verticalButton = new Button(styleGroup, 16);
    verticalButton.setText__Ljava_lang_String_2("SWT.VERTICAL");
    flatButton = new Button(styleGroup, 32);
    flatButton.setText__Ljava_lang_String_2("SWT.FLAT");
    shadowOutButton = new Button(styleGroup, 32);
    shadowOutButton.setText__Ljava_lang_String_2("SWT.SHADOW_OUT");
    wrapButton = new Button(styleGroup, 32);
    wrapButton.setText__Ljava_lang_String_2("SWT.WRAP");
    rightButton = new Button(styleGroup, 32);
    rightButton.setText__Ljava_lang_String_2("SWT.RIGHT");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function disposeExampleWidgets__(): void {
    super.disposeExampleWidgets__();
    return;
  }
  public override function getExampleWidgetItems__(): JavaArray {
    var imageToolBarItems: JavaArray = imageToolBar.getItems__();
    var textToolBarItems: JavaArray = textToolBar.getItems__();
    var imageTextToolBarItems: JavaArray = imageTextToolBar.getItems__();
    var allItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Item;").lengths(imageToolBarItems.length + textToolBarItems.length + imageTextToolBarItems.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(imageToolBarItems, 0, allItems, 0, imageToolBarItems.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textToolBarItems, 0, allItems, imageToolBarItems.length, textToolBarItems.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(imageTextToolBarItems, 0, allItems, imageToolBarItems.length + textToolBarItems.length, imageTextToolBarItems.length);
    return allItems;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(imageToolBar, textToolBar, imageTextToolBar);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("ToolTipText");
  }
  public override function getShortTabText__(): String {
    return "TB";
  }
  public override function getTabText__(): String {
    return "ToolBar";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    horizontalButton.setSelection__Z((imageToolBar.getStyle__() & 256) != 0);
    verticalButton.setSelection__Z((imageToolBar.getStyle__() & 512) != 0);
    flatButton.setSelection__Z((imageToolBar.getStyle__() & 8388608) != 0);
    wrapButton.setSelection__Z((imageToolBar.getStyle__() & 64) != 0);
    shadowOutButton.setSelection__Z((imageToolBar.getStyle__() & 8) != 0);
    borderButton.setSelection__Z((imageToolBar.getStyle__() & 2048) != 0);
    rightButton.setSelection__Z((imageToolBar.getStyle__() & 131072) != 0);
  }
}
}
