package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ToolTipTab extends Tab {
  internal var toolTip1: ToolTip;
  internal var toolTipGroup: Group;
  internal var balloonButton: Button;
  internal var iconErrorButton: Button;
  internal var iconInformationButton: Button;
  internal var iconWarningButton: Button;
  internal var noIconButton: Button;
  internal var autoHideButton: Button;
  internal var showInTrayButton: Button;
  internal var tray: Tray;
  internal var trayItem: TrayItem;
  function ToolTipTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    toolTipGroup = new Group(exampleGroup, 0);
    toolTipGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    toolTipGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    toolTipGroup.setText__Ljava_lang_String_2("ToolTip");
    visibleButton = new Button(toolTipGroup, 32);
    visibleButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Visible"));
    visibleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ToolTipTab$1(this));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (balloonButton.getSelection__())
      style |= 4096;
    if (iconErrorButton.getSelection__())
      style |= 1;
    if (iconInformationButton.getSelection__())
      style |= 2;
    if (iconWarningButton.getSelection__())
      style |= 8;
    toolTip1 = new ToolTip(shell, style);
    toolTip1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("ToolTip_Title"));
    toolTip1.setMessage__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string"));
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.ToolTipTab$2(this));
    return tabFolderPage;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    balloonButton = new Button(styleGroup, 32);
    balloonButton.setText__Ljava_lang_String_2("SWT.BALLOON");
    iconErrorButton = new Button(styleGroup, 16);
    iconErrorButton.setText__Ljava_lang_String_2("SWT.ICON_ERROR");
    iconInformationButton = new Button(styleGroup, 16);
    iconInformationButton.setText__Ljava_lang_String_2("SWT.ICON_INFORMATION");
    iconWarningButton = new Button(styleGroup, 16);
    iconWarningButton.setText__Ljava_lang_String_2("SWT.ICON_WARNING");
    noIconButton = new Button(styleGroup, 16);
    noIconButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("No_Icon"));
  }
  public override function createColorAndFontGroup__(): void {
  }
  public override function createOtherGroup__(): void {
    otherGroup = new Group(controlGroup, 0);
    otherGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    otherGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, false, false])));
    otherGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Other"));
    autoHideButton = new Button(otherGroup, 32);
    autoHideButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("AutoHide"));
    showInTrayButton = new Button(otherGroup, 32);
    showInTrayButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Show_In_Tray"));
    tray = display.getSystemTray__();
    showInTrayButton.setEnabled__Z(tray !== null);
    autoHideButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ToolTipTab$3(this));
    showInTrayButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.ToolTipTab$4(this));
    shell.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.ToolTipTab$5(this));
    autoHideButton.setSelection__Z(true);
  }
  public override function createSizeGroup__(): void {
  }
  public override function disposeExampleWidgets__(): void {
    this.disposeTrayItem__();
    super.disposeExampleWidgets__();
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(toolTip1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Message", "Text");
  }
  public override function getTabText__(): String {
    return "ToolTip";
  }
  public override function setExampleWidgetState__(): void {
    this.showExampleWidgetInTray__();
    this.setExampleWidgetAutoHide__();
    super.setExampleWidgetState__();
    balloonButton.setSelection__Z((toolTip1.getStyle__() & 4096) != 0);
    iconErrorButton.setSelection__Z((toolTip1.getStyle__() & 1) != 0);
    iconInformationButton.setSelection__Z((toolTip1.getStyle__() & 2) != 0);
    iconWarningButton.setSelection__Z((toolTip1.getStyle__() & 8) != 0);
    noIconButton.setSelection__Z((toolTip1.getStyle__() & (1 | 2 | 8)) == 0);
    autoHideButton.setSelection__Z(toolTip1.getAutoHide__());
  }
  public override function setExampleWidgetVisibility__(): void {
    toolTip1.setVisible__Z(visibleButton.getSelection__());
  }
  public function setExampleWidgetAutoHide__(): void {
    toolTip1.setAutoHide__Z(autoHideButton.getSelection__());
  }
  public function showExampleWidgetInTray__(): void {
    if (showInTrayButton.getSelection__()) {
      this.createTrayItem__();
      trayItem.setToolTip__Lorg_eclipse_swt_widgets_ToolTip_2(toolTip1);
    } else {
      this.disposeTrayItem__();
    }
    return;
  }
  public function createTrayItem__(): void {
    if (trayItem === null) {
      trayItem = new TrayItem(tray, 0);
      trayItem.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    }
    return;
  }
  public function disposeTrayItem__(): void {
    if (trayItem !== null) {
      trayItem.setToolTip__Lorg_eclipse_swt_widgets_ToolTip_2(null);
      trayItem.dispose__();
      trayItem = null;
    }
    return;
  }
}
}
