package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TreeColumn;
import java.lang.IllegalArgumentException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import java.lang.System;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TreeTab extends ScrollableTab {
  internal var tree1: Tree;
  internal var tree2: Tree;
  internal var textNode1: TreeItem;
  internal var imageNode1: TreeItem;
  internal var treeGroup: Group;
  internal var imageTreeGroup: Group;
  internal var itemGroup: Group;
  internal var packColumnsButton: Button;
  internal var noScrollButton: Button;
  internal var checkButton: Button;
  internal var fullSelectionButton: Button;
  internal var multipleColumns: Button;
  internal var moveableColumns: Button;
  internal var resizableColumns: Button;
  internal var headerVisibleButton: Button;
  internal var sortIndicatorButton: Button;
  internal var headerImagesButton: Button;
  internal var subImagesButton: Button;
  internal var linesVisibleButton: Button;
  public static const ITEM_FOREGROUND_COLOR: int = 3;
  public static const ITEM_BACKGROUND_COLOR: int = 4;
  public static const ITEM_FONT: int = 5;
  public static const CELL_FOREGROUND_COLOR: int = 6;
  public static const CELL_BACKGROUND_COLOR: int = 7;
  public static const CELL_FONT: int = 8;
  internal var itemForegroundColor: Color;
  internal var itemBackgroundColor: Color;
  internal var cellForegroundColor: Color;
  internal var cellBackgroundColor: Color;
  internal var itemFont: Font;
  internal var cellFont: Font;
  public static var columnTitles: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("TableTitle_0"), ControlExample.getResourceString__Ljava_lang_String_2("TableTitle_1"), ControlExample.getResourceString__Ljava_lang_String_2("TableTitle_2"), ControlExample.getResourceString__Ljava_lang_String_2("TableTitle_3"));
  public static var tableData: JavaArray = new JavaArray("[[Ljava/lang/String;").values(new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("TableLine0_0"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine0_1"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine0_2"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine0_3")), new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("TableLine1_0"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine1_1"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine1_2"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine1_3")), new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("TableLine2_0"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine2_1"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine2_2"), ControlExample.getResourceString__Ljava_lang_String_2("TableLine2_3")));
  internal var menuMouseCoords: Point;
  function TreeTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createColorAndFontGroup__(): void {
    super.createColorAndFontGroup__();
    var item: TableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item_Foreground_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item_Background_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item_Font"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Cell_Foreground_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Cell_Background_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Cell_Font"));
    shell.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$1(this));
    return;
  }
  public override function changeFontOrColor__I(index: int): void {
    switch (index) {
      case 3 :
        {
          var oldColor: Color = itemForegroundColor;
          if (oldColor === null)
            oldColor = textNode1.getForeground__();
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor.getRGB__());
          var rgb: RGB = colorDialog.open__();
          if (rgb === null)
            return;
          oldColor = itemForegroundColor;
          itemForegroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb]));
          this.setItemForeground__();
          if (oldColor !== null)
            oldColor.dispose__();
        }
        break;
      case 4 :
        {
          var oldColor_1: Color = itemBackgroundColor;
          if (oldColor_1 === null)
            oldColor_1 = textNode1.getBackground__();
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor_1.getRGB__());
          var rgb_1: RGB = colorDialog.open__();
          if (rgb_1 === null)
            return;
          oldColor_1 = itemBackgroundColor;
          itemBackgroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb_1]));
          this.setItemBackground__();
          if (oldColor_1 !== null)
            oldColor_1.dispose__();
        }
        break;
      case 5 :
        {
          var oldFont: Font = itemFont;
          if (oldFont === null)
            oldFont = textNode1.getFont__();
          fontDialog.setFontList___3Lorg_eclipse_swt_graphics_FontData_2(oldFont.getFontData__());
          var fontData: FontData = fontDialog.open__();
          if (fontData === null)
            return;
          oldFont = itemFont;
          itemFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [display, fontData]));
          this.setItemFont__();
          this.setExampleWidgetSize__();
          if (oldFont !== null)
            oldFont.dispose__();
        }
        break;
      case 6 :
        {
          var oldColor_2: Color = cellForegroundColor;
          if (oldColor_2 === null)
            oldColor_2 = textNode1.getForeground__I(1);
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor_2.getRGB__());
          var rgb_2: RGB = colorDialog.open__();
          if (rgb_2 === null)
            return;
          oldColor_2 = cellForegroundColor;
          cellForegroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb_2]));
          this.setCellForeground__();
          if (oldColor_2 !== null)
            oldColor_2.dispose__();
        }
        break;
      case 7 :
        {
          var oldColor_3: Color = cellBackgroundColor;
          if (oldColor_3 === null)
            oldColor_3 = textNode1.getBackground__I(1);
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor_3.getRGB__());
          var rgb_3: RGB = colorDialog.open__();
          if (rgb_3 === null)
            return;
          oldColor_3 = cellBackgroundColor;
          cellBackgroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb_3]));
          this.setCellBackground__();
          if (oldColor_3 !== null)
            oldColor_3.dispose__();
        }
        break;
      case 8 :
        {
          var oldFont_1: Font = cellFont;
          if (oldFont_1 === null)
            oldFont_1 = textNode1.getFont__I(1);
          fontDialog.setFontList___3Lorg_eclipse_swt_graphics_FontData_2(oldFont_1.getFontData__());
          var fontData_1: FontData = fontDialog.open__();
          if (fontData_1 === null)
            return;
          oldFont_1 = cellFont;
          cellFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [display, fontData_1]));
          this.setCellFont__();
          this.setExampleWidgetSize__();
          if (oldFont_1 !== null)
            oldFont_1.dispose__();
        }
        break;
      default :
        super.changeFontOrColor__I(index);
    }
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    linesVisibleButton = new Button(otherGroup, 32);
    linesVisibleButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Lines_Visible"));
    multipleColumns = new Button(otherGroup, 32);
    multipleColumns.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Multiple_Columns"));
    headerVisibleButton = new Button(otherGroup, 32);
    headerVisibleButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Header_Visible"));
    sortIndicatorButton = new Button(otherGroup, 32);
    sortIndicatorButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Sort_Indicator"));
    moveableColumns = new Button(otherGroup, 32);
    moveableColumns.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Moveable_Columns"));
    resizableColumns = new Button(otherGroup, 32);
    resizableColumns.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Resizable_Columns"));
    headerImagesButton = new Button(otherGroup, 32);
    headerImagesButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Header_Images"));
    subImagesButton = new Button(otherGroup, 32);
    subImagesButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Sub_Images"));
    linesVisibleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$2(this));
    multipleColumns.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$3(this));
    headerVisibleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$4(this));
    sortIndicatorButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$5(this));
    moveableColumns.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$6(this));
    resizableColumns.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$7(this));
    headerImagesButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$8(this));
    subImagesButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$9(this));
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    treeGroup = new Group(exampleGroup, 0);
    treeGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    treeGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    treeGroup.setText__Ljava_lang_String_2("Tree");
    imageTreeGroup = new Group(exampleGroup, 0);
    imageTreeGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    imageTreeGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imageTreeGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Tree_With_Images"));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (singleButton.getSelection__())
      style |= 4;
    if (multiButton.getSelection__())
      style |= 2;
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (noScrollButton.getSelection__())
      style |= 16;
    if (checkButton.getSelection__())
      style |= 32;
    if (fullSelectionButton.getSelection__())
      style |= 65536;
    if (borderButton.getSelection__())
      style |= 2048;
    tree1 = new Tree(treeGroup, style);
    var multiColumn: Boolean = multipleColumns.getSelection__();
    if (multiColumn) {
      for (var i: int = 0; i < columnTitles.length; i++) {
        var treeColumn: TreeColumn = new TreeColumn(new Arguments(org.eclipse.swt.widgets.TreeColumn.TreeColumn__Lorg_eclipse_swt_widgets_Tree_2I, [tree1, 0]));
        treeColumn.setText__Ljava_lang_String_2(columnTitles[i]);
        treeColumn.setToolTipText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Tooltip", new JavaArray("[Ljava/lang/String;").values(columnTitles[i])));
      }
      tree1.setSortColumn__Lorg_eclipse_swt_widgets_TreeColumn_2(tree1.getColumn__I(0));
    }
    for (var i_1: int = 0; i_1 < 4; i_1++) {
      var item: TreeItem = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_Tree_2I, [tree1, 0]));
      this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item, i_1, ControlExample.getResourceString__Ljava_lang_String_2("Node_" + (i_1 + 1)));
      if (i_1 < 3) {
        var subitem: TreeItem = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [item, 0]));
        this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(subitem, i_1, ControlExample.getResourceString__Ljava_lang_String_2("Node_" + (i_1 + 1) + "_1"));
      }
    }
    var treeRoots: JavaArray = tree1.getItems__();
    var item_1: TreeItem = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [treeRoots[1], 0]));
    this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item_1, 1, ControlExample.getResourceString__Ljava_lang_String_2("Node_2_2"));
    item_1 = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [item_1, 0]));
    this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item_1, 1, ControlExample.getResourceString__Ljava_lang_String_2("Node_2_2_1"));
    textNode1 = treeRoots[0];
    this.packColumns__Lorg_eclipse_swt_widgets_Tree_2(tree1);
    try {
      var column: TreeColumn = tree1.getColumn__I(0);
      resizableColumns.setSelection__Z(column.getResizable__());
    } catch (ex : IllegalArgumentException) {
    }
    tree2 = new Tree(imageTreeGroup, style);
    var image: Image = instance.images[0];
    if (multiColumn) {
      for (var i_2: int = 0; i_2 < columnTitles.length; i_2++) {
        var treeColumn_1: TreeColumn = new TreeColumn(new Arguments(org.eclipse.swt.widgets.TreeColumn.TreeColumn__Lorg_eclipse_swt_widgets_Tree_2I, [tree2, 0]));
        treeColumn_1.setText__Ljava_lang_String_2(columnTitles[i_2]);
        treeColumn_1.setToolTipText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Tooltip", new JavaArray("[Ljava/lang/String;").values(columnTitles[i_2])));
        if (headerImagesButton.getSelection__())
          treeColumn_1.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[i_2 % 3]);
      }
    }
    for (var i_3: int = 0; i_3 < 4; i_3++) {
      item_1 = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_Tree_2I, [tree2, 0]));
      this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item_1, i_3, ControlExample.getResourceString__Ljava_lang_String_2("Node_" + (i_3 + 1)));
      if (multiColumn && subImagesButton.getSelection__()) {
        for (var j: int = 0; j < columnTitles.length; j++) {
          item_1.setImage__ILorg_eclipse_swt_graphics_Image_2(j, image);
        }
      } else {
        item_1.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
      }
      if (i_3 < 3) {
        var subitem_1: TreeItem = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [item_1, 0]));
        this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(subitem_1, i_3, ControlExample.getResourceString__Ljava_lang_String_2("Node_" + (i_3 + 1) + "_1"));
        if (multiColumn && subImagesButton.getSelection__()) {
          for (var j_1: int = 0; j_1 < columnTitles.length; j_1++) {
            subitem_1.setImage__ILorg_eclipse_swt_graphics_Image_2(j_1, image);
          }
        } else {
          subitem_1.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
        }
      }
    }
    treeRoots = tree2.getItems__();
    item_1 = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [treeRoots[1], 0]));
    this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item_1, 1, ControlExample.getResourceString__Ljava_lang_String_2("Node_2_2"));
    if (multiColumn && subImagesButton.getSelection__()) {
      for (var j_2: int = 0; j_2 < columnTitles.length; j_2++) {
        item_1.setImage__ILorg_eclipse_swt_graphics_Image_2(j_2, image);
      }
    } else {
      item_1.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
    }
    item_1 = new TreeItem(new Arguments(org.eclipse.swt.widgets.TreeItem.TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I, [item_1, 0]));
    this.setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item_1, 1, ControlExample.getResourceString__Ljava_lang_String_2("Node_2_2_1"));
    if (multiColumn && subImagesButton.getSelection__()) {
      for (var j_3: int = 0; j_3 < columnTitles.length; j_3++) {
        item_1.setImage__ILorg_eclipse_swt_graphics_Image_2(j_3, image);
      }
    } else {
      item_1.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
    }
    imageNode1 = treeRoots[0];
    this.packColumns__Lorg_eclipse_swt_widgets_Tree_2(tree2);
    return;
  }
  public function setItemText__Lorg_eclipse_swt_widgets_TreeItem_2ILjava_lang_String_2(item: TreeItem, i: int, node: String): void {
    var index: int = i % 3;
    if (multipleColumns.getSelection__()) {
      tableData[index][0] = node;
      item.setText___3Ljava_lang_String_2(tableData[index]);
    } else {
      item.setText__Ljava_lang_String_2(node);
    }
    return;
  }
  public override function createSizeGroup__(): void {
    super.createSizeGroup__();
    packColumnsButton = new Button(sizeGroup, 8);
    packColumnsButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Pack_Columns"));
    packColumnsButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$10(this));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    noScrollButton = new Button(styleGroup, 32);
    noScrollButton.setText__Ljava_lang_String_2("SWT.NO_SCROLL");
    checkButton = new Button(styleGroup, 32);
    checkButton.setText__Ljava_lang_String_2("SWT.CHECK");
    fullSelectionButton = new Button(styleGroup, 32);
    fullSelectionButton.setText__Ljava_lang_String_2("SWT.FULL_SELECTION");
    return;
  }
  public override function getExampleWidgetItems__(): JavaArray {
    var columns1: JavaArray = tree1.getColumns__();
    var columns2: JavaArray = tree2.getColumns__();
    var allItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Item;").lengths(columns1.length + columns2.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns1, 0, allItems, 0, columns1.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns2, 0, allItems, columns1.length, columns2.length);
    return allItems;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(tree1, tree2);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("ColumnOrder", "Selection", "ToolTipText", "TopItem");
  }
  public override function parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName: String, value: String, widget: Widget): JavaArray {
    if (Object(typeName).equals__Ljava_lang_Object_2("org.eclipse.swt.widgets.TreeItem")) {
      var item: TreeItem = this.findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TreeItem_2(value, (Tree(widget)).getItems__());
      if (item !== null)
        return new JavaArray("[Ljava/lang/Object;").values(item);
    }
    if (Object(typeName).equals__Ljava_lang_Object_2("[Lorg.eclipse.swt.widgets.TreeItem;")) {
      var values: JavaArray = this.split__Ljava_lang_String_2C(value, 44);
      var items: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TreeItem;").lengths(values.length);
      for (var i: int = 0; i < values.length; i++) {
        var item_1: TreeItem = this.findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TreeItem_2(values[i], (Tree(widget)).getItems__());
        if (item_1 === null)
          break;
        items[i] = item_1;
      }
      return new JavaArray("[Ljava/lang/Object;").values(items);
    }
    return super.parameterForType__Ljava_lang_String_2Ljava_lang_String_2Lorg_eclipse_swt_widgets_Widget_2(typeName, value, widget);
  }
  public function findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TreeItem_2(value: String, items: JavaArray): TreeItem {
    for (var i: int = 0; i < items.length; i++) {
      var item: TreeItem = items[i];
      if (Object(item.getText__()).equals__Ljava_lang_Object_2(value))
        return item;
      item = this.findItem__Ljava_lang_String_2_3Lorg_eclipse_swt_widgets_TreeItem_2(value, item.getItems__());
      if (item !== null)
        return item;
    }
    return null;
  }
  public override function getTabText__(): String {
    return "Tree";
  }
  public function packColumns__Lorg_eclipse_swt_widgets_Tree_2(tree: Tree): void {
    if (multipleColumns.getSelection__()) {
      var columnCount: int = tree.getColumnCount__();
      for (var i: int = 0; i < columnCount; i++) {
        var treeColumn: TreeColumn = tree.getColumn__I(i);
        treeColumn.pack__();
      }
    }
    return;
  }
  public function setColumnsMoveable__(): void {
    var selection: Boolean = moveableColumns.getSelection__();
    var columns1: JavaArray = tree1.getColumns__();
    for (var i: int = 0; i < columns1.length; i++) {
      columns1[i].setMoveable__Z(selection);
    }
    var columns2: JavaArray = tree2.getColumns__();
    for (var i_1: int = 0; i_1 < columns2.length; i_1++) {
      columns2[i_1].setMoveable__Z(selection);
    }
    return;
  }
  public function setColumnsResizable__(): void {
    var selection: Boolean = resizableColumns.getSelection__();
    var columns1: JavaArray = tree1.getColumns__();
    for (var i: int = 0; i < columns1.length; i++) {
      columns1[i].setResizable__Z(selection);
    }
    var columns2: JavaArray = tree2.getColumns__();
    for (var i_1: int = 0; i_1 < columns2.length; i_1++) {
      columns2[i_1].setResizable__Z(selection);
    }
    return;
  }
  public override function resetColorsAndFonts__(): void {
    super.resetColorsAndFonts__();
    var oldColor: Color = itemForegroundColor;
    itemForegroundColor = null;
    this.setItemForeground__();
    if (oldColor !== null)
      oldColor.dispose__();
    oldColor = itemBackgroundColor;
    itemBackgroundColor = null;
    this.setItemBackground__();
    if (oldColor !== null)
      oldColor.dispose__();
    var oldFont: Font = font;
    itemFont = null;
    this.setItemFont__();
    if (oldFont !== null)
      oldFont.dispose__();
    oldColor = cellForegroundColor;
    cellForegroundColor = null;
    this.setCellForeground__();
    if (oldColor !== null)
      oldColor.dispose__();
    oldColor = cellBackgroundColor;
    cellBackgroundColor = null;
    this.setCellBackground__();
    if (oldColor !== null)
      oldColor.dispose__();
    oldFont = font;
    cellFont = null;
    this.setCellFont__();
    if (oldFont !== null)
      oldFont.dispose__();
    return;
  }
  public override function setExampleWidgetState__(): void {
    this.setItemBackground__();
    this.setItemForeground__();
    this.setItemFont__();
    this.setCellBackground__();
    this.setCellForeground__();
    this.setCellFont__();
    if (!instance.startup) {
      this.setColumnsMoveable__();
      this.setColumnsResizable__();
      this.setWidgetHeaderVisible__();
      this.setWidgetSortIndicator__();
      this.setWidgetLinesVisible__();
    }
    super.setExampleWidgetState__();
    noScrollButton.setSelection__Z((tree1.getStyle__() & 16) != 0);
    checkButton.setSelection__Z((tree1.getStyle__() & 32) != 0);
    fullSelectionButton.setSelection__Z((tree1.getStyle__() & 65536) != 0);
    try {
      var column: TreeColumn = tree1.getColumn__I(0);
      moveableColumns.setSelection__Z(column.getMoveable__());
      resizableColumns.setSelection__Z(column.getResizable__());
    } catch (ex : IllegalArgumentException) {
    }
    headerVisibleButton.setSelection__Z(tree1.getHeaderVisible__());
    linesVisibleButton.setSelection__Z(tree1.getLinesVisible__());
    return;
  }
  public function setCellBackground__(): void {
    if (!instance.startup) {
      textNode1.setBackground__ILorg_eclipse_swt_graphics_Color_2(1, cellBackgroundColor);
      imageNode1.setBackground__ILorg_eclipse_swt_graphics_Color_2(1, cellBackgroundColor);
    }
    var color: Color = cellBackgroundColor;
    if (color === null)
      color = textNode1.getBackground__I(1);
    var item: TableItem = colorAndFontTable.getItem__I(7);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setCellForeground__(): void {
    if (!instance.startup) {
      textNode1.setForeground__ILorg_eclipse_swt_graphics_Color_2(1, cellForegroundColor);
      imageNode1.setForeground__ILorg_eclipse_swt_graphics_Color_2(1, cellForegroundColor);
    }
    var color: Color = cellForegroundColor;
    if (color === null)
      color = textNode1.getForeground__I(1);
    var item: TableItem = colorAndFontTable.getItem__I(6);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setCellFont__(): void {
    if (!instance.startup) {
      textNode1.setFont__ILorg_eclipse_swt_graphics_Font_2(1, cellFont);
      imageNode1.setFont__ILorg_eclipse_swt_graphics_Font_2(1, cellFont);
    }
    var ft: Font = cellFont;
    if (ft === null)
      ft = textNode1.getFont__I(1);
    var item: TableItem = colorAndFontTable.getItem__I(8);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.fontImage__Lorg_eclipse_swt_graphics_Font_2(ft));
    item.setFont__Lorg_eclipse_swt_graphics_Font_2(ft);
    colorAndFontTable.layout__();
    return;
  }
  public function setItemBackground__(): void {
    if (!instance.startup) {
      textNode1.setBackground__Lorg_eclipse_swt_graphics_Color_2(itemBackgroundColor);
      imageNode1.setBackground__Lorg_eclipse_swt_graphics_Color_2(itemBackgroundColor);
    }
    var color: Color = itemBackgroundColor;
    if (color === null)
      color = textNode1.getBackground__();
    var item: TableItem = colorAndFontTable.getItem__I(4);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setItemForeground__(): void {
    if (!instance.startup) {
      textNode1.setForeground__Lorg_eclipse_swt_graphics_Color_2(itemForegroundColor);
      imageNode1.setForeground__Lorg_eclipse_swt_graphics_Color_2(itemForegroundColor);
    }
    var color: Color = itemForegroundColor;
    if (color === null)
      color = textNode1.getForeground__();
    var item: TableItem = colorAndFontTable.getItem__I(3);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setItemFont__(): void {
    if (!instance.startup) {
      textNode1.setFont__Lorg_eclipse_swt_graphics_Font_2(itemFont);
      imageNode1.setFont__Lorg_eclipse_swt_graphics_Font_2(itemFont);
    }
    var ft: Font = itemFont;
    if (ft === null)
      ft = textNode1.getFont__();
    var item: TableItem = colorAndFontTable.getItem__I(5);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.fontImage__Lorg_eclipse_swt_graphics_Font_2(ft));
    item.setFont__Lorg_eclipse_swt_graphics_Font_2(ft);
    colorAndFontTable.layout__();
    return;
  }
  public function setWidgetHeaderVisible__(): void {
    tree1.setHeaderVisible__Z(headerVisibleButton.getSelection__());
    tree2.setHeaderVisible__Z(headerVisibleButton.getSelection__());
    return;
  }
  public function setWidgetSortIndicator__(): void {
    if (sortIndicatorButton.getSelection__()) {
      this.initializeSortState__Lorg_eclipse_swt_widgets_Tree_2(tree1);
      this.initializeSortState__Lorg_eclipse_swt_widgets_Tree_2(tree2);
    } else {
      this.resetSortState__Lorg_eclipse_swt_widgets_Tree_2(tree1);
      this.resetSortState__Lorg_eclipse_swt_widgets_Tree_2(tree2);
    }
    return;
  }
  public function initializeSortState__Lorg_eclipse_swt_widgets_Tree_2(tree: Tree): void {
    tree.setSortDirection__I(1024);
    var columns: JavaArray = tree.getColumns__();
    for (var i: int = 0; i < columns.length; i++) {
      var column: TreeColumn = columns[i];
      if (i == 0)
        tree.setSortColumn__Lorg_eclipse_swt_widgets_TreeColumn_2(column);
      var listener: SelectionListener = new org.eclipse.swt.examples.controlexample.TreeTab$11(this, tree);
      column.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener);
      column.setData__Ljava_lang_String_2Ljava_lang_Object_2("SortListener", listener);
    }
    return;
  }
  public function resetSortState__Lorg_eclipse_swt_widgets_Tree_2(tree: Tree): void {
    tree.setSortDirection__I(0);
    var columns: JavaArray = tree.getColumns__();
    for (var i: int = 0; i < columns.length; i++) {
      var listener: SelectionListener = SelectionListener(columns[i].getData__Ljava_lang_String_2("SortListener"));
      if (listener !== null)
        columns[i].removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener);
    }
    return;
  }
  public function setWidgetLinesVisible__(): void {
    tree1.setLinesVisible__Z(linesVisibleButton.getSelection__());
    tree2.setLinesVisible__Z(linesVisibleButton.getSelection__());
    return;
  }
  public override function specialPopupMenuItems__Lorg_eclipse_swt_widgets_Menu_2Lorg_eclipse_swt_widgets_Event_2(menu: Menu, event: Event): void {
    var item: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 8]));
    item.setText__Ljava_lang_String_2("getItem(Point) on mouse coordinates");
    var t: Tree = Tree(event.widget);
    menuMouseCoords = t.toControl__Lorg_eclipse_swt_graphics_Point_2(new Point(event.x, event.y));
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.TreeTab$12(this, t));
    return;
  }
}
}
