package org.eclipse.swt {
import org.eclipse.swt.internal.*;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.internal.Library;
import java.lang.Throwable;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
dynamic public class SWT {
  public static const None: int = 0;
  public static const KeyDown: int = 1;
  public static const KeyUp: int = 2;
  public static const MouseDown: int = 3;
  public static const MouseUp: int = 4;
  public static const MouseMove: int = 5;
  public static const MouseEnter: int = 6;
  public static const MouseExit: int = 7;
  public static const MouseDoubleClick: int = 8;
  public static const Paint: int = 9;
  public static const Move: int = 10;
  public static const Resize: int = 11;
  public static const Dispose: int = 12;
  public static const Selection: int = 13;
  public static const DefaultSelection: int = 14;
  public static const FocusIn: int = 15;
  public static const FocusOut: int = 16;
  public static const Expand: int = 17;
  public static const Collapse: int = 18;
  public static const Iconify: int = 19;
  public static const Deiconify: int = 20;
  public static const Close: int = 21;
  public static const Show: int = 22;
  public static const Hide: int = 23;
  public static const Modify: int = 24;
  public static const Verify: int = 25;
  public static const Activate: int = 26;
  public static const Deactivate: int = 27;
  public static const Help: int = 28;
  public static const DragDetect: int = 29;
  public static const Arm: int = 30;
  public static const Traverse: int = 31;
  public static const MouseHover: int = 32;
  public static const HardKeyDown: int = 33;
  public static const HardKeyUp: int = 34;
  public static const MenuDetect: int = 35;
  public static const SetData: int = 36;
  public static const MouseWheel: int = 37;
  public static const Settings: int = 39;
  public static const EraseItem: int = 40;
  public static const MeasureItem: int = 41;
  public static const PaintItem: int = 42;
  public static const ImeComposition: int = 43;
  public static const COMPOSITION_CHANGED: int = 1;
  public static const COMPOSITION_OFFSET: int = 2;
  public static const COMPOSITION_SELECTION: int = 3;
  public static const DRAG: int = 1;
  public static const SELECTED: int = 1 << 1;
  public static const FOCUSED: int = 1 << 2;
  public static const BACKGROUND: int = 1 << 3;
  public static const FOREGROUND: int = 1 << 4;
  public static const HOT: int = 1 << 5;
  public static const TRAVERSE_NONE: int = 0;
  public static const TRAVERSE_ESCAPE: int = 1 << 1;
  public static const TRAVERSE_RETURN: int = 1 << 2;
  public static const TRAVERSE_TAB_PREVIOUS: int = 1 << 3;
  public static const TRAVERSE_TAB_NEXT: int = 1 << 4;
  public static const TRAVERSE_ARROW_PREVIOUS: int = 1 << 5;
  public static const TRAVERSE_ARROW_NEXT: int = 1 << 6;
  public static const TRAVERSE_MNEMONIC: int = 1 << 7;
  public static const TRAVERSE_PAGE_PREVIOUS: int = 1 << 8;
  public static const TRAVERSE_PAGE_NEXT: int = 1 << 9;
  public static const NONE: int = 0;
  public static const NULL: int = 0;
  public static const DEFAULT: int = -1;
  public static const OFF: int = 0;
  public static const ON: int = 1;
  public static const LOW: int = 1;
  public static const HIGH: int = 2;
  public static const BAR: int = 1 << 1;
  public static const DROP_DOWN: int = 1 << 2;
  public static const POP_UP: int = 1 << 3;
  public static const SEPARATOR: int = 1 << 1;
  public static const TOGGLE: int = 1 << 1;
  public static const ARROW: int = 1 << 2;
  public static const PUSH: int = 1 << 3;
  public static const RADIO: int = 1 << 4;
  public static const CHECK: int = 1 << 5;
  public static const CASCADE: int = 1 << 6;
  public static const MULTI: int = 1 << 1;
  public static const SINGLE: int = 1 << 2;
  public static const READ_ONLY: int = 1 << 3;
  public static const WRAP: int = 1 << 6;
  public static const SEARCH: int = 1 << 7;
  public static const SIMPLE: int = 1 << 6;
  public static const PASSWORD: int = 1 << 22;
  public static const SHADOW_IN: int = 1 << 2;
  public static const SHADOW_OUT: int = 1 << 3;
  public static const SHADOW_ETCHED_IN: int = 1 << 4;
  public static const SHADOW_ETCHED_OUT: int = 1 << 6;
  public static const SHADOW_NONE: int = 1 << 5;
  public static const INDETERMINATE: int = 1 << 1;
  public static const TOOL: int = 1 << 2;
  public static const NO_TRIM: int = 1 << 3;
  public static const RESIZE: int = 1 << 4;
  public static const TITLE: int = 1 << 5;
  public static const CLOSE: int = 1 << 6;
  public static const MENU: int = 64;
  public static const MIN: int = 1 << 7;
  public static const MAX: int = 1 << 10;
  public static const H_SCROLL: int = 1 << 8;
  public static const V_SCROLL: int = 1 << 9;
  public static const NO_SCROLL: int = 1 << 4;
  public static const BORDER: int = 1 << 11;
  public static const CLIP_CHILDREN: int = 1 << 12;
  public static const CLIP_SIBLINGS: int = 1 << 13;
  public static const ON_TOP: int = 1 << 14;
  public static const SHELL_TRIM: int = 64 | 32 | 128 | 1024 | 16;
  public static const DIALOG_TRIM: int = 32 | 64 | 2048;
  public static const MODELESS: int = 0;
  public static const PRIMARY_MODAL: int = 1 << 15;
  public static const APPLICATION_MODAL: int = 1 << 16;
  public static const SYSTEM_MODAL: int = 1 << 17;
  public static const HIDE_SELECTION: int = 1 << 15;
  public static const FULL_SELECTION: int = 1 << 16;
  public static const FLAT: int = 1 << 23;
  public static const SMOOTH: int = 1 << 16;
  public static const NO_BACKGROUND: int = 1 << 18;
  public static const NO_FOCUS: int = 1 << 19;
  public static const NO_REDRAW_RESIZE: int = 1 << 20;
  public static const NO_MERGE_PAINTS: int = 1 << 21;
  public static const NO_RADIO_GROUP: int = 1 << 22;
  public static const LEFT_TO_RIGHT: int = 1 << 25;
  public static const RIGHT_TO_LEFT: int = 1 << 26;
  public static const MIRRORED: int = 1 << 27;
  public static const EMBEDDED: int = 1 << 24;
  public static const VIRTUAL: int = 1 << 28;
  public static const DOUBLE_BUFFERED: int = 1 << 29;
  public static const TRANSPARENT: int = 1 << 30;
  public static const UP: int = 1 << 7;
  public static const UNDERLINE_SINGLE: int = 0;
  public static const UNDERLINE_DOUBLE: int = 1;
  public static const UNDERLINE_ERROR: int = 2;
  public static const UNDERLINE_SQUIGGLE: int = 3;
  public static const UNDERLINE_LINK: int = 4;
  public static const BORDER_SOLID: int = 1;
  public static const BORDER_DASH: int = 2;
  public static const BORDER_DOT: int = 4;
  public static const TOP: int = 128;
  public static const DOWN: int = 1 << 10;
  public static const BOTTOM: int = 1024;
  public static const LEAD: int = 1 << 14;
  public static const LEFT: int = 16384;
  public static const TRAIL: int = 1 << 17;
  public static const RIGHT: int = 131072;
  public static const CENTER: int = 1 << 24;
  public static const HORIZONTAL: int = 1 << 8;
  public static const VERTICAL: int = 1 << 9;
  public static const DATE: int = 1 << 5;
  public static const TIME: int = 1 << 7;
  public static const CALENDAR: int = 1 << 10;
  public static const SHORT: int = 1 << 15;
  public static const MEDIUM: int = 1 << 16;
  public static const LONG: int = 1 << 28;
  public static const MOZILLA: int = 1 << 15;
  public static const BALLOON: int = 1 << 12;
  public static const BEGINNING: int = 1;
  public static const FILL: int = 4;
  public static const DBCS: int = 1 << 1;
  public static const ALPHA: int = 1 << 2;
  public static const NATIVE: int = 1 << 3;
  public static const PHONETIC: int = 1 << 4;
  public static const ROMAN: int = 1 << 5;
  public static const BS: uint = 8;
  public static const CR: uint = 13;
  public static const DEL: uint = 0x7F;
  public static const ESC: uint = 0x1B;
  public static const LF: uint = 10;
  public static const TAB: uint = 9;
  public static const ALT: int = 1 << 16;
  public static const SHIFT: int = 1 << 17;
  public static const CTRL: int = 1 << 18;
  public static const CONTROL: int = 262144;
  public static const COMMAND: int = 1 << 22;
  public static var MODIFIER_MASK: int;
  public static const BUTTON1: int = 1 << 19;
  public static const BUTTON2: int = 1 << 20;
  public static const BUTTON3: int = 1 << 21;
  public static const BUTTON4: int = 1 << 23;
  public static const BUTTON5: int = 1 << 25;
  public static var BUTTON_MASK: int;
  public static var MOD1: int;
  public static var MOD2: int;
  public static var MOD3: int;
  public static var MOD4: int;
  public static const SCROLL_LINE: int = 1;
  public static const SCROLL_PAGE: int = 2;
  public static const KEYCODE_BIT: int = (1 << 24);
  public static const KEY_MASK: int = 16777216 + 0xFFFF;
  public static const ARROW_UP: int = 16777216 + 1;
  public static const ARROW_DOWN: int = 16777216 + 2;
  public static const ARROW_LEFT: int = 16777216 + 3;
  public static const ARROW_RIGHT: int = 16777216 + 4;
  public static const PAGE_UP: int = 16777216 + 5;
  public static const PAGE_DOWN: int = 16777216 + 6;
  public static const HOME: int = 16777216 + 7;
  public static const END: int = 16777216 + 8;
  public static const INSERT: int = 16777216 + 9;
  public static const F1: int = 16777216 + 10;
  public static const F2: int = 16777216 + 11;
  public static const F3: int = 16777216 + 12;
  public static const F4: int = 16777216 + 13;
  public static const F5: int = 16777216 + 14;
  public static const F6: int = 16777216 + 15;
  public static const F7: int = 16777216 + 16;
  public static const F8: int = 16777216 + 17;
  public static const F9: int = 16777216 + 18;
  public static const F10: int = 16777216 + 19;
  public static const F11: int = 16777216 + 20;
  public static const F12: int = 16777216 + 21;
  public static const F13: int = 16777216 + 22;
  public static const F14: int = 16777216 + 23;
  public static const F15: int = 16777216 + 24;
  public static const KEYPAD_MULTIPLY: int = 16777216 + 42;
  public static const KEYPAD_ADD: int = 16777216 + 43;
  public static const KEYPAD_SUBTRACT: int = 16777216 + 45;
  public static const KEYPAD_DECIMAL: int = 16777216 + 46;
  public static const KEYPAD_DIVIDE: int = 16777216 + 47;
  public static const KEYPAD_0: int = 16777216 + 48;
  public static const KEYPAD_1: int = 16777216 + 49;
  public static const KEYPAD_2: int = 16777216 + 50;
  public static const KEYPAD_3: int = 16777216 + 51;
  public static const KEYPAD_4: int = 16777216 + 52;
  public static const KEYPAD_5: int = 16777216 + 53;
  public static const KEYPAD_6: int = 16777216 + 54;
  public static const KEYPAD_7: int = 16777216 + 55;
  public static const KEYPAD_8: int = 16777216 + 56;
  public static const KEYPAD_9: int = 16777216 + 57;
  public static const KEYPAD_EQUAL: int = 16777216 + 61;
  public static const KEYPAD_CR: int = 16777216 + 80;
  public static const HELP: int = 16777216 + 81;
  public static const CAPS_LOCK: int = 16777216 + 82;
  public static const NUM_LOCK: int = 16777216 + 83;
  public static const SCROLL_LOCK: int = 16777216 + 84;
  public static const PAUSE: int = 16777216 + 85;
  public static const BREAK: int = 16777216 + 86;
  public static const PRINT_SCREEN: int = 16777216 + 87;
  public static const ICON_ERROR: int = 1;
  public static const ICON_INFORMATION: int = 1 << 1;
  public static const ICON_QUESTION: int = 1 << 2;
  public static const ICON_WARNING: int = 1 << 3;
  public static const ICON_WORKING: int = 1 << 4;
  public static const ICON_SEARCH: int = 1 << 9;
  public static const ICON_CANCEL: int = 1 << 8;
  public static const OK: int = 1 << 5;
  public static const YES: int = 1 << 6;
  public static const NO: int = 1 << 7;
  public static const CANCEL: int = 1 << 8;
  public static const ABORT: int = 1 << 9;
  public static const RETRY: int = 1 << 10;
  public static const IGNORE: int = 1 << 11;
  public static const OPEN: int = 1 << 12;
  public static const SAVE: int = 1 << 13;
  public static const INHERIT_NONE: int = 0;
  public static const INHERIT_DEFAULT: int = 1;
  public static const INHERIT_FORCE: int = 2;
  public static const COLOR_WHITE: int = 1;
  public static const COLOR_BLACK: int = 2;
  public static const COLOR_RED: int = 3;
  public static const COLOR_DARK_RED: int = 4;
  public static const COLOR_GREEN: int = 5;
  public static const COLOR_DARK_GREEN: int = 6;
  public static const COLOR_YELLOW: int = 7;
  public static const COLOR_DARK_YELLOW: int = 8;
  public static const COLOR_BLUE: int = 9;
  public static const COLOR_DARK_BLUE: int = 10;
  public static const COLOR_MAGENTA: int = 11;
  public static const COLOR_DARK_MAGENTA: int = 12;
  public static const COLOR_CYAN: int = 13;
  public static const COLOR_DARK_CYAN: int = 14;
  public static const COLOR_GRAY: int = 15;
  public static const COLOR_DARK_GRAY: int = 16;
  public static const COLOR_WIDGET_DARK_SHADOW: int = 17;
  public static const COLOR_WIDGET_NORMAL_SHADOW: int = 18;
  public static const COLOR_WIDGET_LIGHT_SHADOW: int = 19;
  public static const COLOR_WIDGET_HIGHLIGHT_SHADOW: int = 20;
  public static const COLOR_WIDGET_FOREGROUND: int = 21;
  public static const COLOR_WIDGET_BACKGROUND: int = 22;
  public static const COLOR_WIDGET_BORDER: int = 23;
  public static const COLOR_LIST_FOREGROUND: int = 24;
  public static const COLOR_LIST_BACKGROUND: int = 25;
  public static const COLOR_LIST_SELECTION: int = 26;
  public static const COLOR_LIST_SELECTION_TEXT: int = 27;
  public static const COLOR_INFO_FOREGROUND: int = 28;
  public static const COLOR_INFO_BACKGROUND: int = 29;
  public static const COLOR_TITLE_FOREGROUND: int = 30;
  public static const COLOR_TITLE_BACKGROUND: int = 31;
  public static const COLOR_TITLE_BACKGROUND_GRADIENT: int = 32;
  public static const COLOR_TITLE_INACTIVE_FOREGROUND: int = 33;
  public static const COLOR_TITLE_INACTIVE_BACKGROUND: int = 34;
  public static const COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT: int = 35;
  public static const DRAW_TRANSPARENT: int = 1 << 0;
  public static const DRAW_DELIMITER: int = 1 << 1;
  public static const DRAW_TAB: int = 1 << 2;
  public static const DRAW_MNEMONIC: int = 1 << 3;
  public static const DELIMITER_SELECTION: int = 1 << 17;
  public static const LAST_LINE_SELECTION: int = 1 << 20;
  public static const ERROR_UNSPECIFIED: int = 1;
  public static const ERROR_NO_HANDLES: int = 2;
  public static const ERROR_NO_MORE_CALLBACKS: int = 3;
  public static const ERROR_NULL_ARGUMENT: int = 4;
  public static const ERROR_INVALID_ARGUMENT: int = 5;
  public static const ERROR_INVALID_RANGE: int = 6;
  public static const ERROR_CANNOT_BE_ZERO: int = 7;
  public static const ERROR_CANNOT_GET_ITEM: int = 8;
  public static const ERROR_CANNOT_GET_SELECTION: int = 9;
  public static const ERROR_CANNOT_INVERT_MATRIX: int = 10;
  public static const ERROR_CANNOT_GET_ITEM_HEIGHT: int = 11;
  public static const ERROR_CANNOT_GET_TEXT: int = 12;
  public static const ERROR_CANNOT_SET_TEXT: int = 13;
  public static const ERROR_ITEM_NOT_ADDED: int = 14;
  public static const ERROR_ITEM_NOT_REMOVED: int = 15;
  public static const ERROR_NO_GRAPHICS_LIBRARY: int = 16;
  public static const ERROR_NOT_IMPLEMENTED: int = 20;
  public static const ERROR_MENU_NOT_DROP_DOWN: int = 21;
  public static const ERROR_THREAD_INVALID_ACCESS: int = 22;
  public static const ERROR_WIDGET_DISPOSED: int = 24;
  public static const ERROR_MENUITEM_NOT_CASCADE: int = 27;
  public static const ERROR_CANNOT_SET_SELECTION: int = 28;
  public static const ERROR_CANNOT_SET_MENU: int = 29;
  public static const ERROR_CANNOT_SET_ENABLED: int = 30;
  public static const ERROR_CANNOT_GET_ENABLED: int = 31;
  public static const ERROR_INVALID_PARENT: int = 32;
  public static const ERROR_MENU_NOT_BAR: int = 33;
  public static const ERROR_CANNOT_GET_COUNT: int = 36;
  public static const ERROR_MENU_NOT_POP_UP: int = 37;
  public static const ERROR_UNSUPPORTED_DEPTH: int = 38;
  public static const ERROR_IO: int = 39;
  public static const ERROR_INVALID_IMAGE: int = 40;
  public static const ERROR_UNSUPPORTED_FORMAT: int = 42;
  public static const ERROR_INVALID_SUBCLASS: int = 43;
  public static const ERROR_GRAPHIC_DISPOSED: int = 44;
  public static const ERROR_DEVICE_DISPOSED: int = 45;
  public static const ERROR_FAILED_EXEC: int = 46;
  public static const ERROR_FAILED_LOAD_LIBRARY: int = 47;
  public static const ERROR_INVALID_FONT: int = 48;
  public static const ERROR_FUNCTION_DISPOSED: int = 49;
  public static const ERROR_FAILED_EVALUATE: int = 50;
  public static const ERROR_INVALID_RETURN_VALUE: int = 51;
  public static const BITMAP: int = 0;
  public static const ICON: int = 1;
  public static const IMAGE_COPY: int = 0;
  public static const IMAGE_DISABLE: int = 1;
  public static const IMAGE_GRAY: int = 2;
  public static const ERROR: int = 1;
  public static const PAUSED: int = 1 << 2;
  public static const NORMAL: int = 0;
  public static const BOLD: int = 1 << 0;
  public static const ITALIC: int = 1 << 1;
  public static const CURSOR_ARROW: int = 0;
  public static const CURSOR_WAIT: int = 1;
  public static const CURSOR_CROSS: int = 2;
  public static const CURSOR_APPSTARTING: int = 3;
  public static const CURSOR_HELP: int = 4;
  public static const CURSOR_SIZEALL: int = 5;
  public static const CURSOR_SIZENESW: int = 6;
  public static const CURSOR_SIZENS: int = 7;
  public static const CURSOR_SIZENWSE: int = 8;
  public static const CURSOR_SIZEWE: int = 9;
  public static const CURSOR_SIZEN: int = 10;
  public static const CURSOR_SIZES: int = 11;
  public static const CURSOR_SIZEE: int = 12;
  public static const CURSOR_SIZEW: int = 13;
  public static const CURSOR_SIZENE: int = 14;
  public static const CURSOR_SIZESE: int = 15;
  public static const CURSOR_SIZESW: int = 16;
  public static const CURSOR_SIZENW: int = 17;
  public static const CURSOR_UPARROW: int = 18;
  public static const CURSOR_IBEAM: int = 19;
  public static const CURSOR_NO: int = 20;
  public static const CURSOR_HAND: int = 21;
  public static const CAP_FLAT: int = 1;
  public static const CAP_ROUND: int = 2;
  public static const CAP_SQUARE: int = 3;
  public static const JOIN_MITER: int = 1;
  public static const JOIN_ROUND: int = 2;
  public static const JOIN_BEVEL: int = 3;
  public static const LINE_SOLID: int = 1;
  public static const LINE_DASH: int = 2;
  public static const LINE_DOT: int = 3;
  public static const LINE_DASHDOT: int = 4;
  public static const LINE_DASHDOTDOT: int = 5;
  public static const LINE_CUSTOM: int = 6;
  public static const PATH_MOVE_TO: int = 1;
  public static const PATH_LINE_TO: int = 2;
  public static const PATH_QUAD_TO: int = 3;
  public static const PATH_CUBIC_TO: int = 4;
  public static const PATH_CLOSE: int = 5;
  public static const FILL_EVEN_ODD: int = 1;
  public static const FILL_WINDING: int = 2;
  public static const IMAGE_UNDEFINED: int = -1;
  public static const IMAGE_BMP: int = 0;
  public static const IMAGE_BMP_RLE: int = 1;
  public static const IMAGE_GIF: int = 2;
  public static const IMAGE_ICO: int = 3;
  public static const IMAGE_JPEG: int = 4;
  public static const IMAGE_PNG: int = 5;
  public static const IMAGE_TIFF: int = 6;
  public static const IMAGE_OS2_BMP: int = 7;
  public static const DM_UNSPECIFIED: int = 0x0;
  public static const DM_FILL_NONE: int = 0x1;
  public static const DM_FILL_BACKGROUND: int = 0x2;
  public static const DM_FILL_PREVIOUS: int = 0x3;
  public static const TRANSPARENCY_NONE: int = 0x0;
  public static const TRANSPARENCY_ALPHA: int = 1 << 0;
  public static const TRANSPARENCY_MASK: int = 1 << 1;
  public static const TRANSPARENCY_PIXEL: int = 1 << 2;
  public static const MOVEMENT_CHAR: int = 1 << 0;
  public static const MOVEMENT_CLUSTER: int = 1 << 1;
  public static const MOVEMENT_WORD: int = 1 << 2;
  public static const MOVEMENT_WORD_END: int = 1 << 3;
  public static const MOVEMENT_WORD_START: int = 1 << 4;

  __clinit();

  static private function __clinit(): void {
    {
      BUTTON_MASK = 524288 | 1048576 | 2097152 | 8388608 | 33554432;
      MODIFIER_MASK = 65536 | 131072 | 262144 | 4194304;
      var platform: String = getPlatform__();
      if (Object("carbon").equals__Ljava_lang_Object_2(platform) || Object("cocoa").equals__Ljava_lang_Object_2(platform)) {
        MOD1 = 4194304;
        MOD2 = 131072;
        MOD3 = 65536;
        MOD4 = 262144;
      } else {
        MOD1 = 262144;
        MOD2 = 131072;
        MOD3 = 65536;
        MOD4 = 0;
      }
    }
  }
  public static function findErrorText__I(code: int): String {
    switch (code) {
      case 1 :
        return "Unspecified error";
      case 2 :
        return "No more handles";
      case 3 :
        return "No more callbacks";
      case 4 :
        return "Argument cannot be null";
      case 5 :
        return "Argument not valid";
      case 51 :
        return "Return value not valid";
      case 6 :
        return "Index out of bounds";
      case 7 :
        return "Argument cannot be zero";
      case 8 :
        return "Cannot get item";
      case 9 :
        return "Cannot get selection";
      case 11 :
        return "Cannot get item height";
      case 12 :
        return "Cannot get text";
      case 13 :
        return "Cannot set text";
      case 14 :
        return "Item not added";
      case 15 :
        return "Item not removed";
      case 20 :
        return "Not implemented";
      case 21 :
        return "Menu must be a drop down";
      case 22 :
        return "Invalid thread access";
      case 24 :
        return "Widget is disposed";
      case 27 :
        return "Menu item is not a CASCADE";
      case 28 :
        return "Cannot set selection";
      case 29 :
        return "Cannot set menu";
      case 30 :
        return "Cannot set the enabled state";
      case 31 :
        return "Cannot get the enabled state";
      case 32 :
        return "Widget has the wrong parent";
      case 33 :
        return "Menu is not a BAR";
      case 36 :
        return "Cannot get count";
      case 37 :
        return "Menu is not a POP_UP";
      case 38 :
        return "Unsupported color depth";
      case 39 :
        return "i/o error";
      case 40 :
        return "Invalid image";
      case 42 :
        return "Unsupported or unrecognized format";
      case 43 :
        return "Subclassing not allowed";
      case 44 :
        return "Graphic is disposed";
      case 45 :
        return "Device is disposed";
      case 49 :
        return "BrowserFunction is disposed";
      case 46 :
        return "Failed to execute runnable";
      case 50 :
        return "Failed to evaluate javascript expression";
      case 47 :
        return "Unable to load library";
      case 10 :
        return "Cannot invert matrix";
      case 16 :
        return "Unable to load graphics library";
      case 48 :
        return "Font not valid";
    }
    return "Unknown error";
  }
  public static function getMessage__Ljava_lang_String_2(key: String): String {
    return Compatibility.getMessage__Ljava_lang_String_2(key);
  }
  public static function getPlatform__(): String {
    return "flex";
  }
  public static function getVersion__(): int {
    return Library.SWT_VERSION;
  }
  public static function error__I(code: int): void {
    error__ILjava_lang_Throwable_2(code, null);
  }
  public static function error__ILjava_lang_Throwable_2(code: int, throwable: Throwable): void {
    error__ILjava_lang_Throwable_2Ljava_lang_String_2(code, throwable, null);
  }
  public static function error__ILjava_lang_Throwable_2Ljava_lang_String_2(code: int, throwable: Throwable, detail: String): void {
    if (code != 46) {
      if (throwable is SWTError)
        throw SWTError(throwable);
      if (throwable is SWTException)
        throw SWTException(throwable);
    }
    var message: String = findErrorText__I(code);
    if (detail !== null)
      message += detail;
    switch (code) {
      case 4 :
      case 7 :
      case 5 :
      case 33 :
      case 21 :
      case 37 :
      case 27 :
      case 32 :
      case 6 :
        {
          throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, [message]));
        }
      case 43 :
      case 22 :
      case 24 :
      case 44 :
      case 45 :
      case 49 :
      case 40 :
      case 38 :
      case 42 :
      case 46 :
      case 50 :
      case 10 :
      case 16 :
      case 51 :
      case 39 :
        {
          var exception: SWTException = new SWTException(new Arguments(org.eclipse.swt.SWTException.SWTException__ILjava_lang_String_2, [code, message]));
          exception.throwable = throwable;
          throw exception;
        }
      case 36 :
      case 31 :
      case 8 :
      case 11 :
      case 9 :
      case 12 :
      case 30 :
      case 29 :
      case 28 :
      case 13 :
      case 14 :
      case 15 :
      case 2 :
      case 47 :
      case 3 :
      case 20 :
      case 1 :
        {
          var error: SWTError = new SWTError(new Arguments(org.eclipse.swt.SWTError.SWTError__ILjava_lang_String_2, [code, message]));
          error.throwable = throwable;
          throw error;
        }
    }
    var error_1: SWTError = new SWTError(new Arguments(org.eclipse.swt.SWTError.SWTError__ILjava_lang_String_2, [code, message]));
    error_1.throwable = throwable;
    throw error_1;
    return;
  }
}
}
