package org.eclipse.swt {
import org.eclipse.swt.internal.*;
import java.lang.Error__;
import java.lang.Throwable;
import org.eclipse.swt.internal.Library;
import java.lang.System;
import java.lang.Arguments;
dynamic public class SWTError extends Error__ {
  public var code: int;
  public var throwable: Throwable;
  public static const serialVersionUID: Number = 3833467327105808433;
  public function SWTError__(): Object {
    return this;
  }
  public function SWTError__Ljava_lang_String_2(message: String): Object {
    return this;
  }
  public function SWTError__I(code: int): Object {
    return this;
  }
  public function SWTError__ILjava_lang_String_2(code: int, message: String): Object {
    this.code = code;
    return this;
  }
  public override function getCause__(): Throwable {
    return throwable;
  }
  public override function getMessage__(): String {
    if (throwable === null)
      return super.getMessage__();
    return super.getMessage__() + " (" + throwable.toString__() + ")";
  }
  public override function printStackTrace__(): void {
    super.printStackTrace__();
    if (Library.JAVA_VERSION < Library.JAVA_VERSION__III(1, 4, 0) && throwable !== null) {
      System.err.println__Ljava_lang_String_2("*** Stack trace of contained error ***");
      throwable.printStackTrace__();
    }
    return;
  }
  public function SWTError(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is String) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        args2 = [1];
        args3 = [args2[0], SWT.findErrorText__I(args2[0])];
        var superArgs: Arguments;
        superArgs = new Arguments(java.lang.Error__.Error____Ljava_lang_String_2, [args3[1]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [1, args1[0]];
        superArgs = new Arguments(java.lang.Error__.Error____Ljava_lang_String_2, [args3[1]]);
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [args2[0], SWT.findErrorText__I(args2[0])];
        superArgs = new Arguments(java.lang.Error__.Error____Ljava_lang_String_2, [args3[1]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        superArgs = new Arguments(java.lang.Error__.Error____Ljava_lang_String_2, [args3[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        SWTError__ILjava_lang_String_2(args3[0], args3[1]);
        SWTError__I(args2[0]);
        SWTError__();
        break;
      case 1:
        SWTError__ILjava_lang_String_2(args3[0], args3[1]);
        SWTError__Ljava_lang_String_2(args1[0]);
        break;
      case 2:
        SWTError__ILjava_lang_String_2(args3[0], args3[1]);
        SWTError__I(args2[0]);
        break;
      case 3:
        SWTError__ILjava_lang_String_2(args3[0], args3[1]);
        break;
    }
  }
  public static const SWTError__ : int = 0;
  public static const SWTError__Ljava_lang_String_2 : int = 1;
  public static const SWTError__I : int = 2;
  public static const SWTError__ILjava_lang_String_2 : int = 3;
}
}
