package org.eclipse.swt {
import org.eclipse.swt.internal.*;
import java.lang.RuntimeException;
import java.lang.Throwable;
import org.eclipse.swt.internal.Library;
import java.lang.System;
import java.lang.Arguments;
dynamic public class SWTException extends RuntimeException {
  public var code: int;
  public var throwable: Throwable;
  public static const serialVersionUID: Number = 3257282552304842547;
  public function SWTException__(): Object {
    return this;
  }
  public function SWTException__Ljava_lang_String_2(message: String): Object {
    return this;
  }
  public function SWTException__I(code: int): Object {
    return this;
  }
  public function SWTException__ILjava_lang_String_2(code: int, message: String): Object {
    this.code = code;
    return this;
  }
  public override function getCause__(): Throwable {
    return throwable;
  }
  public override function getMessage__(): String {
    if (throwable === null)
      return super.getMessage__();
    return super.getMessage__() + " (" + throwable.toString__() + ")";
  }
  public override function printStackTrace__(): void {
    super.printStackTrace__();
    if (Library.JAVA_VERSION < Library.JAVA_VERSION__III(1, 4, 0) && throwable !== null) {
      System.err.println__Ljava_lang_String_2("*** Stack trace of contained exception ***");
      throwable.printStackTrace__();
    }
    return;
  }
  public function SWTException(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is String) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        args2 = [1];
        args3 = [args2[0], SWT.findErrorText__I(args2[0])];
        var superArgs: Arguments;
        superArgs = new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, [args3[1]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [1, args1[0]];
        superArgs = new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, [args3[1]]);
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [args2[0], SWT.findErrorText__I(args2[0])];
        superArgs = new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, [args3[1]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        superArgs = new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, [args3[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        SWTException__ILjava_lang_String_2(args3[0], args3[1]);
        SWTException__I(args2[0]);
        SWTException__();
        break;
      case 1:
        SWTException__ILjava_lang_String_2(args3[0], args3[1]);
        SWTException__Ljava_lang_String_2(args1[0]);
        break;
      case 2:
        SWTException__ILjava_lang_String_2(args3[0], args3[1]);
        SWTException__I(args2[0]);
        break;
      case 3:
        SWTException__ILjava_lang_String_2(args3[0], args3[1]);
        break;
    }
  }
  public static const SWTException__ : int = 0;
  public static const SWTException__Ljava_lang_String_2 : int = 1;
  public static const SWTException__I : int = 2;
  public static const SWTException__ILjava_lang_String_2 : int = 3;
}
}
