package org.eclipse.swt.animation {
import mx.effects.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import mx.effects.Effect;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.SWT;
import java.lang.Math__;
dynamic public class Animation {
  internal var object: Effect;
  internal var widget: Widget;
  internal var repeatCount: int = 1;
  internal var startDelay: Number = 0;
  internal var disposed: Boolean;
  public static const FOREVER: int = 0;
  public function Animation() {
    return;
  }
  public function checkAnimation__(): void {
    if (this.isDisposed__())
      SWT.error__I(24);
    return;
  }
  public function dispose__(): void {
    if (this.isDisposed__())
      return;
    disposed = true;
    this.release__();
  }
  public function release__(): void {
    widget = null;
    object = null;
  }
  public function setBeginTime__J(beginTime: Number): void {
    this.checkAnimation__();
    this.startDelay = beginTime;
  }
  public function setRepeatCount__I(repeatCount_1: int): void {
    this.checkAnimation__();
    if (repeatCount_1 == 0)
      SWT.error__I(5);
    this.repeatCount = repeatCount_1;
  }
  public function start__Lorg_eclipse_swt_widgets_Widget_2(widget_1: Widget): void {
    this.checkAnimation__();
    this.widget = widget_1;
    this.create__();
    object.play();
  }
  public function create__(): void {
    object.repeatCount = Math__.max__II(0, this.repeatCount);
    object.startDelay = int(startDelay);
  }
  public function stop__(): void {
    this.checkAnimation__();
    if (object !== null)
      object.pause();
  }
  public function isDisposed__(): Boolean {
    return disposed;
  }
}
}
