package org.eclipse.swt.animation {
import mx.effects.CompositeEffect;
import org.eclipse.swt.SWT;
import java.lang.System;
import java.lang.JavaArray;
dynamic public class CompositeAnimation extends Animation {
  internal var childCount: int = 0;
  internal var animations: JavaArray = new JavaArray("[Lorg/eclipse/swt/animation/Animation;").lengths(4);
  public function addAnimation__Lorg_eclipse_swt_animation_Animation_2(animation: Animation): void {
    if (animations.length == childCount) {
      var temp: JavaArray = new JavaArray("[Lorg/eclipse/swt/animation/Animation;").lengths(childCount + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(animations, 0, temp, 0, childCount);
      animations = temp;
    }
    animations[childCount] = animation;
    childCount++;
    return;
  }
  public override function create__(): void {
    super.create__();
    var effect: CompositeEffect = CompositeEffect(object);
    for (var i: int = 0; i < childCount; i++) {
      animations[i].create__();
      effect.addChild(animations[i].object);
    }
    return;
  }
  public function getAnimation__I(index: int): Animation {
    this.checkAnimation__();
    if (!(0 <= index && index < childCount))
      SWT.error__I(5);
    return animations[index];
  }
  public override function release__(): void {
    for (var i: int = 0; i < childCount; i++) {
      animations[i].release__();
    }
    super.release__();
    return;
  }
}
}
