package org.eclipse.swt.animation {
import mx.effects.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.*;
import mx.effects.AnimateProperty;
import org.eclipse.swt.SWT;
import mx.effects.Parallel;
import org.eclipse.swt.widgets.Control;
import java.lang.Integer;
import java.lang.Double;
dynamic public class PropertyAnimation extends Animation {
  internal var duration: Number = 0;
  internal var target: Object;
  internal var from: Object;
  internal var to_org_eclipse_swt_animation_PropertyAnimation: Object;
  internal var property: String;
  internal var xAnin: AnimateProperty;
  internal var yAnin: AnimateProperty;
  internal var widthAnin: AnimateProperty;
  internal var heightAnin: AnimateProperty;
  public override function create__(): void {
    if (target === null || property === null)
      SWT.error__I(5);
    var easingFunction: Function = this.easingFunction__();
    if (Object(property).equals__Ljava_lang_Object_2("size") || Object(property).equals__Ljava_lang_Object_2("location") || Object(property).equals__Ljava_lang_Object_2("bounds")) {
      var parallel: Parallel = new Parallel();
      if (parallel === null)
        SWT.error__I(2);
      object = parallel;
      if (Object(property).equals__Ljava_lang_Object_2("bounds") || Object(property).equals__Ljava_lang_Object_2("location")) {
        xAnin = new AnimateProperty();
        if (xAnin === null)
          SWT.error__I(2);
        xAnin.property = "x";
        xAnin.easingFunction = easingFunction;
        parallel.addChild(xAnin);
        yAnin = new AnimateProperty();
        if (yAnin === null)
          SWT.error__I(2);
        yAnin.property = "y";
        yAnin.easingFunction = easingFunction;
        parallel.addChild(yAnin);
      }
      if (Object(property).equals__Ljava_lang_Object_2("bounds") || Object(property).equals__Ljava_lang_Object_2("size")) {
        widthAnin = new AnimateProperty();
        if (widthAnin === null)
          SWT.error__I(2);
        widthAnin.property = "width";
        widthAnin.easingFunction = easingFunction;
        parallel.addChild(widthAnin);
        heightAnin = new AnimateProperty();
        if (heightAnin === null)
          SWT.error__I(2);
        heightAnin.property = "height";
        heightAnin.easingFunction = easingFunction;
        parallel.addChild(heightAnin);
      }
    } else {
      var animation: AnimateProperty = new AnimateProperty();
      if (animation === null)
        SWT.error__I(2);
      animation.property = property;
      animation.easingFunction = easingFunction;
      object = animation;
    }
    object.target = (Control(target)).object;
    object.duration = duration;
    if (Object(property).equals__Ljava_lang_Object_2("bounds")) {
      if (from !== null) {
        var fromRect: Rectangle = Rectangle(from);
        xAnin.fromValue = fromRect.x;
        yAnin.fromValue = fromRect.y;
        widthAnin.fromValue = fromRect.width;
        heightAnin.fromValue = fromRect.height;
      }
      var toRect: Rectangle = Rectangle(to_org_eclipse_swt_animation_PropertyAnimation);
      xAnin.toValue = toRect.x;
      yAnin.toValue = toRect.y;
      widthAnin.toValue = toRect.width;
      heightAnin.toValue = toRect.height;
    } else if (Object(property).equals__Ljava_lang_Object_2("size")) {
      if (from !== null) {
        var fromPt: Point = Point(from);
        widthAnin.fromValue = fromPt.x;
        heightAnin.fromValue = fromPt.y;
      }
      var toRect_1: Point = Point(to_org_eclipse_swt_animation_PropertyAnimation);
      widthAnin.toValue = toRect_1.x;
      heightAnin.toValue = toRect_1.y;
    } else if (Object(property).equals__Ljava_lang_Object_2("location")) {
      if (from !== null) {
        var fromPt_1: Point = Point(from);
        xAnin.fromValue = fromPt_1.x;
        yAnin.fromValue = fromPt_1.y;
      }
      var toRect_2: Point = Point(to_org_eclipse_swt_animation_PropertyAnimation);
      xAnin.toValue = toRect_2.x;
      yAnin.toValue = toRect_2.y;
    } else if (Object(property).equals__Ljava_lang_Object_2("alpha")) {
      if (from !== null) {
        var alphaFrom: int = (Integer(from)).intValue__();
        (AnimateProperty(object)).fromValue = (alphaFrom & 0xFF) / Number(0xFF);
      }
      var alphaTo: int = (Integer(to_org_eclipse_swt_animation_PropertyAnimation)).intValue__();
      (AnimateProperty(object)).toValue = (alphaTo & 0xFF) / Number(0xFF);
    } else {
      var fromVal: Number = 0;
      var toVal: Number = 1;
      if (to_org_eclipse_swt_animation_PropertyAnimation is Double) {
        if (from !== null)
          fromVal = (Double(from)).doubleValue__();
        toVal = (Double(to_org_eclipse_swt_animation_PropertyAnimation)).doubleValue__();
      } else if (to_org_eclipse_swt_animation_PropertyAnimation is Integer) {
        if (from !== null)
          fromVal = (Integer(from)).doubleValue__();
        toVal = (Integer(to_org_eclipse_swt_animation_PropertyAnimation)).doubleValue__();
      }
      if (from !== null) {
        (AnimateProperty(object)).fromValue = fromVal;
      }
      (AnimateProperty(object)).toValue = toVal;
    }
    return;
  }
  public function easingFunction__(): Function {
    import mx.effects.easing.*;
    return mx.effects.easing.Linear.easeNone;
  }
  public function getDuration__(): Number {
    this.checkAnimation__();
    return duration;
  }
  public function setDuration__J(duration_1: Number): void {
    this.checkAnimation__();
    this.duration = duration_1;
  }
  public function setFrom__Ljava_lang_Object_2(value: Object): void {
    this.checkAnimation__();
    from = value;
  }
  public function setProperty__Ljava_lang_String_2(property_1: String): void {
    this.checkAnimation__();
    this.property = property_1;
  }
  public function setTarget__Ljava_lang_Object_2(target_1: Object): void {
    this.checkAnimation__();
    this.target = target_1;
  }
  public function setTo__Ljava_lang_Object_2(value: Object): void {
    this.checkAnimation__();
    to_org_eclipse_swt_animation_PropertyAnimation = value;
  }
}
}
