package org.eclipse.swt.browser {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import java.lang.Class__;
import java.lang.ClassNotFoundException;
import java.lang.IllegalAccessException;
import java.lang.InstantiationException;
import java.lang.Thread;
import org.eclipse.swt.SWTException;
import java.lang.Arguments;
dynamic public class Browser extends Composite {
  internal var webBrowser: WebBrowser;
  internal var userStyle: int;
  public static const PACKAGE_PREFIX: String = "org.eclipse.swt.browser.";
  public static const NO_INPUT_METHOD: String = "org.eclipse.swt.internal.gtk.noInputMethod";
  public function Browser(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [Browser.checkParent__Lorg_eclipse_swt_widgets_Composite_2(parent), Browser.checkStyle__I(style)]));
    userStyle = style;
    var platform: String = SWT.getPlatform__();
    var display: Display = parent.getDisplay__();
    if (Object("gtk").equals__Ljava_lang_Object_2(platform))
      display.setData__Ljava_lang_String_2Ljava_lang_Object_2("org.eclipse.swt.internal.gtk.noInputMethod", null);
    var className: String = null;
    if ((style & 32768) != 0) {
      className = "org.eclipse.swt.browser.Mozilla";
    } else {
      if (Object("win32").equals__Ljava_lang_Object_2(platform) || Object("wpf").equals__Ljava_lang_Object_2(platform)) {
        className = "org.eclipse.swt.browser.IE";
      } else if (Object("motif").equals__Ljava_lang_Object_2(platform)) {
        className = "org.eclipse.swt.browser.Mozilla";
      } else if (Object("gtk").equals__Ljava_lang_Object_2(platform)) {
        className = "org.eclipse.swt.browser.Mozilla";
      } else if (Object("carbon").equals__Ljava_lang_Object_2(platform) || Object("cocoa").equals__Ljava_lang_Object_2(platform)) {
        className = "org.eclipse.swt.browser.Safari";
      } else if (Object("photon").equals__Ljava_lang_Object_2(platform)) {
        className = "org.eclipse.swt.browser.Voyager";
      } else {
        this.dispose__();
        SWT.error__I(2);
      }
    }
    try {
      var clazz: Class__ = Class__.forName__Ljava_lang_String_2(className);
      webBrowser = WebBrowser(clazz.newInstance__());
    } catch (e : ClassNotFoundException) {
    } catch (e_1 : IllegalAccessException) {
    } catch (e_2 : InstantiationException) {
    }
    if (webBrowser === null) {
      this.dispose__();
      SWT.error__I(2);
    }
    webBrowser.setBrowser__Lorg_eclipse_swt_browser_Browser_2(this);
    webBrowser.create__Lorg_eclipse_swt_widgets_Composite_2I(parent, style);
    return;
  }
  public static function checkParent__Lorg_eclipse_swt_widgets_Composite_2(parent: Composite): Composite {
    var platform: String = SWT.getPlatform__();
    if (!Object("gtk").equals__Ljava_lang_Object_2(platform))
      return parent;
    if (parent !== null && !parent.isDisposed__()) {
      var display: Display = parent.getDisplay__();
      if (display !== null) {
        if (display.getThread__() === Thread.currentThread__()) {
          display.setData__Ljava_lang_String_2Ljava_lang_Object_2("org.eclipse.swt.internal.gtk.noInputMethod", "true");
        }
      }
    }
    return parent;
  }
  public static function checkStyle__I(style: int): int {
    var platform: String = SWT.getPlatform__();
    if ((style & 32768) != 0) {
      if (Object("carbon").equals__Ljava_lang_Object_2(platform))
        return style | 16777216;
      if (Object("motif").equals__Ljava_lang_Object_2(platform))
        return style | 16777216;
      return style;
    }
    if (Object("win32").equals__Ljava_lang_Object_2(platform)) {
      return style & ~2048;
    } else if (Object("motif").equals__Ljava_lang_Object_2(platform)) {
      return style | 16777216;
    }
    return style;
  }
  public override function checkWidget__(): void {
    super.checkWidget__();
  }
  public static function clearSessions__(): void {
    WebBrowser.clearSessions__();
  }
  public function addCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener: CloseWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener);
  }
  public function addLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener: LocationListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener);
  }
  public function addOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener: OpenWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener);
  }
  public function addProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener: ProgressListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener);
  }
  public function addStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener: StatusTextListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener);
  }
  public function addTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener: TitleListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener);
  }
  public function addVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener: VisibilityWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.addVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener);
  }
  public function back__(): Boolean {
    this.checkWidget__();
    return webBrowser.back__();
  }
  public override function checkSubclass__(): void {
    var name: String = Object(this).getClass__().getName__();
    var index: int = Object(name).lastIndexOf__I(46);
    if (!Object(Object(name).substring__II(0, index + 1)).equals__Ljava_lang_Object_2("org.eclipse.swt.browser.")) {
      SWT.error__I(43);
    }
    return;
  }
  public function execute__Ljava_lang_String_2(script: String): Boolean {
    this.checkWidget__();
    if (script === null)
      SWT.error__I(4);
    return webBrowser.execute__Ljava_lang_String_2(script);
  }
  public function evaluate__Ljava_lang_String_2(script: String): Object {
    this.checkWidget__();
    if (script === null)
      SWT.error__I(4);
    return webBrowser.evaluate__Ljava_lang_String_2(script);
  }
  public function forward__(): Boolean {
    this.checkWidget__();
    return webBrowser.forward__();
  }
  public function getBrowserType__(): String {
    this.checkWidget__();
    return webBrowser.getBrowserType__();
  }
  public override function getStyle__(): int {
    return super.getStyle__() | (userStyle & 2048);
  }
  public function getText__(): String {
    this.checkWidget__();
    return webBrowser.getText__();
  }
  public function getUrl__(): String {
    this.checkWidget__();
    return webBrowser.getUrl__();
  }
  public function getWebBrowser__(): Object {
    this.checkWidget__();
    return webBrowser.getWebBrowser__();
  }
  public function isBackEnabled__(): Boolean {
    this.checkWidget__();
    return webBrowser.isBackEnabled__();
  }
  public override function isFocusControl__(): Boolean {
    this.checkWidget__();
    if (webBrowser.isFocusControl__())
      return true;
    return super.isFocusControl__();
  }
  public function isForwardEnabled__(): Boolean {
    this.checkWidget__();
    return webBrowser.isForwardEnabled__();
  }
  public function refresh__(): void {
    this.checkWidget__();
    webBrowser.refresh__();
  }
  public function removeCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener: CloseWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener);
  }
  public function removeLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener: LocationListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener);
  }
  public function removeOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener: OpenWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener);
  }
  public function removeProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener: ProgressListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener);
  }
  public function removeStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener: StatusTextListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener);
  }
  public function removeTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener: TitleListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener);
  }
  public function removeVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener: VisibilityWindowListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    webBrowser.removeVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener);
  }
  public function setText__Ljava_lang_String_2(html: String): Boolean {
    this.checkWidget__();
    if (html === null)
      SWT.error__I(4);
    return webBrowser.setText__Ljava_lang_String_2(html);
  }
  public function setUrl__Ljava_lang_String_2(url: String): Boolean {
    this.checkWidget__();
    if (url === null)
      SWT.error__I(4);
    return webBrowser.setUrl__Ljava_lang_String_2(url);
  }
  public function stop__(): void {
    this.checkWidget__();
    webBrowser.stop__();
  }
}
}
