package org.eclipse.swt.browser {
import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SWT;
import java.util.Hashtable;
import java.lang.Runnable;
import java.lang.System;
import org.eclipse.swt.widgets.Composite;
import java.util.Enumeration;
import java.lang.StringBuffer;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class WebBrowser {
  internal var browser: Browser;
  internal var functions: Hashtable = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
  internal var closeWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/CloseWindowListener;").lengths(0);
  internal var locationListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/LocationListener;").lengths(0);
  internal var openWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/OpenWindowListener;").lengths(0);
  internal var progressListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/ProgressListener;").lengths(0);
  internal var statusTextListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/StatusTextListener;").lengths(0);
  internal var titleListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/TitleListener;").lengths(0);
  internal var visibilityWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/VisibilityWindowListener;").lengths(0);
  internal var nextFunctionIndex: int = 1;
  internal var evaluateResult: Object;
  public static const ERROR_ID: String = "org.eclipse.swt.browser.error";
  public static const EXECUTE_ID: String = "SWTExecuteTemporaryFunction";
  public static var MozillaClearSessions: Runnable;
  public static var NativeClearSessions: Runnable;
  public static var KeyTable: JavaArray = new JavaArray("[[I").values(new JavaArray("[I").values(18, 65536), new JavaArray("[I").values(16, 131072), new JavaArray("[I").values(17, 262144), new JavaArray("[I").values(224, 4194304), new JavaArray("[I").values(65, 97), new JavaArray("[I").values(66, 98), new JavaArray("[I").values(67, 99), new JavaArray("[I").values(68, 100), new JavaArray("[I").values(69, 101), new JavaArray("[I").values(70, 102), new JavaArray("[I").values(71, 103), new JavaArray("[I").values(72, 104), new JavaArray("[I").values(73, 105), new JavaArray("[I").values(74, 106), new JavaArray("[I").values(75, 107), new JavaArray("[I").values(76, 108), new JavaArray("[I").values(77, 109), new JavaArray("[I").values(78, 110), new JavaArray("[I").values(79, 111), new JavaArray("[I").values(80, 112), new JavaArray("[I").values(81, 113), new JavaArray("[I").values(82, 114), new JavaArray("[I").values(83, 115), new JavaArray("[I").values(84, 116), new JavaArray("[I").values(85, 117), new JavaArray("[I").values(86, 118), new JavaArray("[I").values(87, 119), new JavaArray("[I").values(88, 120), new JavaArray("[I").values(89, 121), new JavaArray("[I").values(90, 122), new JavaArray("[I").values(48, 48), new JavaArray("[I").values(49, 49), new JavaArray("[I").values(50, 50), new JavaArray("[I").values(51, 51), new JavaArray("[I").values(52, 52), new JavaArray("[I").values(53, 53), new JavaArray("[I").values(54, 54), new JavaArray("[I").values(55, 55), new JavaArray("[I").values(56, 56), new JavaArray("[I").values(57, 57), new JavaArray("[I").values(32, 32), new JavaArray("[I").values(59, 59), new JavaArray("[I").values(61, 61), new JavaArray("[I").values(188, 44), new JavaArray("[I").values(190, 46), new JavaArray("[I").values(191, 47), new JavaArray("[I").values(219, 91), new JavaArray("[I").values(221, 93), new JavaArray("[I").values(222, 39), new JavaArray("[I").values(192, 96), new JavaArray("[I").values(220, 92), new JavaArray("[I").values(108, 124), new JavaArray("[I").values(37, 16777219), new JavaArray("[I").values(39, 16777220), new JavaArray("[I").values(38, 16777217), new JavaArray("[I").values(40, 16777218), new JavaArray("[I").values(45, 16777225), new JavaArray("[I").values(36, 16777223), new JavaArray("[I").values(35, 16777224), new JavaArray("[I").values(46, 127), new JavaArray("[I").values(33, 16777221), new JavaArray("[I").values(34, 16777222), new JavaArray("[I").values(8, 8), new JavaArray("[I").values(13, 13), new JavaArray("[I").values(9, 9), new JavaArray("[I").values(27, 27), new JavaArray("[I").values(12, 127), new JavaArray("[I").values(112, 16777226), new JavaArray("[I").values(113, 16777227), new JavaArray("[I").values(114, 16777228), new JavaArray("[I").values(115, 16777229), new JavaArray("[I").values(116, 16777230), new JavaArray("[I").values(117, 16777231), new JavaArray("[I").values(118, 16777232), new JavaArray("[I").values(119, 16777233), new JavaArray("[I").values(120, 16777234), new JavaArray("[I").values(121, 16777235), new JavaArray("[I").values(122, 16777236), new JavaArray("[I").values(123, 16777237), new JavaArray("[I").values(124, 16777238), new JavaArray("[I").values(125, 16777239), new JavaArray("[I").values(126, 16777240), new JavaArray("[I").values(127, 0), new JavaArray("[I").values(128, 0), new JavaArray("[I").values(129, 0), new JavaArray("[I").values(130, 0), new JavaArray("[I").values(131, 0), new JavaArray("[I").values(132, 0), new JavaArray("[I").values(133, 0), new JavaArray("[I").values(134, 0), new JavaArray("[I").values(135, 0), new JavaArray("[I").values(96, 16777264), new JavaArray("[I").values(97, 16777265), new JavaArray("[I").values(98, 16777266), new JavaArray("[I").values(99, 16777267), new JavaArray("[I").values(100, 16777268), new JavaArray("[I").values(101, 16777269), new JavaArray("[I").values(102, 16777270), new JavaArray("[I").values(103, 16777271), new JavaArray("[I").values(104, 16777272), new JavaArray("[I").values(105, 16777273), new JavaArray("[I").values(14, 16777296), new JavaArray("[I").values(107, 16777259), new JavaArray("[I").values(109, 16777261), new JavaArray("[I").values(106, 16777258), new JavaArray("[I").values(111, 16777263), new JavaArray("[I").values(110, 16777262), new JavaArray("[I").values(20, 16777298), new JavaArray("[I").values(144, 16777299), new JavaArray("[I").values(145, 16777300), new JavaArray("[I").values(44, 16777303), new JavaArray("[I").values(6, 16777297), new JavaArray("[I").values(19, 16777301), new JavaArray("[I").values(3, 16777302), new JavaArray("[I").values(186, 59), new JavaArray("[I").values(187, 61), new JavaArray("[I").values(189, 45));
  public function addCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener: CloseWindowListener): void {
    var newCloseWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/CloseWindowListener;").lengths(closeWindowListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(closeWindowListeners, 0, newCloseWindowListeners, 0, closeWindowListeners.length);
    closeWindowListeners = newCloseWindowListeners;
    closeWindowListeners[closeWindowListeners.length - 1] = listener;
  }
  public function addLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener: LocationListener): void {
    var newLocationListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/LocationListener;").lengths(locationListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(locationListeners, 0, newLocationListeners, 0, locationListeners.length);
    locationListeners = newLocationListeners;
    locationListeners[locationListeners.length - 1] = listener;
  }
  public function addOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener: OpenWindowListener): void {
    var newOpenWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/OpenWindowListener;").lengths(openWindowListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(openWindowListeners, 0, newOpenWindowListeners, 0, openWindowListeners.length);
    openWindowListeners = newOpenWindowListeners;
    openWindowListeners[openWindowListeners.length - 1] = listener;
  }
  public function addProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener: ProgressListener): void {
    var newProgressListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/ProgressListener;").lengths(progressListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(progressListeners, 0, newProgressListeners, 0, progressListeners.length);
    progressListeners = newProgressListeners;
    progressListeners[progressListeners.length - 1] = listener;
  }
  public function addStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener: StatusTextListener): void {
    var newStatusTextListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/StatusTextListener;").lengths(statusTextListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(statusTextListeners, 0, newStatusTextListeners, 0, statusTextListeners.length);
    statusTextListeners = newStatusTextListeners;
    statusTextListeners[statusTextListeners.length - 1] = listener;
  }
  public function addTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener: TitleListener): void {
    var newTitleListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/TitleListener;").lengths(titleListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(titleListeners, 0, newTitleListeners, 0, titleListeners.length);
    titleListeners = newTitleListeners;
    titleListeners[titleListeners.length - 1] = listener;
  }
  public function addVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener: VisibilityWindowListener): void {
    var newVisibilityWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/VisibilityWindowListener;").lengths(visibilityWindowListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, visibilityWindowListeners.length);
    visibilityWindowListeners = newVisibilityWindowListeners;
    visibilityWindowListeners[visibilityWindowListeners.length - 1] = listener;
  }
  public function back__(): Boolean { // abstract
    return false;
  }
  public static function clearSessions__(): void {
    if (NativeClearSessions !== null)
      NativeClearSessions.run__();
    if (MozillaClearSessions !== null)
      MozillaClearSessions.run__();
  }
  public function create__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): void { } // abstract
  public static function CreateErrorString__Ljava_lang_String_2(error: String): String {
    return "org.eclipse.swt.browser.error" + error;
  }
  public static function ExtractError__Ljava_lang_String_2(error: String): String {
    return Object(error).substring__I(Object("org.eclipse.swt.browser.error").length__());
  }
  public function createFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1: BrowserFunction): void {
    var keys: Enumeration = functions.keys__();
    while (keys.hasMoreElements__()) {
      var key: Object = keys.nextElement__();
      var current: BrowserFunction = BrowserFunction(functions.get__Ljava_lang_Object_2(key));
      if (Object(current.name).equals__Ljava_lang_Object_2(function_1.name)) {
        functions.remove__Ljava_lang_Object_2(key);
        break;
      }
    }
    function_1.index = this.getNextFunctionIndex__();
    this.registerFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1);
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["window."]));
    buffer.append__Ljava_lang_String_2(function_1.name);
    buffer.append__Ljava_lang_String_2(" = function ");
    buffer.append__Ljava_lang_String_2(function_1.name);
    buffer.append__Ljava_lang_String_2("() {var result = window.external.callJava(");
    buffer.append__I(function_1.index);
    buffer.append__Ljava_lang_String_2(",Array.prototype.slice.call(arguments)); if (typeof result == \'string\' && result.indexOf(\'");
    buffer.append__Ljava_lang_String_2("org.eclipse.swt.browser.error");
    buffer.append__Ljava_lang_String_2("\') == 0) {var error = new Error(result.substring(");
    buffer.append__I(Object("org.eclipse.swt.browser.error").length__());
    buffer.append__Ljava_lang_String_2(")); throw error;} return result;}");
    function_1.functionString = buffer.toString__();
    if (!this.execute__Ljava_lang_String_2(function_1.functionString)) {
      this.deregisterFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1);
    }
    return;
  }
  public function deregisterFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1: BrowserFunction): void {
    functions.remove__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [function_1.index])));
    return;
  }
  public function destroyFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1: BrowserFunction): void {
    this.execute__Ljava_lang_String_2(this.getDeleteFunctionString__Ljava_lang_String_2(function_1.name));
    this.deregisterFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1);
    return;
  }
  public function execute__Ljava_lang_String_2(script: String): Boolean { // abstract
    return false;
  }
  public function evaluate__Ljava_lang_String_2(script: String): Object {
    var function_1: BrowserFunction = new WebBrowser$EvaluateFunction(this, browser, "");
    var index: int = this.getNextFunctionIndex__();
    function_1.index = index;
    function_1.isEvaluate = true;
    this.registerFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1);
    var functionName: String = "SWTExecuteTemporaryFunction" + index;
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["window."]));
    buffer.append__Ljava_lang_String_2(functionName);
    buffer.append__Ljava_lang_String_2(" = function ");
    buffer.append__Ljava_lang_String_2(functionName);
    buffer.append__Ljava_lang_String_2("() {\n");
    buffer.append__Ljava_lang_String_2(script);
    buffer.append__Ljava_lang_String_2("\n};");
    this.execute__Ljava_lang_String_2(buffer.toString__());
    buffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["if (window."]));
    buffer.append__Ljava_lang_String_2(functionName);
    buffer.append__Ljava_lang_String_2(" == undefined) {window.external.callJava(");
    buffer.append__I(index);
    buffer.append__Ljava_lang_String_2(", [\'");
    buffer.append__Ljava_lang_String_2("org.eclipse.swt.browser.error");
    buffer.append__Ljava_lang_String_2("\']);} else {try {var result = ");
    buffer.append__Ljava_lang_String_2(functionName);
    buffer.append__Ljava_lang_String_2("(); window.external.callJava(");
    buffer.append__I(index);
    buffer.append__Ljava_lang_String_2(", [result]);} catch (e) {window.external.callJava(");
    buffer.append__I(index);
    buffer.append__Ljava_lang_String_2(", [\'");
    buffer.append__Ljava_lang_String_2("org.eclipse.swt.browser.error");
    buffer.append__Ljava_lang_String_2("\' + e.message]);}}");
    this.execute__Ljava_lang_String_2(buffer.toString__());
    this.execute__Ljava_lang_String_2(this.getDeleteFunctionString__Ljava_lang_String_2(functionName));
    this.deregisterFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1);
    var result: Object = evaluateResult;
    evaluateResult = null;
    if (result is SWTException)
      throw SWTException(result);
    return result;
  }
  public function forward__(): Boolean { // abstract
    return false;
  }
  public function getBrowserType__(): String { // abstract
    return null;
  }
  public function getDeleteFunctionString__Ljava_lang_String_2(functionName: String): String {
    return "delete window." + functionName + String.fromCharCode(59);
  }
  public function getNextFunctionIndex__(): int {
    return nextFunctionIndex++;
  }
  public function getText__(): String { // abstract
    return null;
  }
  public function getUrl__(): String { // abstract
    return null;
  }
  public function getWebBrowser__(): Object {
    return null;
  }
  public function isBackEnabled__(): Boolean { // abstract
    return false;
  }
  public function isFocusControl__(): Boolean {
    return false;
  }
  public function isForwardEnabled__(): Boolean { // abstract
    return false;
  }
  public function refresh__(): void { } // abstract
  public function registerFunction__Lorg_eclipse_swt_browser_BrowserFunction_2(function_1: BrowserFunction): void {
    functions.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [function_1.index])), function_1);
  }
  public function removeCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(listener: CloseWindowListener): void {
    if (closeWindowListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < closeWindowListeners.length; i++) {
      if (listener === closeWindowListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (closeWindowListeners.length == 1) {
      closeWindowListeners = new JavaArray("[Lorg/eclipse/swt/browser/CloseWindowListener;").lengths(0);
      return;
    }
    var newCloseWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/CloseWindowListener;").lengths(closeWindowListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(closeWindowListeners, 0, newCloseWindowListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(closeWindowListeners, index + 1, newCloseWindowListeners, index, closeWindowListeners.length - index - 1);
    closeWindowListeners = newCloseWindowListeners;
    return;
  }
  public function removeLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(listener: LocationListener): void {
    if (locationListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < locationListeners.length; i++) {
      if (listener === locationListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (locationListeners.length == 1) {
      locationListeners = new JavaArray("[Lorg/eclipse/swt/browser/LocationListener;").lengths(0);
      return;
    }
    var newLocationListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/LocationListener;").lengths(locationListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(locationListeners, 0, newLocationListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(locationListeners, index + 1, newLocationListeners, index, locationListeners.length - index - 1);
    locationListeners = newLocationListeners;
    return;
  }
  public function removeOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(listener: OpenWindowListener): void {
    if (openWindowListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < openWindowListeners.length; i++) {
      if (listener === openWindowListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (openWindowListeners.length == 1) {
      openWindowListeners = new JavaArray("[Lorg/eclipse/swt/browser/OpenWindowListener;").lengths(0);
      return;
    }
    var newOpenWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/OpenWindowListener;").lengths(openWindowListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(openWindowListeners, 0, newOpenWindowListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(openWindowListeners, index + 1, newOpenWindowListeners, index, openWindowListeners.length - index - 1);
    openWindowListeners = newOpenWindowListeners;
    return;
  }
  public function removeProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(listener: ProgressListener): void {
    if (progressListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < progressListeners.length; i++) {
      if (listener === progressListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (progressListeners.length == 1) {
      progressListeners = new JavaArray("[Lorg/eclipse/swt/browser/ProgressListener;").lengths(0);
      return;
    }
    var newProgressListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/ProgressListener;").lengths(progressListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(progressListeners, 0, newProgressListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(progressListeners, index + 1, newProgressListeners, index, progressListeners.length - index - 1);
    progressListeners = newProgressListeners;
    return;
  }
  public function removeStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(listener: StatusTextListener): void {
    if (statusTextListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < statusTextListeners.length; i++) {
      if (listener === statusTextListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (statusTextListeners.length == 1) {
      statusTextListeners = new JavaArray("[Lorg/eclipse/swt/browser/StatusTextListener;").lengths(0);
      return;
    }
    var newStatusTextListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/StatusTextListener;").lengths(statusTextListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(statusTextListeners, 0, newStatusTextListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(statusTextListeners, index + 1, newStatusTextListeners, index, statusTextListeners.length - index - 1);
    statusTextListeners = newStatusTextListeners;
    return;
  }
  public function removeTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(listener: TitleListener): void {
    if (titleListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < titleListeners.length; i++) {
      if (listener === titleListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (titleListeners.length == 1) {
      titleListeners = new JavaArray("[Lorg/eclipse/swt/browser/TitleListener;").lengths(0);
      return;
    }
    var newTitleListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/TitleListener;").lengths(titleListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(titleListeners, 0, newTitleListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(titleListeners, index + 1, newTitleListeners, index, titleListeners.length - index - 1);
    titleListeners = newTitleListeners;
    return;
  }
  public function removeVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(listener: VisibilityWindowListener): void {
    if (visibilityWindowListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < visibilityWindowListeners.length; i++) {
      if (listener === visibilityWindowListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (visibilityWindowListeners.length == 1) {
      visibilityWindowListeners = new JavaArray("[Lorg/eclipse/swt/browser/VisibilityWindowListener;").lengths(0);
      return;
    }
    var newVisibilityWindowListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/browser/VisibilityWindowListener;").lengths(visibilityWindowListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, visibilityWindowListeners.length - index - 1);
    visibilityWindowListeners = newVisibilityWindowListeners;
    return;
  }
  public function setBrowser__Lorg_eclipse_swt_browser_Browser_2(browser_1: Browser): void {
    this.browser = browser_1;
    return;
  }
  public function setText__Ljava_lang_String_2(html: String): Boolean { // abstract
    return false;
  }
  public function setUrl__Ljava_lang_String_2(url: String): Boolean { // abstract
    return false;
  }
  public function stop__(): void { } // abstract
  public function translateKey__I(key: int): int {
    for (var i: int = 0; i < KeyTable.length; i++) {
      if (KeyTable[i][0] == key)
        return KeyTable[i][1];
    }
    return 0;
  }
}
}
