package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Runnable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class AnimatedProgress extends Canvas {
  public static const SLEEP: int = 70;
  public static const DEFAULT_WIDTH: int = 160;
  public static const DEFAULT_HEIGHT: int = 18;
  internal var active: Boolean = false;
  internal var showStripes: Boolean = false;
  internal var value: int;
  internal var orientation: int = 256;
  internal var showBorder: Boolean = false;
  public function AnimatedProgress(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [parent, AnimatedProgress.checkStyle__I(style)]));
    if ((style & 512) != 0) {
      orientation = 512;
    }
    showBorder = (style & 2048) != 0;
    this.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.custom.AnimatedProgress$1(this));
    this.addPaintListener__Lorg_eclipse_swt_events_PaintListener_2(new org.eclipse.swt.custom.AnimatedProgress$2(this));
    this.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.custom.AnimatedProgress$3(this));
    return;
  }
  private static function checkStyle__I(style: int): int {
    var mask: int = 0;
    return style & mask;
  }
  public function clear__(): void {
    this.checkWidget__();
    if (active)
      this.stop__();
    showStripes = false;
    this.redraw__();
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var size: Point = null;
    if (orientation == 256) {
      size = new Point(160, 18);
    } else {
      size = new Point(18, 160);
    }
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    return size;
  }
  private function drawBevelRect__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc: GC, x_1: int, y_1: int, w: int, h: int, topleft: Color, bottomright: Color): void {
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(topleft);
    gc.drawLine__IIII(x_1, y_1, x_1 + w - 1, y_1);
    gc.drawLine__IIII(x_1, y_1, x_1, y_1 + h - 1);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(bottomright);
    gc.drawLine__IIII(x_1 + w, y_1, x_1 + w, y_1 + h);
    gc.drawLine__IIII(x_1, y_1 + h, x_1 + w, y_1 + h);
  }
  public function paint__Lorg_eclipse_swt_events_PaintEvent_2(event: PaintEvent): void {
    var gc: GC = event.gc;
    var disp: Display = this.getDisplay__();
    var rect: Rectangle = this.getClientArea__();
    gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
    if (showBorder) {
      this.drawBevelRect__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor__I(18), disp.getSystemColor__I(20));
    }
    this.paintStripes__Lorg_eclipse_swt_graphics_GC_2(gc);
    return;
  }
  public function paintStripes__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (!showStripes)
      return;
    var rect: Rectangle = this.getClientArea__();
    rect = new Rectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
    gc.setLineWidth__I(2);
    gc.setClipping__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
    var color: Color = this.getDisplay__().getSystemColor__I(26);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
    var step: int = 12;
    var foregroundValue: int = value == 0 ? step - 2 : value - 2;
    if (orientation == 256) {
      var y_1: int = rect.y - 1;
      var w: int = rect.width;
      var h: int = rect.height + 2;
      for (var i: int = 0; i < w; i += step) {
        var x_1: int = i + foregroundValue;
        gc.drawLine__IIII(x_1, y_1, x_1, h);
      }
    } else {
      var x_2: int = rect.x - 1;
      var w_1: int = rect.width + 2;
      var h_1: int = rect.height;
      for (var i_1: int = 0; i_1 < h_1; i_1 += step) {
        var y_2: int = i_1 + foregroundValue;
        gc.drawLine__IIII(x_2, y_2, w_1, y_2);
      }
    }
    if (active) {
      value = (value + 2) % step;
    }
    return;
  }
  public function start__(): void {
    this.checkWidget__();
    if (active)
      return;
    active = true;
    showStripes = true;
    var display_1: Display = this.getDisplay__();
    var timer: JavaArray = new JavaArray("[Ljava/lang/Runnable;").lengths(1);
    timer[0] = new org.eclipse.swt.custom.AnimatedProgress$4(this, display_1, timer);
    display_1.timerExec__ILjava_lang_Runnable_2(70, timer[0]);
  }
  public function stop__(): void {
    active = false;
  }
}
}
