package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Bullet {
  public var type: int;
  public var style: StyleRange;
  public var text: String;
  internal var linesIndices: JavaArray;
  internal var count: int;
  public function Bullet__Lorg_eclipse_swt_custom_StyleRange_2(style: StyleRange): Object {
    return this;
  }
  public function Bullet__ILorg_eclipse_swt_custom_StyleRange_2(type: int, style: StyleRange): Object {
    if (style === null)
      SWT.error__I(4);
    if (style.metrics === null)
      SWT.error__I(4);
    this.type = type;
    this.style = style;
    return this;
  }
  public function addIndices__II(startLine: int, lineCount: int): void {
    if (linesIndices === null) {
      linesIndices = new JavaArray("[I").lengths(lineCount);
      count = lineCount;
      for (var i: int = 0; i < lineCount; i++)
        linesIndices[i] = startLine + i;
    } else {
      var modifyStart: int = 0;
      while (modifyStart < count) {
        if (startLine <= linesIndices[modifyStart])
          break;
        modifyStart++;
      }
      var modifyEnd: int = modifyStart;
      while (modifyEnd < count) {
        if (startLine + lineCount <= linesIndices[modifyEnd])
          break;
        modifyEnd++;
      }
      var newSize: int = modifyStart + lineCount + count - modifyEnd;
      if (newSize > linesIndices.length) {
        var newLinesIndices: JavaArray = new JavaArray("[I").lengths(newSize);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(linesIndices, 0, newLinesIndices, 0, count);
        linesIndices = newLinesIndices;
      }
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(linesIndices, modifyEnd, linesIndices, modifyStart + lineCount, count - modifyEnd);
      for (var i_1: int = 0; i_1 < lineCount; i_1++)
        linesIndices[modifyStart + i_1] = startLine + i_1;
      count = newSize;
    }
    return;
  }
  public function indexOf__I(lineIndex: int): int {
    for (var i: int = 0; i < count; i++) {
      if (linesIndices[i] == lineIndex)
        return i;
    }
    return -1;
  }
  public function hashCode__(): int {
    return style.hashCode__() ^ type;
  }
  public function removeIndices__IIIZ(startLine: int, replaceLineCount: int, newLineCount: int, update: Boolean): JavaArray {
    if (count == 0)
      return null;
    if (startLine > linesIndices[count - 1])
      return null;
    var endLine: int = startLine + replaceLineCount;
    var delta: int = newLineCount - replaceLineCount;
    for (var i: int = 0; i < count; i++) {
      var index: int = linesIndices[i];
      if (startLine <= index) {
        var j: int = i;
        while (j < count) {
          if (linesIndices[j] >= endLine)
            break;
          j++;
        }
        if (update) {
          for (var k: int = j; k < count; k++)
            linesIndices[k] += delta;
        }
        var redrawLines: JavaArray = new JavaArray("[I").lengths(count - j);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(linesIndices, j, redrawLines, 0, count - j);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(linesIndices, j, linesIndices, i, count - j);
        count -= (j - i);
        return redrawLines;
      }
    }
    for (var i_1: int = 0; i_1 < count; i_1++)
      linesIndices[i_1] += delta;
    return null;
  }
  public function size__(): int {
    return count;
  }
  public function Bullet(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is StyleRange) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is StyleRange) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [1, args0[0]];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Bullet__ILorg_eclipse_swt_custom_StyleRange_2(args1[0], args1[1]);
        Bullet__Lorg_eclipse_swt_custom_StyleRange_2(args0[0]);
        break;
      case 1:
        Bullet__ILorg_eclipse_swt_custom_StyleRange_2(args1[0], args1[1]);
        break;
    }
  }
  public static const Bullet__Lorg_eclipse_swt_custom_StyleRange_2 : int = 0;
  public static const Bullet__ILorg_eclipse_swt_custom_StyleRange_2 : int = 1;
}
}
