package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Display;
import java.lang.Runnable;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import org.eclipse.swt.graphics.Cursor;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class BusyIndicator {
  public static var nextBusyId: int = 1;
  public static const BUSYID_NAME: String = "SWT BusyIndicator";
  public static const BUSY_CURSOR: String = "SWT BusyIndicator Cursor";
  public static function showWhile__Lorg_eclipse_swt_widgets_Display_2Ljava_lang_Runnable_2(display: Display, runnable: Runnable): void {
    if (runnable === null)
      SWT.error__I(4);
    if (display === null) {
      display = Display.getCurrent__();
      if (display === null) {
        runnable.run__();
        return;
      }
    }
    var busyId: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [nextBusyId]));
    nextBusyId++;
    var cursor: Cursor = display.getSystemCursor__I(1);
    var shells: JavaArray = display.getShells__();
    for (var i: int = 0; i < shells.length; i++) {
      var id: Integer = Integer(shells[i].getData__Ljava_lang_String_2("SWT BusyIndicator"));
      if (id === null) {
        shells[i].setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor);
        shells[i].setData__Ljava_lang_String_2Ljava_lang_Object_2("SWT BusyIndicator", busyId);
      }
    }
    try {
      runnable.run__();
    } finally {
      shells = display.getShells__();
      for (var i_1: int = 0; i_1 < shells.length; i_1++) {
        var id_1: Integer = Integer(shells[i_1].getData__Ljava_lang_String_2("SWT BusyIndicator"));
        if (id_1 === busyId) {
          shells[i_1].setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
          shells[i_1].setData__Ljava_lang_String_2Ljava_lang_Object_2("SWT BusyIndicator", null);
        }
      }
    }
    return;
  }
}
}
