package org.eclipse.swt.custom {
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Layout;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CBanner extends Composite {
  internal var left: Control;
  internal var right: Control;
  internal var bottom: Control;
  internal var simple: Boolean = true;
  internal var curve: JavaArray = new JavaArray("[I").lengths(0);
  internal var curveStart: int = 0;
  internal var curveRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var curve_width: int = 5;
  internal var curve_indent: int = -2;
  internal var rightWidth: int = -1;
  internal var rightMinWidth: int = 0;
  internal var rightMinHeight: int = 0;
  internal var resizeCursor: Cursor;
  internal var dragging: Boolean = false;
  internal var rightDragDisplacement: int = 0;
  internal var listener: Listener;
  public static const OFFSCREEN: int = -200;
  public static const BORDER_BOTTOM: int = 2;
  public static const BORDER_TOP: int = 3;
  public static const BORDER_STRIPE: int = 1;
  public static const CURVE_TAIL: int = 200;
  public static const BEZIER_RIGHT: int = 30;
  public static const BEZIER_LEFT: int = 30;
  public static const MIN_LEFT: int = 10;
  public static var BORDER1: int = 20;
  public function CBanner(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, CBanner.checkStyle__I(style)]));
    super.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new CBannerLayout());
    resizeCursor = new Cursor(new Arguments(org.eclipse.swt.graphics.Cursor.Cursor__Lorg_eclipse_swt_graphics_Device_2I, [this.getDisplay__(), 9]));
    listener = new org.eclipse.swt.custom.CBanner$1(this);
    var events: JavaArray = new JavaArray("[I").values(12, 3, 7, 5, 4, 9, 11);
    for (var i: int = 0; i < events.length; i++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(events[i], listener);
    }
    return;
  }
  public static function bezier__IIIIIIIII(x0: int, y0: int, x1: int, y1: int, x2: int, y2: int, x3: int, y3: int, count: int): JavaArray {
    var a0: Number = x0;
    var a1: Number = 3 * (x1 - x0);
    var a2: Number = 3 * (x0 + x2 - 2 * x1);
    var a3: Number = x3 - x0 + 3 * x1 - 3 * x2;
    var b0: Number = y0;
    var b1: Number = 3 * (y1 - y0);
    var b2: Number = 3 * (y0 + y2 - 2 * y1);
    var b3: Number = y3 - y0 + 3 * y1 - 3 * y2;
    var polygon: JavaArray = new JavaArray("[I").lengths(2 * count + 2);
    for (var i: int = 0; i <= count; i++) {
      var t: Number = Number(i) / Number(count);
      polygon[2 * i] = int((a0 + a1 * t + a2 * t * t + a3 * t * t * t));
      polygon[2 * i + 1] = int((b0 + b1 * t + b2 * t * t + b3 * t * t * t));
    }
    return polygon;
  }
  public static function checkStyle__I(style: int): int {
    return 0;
  }
  public function getBottom__(): Control {
    this.checkWidget__();
    return bottom;
  }
  public override function getClientArea__(): Rectangle {
    return new Rectangle(0, 0, 0, 0);
  }
  public function getLeft__(): Control {
    this.checkWidget__();
    return left;
  }
  public function getRight__(): Control {
    this.checkWidget__();
    return right;
  }
  public function getRightMinimumSize__(): Point {
    this.checkWidget__();
    return new Point(rightMinWidth, rightMinHeight);
  }
  public function getRightWidth__(): int {
    this.checkWidget__();
    if (right === null)
      return 0;
    if (rightWidth == -1) {
      var size: Point = right.computeSize__IIZ(-1, -1, false);
      return size.x;
    }
    return rightWidth;
  }
  public function getSimple__(): Boolean {
    this.checkWidget__();
    return simple;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    if (resizeCursor !== null)
      resizeCursor.dispose__();
    resizeCursor = null;
    left = null;
    right = null;
    bottom = null;
  }
  public function onMouseDown__II(x_1: int, y_1: int): void {
    if (curveRect.contains__II(x_1, y_1)) {
      dragging = true;
      rightDragDisplacement = curveStart - x_1 + curve_width - curve_indent;
    }
    return;
  }
  public function onMouseExit__(): void {
    if (!dragging)
      this.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    return;
  }
  public function onMouseMove__II(x_1: int, y_1: int): void {
    if (dragging) {
      var size: Point = this.getSize__();
      if (!(0 < x_1 && x_1 < size.x))
        return;
      rightWidth = Math__.max__II(0, size.x - x_1 - rightDragDisplacement);
      if (rightMinWidth == -1) {
        var minSize: Point = right.computeSize__II(rightMinWidth, rightMinHeight);
        rightWidth = Math__.max__II(minSize.x, rightWidth);
      } else {
        rightWidth = Math__.max__II(rightMinWidth, rightWidth);
      }
      this.layout__Z(false);
      return;
    }
    if (curveRect.contains__II(x_1, y_1)) {
      this.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(resizeCursor);
    } else {
      this.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(null);
    }
    return;
  }
  public function onMouseUp__(): void {
    dragging = false;
    return;
  }
  public function onPaint__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (left === null && right === null)
      return;
    var size: Point = this.getSize__();
    var border1: Color = this.getDisplay__().getSystemColor__I(BORDER1);
    if (bottom !== null) {
      var y_1: int = bottom.getBounds__().y - 1 - 1;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(border1);
      gc.drawLine__IIII(0, y_1, size.x, y_1);
    }
    if (left === null || right === null)
      return;
    var line1: JavaArray = new JavaArray("[I").lengths(curve.length + 6);
    var index: int = 0;
    var x_1: int = curveStart;
    line1[index++] = x_1 + 1;
    line1[index++] = size.y - 1;
    for (var i: int = 0; i < int(curve.length / 2); i++) {
      line1[index++] = x_1 + curve[2 * i];
      line1[index++] = curve[2 * i + 1];
    }
    line1[index++] = x_1 + curve_width;
    line1[index++] = 0;
    line1[index++] = size.x;
    line1[index++] = 0;
    var background_1: Color = this.getBackground__();
    if (this.getDisplay__().getDepth__() >= 15) {
      var line2: JavaArray = new JavaArray("[I").lengths(line1.length);
      index = 0;
      for (var i_1: int = 0; i_1 < int(line1.length / 2); i_1++) {
        line2[index] = line1[index++] - 1;
        line2[index] = line1[index++];
      }
      var line3: JavaArray = new JavaArray("[I").lengths(line1.length);
      index = 0;
      for (var i_2: int = 0; i_2 < int(line1.length / 2); i_2++) {
        line3[index] = line1[index++] + 1;
        line3[index] = line1[index++];
      }
      var from: RGB = border1.getRGB__();
      var to_1: RGB = background_1.getRGB__();
      var red: int = from.red + int(3 * (to_1.red - from.red) / 4);
      var green: int = from.green + int(3 * (to_1.green - from.green) / 4);
      var blue: int = from.blue + int(3 * (to_1.blue - from.blue) / 4);
      var color: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [this.getDisplay__(), red, green, blue]));
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
      gc.drawPolyline___3I(line2);
      gc.drawPolyline___3I(line3);
      color.dispose__();
      var x1: int = Math__.max__II(0, curveStart - 200);
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(background_1);
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(border1);
      gc.fillGradientRectangle__IIIIZ(x1, size.y - 1, curveStart - x1 + 1, 1, false);
    } else {
      var x1_1: int = Math__.max__II(0, curveStart - 200);
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(border1);
      gc.drawLine__IIII(x1_1, size.y - 1, curveStart + 1, size.y - 1);
    }
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(border1);
    gc.drawPolyline___3I(line1);
    return;
  }
  public function onResize__(): void {
    this.updateCurve__I(this.getSize__().y);
    return;
  }
  public function setBottom__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control !== null && control.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (bottom !== null && !bottom.isDisposed__()) {
      var size: Point = bottom.getSize__();
      bottom.setLocation__II(-200 - size.x, -200 - size.y);
    }
    bottom = control;
    this.layout__Z(false);
    return;
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setLeft__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control !== null && control.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (left !== null && !left.isDisposed__()) {
      var size: Point = left.getSize__();
      left.setLocation__II(-200 - size.x, -200 - size.y);
    }
    left = control;
    this.layout__Z(false);
    return;
  }
  public function setRight__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control !== null && control.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (right !== null && !right.isDisposed__()) {
      var size: Point = right.getSize__();
      right.setLocation__II(-200 - size.x, -200 - size.y);
    }
    right = control;
    this.layout__Z(false);
    return;
  }
  public function setRightMinimumSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null || size.x < -1 || size.y < -1)
      SWT.error__I(5);
    rightMinWidth = size.x;
    rightMinHeight = size.y;
    this.layout__Z(false);
    return;
  }
  public function setRightWidth__I(width_1: int): void {
    this.checkWidget__();
    if (width_1 < -1)
      SWT.error__I(5);
    rightWidth = width_1;
    this.layout__Z(false);
    return;
  }
  public function setSimple__Z(simple_1: Boolean): void {
    this.checkWidget__();
    if (this.simple != simple_1) {
      this.simple = simple_1;
      if (simple_1) {
        curve_width = 5;
        curve_indent = -2;
      } else {
        curve_width = 50;
        curve_indent = 5;
      }
      this.updateCurve__I(this.getSize__().y);
      this.layout__Z(false);
      this.redraw__();
    }
    return;
  }
  public function updateCurve__I(height_1: int): void {
    var h: int = height_1 - 1;
    if (simple) {
      curve = new JavaArray("[I").values(0, h, 1, h, 2, h - 1, 3, h - 2, 3, 2, 4, 1, 5, 0);
    } else {
      curve = CBanner.bezier__IIIIIIIII(0, h + 1, 30, h + 1, curve_width - 30, 0, curve_width, 0, curve_width);
    }
    return;
  }
}
}
