package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.graphics.Rectangle;
dynamic public class CBannerLayout extends Layout {
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var banner: CBanner = CBanner(composite);
    var left: Control = banner.left;
    var right: Control = banner.right;
    var bottom: Control = banner.bottom;
    var showCurve: Boolean = left !== null && right !== null;
    var height: int = hHint;
    var width: int = wHint;
    var bottomSize: Point = new Point(0, 0);
    if (bottom !== null) {
      var trim: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(bottom);
      var w: int = wHint == -1 ? -1 : Math__.max__II(0, width - trim);
      bottomSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(bottom, w, -1, flushCache);
    }
    var rightSize: Point = new Point(0, 0);
    if (right !== null) {
      var trim_1: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(right);
      var w_1: int = -1;
      if (banner.rightWidth != -1) {
        w_1 = banner.rightWidth - trim_1;
        if (left !== null) {
          w_1 = Math__.min__II(w_1, width - banner.curve_width + 2 * banner.curve_indent - 10 - trim_1);
        }
        w_1 = Math__.max__II(0, w_1);
      }
      rightSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(right, w_1, -1, flushCache);
      if (wHint != -1) {
        width -= rightSize.x + banner.curve_width - 2 * banner.curve_indent;
      }
    }
    var leftSize: Point = new Point(0, 0);
    if (left !== null) {
      var trim_2: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(left);
      var w_2: int = wHint == -1 ? -1 : Math__.max__II(0, width - trim_2);
      leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, w_2, -1, flushCache);
    }
    width = leftSize.x + rightSize.x;
    height = bottomSize.y;
    if (bottom !== null && (left !== null || right !== null)) {
      height += 1 + 2;
    }
    if (left !== null) {
      if (right === null) {
        height += leftSize.y;
      } else {
        height += Math__.max__II(leftSize.y, banner.rightMinHeight == -1 ? rightSize.y : banner.rightMinHeight);
      }
    } else {
      height += rightSize.y;
    }
    if (showCurve) {
      width += banner.curve_width - 2 * banner.curve_indent;
      height += 3 + 2 + 2 * 1;
    }
    if (wHint != -1)
      width = wHint;
    if (hHint != -1)
      height = hHint;
    return new Point(width, height);
  }
  public function computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control: Control, wHint: int, hHint: int, flushCache: Boolean): Point {
    var data: Object = control.getLayoutData__();
    if (data === null || !(data is CLayoutData)) {
      data = new CLayoutData();
      control.setLayoutData__Ljava_lang_Object_2(data);
    }
    return (CLayoutData(data)).computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, wHint, hHint, flushCache);
  }
  public function computeTrim__Lorg_eclipse_swt_widgets_Control_2(c: Control): int {
    if (c is Scrollable) {
      var rect: Rectangle = (Scrollable(c)).computeTrim__IIII(0, 0, 0, 0);
      return rect.width;
    }
    return c.getBorderWidth__() * 2;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    var data: Object = control.getLayoutData__();
    if (data !== null && data is CLayoutData)
      (CLayoutData(data)).flushCache__();
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var banner: CBanner = CBanner(composite);
    var left: Control = banner.left;
    var right: Control = banner.right;
    var bottom: Control = banner.bottom;
    var size: Point = banner.getSize__();
    var showCurve: Boolean = left !== null && right !== null;
    var width: int = size.x - 2 * banner.getBorderWidth__();
    var height: int = size.y - 2 * banner.getBorderWidth__();
    var bottomSize: Point = new Point(0, 0);
    if (bottom !== null) {
      var trim: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(bottom);
      var w: int = Math__.max__II(0, width - trim);
      bottomSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(bottom, w, -1, flushCache);
      height -= bottomSize.y + 1 + 2;
    }
    if (showCurve)
      height -= 3 + 2 + 2 * 1;
    height = Math__.max__II(0, height);
    var rightSize: Point = new Point(0, 0);
    if (right !== null) {
      var trim_1: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(right);
      var w_1: int = -1;
      if (banner.rightWidth != -1) {
        w_1 = banner.rightWidth - trim_1;
        if (left !== null) {
          w_1 = Math__.min__II(w_1, width - banner.curve_width + 2 * banner.curve_indent - 10 - trim_1);
        }
        w_1 = Math__.max__II(0, w_1);
      }
      rightSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(right, w_1, -1, flushCache);
      width = width - (rightSize.x - banner.curve_indent + banner.curve_width - banner.curve_indent);
    }
    var leftSize: Point = new Point(0, 0);
    if (left !== null) {
      var trim_2: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(left);
      var w_2: int = Math__.max__II(0, width - trim_2);
      leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, w_2, -1, flushCache);
    }
    var x: int = 0;
    var y: int = 0;
    var oldStart: int = banner.curveStart;
    var leftRect: Rectangle = null;
    var rightRect: Rectangle = null;
    var bottomRect: Rectangle = null;
    if (bottom !== null) {
      bottomRect = new Rectangle(x, y + size.y - bottomSize.y, bottomSize.x, bottomSize.y);
    }
    if (showCurve)
      y += 3 + 1;
    if (left !== null) {
      leftRect = new Rectangle(x, y, leftSize.x, leftSize.y);
      banner.curveStart = x + leftSize.x - banner.curve_indent;
      x += leftSize.x - banner.curve_indent + banner.curve_width - banner.curve_indent;
    }
    if (right !== null) {
      if (left !== null) {
        rightSize.y = Math__.max__II(leftSize.y, banner.rightMinHeight == -1 ? rightSize.y : banner.rightMinHeight);
      }
      rightRect = new Rectangle(x, y, rightSize.x, rightSize.y);
    }
    if (banner.curveStart < oldStart) {
      banner.redraw__IIIIZ(banner.curveStart - 200, 0, oldStart + banner.curve_width - banner.curveStart + 200 + 5, size.y, false);
    }
    if (banner.curveStart > oldStart) {
      banner.redraw__IIIIZ(oldStart - 200, 0, banner.curveStart + banner.curve_width - oldStart + 200 + 5, size.y, false);
    }
    banner.update__();
    banner.curveRect = new Rectangle(banner.curveStart, 0, banner.curve_width, size.y);
    if (bottomRect !== null)
      bottom.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(bottomRect);
    if (rightRect !== null)
      right.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(rightRect);
    if (leftRect !== null)
      left.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(leftRect);
    return;
  }
}
}
