package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import java.lang.Runnable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.GC;
import java.lang.Math__;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Character;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.widgets.Layout;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CCombo extends Composite {
  internal var text: Text;
  internal var list: List;
  internal var visibleItemCount: int = 5;
  internal var popup: Shell;
  internal var arrow: Button;
  internal var hasFocus: Boolean;
  internal var listener: Listener;
  internal var filter: Listener;
  internal var foreground: Color;
  internal var background: Color;
  internal var font: Font;
  internal var _shell: Shell;
  public static const PACKAGE_PREFIX: String = "org.eclipse.swt.custom.";
  public function CCombo(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style = CCombo.checkStyle__I(style)]));
    _shell = super.getShell__();
    var textStyle: int = 4;
    if ((style & 8) != 0)
      textStyle |= 8;
    if ((style & 8388608) != 0)
      textStyle |= 8388608;
    text = new Text(this, textStyle);
    var arrowStyle: int = 4 | 1024;
    if ((style & 8388608) != 0)
      arrowStyle |= 8388608;
    arrow = new Button(this, arrowStyle);
    listener = new CCombo$1(this);
    filter = new org.eclipse.swt.custom.CCombo$2(this);
    var comboEvents: JavaArray = new JavaArray("[I").values(12, 15, 10, 11);
    for (var i: int = 0; i < comboEvents.length; i++)
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(comboEvents[i], listener);
    var textEvents: JavaArray = new JavaArray("[I").values(14, 1, 2, 35, 24, 3, 4, 8, 37, 31, 15, 25);
    for (var i_1: int = 0; i_1 < textEvents.length; i_1++)
      text.addListener__ILorg_eclipse_swt_widgets_Listener_2(textEvents[i_1], listener);
    var arrowEvents: JavaArray = new JavaArray("[I").values(3, 4, 13, 15);
    for (var i_2: int = 0; i_2 < arrowEvents.length; i_2++)
      arrow.addListener__ILorg_eclipse_swt_widgets_Listener_2(arrowEvents[i_2], listener);
    this.createPopup___3Ljava_lang_String_2I(null, -1);
    this.initAccessible__();
    return;
  }
  public static function checkStyle__I(style: int): int {
    var mask: int = 2048 | 8 | 8388608 | 33554432 | 67108864;
    return 524288 | (style & mask);
  }
  public function add__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    list.add__Ljava_lang_String_2(string);
  }
  public function add__Ljava_lang_String_2I(string: String, index: int): void {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    list.add__Ljava_lang_String_2I(string, index);
  }
  public function addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener_1: ModifyListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(24, typedListener);
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
  }
  public function addVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener_1: VerifyListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(25, typedListener);
  }
  public function arrowEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.type) {
      case 15 :
        {
          this.handleFocus__I(15);
          break;
        }
      case 3 :
        {
          var mouseEvent: Event = new Event();
          mouseEvent.button = event.button;
          mouseEvent.count = event.count;
          mouseEvent.stateMask = event.stateMask;
          mouseEvent.time = event.time;
          mouseEvent.x = event.x;
          mouseEvent.y = event.y;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3, mouseEvent);
          event.doit = mouseEvent.doit;
          break;
        }
      case 4 :
        {
          var mouseEvent_1: Event = new Event();
          mouseEvent_1.button = event.button;
          mouseEvent_1.count = event.count;
          mouseEvent_1.stateMask = event.stateMask;
          mouseEvent_1.time = event.time;
          mouseEvent_1.x = event.x;
          mouseEvent_1.y = event.y;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(4, mouseEvent_1);
          event.doit = mouseEvent_1.doit;
          break;
        }
      case 13 :
        {
          text.setFocus__();
          this.dropDown__Z(!this.isDropped__());
          break;
        }
    }
    return;
  }
  public override function checkSubclass__(): void {
    var name: String = Object(this).getClass__().getName__();
    var index: int = Object(name).lastIndexOf__I(46);
    if (!Object(Object(name).substring__II(0, index + 1)).equals__Ljava_lang_Object_2("org.eclipse.swt.custom.")) {
      SWT.error__I(43);
    }
    return;
  }
  public function clearSelection__(): void {
    this.checkWidget__();
    text.clearSelection__();
    list.deselectAll__();
    return;
  }
  public function comboEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.type) {
      case 12 :
        this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
        event.type = 0;
        if (popup !== null && !popup.isDisposed__()) {
          list.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
          popup.dispose__();
        }
        var shell: Shell = this.getShell__();
        shell.removeListener__ILorg_eclipse_swt_widgets_Listener_2(27, listener);
        var display_1: Display = this.getDisplay__();
        display_1.removeFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
        popup = null;
        text = null;
        list = null;
        arrow = null;
        _shell = null;
        break;
      case 15 :
        var focusControl: Control = this.getDisplay__().getFocusControl__();
        if (focusControl === arrow || focusControl === list)
          return;
        if (this.isDropped__()) {
          list.setFocus__();
        } else {
          text.setFocus__();
        }
        break;
      case 10 :
        this.dropDown__Z(false);
        break;
      case 11 :
        this.internalLayout__Z(false);
        break;
    }
    return;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var width_1: int = 0;
    var height_1: int = 0;
    var items: JavaArray = list.getItems__();
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [text]));
    var spacer: int = gc.stringExtent__Ljava_lang_String_2(" ").x;
    var textWidth: int = gc.stringExtent__Ljava_lang_String_2(text.getText__()).x;
    for (var i: int = 0; i < items.length; i++) {
      textWidth = Math__.max__II(gc.stringExtent__Ljava_lang_String_2(items[i]).x, textWidth);
    }
    gc.dispose__();
    var textSize: Point = text.computeSize__IIZ(-1, -1, changed);
    var arrowSize: Point = arrow.computeSize__IIZ(-1, -1, changed);
    var listSize: Point = list.computeSize__IIZ(-1, -1, changed);
    var borderWidth: int = this.getBorderWidth__();
    height_1 = Math__.max__II(textSize.y, arrowSize.y);
    width_1 = Math__.max__II(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x);
    if (wHint != -1)
      width_1 = wHint;
    if (hHint != -1)
      height_1 = hHint;
    return new Point(width_1 + 2 * borderWidth, height_1 + 2 * borderWidth);
  }
  public function copy__(): void {
    this.checkWidget__();
    text.copy__();
  }
  public function createPopup___3Ljava_lang_String_2I(items: JavaArray, selectionIndex: int): void {
    popup = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [this.getShell__(), 8 | 16384]));
    var style_1: int = this.getStyle__();
    var listStyle: int = 4 | 512;
    if ((style_1 & 8388608) != 0)
      listStyle |= 8388608;
    if ((style_1 & 67108864) != 0)
      listStyle |= 67108864;
    if ((style_1 & 33554432) != 0)
      listStyle |= 33554432;
    list = new List(popup, listStyle);
    if (font !== null)
      list.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
    if (foreground !== null)
      list.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
    if (background !== null)
      list.setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
    var popupEvents: JavaArray = new JavaArray("[I").values(21, 9, 27);
    for (var i: int = 0; i < popupEvents.length; i++)
      popup.addListener__ILorg_eclipse_swt_widgets_Listener_2(popupEvents[i], listener);
    var listEvents: JavaArray = new JavaArray("[I").values(4, 13, 31, 1, 2, 15, 12);
    for (var i_1: int = 0; i_1 < listEvents.length; i_1++)
      list.addListener__ILorg_eclipse_swt_widgets_Listener_2(listEvents[i_1], listener);
    if (items !== null)
      list.setItems___3Ljava_lang_String_2(items);
    if (selectionIndex != -1)
      list.setSelection__I(selectionIndex);
  }
  public function cut__(): void {
    this.checkWidget__();
    text.cut__();
  }
  public function deselect__I(index: int): void {
    this.checkWidget__();
    if (0 <= index && index < list.getItemCount__() && index == list.getSelectionIndex__() && Object(text.getText__()).equals__Ljava_lang_Object_2(list.getItem__I(index))) {
      text.setText__Ljava_lang_String_2("");
      list.deselect__I(index);
    }
    return;
  }
  public function deselectAll__(): void {
    this.checkWidget__();
    text.setText__Ljava_lang_String_2("");
    list.deselectAll__();
    return;
  }
  public function dropDown__Z(drop: Boolean): void {
    if (drop == this.isDropped__())
      return;
    if (!drop) {
      popup.setVisible__Z(false);
      if (!this.isDisposed__() && this.isFocusControl__()) {
        text.setFocus__();
      }
      return;
    }
    if (!this.isVisible__())
      return;
    if (this.getShell__() !== popup.getParent__()) {
      var items: JavaArray = list.getItems__();
      var selectionIndex: int = list.getSelectionIndex__();
      list.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
      popup.dispose__();
      popup = null;
      list = null;
      this.createPopup___3Ljava_lang_String_2I(items, selectionIndex);
    }
    var size: Point = this.getSize__();
    var itemCount: int = list.getItemCount__();
    itemCount = (itemCount == 0) ? visibleItemCount : Math__.min__II(visibleItemCount, itemCount);
    var itemHeight: int = list.getItemHeight__() * itemCount;
    var listSize: Point = list.computeSize__IIZ(-1, itemHeight, false);
    list.setBounds__IIII(1, 1, Math__.max__II(size.x - 2, listSize.x), listSize.y);
    var index: int = list.getSelectionIndex__();
    if (index != -1)
      list.setTopIndex__I(index);
    var display_1: Display = this.getDisplay__();
    var listRect: Rectangle = list.getBounds__();
    var parentRect: Rectangle = display_1.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_graphics_Rectangle_2(this.getParent__(), null, this.getBounds__());
    var comboSize: Point = this.getSize__();
    var displayRect: Rectangle = this.getMonitor__().getClientArea__();
    var width_1: int = Math__.max__II(comboSize.x, listRect.width + 2);
    var height_1: int = listRect.height + 2;
    var x_1: int = parentRect.x;
    var y_1: int = parentRect.y + comboSize.y;
    if (y_1 + height_1 > displayRect.y + displayRect.height)
      y_1 = parentRect.y - height_1;
    if (x_1 + width_1 > displayRect.x + displayRect.width)
      x_1 = displayRect.x + displayRect.width - listRect.width;
    popup.setBounds__IIII(x_1, y_1, width_1, height_1);
    popup.setVisible__Z(true);
    if (this.isFocusControl__())
      list.setFocus__();
    return;
  }
  public function _findMnemonic__Ljava_lang_String_2(string: String): uint {
    if (string === null)
      return 0;
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while (index < length && Object(string).charAt__I(index) != 38)
        index++;
      if (++index >= length)
        return 0;
      if (Object(string).charAt__I(index) != 38)
        return Character.toLowerCase__C(Object(string).charAt__I(index));
      index++;
    } while (index < length);
    return 0;
  }
  public function getAssociatedLabel__(): Label {
    var siblings: JavaArray = this.getParent__().getChildren__();
    for (var i: int = 0; i < siblings.length; i++) {
      if (siblings[i] === this) {
        if (i > 0 && siblings[i - 1] is Label) {
          return Label(siblings[i - 1]);
        }
      }
    }
    return null;
  }
  public override function getChildren__(): JavaArray {
    this.checkWidget__();
    return new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
  }
  public function getEditable__(): Boolean {
    this.checkWidget__();
    return text.getEditable__();
  }
  public function getItem__I(index: int): String {
    this.checkWidget__();
    return list.getItem__I(index);
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return list.getItemCount__();
  }
  public function getItemHeight__(): int {
    this.checkWidget__();
    return list.getItemHeight__();
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    return list.getItems__();
  }
  public function getListVisible__(): Boolean {
    this.checkWidget__();
    return this.isDropped__();
  }
  public override function getMenu__(): Menu {
    return text.getMenu__();
  }
  public function getSelection__(): Point {
    this.checkWidget__();
    return text.getSelection__();
  }
  public function getSelectionIndex__(): int {
    this.checkWidget__();
    return list.getSelectionIndex__();
  }
  public override function getShell__(): Shell {
    this.checkWidget__();
    var shell: Shell = super.getShell__();
    if (shell !== _shell) {
      if (_shell !== null && !_shell.isDisposed__()) {
        _shell.removeListener__ILorg_eclipse_swt_widgets_Listener_2(27, listener);
      }
      _shell = shell;
    }
    return _shell;
  }
  public override function getStyle__(): int {
    var style_1: int = super.getStyle__();
    style_1 &= ~8;
    if (!text.getEditable__())
      style_1 |= 8;
    return style_1;
  }
  public function getText__(): String {
    this.checkWidget__();
    return text.getText__();
  }
  public function getTextHeight__(): int {
    this.checkWidget__();
    return text.getLineHeight__();
  }
  public function getTextLimit__(): int {
    this.checkWidget__();
    return text.getTextLimit__();
  }
  public function getVisibleItemCount__(): int {
    this.checkWidget__();
    return visibleItemCount;
  }
  public function handleFocus__I(type: int): void {
    switch (type) {
      case 15 :
        {
          if (hasFocus)
            return;
          if (this.getEditable__())
            text.selectAll__();
          hasFocus = true;
          var shell: Shell = this.getShell__();
          shell.removeListener__ILorg_eclipse_swt_widgets_Listener_2(27, listener);
          shell.addListener__ILorg_eclipse_swt_widgets_Listener_2(27, listener);
          var display_1: Display = this.getDisplay__();
          display_1.removeFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
          display_1.addFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
          var e: Event = new Event();
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(15, e);
          break;
        }
      case 16 :
        {
          if (!hasFocus)
            return;
          var focusControl: Control = this.getDisplay__().getFocusControl__();
          if (focusControl === arrow || focusControl === list || focusControl === text)
            return;
          hasFocus = false;
          var shell_1: Shell = this.getShell__();
          shell_1.removeListener__ILorg_eclipse_swt_widgets_Listener_2(27, listener);
          var display_2: Display = this.getDisplay__();
          display_2.removeFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
          var e_1: Event = new Event();
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(16, e_1);
          break;
        }
    }
    return;
  }
  public function indexOf__Ljava_lang_String_2(string: String): int {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    return list.indexOf__Ljava_lang_String_2(string);
  }
  public function indexOf__Ljava_lang_String_2I(string: String, start: int): int {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    return list.indexOf__Ljava_lang_String_2I(string, start);
  }
  public function initAccessible__(): void {
    var accessibleAdapter: AccessibleAdapter = new org.eclipse.swt.custom.CCombo$3(this);
    this.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(accessibleAdapter);
    text.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(accessibleAdapter);
    list.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(accessibleAdapter);
    arrow.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(new org.eclipse.swt.custom.CCombo$4(this));
    this.getAccessible__().addAccessibleTextListener__Lorg_eclipse_swt_accessibility_AccessibleTextListener_2(new org.eclipse.swt.custom.CCombo$5(this));
    this.getAccessible__().addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.CCombo$6(this));
    text.getAccessible__().addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.CCombo$7(this));
    arrow.getAccessible__().addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.CCombo$8(this));
    return;
  }
  public function isDropped__(): Boolean {
    return popup.getVisible__();
  }
  public override function isFocusControl__(): Boolean {
    this.checkWidget__();
    if (text.isFocusControl__() || arrow.isFocusControl__() || list.isFocusControl__() || popup.isFocusControl__()) {
      return true;
    }
    return super.isFocusControl__();
  }
  public function internalLayout__Z(changed: Boolean): void {
    if (this.isDropped__())
      this.dropDown__Z(false);
    var rect: Rectangle = this.getClientArea__();
    var width_1: int = rect.width;
    var height_1: int = rect.height;
    var arrowSize: Point = arrow.computeSize__IIZ(-1, height_1, changed);
    text.setBounds__IIII(0, 0, width_1 - arrowSize.x, height_1);
    arrow.setBounds__IIII(width_1 - arrowSize.x, 0, arrowSize.x, arrowSize.y);
  }
  public function listEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.type) {
      case 12 :
        if (this.getShell__() !== popup.getParent__()) {
          var items: JavaArray = list.getItems__();
          var selectionIndex: int = list.getSelectionIndex__();
          popup = null;
          list = null;
          this.createPopup___3Ljava_lang_String_2I(items, selectionIndex);
        }
        break;
      case 15 :
        {
          this.handleFocus__I(15);
          break;
        }
      case 4 :
        {
          if (event.button != 1)
            return;
          this.dropDown__Z(false);
          break;
        }
      case 13 :
        {
          var index: int = list.getSelectionIndex__();
          if (index == -1)
            return;
          text.setText__Ljava_lang_String_2(list.getItem__I(index));
          text.selectAll__();
          list.setSelection__I(index);
          var e: Event = new Event();
          e.time = event.time;
          e.stateMask = event.stateMask;
          e.doit = event.doit;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, e);
          event.doit = e.doit;
          break;
        }
      case 31 :
        {
          switch (event.detail) {
            case 4 :
            case 2 :
            case 32 :
            case 64 :
              event.doit = false;
              break;
            case 16 :
            case 8 :
              event.doit = text.traverse__I(event.detail);
              event.detail = 0;
              if (event.doit)
                this.dropDown__Z(false);
              return;
          }
          var e_1: Event = new Event();
          e_1.time = event.time;
          e_1.detail = event.detail;
          e_1.doit = event.doit;
          e_1.character = event.character;
          e_1.keyCode = event.keyCode;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(31, e_1);
          event.doit = e_1.doit;
          event.detail = e_1.detail;
          break;
        }
      case 2 :
        {
          var e_2: Event = new Event();
          e_2.time = event.time;
          e_2.character = event.character;
          e_2.keyCode = event.keyCode;
          e_2.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(2, e_2);
          break;
        }
      case 1 :
        {
          if (event.character == 27) {
            this.dropDown__Z(false);
          }
          if ((event.stateMask & 65536) != 0 && (event.keyCode == 16777217 || event.keyCode == 16777218)) {
            this.dropDown__Z(false);
          }
          if (event.character == 13) {
            this.dropDown__Z(false);
            var e_3: Event = new Event();
            e_3.time = event.time;
            e_3.stateMask = event.stateMask;
            this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(14, e_3);
          }
          if (this.isDisposed__())
            break;
          var e_4: Event = new Event();
          e_4.time = event.time;
          e_4.character = event.character;
          e_4.keyCode = event.keyCode;
          e_4.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(1, e_4);
          break;
        }
    }
    return;
  }
  public function paste__(): void {
    this.checkWidget__();
    text.paste__();
    return;
  }
  public function popupEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.type) {
      case 9 :
        var listRect: Rectangle = list.getBounds__();
        var black: Color = this.getDisplay__().getSystemColor__I(2);
        event.gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(black);
        event.gc.drawRectangle__IIII(0, 0, listRect.width + 1, listRect.height + 1);
        break;
      case 21 :
        event.doit = false;
        this.dropDown__Z(false);
        break;
      case 27 :
        if (!Object("carbon").equals__Ljava_lang_Object_2(SWT.getPlatform__())) {
          var point: Point = arrow.toControl__Lorg_eclipse_swt_graphics_Point_2(this.getDisplay__().getCursorLocation__());
          var size: Point = arrow.getSize__();
          var rect: Rectangle = new Rectangle(0, 0, size.x, size.y);
          if (!rect.contains__Lorg_eclipse_swt_graphics_Point_2(point))
            this.dropDown__Z(false);
        } else {
          this.dropDown__Z(false);
        }
        break;
    }
    return;
  }
  public override function redraw__(): void {
    super.redraw__();
    text.redraw__();
    arrow.redraw__();
    if (popup.isVisible__())
      list.redraw__();
    return;
  }
  public override function redraw__IIIIZ(x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    super.redraw__IIIIZ(x_1, y_1, width_1, height_1, true);
    return;
  }
  public function remove__I(index: int): void {
    this.checkWidget__();
    list.remove__I(index);
    return;
  }
  public function remove__II(start: int, end: int): void {
    this.checkWidget__();
    list.remove__II(start, end);
    return;
  }
  public function remove__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    list.remove__Ljava_lang_String_2(string);
    return;
  }
  public function removeAll__(): void {
    this.checkWidget__();
    text.setText__Ljava_lang_String_2("");
    list.removeAll__();
    return;
  }
  public function removeModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener_1: ModifyListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(24, listener_1);
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener_1);
    return;
  }
  public function removeVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener_1: VerifyListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(25, listener_1);
    return;
  }
  public function select__I(index: int): void {
    this.checkWidget__();
    if (index == -1) {
      list.deselectAll__();
      text.setText__Ljava_lang_String_2("");
      return;
    }
    if (0 <= index && index < list.getItemCount__()) {
      if (index != this.getSelectionIndex__()) {
        text.setText__Ljava_lang_String_2(list.getItem__I(index));
        text.selectAll__();
        list.select__I(index);
        list.showSelection__();
      }
    }
    return;
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    background = color;
    if (text !== null)
      text.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (list !== null)
      list.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (arrow !== null)
      arrow.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    return;
  }
  public function setEditable__Z(editable: Boolean): void {
    this.checkWidget__();
    text.setEditable__Z(editable);
    return;
  }
  public override function setEnabled__Z(enabled: Boolean): void {
    super.setEnabled__Z(enabled);
    if (popup !== null)
      popup.setVisible__Z(false);
    if (text !== null)
      text.setEnabled__Z(enabled);
    if (arrow !== null)
      arrow.setEnabled__Z(enabled);
    return;
  }
  public override function setFocus__(): Boolean {
    this.checkWidget__();
    if (!this.isEnabled__() || !this.isVisible__())
      return false;
    if (this.isFocusControl__())
      return true;
    return text.setFocus__();
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    this.font = font_1;
    text.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    list.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    this.internalLayout__Z(true);
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    foreground = color;
    if (text !== null)
      text.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (list !== null)
      list.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (arrow !== null)
      arrow.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
  }
  public function setItem__ILjava_lang_String_2(index: int, string: String): void {
    this.checkWidget__();
    list.setItem__ILjava_lang_String_2(index, string);
  }
  public function setItems___3Ljava_lang_String_2(items: JavaArray): void {
    this.checkWidget__();
    list.setItems___3Ljava_lang_String_2(items);
    if (!text.getEditable__())
      text.setText__Ljava_lang_String_2("");
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setListVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    this.dropDown__Z(visible);
  }
  public override function setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1: Menu): void {
    text.setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1);
  }
  public function setSelection__Lorg_eclipse_swt_graphics_Point_2(selection: Point): void {
    this.checkWidget__();
    if (selection === null)
      SWT.error__I(4);
    text.setSelection__II(selection.x, selection.y);
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    var index: int = list.indexOf__Ljava_lang_String_2(string);
    if (index == -1) {
      list.deselectAll__();
      text.setText__Ljava_lang_String_2(string);
      return;
    }
    text.setText__Ljava_lang_String_2(string);
    text.selectAll__();
    list.setSelection__I(index);
    list.showSelection__();
    return;
  }
  public function setTextLimit__I(limit: int): void {
    this.checkWidget__();
    text.setTextLimit__I(limit);
    return;
  }
  public override function setToolTipText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    super.setToolTipText__Ljava_lang_String_2(string);
    arrow.setToolTipText__Ljava_lang_String_2(string);
    text.setToolTipText__Ljava_lang_String_2(string);
    return;
  }
  public override function setVisible__Z(visible: Boolean): void {
    super.setVisible__Z(visible);
    if (this.isDisposed__())
      return;
    if (popup === null || popup.isDisposed__())
      return;
    if (!visible)
      popup.setVisible__Z(false);
  }
  public function setVisibleItemCount__I(count: int): void {
    this.checkWidget__();
    if (count < 0)
      return;
    visibleItemCount = count;
  }
  public function stripMnemonic__Ljava_lang_String_2(string: String): String {
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while ((index < length) && (Object(string).charAt__I(index) != 38))
        index++;
      if (++index >= length)
        return string;
      if (Object(string).charAt__I(index) != 38) {
        return Object(string).substring__II(0, index - 1) + Object(string).substring__II(index, length);
      }
      index++;
    } while (index < length);
    return string;
  }
  public function textEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.type) {
      case 15 :
        {
          this.handleFocus__I(15);
          break;
        }
      case 14 :
        {
          this.dropDown__Z(false);
          var e: Event = new Event();
          e.time = event.time;
          e.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(14, e);
          break;
        }
      case 1 :
        {
          var keyEvent: Event = new Event();
          keyEvent.time = event.time;
          keyEvent.character = event.character;
          keyEvent.keyCode = event.keyCode;
          keyEvent.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(1, keyEvent);
          if (this.isDisposed__())
            break;
          event.doit = keyEvent.doit;
          if (!event.doit)
            break;
          if (event.keyCode == 16777217 || event.keyCode == 16777218) {
            event.doit = false;
            if ((event.stateMask & 65536) != 0) {
              var dropped: Boolean = this.isDropped__();
              text.selectAll__();
              if (!dropped)
                this.setFocus__();
              this.dropDown__Z(!dropped);
              break;
            }
            var oldIndex: int = this.getSelectionIndex__();
            if (event.keyCode == 16777217) {
              this.select__I(Math__.max__II(oldIndex - 1, 0));
            } else {
              this.select__I(Math__.min__II(oldIndex + 1, this.getItemCount__() - 1));
            }
            if (oldIndex != this.getSelectionIndex__()) {
              var e_1: Event = new Event();
              e_1.time = event.time;
              e_1.stateMask = event.stateMask;
              this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, e_1);
            }
            if (this.isDisposed__())
              break;
          }
          break;
        }
      case 2 :
        {
          var e_2: Event = new Event();
          e_2.time = event.time;
          e_2.character = event.character;
          e_2.keyCode = event.keyCode;
          e_2.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(2, e_2);
          event.doit = e_2.doit;
          break;
        }
      case 35 :
        {
          var e_3: Event = new Event();
          e_3.time = event.time;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(35, e_3);
          break;
        }
      case 24 :
        {
          list.deselectAll__();
          var e_4: Event = new Event();
          e_4.time = event.time;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(24, e_4);
          break;
        }
      case 3 :
        {
          var mouseEvent: Event = new Event();
          mouseEvent.button = event.button;
          mouseEvent.count = event.count;
          mouseEvent.stateMask = event.stateMask;
          mouseEvent.time = event.time;
          mouseEvent.x = event.x;
          mouseEvent.y = event.y;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3, mouseEvent);
          if (this.isDisposed__())
            break;
          event.doit = mouseEvent.doit;
          if (!event.doit)
            break;
          if (event.button != 1)
            return;
          if (text.getEditable__())
            return;
          var dropped_1: Boolean = this.isDropped__();
          text.selectAll__();
          if (!dropped_1)
            this.setFocus__();
          this.dropDown__Z(!dropped_1);
          break;
        }
      case 4 :
        {
          var mouseEvent_1: Event = new Event();
          mouseEvent_1.button = event.button;
          mouseEvent_1.count = event.count;
          mouseEvent_1.stateMask = event.stateMask;
          mouseEvent_1.time = event.time;
          mouseEvent_1.x = event.x;
          mouseEvent_1.y = event.y;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(4, mouseEvent_1);
          if (this.isDisposed__())
            break;
          event.doit = mouseEvent_1.doit;
          if (!event.doit)
            break;
          if (event.button != 1)
            return;
          if (text.getEditable__())
            return;
          text.selectAll__();
          break;
        }
      case 8 :
        {
          var mouseEvent_2: Event = new Event();
          mouseEvent_2.button = event.button;
          mouseEvent_2.count = event.count;
          mouseEvent_2.stateMask = event.stateMask;
          mouseEvent_2.time = event.time;
          mouseEvent_2.x = event.x;
          mouseEvent_2.y = event.y;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(8, mouseEvent_2);
          break;
        }
      case 37 :
        {
          var keyEvent_1: Event = new Event();
          keyEvent_1.time = event.time;
          keyEvent_1.keyCode = event.count > 0 ? 16777217 : 16777218;
          keyEvent_1.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(1, keyEvent_1);
          if (this.isDisposed__())
            break;
          event.doit = keyEvent_1.doit;
          if (!event.doit)
            break;
          if (event.count != 0) {
            event.doit = false;
            var oldIndex_1: int = this.getSelectionIndex__();
            if (event.count > 0) {
              this.select__I(Math__.max__II(oldIndex_1 - 1, 0));
            } else {
              this.select__I(Math__.min__II(oldIndex_1 + 1, this.getItemCount__() - 1));
            }
            if (oldIndex_1 != this.getSelectionIndex__()) {
              var e_5: Event = new Event();
              e_5.time = event.time;
              e_5.stateMask = event.stateMask;
              this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, e_5);
            }
            if (this.isDisposed__())
              break;
          }
          break;
        }
      case 31 :
        {
          switch (event.detail) {
            case 32 :
            case 64 :
              event.doit = false;
              break;
            case 8 :
              event.doit = this.traverse__I(8);
              event.detail = 0;
              return;
          }
          var e_6: Event = new Event();
          e_6.time = event.time;
          e_6.detail = event.detail;
          e_6.doit = event.doit;
          e_6.character = event.character;
          e_6.keyCode = event.keyCode;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(31, e_6);
          event.doit = e_6.doit;
          event.detail = e_6.detail;
          break;
        }
      case 25 :
        {
          var e_7: Event = new Event();
          e_7.text = event.text;
          e_7.start = event.start;
          e_7.end = event.end;
          e_7.character = event.character;
          e_7.keyCode = event.keyCode;
          e_7.stateMask = event.stateMask;
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(25, e_7);
          event.doit = e_7.doit;
          break;
        }
    }
    return;
  }
}
}
