package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.GC;
import java.lang.Character;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CLabel extends Canvas {
  public static const GAP: int = 5;
  public static const INDENT: int = 3;
  public static const ELLIPSIS: String = "...";
  private var align: int = 16384;
  private var hIndent: int = 3;
  private var vIndent: int = 3;
  private var text: String;
  private var image: Image;
  private var appToolTipText: String;
  private var backgroundImage: Image;
  private var gradientColors: JavaArray;
  private var gradientPercents: JavaArray;
  private var gradientVertical: Boolean;
  private var background: Color;
  private var disposeListener: Listener;
  public static var DRAW_FLAGS: int = 8 | 4 | 1 | 2;
  public function CLabel(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [parent, CLabel.checkStyle__I(style)]));
    if ((style & (16777216 | 131072)) == 0)
      style |= 16384;
    if ((style & 16777216) != 0)
      align = 16777216;
    if ((style & 131072) != 0)
      align = 131072;
    if ((style & 16384) != 0)
      align = 16384;
    this.addPaintListener__Lorg_eclipse_swt_events_PaintListener_2(new org.eclipse.swt.custom.CLabel$1(this));
    this.addTraverseListener__Lorg_eclipse_swt_events_TraverseListener_2(new org.eclipse.swt.custom.CLabel$2(this));
    disposeListener = new org.eclipse.swt.custom.CLabel$3(this);
    this.initAccessible__();
    return;
  }
  private static function checkStyle__I(style: int): int {
    if ((style & 2048) != 0)
      style |= 4;
    var mask: int = 4 | 8 | 32 | 33554432 | 67108864;
    style = style & mask;
    return style |= 524288 | 536870912;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var e: Point = this.getTotalSize__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2(image, text);
    if (wHint == -1) {
      e.x += 2 * hIndent;
    } else {
      e.x = wHint;
    }
    if (hHint == -1) {
      e.y += 2 * vIndent;
    } else {
      e.y = hHint;
    }
    return e;
  }
  private function drawBevelRect__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc: GC, x_1: int, y_1: int, w: int, h: int, topleft: Color, bottomright: Color): void {
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(bottomright);
    gc.drawLine__IIII(x_1 + w, y_1, x_1 + w, y_1 + h);
    gc.drawLine__IIII(x_1, y_1 + h, x_1 + w, y_1 + h);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(topleft);
    gc.drawLine__IIII(x_1, y_1, x_1 + w - 1, y_1);
    gc.drawLine__IIII(x_1, y_1, x_1, y_1 + h - 1);
  }
  public function _findMnemonic__Ljava_lang_String_2(string: String): uint {
    if (string === null)
      return 0;
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while (index < length && Object(string).charAt__I(index) != 38)
        index++;
      if (++index >= length)
        return 0;
      if (Object(string).charAt__I(index) != 38)
        return Character.toLowerCase__C(Object(string).charAt__I(index));
      index++;
    } while (index < length);
    return 0;
  }
  public function getAlignment__(): int {
    return align;
  }
  public function getImage__(): Image {
    return image;
  }
  private function getTotalSize__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2(image_1: Image, text_1: String): Point {
    var size: Point = new Point(0, 0);
    if (image_1 !== null) {
      var r: Rectangle = image_1.getBounds__();
      size.x += r.width;
      size.y += r.height;
    }
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
    if (text_1 !== null && Object(text_1).length__() > 0) {
      var e: Point = gc.textExtent__Ljava_lang_String_2I(text_1, DRAW_FLAGS);
      size.x += e.x;
      size.y = Math__.max__II(size.y, e.y);
      if (image_1 !== null)
        size.x += 5;
    } else {
      size.y = Math__.max__II(size.y, gc.getFontMetrics__().getHeight__());
    }
    gc.dispose__();
    return size;
  }
  public override function getStyle__(): int {
    var style_1: int = super.getStyle__();
    switch (align) {
      case 131072 :
        style_1 |= 131072;
        break;
      case 16777216 :
        style_1 |= 16777216;
        break;
      case 16384 :
        style_1 |= 16384;
        break;
    }
    return style_1;
  }
  public function getText__(): String {
    return text;
  }
  public override function getToolTipText__(): String {
    this.checkWidget__();
    return appToolTipText;
  }
  private function initAccessible__(): void {
    var accessible_1: Accessible = this.getAccessible__();
    accessible_1.addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(new org.eclipse.swt.custom.CLabel$4(this));
    accessible_1.addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.CLabel$5(this));
    return;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeListener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    gradientColors = null;
    gradientPercents = null;
    backgroundImage = null;
    text = null;
    image = null;
    appToolTipText = null;
    return;
  }
  public function onMnemonic__Lorg_eclipse_swt_events_TraverseEvent_2(event: TraverseEvent): void {
    var mnemonic: uint = this._findMnemonic__Ljava_lang_String_2(text);
    if (mnemonic == 0)
      return;
    if (Character.toLowerCase__C(event.character) != mnemonic)
      return;
    var control: Composite = this.getParent__();
    while (control !== null) {
      var children_1: JavaArray = control.getChildren__();
      var index: int = 0;
      while (index < children_1.length) {
        if (children_1[index] === this)
          break;
        index++;
      }
      index++;
      if (index < children_1.length) {
        if (children_1[index].setFocus__()) {
          event.doit = true;
          event.detail = 0;
        }
      }
      control = control.getParent__();
    }
    return;
  }
  public function onPaint__Lorg_eclipse_swt_events_PaintEvent_2(event: PaintEvent): void {
    var rect: Rectangle = this.getClientArea__();
    if (rect.width == 0 || rect.height == 0)
      return;
    var shortenText: Boolean = false;
    var t: String = text;
    var img: Image = image;
    var availableWidth: int = Math__.max__II(0, rect.width - 2 * hIndent);
    var extent: Point = this.getTotalSize__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2(img, t);
    if (extent.x > availableWidth) {
      img = null;
      extent = this.getTotalSize__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2(img, t);
      if (extent.x > availableWidth) {
        shortenText = true;
      }
    }
    var gc: GC = event.gc;
    var lines: JavaArray = text === null ? null : this.splitString__Ljava_lang_String_2(text);
    if (shortenText) {
      extent.x = 0;
      for (var i: int = 0; i < lines.length; i++) {
        var e: Point = gc.textExtent__Ljava_lang_String_2I(lines[i], DRAW_FLAGS);
        if (e.x > availableWidth) {
          lines[i] = this.shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2I(gc, lines[i], availableWidth);
          extent.x = Math__.max__II(extent.x, this.getTotalSize__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2(null, lines[i]).x);
        } else {
          extent.x = Math__.max__II(extent.x, e.x);
        }
      }
      if (appToolTipText === null) {
        super.setToolTipText__Ljava_lang_String_2(text);
      }
    } else {
      super.setToolTipText__Ljava_lang_String_2(appToolTipText);
    }
    var x_1: int = rect.x + hIndent;
    if (align == 16777216) {
      x_1 = int((rect.width - extent.x) / 2);
    }
    if (align == 131072) {
      x_1 = rect.width - hIndent - extent.x;
    }
    try {
      if (backgroundImage !== null) {
        var imageRect: Rectangle = backgroundImage.getBounds__();
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
        gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
        var xPos: int = 0;
        while (xPos < rect.width) {
          var yPos: int = 0;
          while (yPos < rect.height) {
            gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(backgroundImage, xPos, yPos);
            yPos += imageRect.height;
          }
          xPos += imageRect.width;
        }
      } else if (gradientColors !== null) {
        var oldBackground: Color = gc.getBackground__();
        if (gradientColors.length == 1) {
          if (gradientColors[0] !== null)
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(gradientColors[0]);
          gc.fillRectangle__IIII(0, 0, rect.width, rect.height);
        } else {
          var oldForeground: Color = gc.getForeground__();
          var lastColor: Color = gradientColors[0];
          if (lastColor === null)
            lastColor = oldBackground;
          var pos: int = 0;
          for (var i_1: int = 0; i_1 < gradientPercents.length; ++i_1) {
            gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(lastColor);
            lastColor = gradientColors[i_1 + 1];
            if (lastColor === null)
              lastColor = oldBackground;
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(lastColor);
            if (gradientVertical) {
              var gradientHeight: int = (int(gradientPercents[i_1] * rect.height / 100)) - pos;
              gc.fillGradientRectangle__IIIIZ(0, pos, rect.width, gradientHeight, true);
              pos += gradientHeight;
            } else {
              var gradientWidth: int = (int(gradientPercents[i_1] * rect.width / 100)) - pos;
              gc.fillGradientRectangle__IIIIZ(pos, 0, gradientWidth, rect.height, false);
              pos += gradientWidth;
            }
          }
          if (gradientVertical && pos < rect.height) {
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
            gc.fillRectangle__IIII(0, pos, rect.width, rect.height - pos);
          }
          if (!gradientVertical && pos < rect.width) {
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
            gc.fillRectangle__IIII(pos, 0, rect.width - pos, rect.height);
          }
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(oldForeground);
        }
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(oldBackground);
      } else {
        if (background !== null || (this.getStyle__() & 536870912) == 0) {
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
          gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
        }
      }
    } catch (e_1 : SWTException) {
      if ((this.getStyle__() & 536870912) == 0) {
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
        gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
      }
    }
    var style_1: int = this.getStyle__();
    if ((style_1 & 4) != 0 || (style_1 & 8) != 0) {
      this.paintBorder__Lorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Rectangle_2(gc, rect);
    }
    if (img !== null) {
      var imageRect_1: Rectangle = img.getBounds__();
      gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(img, 0, 0, imageRect_1.width, imageRect_1.height, x_1, int((rect.height - imageRect_1.height) / 2), imageRect_1.width, imageRect_1.height);
      x_1 += imageRect_1.width + 5;
      extent.x -= imageRect_1.width + 5;
    }
    if (lines !== null) {
      var lineHeight: int = gc.getFontMetrics__().getHeight__();
      var textHeight: int = lines.length * lineHeight;
      var lineY: int = Math__.max__II(vIndent, rect.y + int((rect.height - textHeight) / 2));
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getForeground__());
      for (var i_2: int = 0; i_2 < lines.length; i_2++) {
        var lineX: int = x_1;
        if (lines.length > 1) {
          if (align == 16777216) {
            var lineWidth: int = gc.textExtent__Ljava_lang_String_2I(lines[i_2], DRAW_FLAGS).x;
            lineX = x_1 + Math__.max__II(0, int((extent.x - lineWidth) / 2));
          }
          if (align == 131072) {
            var lineWidth_1: int = gc.textExtent__Ljava_lang_String_2I(lines[i_2], DRAW_FLAGS).x;
            lineX = Math__.max__II(x_1, rect.x + rect.width - hIndent - lineWidth_1);
          }
        }
        gc.drawText__Ljava_lang_String_2III(lines[i_2], lineX, lineY, DRAW_FLAGS);
        lineY += lineHeight;
      }
    }
    return;
  }
  private function paintBorder__Lorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Rectangle_2(gc: GC, r: Rectangle): void {
    var disp: Display = this.getDisplay__();
    var c1: Color = null;
    var c2: Color = null;
    var style_1: int = this.getStyle__();
    if ((style_1 & 4) != 0) {
      c1 = disp.getSystemColor__I(18);
      c2 = disp.getSystemColor__I(20);
    }
    if ((style_1 & 8) != 0) {
      c1 = disp.getSystemColor__I(19);
      c2 = disp.getSystemColor__I(18);
    }
    if (c1 !== null && c2 !== null) {
      gc.setLineWidth__I(1);
      this.drawBevelRect__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
    }
    return;
  }
  public function setAlignment__I(align_1: int): void {
    this.checkWidget__();
    if (align_1 != 16384 && align_1 != 131072 && align_1 != 16777216) {
      SWT.error__I(5);
    }
    if (this.align != align_1) {
      this.align = align_1;
      this.redraw__();
    }
    return;
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (backgroundImage === null && gradientColors === null && gradientPercents === null) {
      if (color === null) {
        if (background === null)
          return;
      } else {
        if (color.equals__Ljava_lang_Object_2(background))
          return;
      }
    }
    background = color;
    backgroundImage = null;
    gradientColors = null;
    gradientPercents = null;
    this.redraw__();
    return;
  }
  public function setBackground___3Lorg_eclipse_swt_graphics_Color_2_3I(colors: JavaArray, percents: JavaArray): void {
    this.setBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors, percents, false);
    return;
  }
  public function setBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors: JavaArray, percents: JavaArray, vertical: Boolean): void {
    this.checkWidget__();
    if (colors !== null) {
      if (percents === null || percents.length != colors.length - 1) {
        SWT.error__I(5);
      }
      if (this.getDisplay__().getDepth__() < 15) {
        colors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(colors[colors.length - 1]);
        percents = new JavaArray("[I").lengths();
      }
      for (var i: int = 0; i < percents.length; i++) {
        if (percents[i] < 0 || percents[i] > 100) {
          SWT.error__I(5);
        }
        if (i > 0 && percents[i] < percents[i - 1]) {
          SWT.error__I(5);
        }
      }
    }
    var background_1: Color = this.getBackground__();
    if (backgroundImage === null) {
      if ((gradientColors !== null) && (colors !== null) && (gradientColors.length == colors.length)) {
        var same: Boolean = false;
        for (var i_1: int = 0; i_1 < gradientColors.length; i_1++) {
          same = (gradientColors[i_1] === colors[i_1]) || ((gradientColors[i_1] === null) && (colors[i_1] === background_1)) || ((gradientColors[i_1] === background_1) && (colors[i_1] === null));
          if (!same)
            break;
        }
        if (same) {
          for (var i_2: int = 0; i_2 < gradientPercents.length; i_2++) {
            same = gradientPercents[i_2] == percents[i_2];
            if (!same)
              break;
          }
        }
        if (same && this.gradientVertical == vertical)
          return;
      }
    } else {
      backgroundImage = null;
    }
    if (colors === null) {
      gradientColors = null;
      gradientPercents = null;
      gradientVertical = false;
    } else {
      gradientColors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").lengths(colors.length);
      for (var i_3: int = 0; i_3 < colors.length; ++i_3)
        gradientColors[i_3] = (colors[i_3] !== null) ? colors[i_3] : background_1;
      gradientPercents = new JavaArray("[I").lengths(percents.length);
      for (var i_4: int = 0; i_4 < percents.length; ++i_4)
        gradientPercents[i_4] = percents[i_4];
      gradientVertical = vertical;
    }
    this.redraw__();
    return;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 === backgroundImage)
      return;
    if (image_1 !== null) {
      gradientColors = null;
      gradientPercents = null;
    }
    backgroundImage = image_1;
    this.redraw__();
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    this.redraw__();
    return;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== this.image) {
      this.image = image_1;
      this.redraw__();
    }
    return;
  }
  public function setText__Ljava_lang_String_2(text_1: String): void {
    this.checkWidget__();
    if (text_1 === null)
      text_1 = "";
    if (!Object(text_1).equals__Ljava_lang_Object_2(this.text)) {
      this.text = text_1;
      this.redraw__();
    }
    return;
  }
  public override function setToolTipText__Ljava_lang_String_2(string: String): void {
    super.setToolTipText__Ljava_lang_String_2(string);
    appToolTipText = super.getToolTipText__();
    return;
  }
  public function shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2I(gc: GC, t: String, width_1: int): String {
    if (t === null)
      return null;
    var w: int = gc.textExtent__Ljava_lang_String_2I("...", DRAW_FLAGS).x;
    if (width_1 <= w)
      return t;
    var l: int = Object(t).length__();
    var max: int = int(l / 2);
    var min: int = 0;
    var mid: int = int((max + min) / 2) - 1;
    if (mid <= 0)
      return t;
    var layout_1: TextLayout = new TextLayout(this.getDisplay__());
    layout_1.setText__Ljava_lang_String_2(t);
    mid = this.validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, mid);
    while (min < mid && mid < max) {
      var s1: String = Object(t).substring__II(0, mid);
      var s2: String = Object(t).substring__II(this.validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, l - mid), l);
      var l1: int = gc.textExtent__Ljava_lang_String_2I(s1, DRAW_FLAGS).x;
      var l2: int = gc.textExtent__Ljava_lang_String_2I(s2, DRAW_FLAGS).x;
      if (l1 + w + l2 > width_1) {
        max = mid;
        mid = this.validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, int((max + min) / 2));
      } else if (l1 + w + l2 < width_1) {
        min = mid;
        mid = this.validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, int((max + min) / 2));
      } else {
        min = max;
      }
    }
    var result: String = mid == 0 ? t : Object(t).substring__II(0, mid) + "..." + Object(t).substring__II(this.validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, l - mid), l);
    layout_1.dispose__();
    return result;
  }
  public function validateOffset__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1: TextLayout, offset: int): int {
    var nextOffset: int = layout_1.getNextOffset__II(offset, 2);
    if (nextOffset != offset)
      return layout_1.getPreviousOffset__II(nextOffset, 2);
    return offset;
  }
  private function splitString__Ljava_lang_String_2(text_1: String): JavaArray {
    var lines: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(1);
    var start: int = 0;
    var pos: int;
    do {
      pos = Object(text_1).indexOf__II(10, start);
      if (pos == -1) {
        lines[lines.length - 1] = Object(text_1).substring__I(start);
      } else {
        var crlf: Boolean = (pos > 0) && (Object(text_1).charAt__I(pos - 1) == 13);
        lines[lines.length - 1] = Object(text_1).substring__II(start, pos - (crlf ? 1 : 0));
        start = pos + 1;
        var newLines: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(lines.length + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines, 0, newLines, 0, lines.length);
        lines = newLines;
      }
    } while (pos != -1);
    return lines;
  }
  public static function access$0(arg0: CLabel): String {
    return arg0.text;
  }
}
}
