package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Region;
import java.lang.System;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TypedListener;
import java.lang.Math__;
import org.eclipse.swt.graphics.FontData;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import java.lang.Integer;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabFolder$2 extends AccessibleAdapter {
  private var this$0: CTabFolder;
  public function CTabFolder$2(this$0: CTabFolder) {
    this.this$0 = this$0;
    return;
  }
  public override function getName__Lorg_eclipse_swt_accessibility_AccessibleEvent_2(e: AccessibleEvent): void {
    var name: String = null;
    var childID: int = e.childID;
    if (childID >= 0 && childID < this$0.items.length) {
      name = this$0.stripMnemonic__Ljava_lang_String_2(this$0.items[childID].getText__());
    } else if (childID == this$0.items.length + 0) {
      name = SWT.getMessage__Ljava_lang_String_2("SWT_ShowList");
    } else if (childID == this$0.items.length + 1) {
      name = this$0.minimized ? SWT.getMessage__Ljava_lang_String_2("SWT_Restore") : SWT.getMessage__Ljava_lang_String_2("SWT_Minimize");
    } else if (childID == this$0.items.length + 2) {
      name = this$0.maximized ? SWT.getMessage__Ljava_lang_String_2("SWT_Restore") : SWT.getMessage__Ljava_lang_String_2("SWT_Maximize");
    }
    e.result = name;
    return;
  }
  public override function getHelp__Lorg_eclipse_swt_accessibility_AccessibleEvent_2(e: AccessibleEvent): void {
    var help: String = null;
    var childID: int = e.childID;
    if (childID == -1) {
      help = this$0.getToolTipText__();
    } else if (childID >= 0 && childID < this$0.items.length) {
      help = this$0.items[childID].getToolTipText__();
    }
    e.result = help;
    return;
  }
  public override function getKeyboardShortcut__Lorg_eclipse_swt_accessibility_AccessibleEvent_2(e: AccessibleEvent): void {
    var shortcut: String = null;
    var childID: int = e.childID;
    if (childID >= 0 && childID < this$0.items.length) {
      var text: String = this$0.items[childID].getText__();
      if (text !== null) {
        var mnemonic: uint = this$0._findMnemonic__Ljava_lang_String_2(text);
        if (mnemonic != 0) {
          shortcut = "Alt+" + String.fromCharCode(mnemonic);
        }
      }
    }
    e.result = shortcut;
    return;
  }
}
}
