package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Region;
import java.lang.System;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TypedListener;
import java.lang.Math__;
import org.eclipse.swt.graphics.FontData;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import java.lang.Integer;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabFolder$3 extends AccessibleControlAdapter {
  private var this$0: CTabFolder;
  public function CTabFolder$3(this$0: CTabFolder) {
    this.this$0 = this$0;
    return;
  }
  public override function getChildAtPoint__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var testPoint: Point = this$0.toControl__II(e.x, e.y);
    var childID: int = -2;
    for (var i: int = 0; i < this$0.items.length; i++) {
      if (this$0.items[i].getBounds__().contains__Lorg_eclipse_swt_graphics_Point_2(testPoint)) {
        childID = i;
        break;
      }
    }
    if (childID == -2) {
      if (this$0.showChevron && this$0.chevronRect.contains__Lorg_eclipse_swt_graphics_Point_2(testPoint)) {
        childID = this$0.items.length + 0;
      } else if (this$0.showMin && this$0.minRect.contains__Lorg_eclipse_swt_graphics_Point_2(testPoint)) {
        childID = this$0.items.length + 1;
      } else if (this$0.showMax && this$0.maxRect.contains__Lorg_eclipse_swt_graphics_Point_2(testPoint)) {
        childID = this$0.items.length + 2;
      } else {
        var location: Rectangle = this$0.getBounds__();
        location.height = location.height - this$0.getClientArea__().height;
        if (location.contains__Lorg_eclipse_swt_graphics_Point_2(testPoint)) {
          childID = -1;
        }
      }
    }
    e.childID = childID;
    return;
  }
  public override function getLocation__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var location: Rectangle = null;
    var pt: Point = null;
    var childID: int = e.childID;
    if (childID == -1) {
      location = this$0.getBounds__();
      pt = this$0.getParent__().toDisplay__II(location.x, location.y);
    } else {
      if (childID >= 0 && childID < this$0.items.length && this$0.items[childID].isShowing__()) {
        location = this$0.items[childID].getBounds__();
      } else if (this$0.showChevron && childID == this$0.items.length + 0) {
        location = this$0.chevronRect;
      } else if (this$0.showMin && childID == this$0.items.length + 1) {
        location = this$0.minRect;
      } else if (this$0.showMax && childID == this$0.items.length + 2) {
        location = this$0.maxRect;
      }
      if (location !== null) {
        pt = this$0.toDisplay__II(location.x, location.y);
      }
    }
    if (location !== null && pt !== null) {
      e.x = pt.x;
      e.y = pt.y;
      e.width = location.width;
      e.height = location.height;
    }
    return;
  }
  public override function getChildCount__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    e.detail = this$0.items.length + 3;
    return;
  }
  public override function getDefaultAction__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var action: String = null;
    var childID: int = e.childID;
    if (childID >= 0 && childID < this$0.items.length) {
      action = SWT.getMessage__Ljava_lang_String_2("SWT_Switch");
    }
    if (childID >= this$0.items.length && childID < this$0.items.length + 3) {
      action = SWT.getMessage__Ljava_lang_String_2("SWT_Press");
    }
    e.result = action;
    return;
  }
  public override function getFocus__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var childID: int = -2;
    if (this$0.isFocusControl__()) {
      if (this$0.selectedIndex == -1) {
        childID = -1;
      } else {
        childID = this$0.selectedIndex;
      }
    }
    e.childID = childID;
    return;
  }
  public override function getRole__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var role: int = 0;
    var childID: int = e.childID;
    if (childID == -1) {
      role = 60;
    } else if (childID >= 0 && childID < this$0.items.length) {
      role = 37;
    } else if (childID >= this$0.items.length && childID < this$0.items.length + 3) {
      role = 43;
    }
    e.detail = role;
    return;
  }
  public override function getSelection__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    e.childID = (this$0.selectedIndex == -1) ? -2 : this$0.selectedIndex;
    return;
  }
  public override function getState__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var state: int = 0;
    var childID: int = e.childID;
    if (childID == -1) {
      state = 0;
    } else if (childID >= 0 && childID < this$0.items.length) {
      state = 2097152;
      if (this$0.isFocusControl__()) {
        state |= 1048576;
      }
      if (this$0.selectedIndex == childID) {
        state |= 2;
        if (this$0.isFocusControl__()) {
          state |= 4;
        }
      }
    } else if (childID == this$0.items.length + 0) {
      state = this$0.showChevron ? 0 : 32768;
    } else if (childID == this$0.items.length + 1) {
      state = this$0.showMin ? 0 : 32768;
    } else if (childID == this$0.items.length + 2) {
      state = this$0.showMax ? 0 : 32768;
    }
    e.detail = state;
    return;
  }
  public override function getChildren__Lorg_eclipse_swt_accessibility_AccessibleControlEvent_2(e: AccessibleControlEvent): void {
    var childIdCount: int = this$0.items.length + 3;
    var children: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(childIdCount);
    for (var i: int = 0; i < childIdCount; i++) {
      children[i] = new Integer(new Arguments(java.lang.Integer.Integer__I, [i]));
    }
    e.children = children;
    return;
  }
}
}
