package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Region;
import java.lang.System;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TypedListener;
import java.lang.Math__;
import org.eclipse.swt.graphics.FontData;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import java.lang.Integer;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabFolder extends Composite {
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var MIN_TAB_WIDTH: int = 4;
  public static var borderInsideRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [132, 130, 132]));
  public static var borderMiddleRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [143, 141, 138]));
  public static var borderOutsideRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [171, 168, 165]));
  internal var xClient: int;
  internal var yClient: int;
  internal var onBottom: Boolean = false;
  internal var single: Boolean = false;
  internal var simple: Boolean = true;
  internal var fixedTabHeight: int = -1;
  internal var tabHeight: int;
  internal var minChars: int = 20;
  internal var items: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabItem;").lengths(0);
  internal var firstIndex: int = -1;
  internal var selectedIndex: int = -1;
  internal var priority: JavaArray = new JavaArray("[I").lengths(0);
  internal var mru: Boolean = false;
  internal var listener: Listener;
  internal var folderListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolder2Listener;").lengths(0);
  internal var tabListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolderListener;").lengths(0);
  internal var selectionBgImage: Image;
  internal var selectionGradientColors: JavaArray;
  internal var selectionGradientPercents: JavaArray;
  internal var selectionGradientVertical: Boolean;
  internal var selectionForeground: Color;
  internal var selectionBackground: Color;
  internal var selectionFadeStart: Color;
  internal var selectionHighlightGradientBegin: Color = null;
  internal var selectionHighlightGradientColorsCache: JavaArray = null;
  internal var bgImage: Image;
  internal var gradientColors: JavaArray;
  internal var gradientPercents: JavaArray;
  internal var gradientVertical: Boolean;
  internal var showUnselectedImage: Boolean = true;
  public static var borderColor: Color;
  internal var showClose: Boolean = false;
  internal var showUnselectedClose: Boolean = true;
  internal var chevronRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var chevronImageState: int = 1;
  internal var showChevron: Boolean = false;
  internal var showMenu: Menu;
  internal var showMin: Boolean = false;
  internal var minRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var minimized: Boolean = false;
  internal var minImageState: int = 1;
  internal var showMax: Boolean = false;
  internal var maxRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var maximized: Boolean = false;
  internal var maxImageState: int = 1;
  internal var topRight: Control;
  internal var topRightRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var topRightAlignment: int = 131072;
  internal var borderLeft: int = 0;
  internal var borderRight: int = 0;
  internal var borderTop: int = 0;
  internal var borderBottom: int = 0;
  internal var highlight_margin: int = 0;
  internal var highlight_header: int = 0;
  internal var curve: JavaArray;
  internal var topCurveHighlightStart: JavaArray;
  internal var topCurveHighlightEnd: JavaArray;
  internal var curveWidth: int = 0;
  internal var curveIndent: int = 0;
  internal var inDispose: Boolean = false;
  internal var oldSize: Point;
  internal var oldFont: Font;
  public static const DEFAULT_WIDTH: int = 64;
  public static const DEFAULT_HEIGHT: int = 64;
  public static const BUTTON_SIZE: int = 18;
  public static var TOP_LEFT_CORNER: JavaArray = new JavaArray("[I").values(0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0);
  public static var TOP_LEFT_CORNER_HILITE: JavaArray = new JavaArray("[I").values(5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6);
  public static var TOP_RIGHT_CORNER: JavaArray = new JavaArray("[I").values(-6, 0, -5, 1, -4, 1, -1, 4, -1, 5, 0, 6);
  public static var BOTTOM_LEFT_CORNER: JavaArray = new JavaArray("[I").values(0, -6, 1, -5, 1, -4, 4, -1, 5, -1, 6, 0);
  public static var BOTTOM_RIGHT_CORNER: JavaArray = new JavaArray("[I").values(-6, 0, -5, -1, -4, -1, -1, -4, -1, -5, 0, -6);
  public static var SIMPLE_TOP_LEFT_CORNER: JavaArray = new JavaArray("[I").values(0, 2, 1, 1, 2, 0);
  public static var SIMPLE_TOP_RIGHT_CORNER: JavaArray = new JavaArray("[I").values(-2, 0, -1, 1, 0, 2);
  public static var SIMPLE_BOTTOM_LEFT_CORNER: JavaArray = new JavaArray("[I").values(0, -2, 1, -1, 2, 0);
  public static var SIMPLE_BOTTOM_RIGHT_CORNER: JavaArray = new JavaArray("[I").values(-2, 0, -1, -1, 0, -2);
  public static var SIMPLE_UNSELECTED_INNER_CORNER: JavaArray = new JavaArray("[I").values(0, 0);
  public static var TOP_LEFT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0);
  public static var TOP_RIGHT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(-7, 0, -6, 1, -5, 1, -2, 4, -2, 5, -1, 6);
  public static var BOTTOM_LEFT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(0, -6, 1, -6, 1, -5, 2, -4, 4, -2, 5, -1, 6, -1, 6, 0);
  public static var BOTTOM_RIGHT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(-7, 0, -7, -1, -6, -1, -5, -2, -3, -4, -2, -5, -2, -6, -1, -6);
  public static var SIMPLE_TOP_LEFT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(0, 2, 1, 1, 2, 0);
  public static var SIMPLE_TOP_RIGHT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(-3, 0, -2, 1, -1, 2);
  public static var SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(0, -3, 1, -2, 2, -1, 3, 0);
  public static var SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS: JavaArray = new JavaArray("[I").values(-4, 0, -3, -1, -2, -2, -1, -3);
  public static const SELECTION_FOREGROUND: int = 24;
  public static const SELECTION_BACKGROUND: int = 25;
  public static const BORDER1_COLOR: int = 18;
  public static const FOREGROUND: int = 21;
  public static const BACKGROUND: int = 22;
  public static const BUTTON_BORDER: int = 17;
  public static const BUTTON_FILL: int = 25;
  public static const NONE: int = 0;
  public static const NORMAL: int = 1;
  public static const HOT: int = 2;
  public static const SELECTED: int = 3;
  public static var CLOSE_FILL: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [252, 160, 160]));
  public static const CHEVRON_CHILD_ID: int = 0;
  public static const MINIMIZE_CHILD_ID: int = 1;
  public static const MAXIMIZE_CHILD_ID: int = 2;
  public static const EXTRA_CHILD_ID_COUNT: int = 3;
  public function CTabFolder(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, CTabFolder.checkStyle__Lorg_eclipse_swt_widgets_Composite_2I(parent, style)]));
    this.init__I(style);
    return;
  }
  public function init__I(style_1: int): void {
    super.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new CTabFolderLayout());
    var style2: int = super.getStyle__();
    oldFont = this.getFont__();
    onBottom = (style2 & 1024) != 0;
    showClose = (style2 & 64) != 0;
    single = (style2 & 4) != 0;
    borderLeft = borderRight = (style_1 & 2048) != 0 ? 1 : 0;
    borderTop = onBottom ? borderLeft : 0;
    borderBottom = onBottom ? 0 : borderLeft;
    highlight_header = (style_1 & 8388608) != 0 ? 1 : 3;
    highlight_margin = (style_1 & 8388608) != 0 ? 0 : 2;
    var display_1: Display = this.getDisplay__();
    selectionForeground = display_1.getSystemColor__I(24);
    selectionBackground = display_1.getSystemColor__I(25);
    borderColor = display_1.getSystemColor__I(18);
    this.updateTabHeight__Z(false);
    this.initAccessible__();
    listener = new org.eclipse.swt.custom.CTabFolder$1(this);
    var folderEvents: JavaArray = new JavaArray("[I").values(12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31);
    for (var i: int = 0; i < folderEvents.length; i++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(folderEvents[i], listener);
    }
    return;
  }
  public static function checkStyle__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): int {
    var mask: int = 64 | 128 | 1024 | 8388608 | 33554432 | 67108864 | 4 | 2;
    style = style & mask;
    if ((style & 128) != 0)
      style = style & ~1024;
    if ((style & 2) != 0)
      style = style & ~4;
    style |= 1048576;
    var platform: String = SWT.getPlatform__();
    if (Object("cocoa").equals__Ljava_lang_Object_2(platform) || Object("carbon").equals__Ljava_lang_Object_2(platform) || Object("gtk").equals__Ljava_lang_Object_2(platform))
      return style;
    if ((style & 67108864) != 0)
      return style;
    if ((parent.getStyle__() & 134217728) != 0 && (style & 33554432) == 0)
      return style;
    return style | 262144;
  }
  public static function fillRegion__Lorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Region_2(gc: GC, region: Region): void {
    var clipping: Region = new Region(new Arguments(org.eclipse.swt.graphics.Region.Region__, []));
    gc.getClipping__Lorg_eclipse_swt_graphics_Region_2(clipping);
    region.intersect__Lorg_eclipse_swt_graphics_Region_2(clipping);
    gc.setClipping__Lorg_eclipse_swt_graphics_Region_2(region);
    gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(region.getBounds__());
    gc.setClipping__Lorg_eclipse_swt_graphics_Region_2(clipping);
    clipping.dispose__();
  }
  public function addCTabFolder2Listener__Lorg_eclipse_swt_custom_CTabFolder2Listener_2(listener_1: CTabFolder2Listener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var newListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolder2Listener;").lengths(folderListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(folderListeners, 0, newListeners, 0, folderListeners.length);
    folderListeners = newListeners;
    folderListeners[folderListeners.length - 1] = listener_1;
  }
  public function addCTabFolderListener__Lorg_eclipse_swt_custom_CTabFolderListener_2(listener_1: CTabFolderListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var newTabListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolderListener;").lengths(tabListeners.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(tabListeners, 0, newTabListeners, 0, tabListeners.length);
    tabListeners = newTabListeners;
    tabListeners[tabListeners.length - 1] = listener_1;
    if (!showClose) {
      showClose = true;
      this.updateItems__();
      this.redraw__();
    }
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null) {
      SWT.error__I(4);
    }
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public function antialias___3ILorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_GC_2(shape: JavaArray, lineRGB: RGB, innerRGB: RGB, outerRGB: RGB, gc: GC): void {
    if (simple)
      return;
    var platform: String = SWT.getPlatform__();
    if (Object("cocoa").equals__Ljava_lang_Object_2(platform))
      return;
    if (Object("carbon").equals__Ljava_lang_Object_2(platform))
      return;
    if (Object("wpf").equals__Ljava_lang_Object_2(platform))
      return;
    if (this.getDisplay__().getDepth__() < 15)
      return;
    if (outerRGB !== null) {
      var index: int = 0;
      var left: Boolean = true;
      var oldY: int = onBottom ? 0 : this.getSize__().y;
      var outer: JavaArray = new JavaArray("[I").lengths(shape.length);
      for (var i: int = 0; i < int(shape.length / 2); i++) {
        if (left && (index + 3 < shape.length)) {
          left = onBottom ? oldY <= shape[index + 3] : oldY >= shape[index + 3];
          oldY = shape[index + 1];
        }
        outer[index] = shape[index++] + (left ? -1 : +1);
        outer[index] = shape[index++];
      }
      var from: RGB = lineRGB;
      var to_1: RGB = outerRGB;
      var red: int = from.red + int(2 * (to_1.red - from.red) / 3);
      var green: int = from.green + int(2 * (to_1.green - from.green) / 3);
      var blue: int = from.blue + int(2 * (to_1.blue - from.blue) / 3);
      var color: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [this.getDisplay__(), red, green, blue]));
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
      gc.drawPolyline___3I(outer);
      color.dispose__();
    }
    if (innerRGB !== null) {
      var inner: JavaArray = new JavaArray("[I").lengths(shape.length);
      var index_1: int = 0;
      var left_1: Boolean = true;
      var oldY_1: int = onBottom ? 0 : this.getSize__().y;
      for (var i_1: int = 0; i_1 < int(shape.length / 2); i_1++) {
        if (left_1 && (index_1 + 3 < shape.length)) {
          left_1 = onBottom ? oldY_1 <= shape[index_1 + 3] : oldY_1 >= shape[index_1 + 3];
          oldY_1 = shape[index_1 + 1];
        }
        inner[index_1] = shape[index_1++] + (left_1 ? +1 : -1);
        inner[index_1] = shape[index_1++];
      }
      var from_1: RGB = lineRGB;
      var to_2: RGB = innerRGB;
      var red_1: int = from_1.red + int(2 * (to_2.red - from_1.red) / 3);
      var green_1: int = from_1.green + int(2 * (to_2.green - from_1.green) / 3);
      var blue_1: int = from_1.blue + int(2 * (to_2.blue - from_1.blue) / 3);
      var color_1: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [this.getDisplay__(), red_1, green_1, blue_1]));
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(color_1);
      gc.drawPolyline___3I(inner);
      color_1.dispose__();
    }
    return;
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var trimX: int = x_1 - marginWidth - highlight_margin - borderLeft;
    var trimWidth: int = width_1 + borderLeft + borderRight + 2 * marginWidth + 2 * highlight_margin;
    if (minimized) {
      var trimY: int = onBottom ? y_1 - borderTop : y_1 - highlight_header - tabHeight - borderTop;
      var trimHeight: int = borderTop + borderBottom + tabHeight + highlight_header;
      return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    } else {
      var trimY_1: int = onBottom ? y_1 - marginHeight - highlight_margin - borderTop : y_1 - marginHeight - highlight_header - tabHeight - borderTop;
      var trimHeight_1: int = height_1 + borderTop + borderBottom + 2 * marginHeight + tabHeight + highlight_header + highlight_margin;
      return new Rectangle(trimX, trimY_1, trimWidth, trimHeight_1);
    }
    return null;
  }
  public function createItem__Lorg_eclipse_swt_custom_CTabItem_2I(item: CTabItem, index: int): void {
    if (0 > index || index > this.getItemCount__())
      SWT.error__I(6);
    item.parent = this;
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabItem;").lengths(items.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    newItems[index] = item;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index, newItems, index + 1, items.length - index);
    items = newItems;
    if (selectedIndex >= index)
      selectedIndex++;
    var newPriority: JavaArray = new JavaArray("[I").lengths(priority.length + 1);
    var next: int = 0;
    var priorityIndex: int = priority.length;
    for (var i: int = 0; i < priority.length; i++) {
      if (!mru && priority[i] == index) {
        priorityIndex = next++;
      }
      newPriority[next++] = priority[i] >= index ? priority[i] + 1 : priority[i];
    }
    newPriority[priorityIndex] = index;
    priority = newPriority;
    if (items.length == 1) {
      if (!this.updateTabHeight__Z(false))
        this.updateItems__();
      this.redraw__();
    } else {
      this.updateItems__();
      this.redrawTabs__();
    }
    return;
  }
  public function destroyItem__Lorg_eclipse_swt_custom_CTabItem_2(item: CTabItem): void {
    if (inDispose)
      return;
    var index: int = this.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(item);
    if (index == -1)
      return;
    if (items.length == 1) {
      items = new JavaArray("[Lorg/eclipse/swt/custom/CTabItem;").lengths(0);
      priority = new JavaArray("[I").lengths(0);
      firstIndex = -1;
      selectedIndex = -1;
      var control: Control = item.getControl__();
      if (control !== null && !control.isDisposed__()) {
        control.setVisible__Z(false);
      }
      this.setToolTipText__Ljava_lang_String_2(null);
      this.setButtonBounds__();
      this.redraw__();
      return;
    }
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabItem;").lengths(items.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, newItems, index, items.length - index - 1);
    items = newItems;
    var newPriority: JavaArray = new JavaArray("[I").lengths(priority.length - 1);
    var next: int = 0;
    for (var i: int = 0; i < priority.length; i++) {
      if (priority[i] == index)
        continue;
      newPriority[next++] = priority[i] > index ? priority[i] - 1 : priority[i];
    }
    priority = newPriority;
    if (selectedIndex == index) {
      var control_1: Control = item.getControl__();
      selectedIndex = -1;
      var nextSelection: int = mru ? priority[0] : Math__.max__II(0, index - 1);
      this.setSelection__IZ(nextSelection, true);
      if (control_1 !== null && !control_1.isDisposed__()) {
        control_1.setVisible__Z(false);
      }
    } else if (selectedIndex > index) {
      selectedIndex--;
    }
    this.updateItems__();
    this.redrawTabs__();
    return;
  }
  public function drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc: GC, shape: JavaArray, selected: Boolean): void {
    var defaultBackground: Color = selected ? selectionBackground : this.getBackground__();
    var image: Image = selected ? selectionBgImage : bgImage;
    var colors: JavaArray = selected ? selectionGradientColors : gradientColors;
    var percents: JavaArray = selected ? selectionGradientPercents : gradientPercents;
    var vertical: Boolean = selected ? selectionGradientVertical : gradientVertical;
    var size: Point = this.getSize__();
    var width_1: int = size.x;
    var height_1: int = tabHeight + highlight_header;
    var x_1: int = 0;
    if (borderLeft > 0) {
      x_1 += 1;
      width_1 -= 2;
    }
    var y_1: int = onBottom ? size.y - borderBottom - height_1 : borderTop;
    this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IIIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Image_2_3Lorg_eclipse_swt_graphics_Color_2_3IZ(gc, shape, x_1, y_1, width_1, height_1, defaultBackground, image, colors, percents, vertical);
    return;
  }
  public function drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IIIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Image_2_3Lorg_eclipse_swt_graphics_Color_2_3IZ(gc: GC, shape: JavaArray, x_1: int, y_1: int, width_1: int, height_1: int, defaultBackground: Color, image: Image, colors: JavaArray, percents: JavaArray, vertical: Boolean): void {
    var clipping: Region = new Region(new Arguments(org.eclipse.swt.graphics.Region.Region__, []));
    gc.getClipping__Lorg_eclipse_swt_graphics_Region_2(clipping);
    var region_1: Region = new Region(new Arguments(org.eclipse.swt.graphics.Region.Region__, []));
    region_1.add___3I(shape);
    region_1.intersect__Lorg_eclipse_swt_graphics_Region_2(clipping);
    gc.setClipping__Lorg_eclipse_swt_graphics_Region_2(region_1);
    if (image !== null) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(defaultBackground);
      gc.fillRectangle__IIII(x_1, y_1, width_1, height_1);
      var imageRect: Rectangle = image.getBounds__();
      gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image, imageRect.x, imageRect.y, imageRect.width, imageRect.height, x_1, y_1, width_1, height_1);
    } else if (colors !== null) {
      if (colors.length == 1) {
        var background_1: Color = colors[0] !== null ? colors[0] : defaultBackground;
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background_1);
        gc.fillRectangle__IIII(x_1, y_1, width_1, height_1);
      } else {
        if (vertical) {
          if (onBottom) {
            var pos: int = 0;
            if (percents[percents.length - 1] < 100) {
              pos = int((100 - percents[percents.length - 1]) * height_1 / 100);
              gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(defaultBackground);
              gc.fillRectangle__IIII(x_1, y_1, width_1, pos);
            }
            var lastColor: Color = colors[colors.length - 1];
            if (lastColor === null)
              lastColor = defaultBackground;
            for (var i: int = percents.length - 1; i >= 0; i--) {
              gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(lastColor);
              lastColor = colors[i];
              if (lastColor === null)
                lastColor = defaultBackground;
              gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(lastColor);
              var percentage: int = i > 0 ? percents[i] - percents[i - 1] : percents[i];
              var gradientHeight: int = int(percentage * height_1 / 100);
              gc.fillGradientRectangle__IIIIZ(x_1, y_1 + pos, width_1, gradientHeight, true);
              pos += gradientHeight;
            }
          } else {
            var lastColor_1: Color = colors[0];
            if (lastColor_1 === null)
              lastColor_1 = defaultBackground;
            var pos_1: int = 0;
            for (var i_1: int = 0; i_1 < percents.length; i_1++) {
              gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(lastColor_1);
              lastColor_1 = colors[i_1 + 1];
              if (lastColor_1 === null)
                lastColor_1 = defaultBackground;
              gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(lastColor_1);
              var percentage_1: int = i_1 > 0 ? percents[i_1] - percents[i_1 - 1] : percents[i_1];
              var gradientHeight_1: int = int(percentage_1 * height_1 / 100);
              gc.fillGradientRectangle__IIIIZ(x_1, y_1 + pos_1, width_1, gradientHeight_1, true);
              pos_1 += gradientHeight_1;
            }
            if (pos_1 < height_1) {
              gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(defaultBackground);
              gc.fillRectangle__IIII(x_1, pos_1, width_1, height_1 - pos_1 + 1);
            }
          }
        } else {
          y_1 = 0;
          height_1 = this.getSize__().y;
          var lastColor_2: Color = colors[0];
          if (lastColor_2 === null)
            lastColor_2 = defaultBackground;
          var pos_2: int = 0;
          for (var i_2: int = 0; i_2 < percents.length; ++i_2) {
            gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(lastColor_2);
            lastColor_2 = colors[i_2 + 1];
            if (lastColor_2 === null)
              lastColor_2 = defaultBackground;
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(lastColor_2);
            var gradientWidth: int = (int(percents[i_2] * width_1 / 100)) - pos_2;
            gc.fillGradientRectangle__IIIIZ(x_1 + pos_2, y_1, gradientWidth, height_1, false);
            pos_2 += gradientWidth;
          }
          if (pos_2 < width_1) {
            gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(defaultBackground);
            gc.fillRectangle__IIII(x_1 + pos_2, y_1, width_1 - pos_2, height_1);
          }
        }
      }
    } else {
      if ((this.getStyle__() & 262144) != 0 || !defaultBackground.equals__Ljava_lang_Object_2(this.getBackground__())) {
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(defaultBackground);
        gc.fillRectangle__IIII(x_1, y_1, width_1, height_1);
      }
    }
    gc.setClipping__Lorg_eclipse_swt_graphics_Region_2(clipping);
    clipping.dispose__();
    region_1.dispose__();
    return;
  }
  public function drawBody__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var gc: GC = event.gc;
    var size: Point = this.getSize__();
    if (!minimized) {
      var width_1: int = size.x - borderLeft - borderRight - 2 * highlight_margin;
      var height_1: int = size.y - borderTop - borderBottom - tabHeight - highlight_header - highlight_margin;
      if (highlight_margin > 0) {
        var shape: JavaArray = null;
        if (onBottom) {
          var x1: int = borderLeft;
          var y1: int = borderTop;
          var x2: int = size.x - borderRight;
          var y2: int = size.y - borderBottom - tabHeight - highlight_header;
          shape = new JavaArray("[I").values(x1, y1, x2, y1, x2, y2, x2 - highlight_margin, y2, x2 - highlight_margin, y1 + highlight_margin, x1 + highlight_margin, y1 + highlight_margin, x1 + highlight_margin, y2, x1, y2);
        } else {
          var x1_1: int = borderLeft;
          var y1_1: int = borderTop + tabHeight + highlight_header;
          var x2_1: int = size.x - borderRight;
          var y2_1: int = size.y - borderBottom;
          shape = new JavaArray("[I").values(x1_1, y1_1, x1_1 + highlight_margin, y1_1, x1_1 + highlight_margin, y2_1 - highlight_margin, x2_1 - highlight_margin, y2_1 - highlight_margin, x2_1 - highlight_margin, y1_1, x2_1, y1_1, x2_1, y2_1, x1_1, y2_1);
        }
        if (selectedIndex != -1 && selectionGradientColors !== null && selectionGradientColors.length > 1 && !selectionGradientVertical) {
          this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, true);
        } else if (selectedIndex == -1 && gradientColors !== null && gradientColors.length > 1 && !gradientVertical) {
          this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, false);
        } else {
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(selectedIndex == -1 ? this.getBackground__() : selectionBackground);
          gc.fillPolygon___3I(shape);
        }
      }
      if ((this.getStyle__() & 262144) != 0) {
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
        gc.fillRectangle__IIII(xClient - marginWidth, yClient - marginHeight, width_1, height_1);
      }
    } else {
      if ((this.getStyle__() & 262144) != 0) {
        var height_2: int = borderTop + tabHeight + highlight_header + borderBottom;
        if (size.y > height_2) {
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getParent__().getBackground__());
          gc.fillRectangle__IIII(0, height_2, size.x, size.y - height_2);
        }
      }
    }
    if (borderLeft > 0) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(borderColor);
      var x1_2: int = borderLeft - 1;
      var x2_2: int = size.x - borderRight;
      var y1_2: int = onBottom ? borderTop - 1 : borderTop + tabHeight;
      var y2_2: int = onBottom ? size.y - tabHeight - borderBottom - 1 : size.y - borderBottom;
      gc.drawLine__IIII(x1_2, y1_2, x1_2, y2_2);
      gc.drawLine__IIII(x2_2, y1_2, x2_2, y2_2);
      if (onBottom) {
        gc.drawLine__IIII(x1_2, y1_2, x2_2, y1_2);
      } else {
        gc.drawLine__IIII(x1_2, y2_2, x2_2, y2_2);
      }
    }
    return;
  }
  public function drawChevron__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (chevronRect.width == 0 || chevronRect.height == 0)
      return;
    var display_1: Display = this.getDisplay__();
    var dpi: Point = display_1.getDPI__();
    var fontHeight: int = int(72 * 10 / dpi.y);
    var fd: FontData = this.getFont__().getFontData__()[0];
    fd.setHeight__I(fontHeight);
    var f: Font = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [display_1, fd]));
    var fHeight: int = int(f.getFontData__()[0].getHeight__() * dpi.y / 72);
    var indent: int = Math__.max__II(2, int((chevronRect.height - fHeight - 4) / 2));
    var x_1: int = chevronRect.x + 2;
    var y_1: int = chevronRect.y + indent;
    var count: int;
    if (single) {
      count = selectedIndex == -1 ? items.length : items.length - 1;
    } else {
      var showCount: int = 0;
      while (showCount < priority.length && items[priority[showCount]].showing) {
        showCount++;
      }
      count = items.length - showCount;
    }
    var chevronString: String = count > 99 ? "99+" : Object(String).valueOf__I(count);
    switch (chevronImageState) {
      case 1 :
        {
          var chevronBorder: Color = single ? this.getSelectionForeground__() : this.getForeground__();
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(chevronBorder);
          gc.setFont__Lorg_eclipse_swt_graphics_Font_2(f);
          gc.drawLine__IIII(x_1, y_1, x_1 + 2, y_1 + 2);
          gc.drawLine__IIII(x_1 + 2, y_1 + 2, x_1, y_1 + 4);
          gc.drawLine__IIII(x_1 + 1, y_1, x_1 + 3, y_1 + 2);
          gc.drawLine__IIII(x_1 + 3, y_1 + 2, x_1 + 1, y_1 + 4);
          gc.drawLine__IIII(x_1 + 4, y_1, x_1 + 6, y_1 + 2);
          gc.drawLine__IIII(x_1 + 6, y_1 + 2, x_1 + 5, y_1 + 4);
          gc.drawLine__IIII(x_1 + 5, y_1, x_1 + 7, y_1 + 2);
          gc.drawLine__IIII(x_1 + 7, y_1 + 2, x_1 + 4, y_1 + 4);
          gc.drawString__Ljava_lang_String_2IIZ(chevronString, x_1 + 7, y_1 + 3, true);
          break;
        }
      case 2 :
        {
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(17));
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(25));
          gc.setFont__Lorg_eclipse_swt_graphics_Font_2(f);
          gc.fillRoundRectangle__IIIIII(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(chevronRect.x, chevronRect.y, chevronRect.width - 1, chevronRect.height - 1, 6, 6);
          gc.drawLine__IIII(x_1, y_1, x_1 + 2, y_1 + 2);
          gc.drawLine__IIII(x_1 + 2, y_1 + 2, x_1, y_1 + 4);
          gc.drawLine__IIII(x_1 + 1, y_1, x_1 + 3, y_1 + 2);
          gc.drawLine__IIII(x_1 + 3, y_1 + 2, x_1 + 1, y_1 + 4);
          gc.drawLine__IIII(x_1 + 4, y_1, x_1 + 6, y_1 + 2);
          gc.drawLine__IIII(x_1 + 6, y_1 + 2, x_1 + 5, y_1 + 4);
          gc.drawLine__IIII(x_1 + 5, y_1, x_1 + 7, y_1 + 2);
          gc.drawLine__IIII(x_1 + 7, y_1 + 2, x_1 + 4, y_1 + 4);
          gc.drawString__Ljava_lang_String_2IIZ(chevronString, x_1 + 7, y_1 + 3, true);
          break;
        }
      case 3 :
        {
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(17));
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(25));
          gc.setFont__Lorg_eclipse_swt_graphics_Font_2(f);
          gc.fillRoundRectangle__IIIIII(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(chevronRect.x, chevronRect.y, chevronRect.width - 1, chevronRect.height - 1, 6, 6);
          gc.drawLine__IIII(x_1 + 1, y_1 + 1, x_1 + 3, y_1 + 3);
          gc.drawLine__IIII(x_1 + 3, y_1 + 3, x_1 + 1, y_1 + 5);
          gc.drawLine__IIII(x_1 + 2, y_1 + 1, x_1 + 4, y_1 + 3);
          gc.drawLine__IIII(x_1 + 4, y_1 + 3, x_1 + 2, y_1 + 5);
          gc.drawLine__IIII(x_1 + 5, y_1 + 1, x_1 + 7, y_1 + 3);
          gc.drawLine__IIII(x_1 + 7, y_1 + 3, x_1 + 6, y_1 + 5);
          gc.drawLine__IIII(x_1 + 6, y_1 + 1, x_1 + 8, y_1 + 3);
          gc.drawLine__IIII(x_1 + 8, y_1 + 3, x_1 + 5, y_1 + 5);
          gc.drawString__Ljava_lang_String_2IIZ(chevronString, x_1 + 8, y_1 + 4, true);
          break;
        }
    }
    f.dispose__();
    return;
  }
  public function drawMaximize__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (maxRect.width == 0 || maxRect.height == 0)
      return;
    var display_1: Display = this.getDisplay__();
    var x_1: int = maxRect.x + int((18 - 10) / 2);
    var y_1: int = maxRect.y + 3;
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(17));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(25));
    switch (maxImageState) {
      case 1 :
        {
          if (!maximized) {
            gc.fillRectangle__IIII(x_1, y_1, 9, 9);
            gc.drawRectangle__IIII(x_1, y_1, 9, 9);
            gc.drawLine__IIII(x_1 + 1, y_1 + 2, x_1 + 8, y_1 + 2);
          } else {
            gc.fillRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.fillRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.drawRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawLine__IIII(x_1 + 3, y_1 + 1, x_1 + 6, y_1 + 1);
            gc.drawLine__IIII(x_1 + 1, y_1 + 4, x_1 + 4, y_1 + 4);
          }
          break;
        }
      case 2 :
        {
          gc.fillRoundRectangle__IIIIII(maxRect.x, maxRect.y, maxRect.width, maxRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(maxRect.x, maxRect.y, maxRect.width - 1, maxRect.height - 1, 6, 6);
          if (!maximized) {
            gc.fillRectangle__IIII(x_1, y_1, 9, 9);
            gc.drawRectangle__IIII(x_1, y_1, 9, 9);
            gc.drawLine__IIII(x_1 + 1, y_1 + 2, x_1 + 8, y_1 + 2);
          } else {
            gc.fillRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.fillRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.drawRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawLine__IIII(x_1 + 3, y_1 + 1, x_1 + 6, y_1 + 1);
            gc.drawLine__IIII(x_1 + 1, y_1 + 4, x_1 + 4, y_1 + 4);
          }
          break;
        }
      case 3 :
        {
          gc.fillRoundRectangle__IIIIII(maxRect.x, maxRect.y, maxRect.width, maxRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(maxRect.x, maxRect.y, maxRect.width - 1, maxRect.height - 1, 6, 6);
          if (!maximized) {
            gc.fillRectangle__IIII(x_1 + 1, y_1 + 1, 9, 9);
            gc.drawRectangle__IIII(x_1 + 1, y_1 + 1, 9, 9);
            gc.drawLine__IIII(x_1 + 2, y_1 + 3, x_1 + 9, y_1 + 3);
          } else {
            gc.fillRectangle__IIII(x_1 + 1, y_1 + 4, 5, 4);
            gc.fillRectangle__IIII(x_1 + 3, y_1 + 1, 5, 4);
            gc.drawRectangle__IIII(x_1 + 1, y_1 + 4, 5, 4);
            gc.drawRectangle__IIII(x_1 + 3, y_1 + 1, 5, 4);
            gc.drawLine__IIII(x_1 + 4, y_1 + 2, x_1 + 7, y_1 + 2);
            gc.drawLine__IIII(x_1 + 2, y_1 + 5, x_1 + 5, y_1 + 5);
          }
          break;
        }
    }
    return;
  }
  public function drawMinimize__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (minRect.width == 0 || minRect.height == 0)
      return;
    var display_1: Display = this.getDisplay__();
    var x_1: int = minRect.x + int((18 - 10) / 2);
    var y_1: int = minRect.y + 3;
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(17));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(25));
    switch (minImageState) {
      case 1 :
        {
          if (!minimized) {
            gc.fillRectangle__IIII(x_1, y_1, 9, 3);
            gc.drawRectangle__IIII(x_1, y_1, 9, 3);
          } else {
            gc.fillRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.fillRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.drawRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawLine__IIII(x_1 + 3, y_1 + 1, x_1 + 6, y_1 + 1);
            gc.drawLine__IIII(x_1 + 1, y_1 + 4, x_1 + 4, y_1 + 4);
          }
          break;
        }
      case 2 :
        {
          gc.fillRoundRectangle__IIIIII(minRect.x, minRect.y, minRect.width, minRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(minRect.x, minRect.y, minRect.width - 1, minRect.height - 1, 6, 6);
          if (!minimized) {
            gc.fillRectangle__IIII(x_1, y_1, 9, 3);
            gc.drawRectangle__IIII(x_1, y_1, 9, 3);
          } else {
            gc.fillRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.fillRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawRectangle__IIII(x_1, y_1 + 3, 5, 4);
            gc.drawRectangle__IIII(x_1 + 2, y_1, 5, 4);
            gc.drawLine__IIII(x_1 + 3, y_1 + 1, x_1 + 6, y_1 + 1);
            gc.drawLine__IIII(x_1 + 1, y_1 + 4, x_1 + 4, y_1 + 4);
          }
          break;
        }
      case 3 :
        {
          gc.fillRoundRectangle__IIIIII(minRect.x, minRect.y, minRect.width, minRect.height, 6, 6);
          gc.drawRoundRectangle__IIIIII(minRect.x, minRect.y, minRect.width - 1, minRect.height - 1, 6, 6);
          if (!minimized) {
            gc.fillRectangle__IIII(x_1 + 1, y_1 + 1, 9, 3);
            gc.drawRectangle__IIII(x_1 + 1, y_1 + 1, 9, 3);
          } else {
            gc.fillRectangle__IIII(x_1 + 1, y_1 + 4, 5, 4);
            gc.fillRectangle__IIII(x_1 + 3, y_1 + 1, 5, 4);
            gc.drawRectangle__IIII(x_1 + 1, y_1 + 4, 5, 4);
            gc.drawRectangle__IIII(x_1 + 3, y_1 + 1, 5, 4);
            gc.drawLine__IIII(x_1 + 4, y_1 + 2, x_1 + 7, y_1 + 2);
            gc.drawLine__IIII(x_1 + 2, y_1 + 5, x_1 + 5, y_1 + 5);
          }
          break;
        }
    }
    return;
  }
  public function drawTabArea__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var gc: GC = event.gc;
    var size: Point = this.getSize__();
    var shape: JavaArray = null;
    if (tabHeight == 0) {
      var style_1: int = this.getStyle__();
      if ((style_1 & 8388608) != 0 && (style_1 & 2048) == 0)
        return;
      var x1: int = borderLeft - 1;
      var x2: int = size.x - borderRight;
      var y1: int = onBottom ? size.y - borderBottom - highlight_header - 1 : borderTop + highlight_header;
      var y2: int = onBottom ? size.y - borderBottom : borderTop;
      if (borderLeft > 0 && onBottom)
        y2 -= 1;
      shape = new JavaArray("[I").values(x1, y1, x1, y2, x2, y2, x2, y1);
      if (selectedIndex != -1 && selectionGradientColors !== null && selectionGradientColors.length > 1 && !selectionGradientVertical) {
        this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, true);
      } else if (selectedIndex == -1 && gradientColors !== null && gradientColors.length > 1 && !gradientVertical) {
        this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, false);
      } else {
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(selectedIndex == -1 ? this.getBackground__() : selectionBackground);
        gc.fillPolygon___3I(shape);
      }
      if (borderLeft > 0) {
        gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(borderColor);
        gc.drawPolyline___3I(shape);
      }
      return;
    }
    var x_1: int = Math__.max__II(0, borderLeft - 1);
    var y_1: int = onBottom ? size.y - borderBottom - tabHeight : borderTop;
    var width_1: int = size.x - borderLeft - borderRight + 1;
    var height_1: int = tabHeight - 1;
    if (onBottom) {
      var left: JavaArray;
      var right: JavaArray;
      if ((this.getStyle__() & 2048) != 0) {
        left = simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
        right = simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
      } else {
        left = simple ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
        right = simple ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
      }
      shape = new JavaArray("[I").lengths(left.length + right.length + 4);
      var index: int = 0;
      shape[index++] = x_1;
      shape[index++] = y_1 - highlight_header;
      for (var i: int = 0; i < int(left.length / 2); i++) {
        shape[index++] = x_1 + left[2 * i];
        shape[index++] = y_1 + height_1 + left[2 * i + 1];
        if (borderLeft == 0)
          shape[index - 1] += 1;
      }
      for (var i_1: int = 0; i_1 < int(right.length / 2); i_1++) {
        shape[index++] = x_1 + width_1 + right[2 * i_1];
        shape[index++] = y_1 + height_1 + right[2 * i_1 + 1];
        if (borderLeft == 0)
          shape[index - 1] += 1;
      }
      shape[index++] = x_1 + width_1;
      shape[index++] = y_1 - highlight_header;
    } else {
      var left_1: JavaArray;
      var right_1: JavaArray;
      if ((this.getStyle__() & 2048) != 0) {
        left_1 = simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
        right_1 = simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
      } else {
        left_1 = simple ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
        right_1 = simple ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
      }
      shape = new JavaArray("[I").lengths(left_1.length + right_1.length + 4);
      var index_1: int = 0;
      shape[index_1++] = x_1;
      shape[index_1++] = y_1 + height_1 + highlight_header + 1;
      for (var i_2: int = 0; i_2 < int(left_1.length / 2); i_2++) {
        shape[index_1++] = x_1 + left_1[2 * i_2];
        shape[index_1++] = y_1 + left_1[2 * i_2 + 1];
      }
      for (var i_3: int = 0; i_3 < int(right_1.length / 2); i_3++) {
        shape[index_1++] = x_1 + width_1 + right_1[2 * i_3];
        shape[index_1++] = y_1 + right_1[2 * i_3 + 1];
      }
      shape[index_1++] = x_1 + width_1;
      shape[index_1++] = y_1 + height_1 + highlight_header + 1;
    }
    var bkSelected: Boolean = single && selectedIndex != -1;
    this.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, bkSelected);
    var r: Region = new Region(new Arguments(org.eclipse.swt.graphics.Region.Region__, []));
    r.add__Lorg_eclipse_swt_graphics_Rectangle_2(new Rectangle(x_1, y_1, width_1 + 1, height_1 + 1));
    r.subtract___3I(shape);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getParent__().getBackground__());
    CTabFolder.fillRegion__Lorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Region_2(gc, r);
    r.dispose__();
    if (!single) {
      for (var i_4: int = 0; i_4 < items.length; i_4++) {
        if (i_4 != selectedIndex && event.getBounds__().intersects__Lorg_eclipse_swt_graphics_Rectangle_2(items[i_4].getBounds__())) {
          items[i_4].onPaint__Lorg_eclipse_swt_graphics_GC_2Z(gc, false);
        }
      }
    }
    if (selectedIndex != -1) {
      var item: CTabItem = items[selectedIndex];
      item.onPaint__Lorg_eclipse_swt_graphics_GC_2Z(gc, true);
    } else {
      var x1_1: int = borderLeft;
      var y1_1: int = (onBottom) ? size.y - borderBottom - tabHeight - 1 : borderTop + tabHeight;
      var x2_1: int = size.x - borderRight;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(borderColor);
      gc.drawLine__IIII(x1_1, y1_1, x2_1, y1_1);
    }
    this.drawChevron__Lorg_eclipse_swt_graphics_GC_2(gc);
    this.drawMinimize__Lorg_eclipse_swt_graphics_GC_2(gc);
    this.drawMaximize__Lorg_eclipse_swt_graphics_GC_2(gc);
    if (borderLeft > 0) {
      var outside: RGB = this.getParent__().getBackground__().getRGB__();
      this.antialias___3ILorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_GC_2(shape, borderColor.getRGB__(), null, outside, gc);
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(borderColor);
      gc.drawPolyline___3I(shape);
    }
    return;
  }
  public function getBorderVisible__(): Boolean {
    this.checkWidget__();
    return borderLeft == 1;
  }
  public override function getClientArea__(): Rectangle {
    this.checkWidget__();
    if (minimized)
      return new Rectangle(xClient, yClient, 0, 0);
    var size: Point = this.getSize__();
    var width_1: int = size.x - borderLeft - borderRight - 2 * marginWidth - 2 * highlight_margin;
    var height_1: int = size.y - borderTop - borderBottom - 2 * marginHeight - highlight_margin - highlight_header;
    height_1 -= tabHeight;
    return new Rectangle(xClient, yClient, width_1, height_1);
  }
  public function getItem__I(index: int): CTabItem {
    if (index < 0 || index >= items.length)
      SWT.error__I(6);
    return items[index];
  }
  public function getItem__Lorg_eclipse_swt_graphics_Point_2(pt: Point): CTabItem {
    if (items.length == 0)
      return null;
    var size: Point = this.getSize__();
    if (size.x <= borderLeft + borderRight)
      return null;
    if (showChevron && chevronRect.contains__Lorg_eclipse_swt_graphics_Point_2(pt))
      return null;
    for (var i: int = 0; i < priority.length; i++) {
      var item: CTabItem = items[priority[i]];
      var rect: Rectangle = item.getBounds__();
      if (rect.contains__Lorg_eclipse_swt_graphics_Point_2(pt))
        return item;
    }
    return null;
  }
  public function getItemCount__(): int {
    return items.length;
  }
  public function getItems__(): JavaArray {
    var tabItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabItem;").lengths(items.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, tabItems, 0, items.length);
    return tabItems;
  }
  public function _findMnemonic__Ljava_lang_String_2(string: String): uint {
    if (string === null)
      return 0;
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while (index < length && Object(string).charAt__I(index) != 38)
        index++;
      if (++index >= length)
        return 0;
      if (Object(string).charAt__I(index) != 38)
        return Character.toLowerCase__C(Object(string).charAt__I(index));
      index++;
    } while (index < length);
    return 0;
  }
  public function stripMnemonic__Ljava_lang_String_2(string: String): String {
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while ((index < length) && (Object(string).charAt__I(index) != 38))
        index++;
      if (++index >= length)
        return string;
      if (Object(string).charAt__I(index) != 38) {
        return Object(string).substring__II(0, index - 1) + Object(string).substring__II(index, length);
      }
      index++;
    } while (index < length);
    return string;
  }
  public function getMinimized__(): Boolean {
    this.checkWidget__();
    return minimized;
  }
  public function getMinimizeVisible__(): Boolean {
    this.checkWidget__();
    return showMin;
  }
  public function getMinimumCharacters__(): int {
    this.checkWidget__();
    return minChars;
  }
  public function getMaximized__(): Boolean {
    this.checkWidget__();
    return maximized;
  }
  public function getMaximizeVisible__(): Boolean {
    this.checkWidget__();
    return showMax;
  }
  public function getMRUVisible__(): Boolean {
    this.checkWidget__();
    return mru;
  }
  public function getRightItemEdge__(): int {
    var x_1: int = this.getSize__().x - borderRight - 3;
    if (showMin)
      x_1 -= 18;
    if (showMax)
      x_1 -= 18;
    if (showChevron)
      x_1 -= int(3 * 18 / 2);
    if (topRight !== null && topRightAlignment != 4) {
      var rightSize: Point = topRight.computeSize__II(-1, -1);
      x_1 -= rightSize.x + 3;
    }
    return Math__.max__II(0, x_1);
  }
  public function getSelection__(): CTabItem {
    if (selectedIndex == -1)
      return null;
    return items[selectedIndex];
  }
  public function getSelectionBackground__(): Color {
    this.checkWidget__();
    return selectionBackground;
  }
  public function getSelectionForeground__(): Color {
    this.checkWidget__();
    return selectionForeground;
  }
  public function getSelectionIndex__(): int {
    return selectedIndex;
  }
  public function getSimple__(): Boolean {
    this.checkWidget__();
    return simple;
  }
  public function getSingle__(): Boolean {
    this.checkWidget__();
    return single;
  }
  public override function getStyle__(): int {
    var style_1: int = super.getStyle__();
    style_1 &= ~(128 | 1024);
    style_1 |= onBottom ? 1024 : 128;
    style_1 &= ~(4 | 2);
    style_1 |= single ? 4 : 2;
    if (borderLeft != 0)
      style_1 |= 2048;
    style_1 &= ~64;
    if (showClose)
      style_1 |= 64;
    return style_1;
  }
  public function getTabHeight__(): int {
    this.checkWidget__();
    if (fixedTabHeight != -1)
      return fixedTabHeight;
    return tabHeight - 1;
  }
  public function getTabPosition__(): int {
    this.checkWidget__();
    return onBottom ? 1024 : 128;
  }
  public function getTopRight__(): Control {
    this.checkWidget__();
    return topRight;
  }
  public function getUnselectedCloseVisible__(): Boolean {
    this.checkWidget__();
    return showUnselectedClose;
  }
  public function getUnselectedImageVisible__(): Boolean {
    this.checkWidget__();
    return showUnselectedImage;
  }
  public function indexOf__Lorg_eclipse_swt_custom_CTabItem_2(item: CTabItem): int {
    this.checkWidget__();
    if (item === null) {
      SWT.error__I(4);
    }
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === item)
        return i;
    }
    return -1;
  }
  public function initAccessible__(): void {
    var accessible_1: Accessible = this.getAccessible__();
    accessible_1.addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(new org.eclipse.swt.custom.CTabFolder$2(this));
    accessible_1.addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.CTabFolder$3(this));
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.custom.CTabFolder$4(this, accessible_1));
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(15, new org.eclipse.swt.custom.CTabFolder$5(this, accessible_1));
    return;
  }
  public function onKeyDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.keyCode) {
      case 16777219 :
      case 16777220 :
        var count: int = items.length;
        if (count == 0)
          return;
        if (selectedIndex == -1)
          return;
        var leadKey: int = (this.getStyle__() & 67108864) != 0 ? 16777220 : 16777219;
        var offset: int = event.keyCode == leadKey ? -1 : 1;
        var index: int;
        if (!mru) {
          index = selectedIndex + offset;
        } else {
          var visible: JavaArray = new JavaArray("[I").lengths(items.length);
          var idx: int = 0;
          var current: int = -1;
          for (var i: int = 0; i < items.length; i++) {
            if (items[i].showing) {
              if (i == selectedIndex)
                current = idx;
              visible[idx++] = i;
            }
          }
          if (current + offset >= 0 && current + offset < idx) {
            index = visible[current + offset];
          } else {
            if (showChevron) {
              var e: CTabFolderEvent = new CTabFolderEvent(this);
              e.widget = this;
              e.time = event.time;
              e.x = chevronRect.x;
              e.y = chevronRect.y;
              e.width = chevronRect.width;
              e.height = chevronRect.height;
              e.doit = true;
              for (var i_1: int = 0; i_1 < folderListeners.length; i_1++) {
                folderListeners[i_1].showList__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e);
              }
              if (e.doit && !this.isDisposed__()) {
                this.showList__Lorg_eclipse_swt_graphics_Rectangle_2(chevronRect);
              }
            }
            return;
          }
        }
        if (index < 0 || index >= count)
          return;
        this.setSelection__IZ(index, true);
        this.forceFocus__();
    }
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    inDispose = true;
    if (showMenu !== null && !showMenu.isDisposed__()) {
      showMenu.dispose__();
      showMenu = null;
    }
    var length: int = items.length;
    for (var i: int = 0; i < length; i++) {
      if (items[i] !== null) {
        items[i].dispose__();
      }
    }
    selectionGradientColors = null;
    selectionGradientPercents = null;
    selectionBgImage = null;
    selectionBackground = null;
    selectionForeground = null;
    this.disposeSelectionHighlightGradientColors__();
    return;
  }
  public function onDragDetect__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var consume: Boolean = false;
    if (chevronRect.contains__II(event.x, event.y) || minRect.contains__II(event.x, event.y) || maxRect.contains__II(event.x, event.y)) {
      consume = true;
    } else {
      for (var i: int = 0; i < items.length; i++) {
        if (items[i].closeRect.contains__II(event.x, event.y)) {
          consume = true;
          break;
        }
      }
    }
    if (consume) {
      event.type = 0;
    }
    return;
  }
  public function onFocus__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.checkWidget__();
    if (selectedIndex >= 0) {
      this.redraw__();
    } else {
      this.setSelection__IZ(0, true);
    }
    return;
  }
  public function onMnemonic__Lorg_eclipse_swt_widgets_Event_2(event: Event): Boolean {
    var key: uint = event.character;
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] !== null) {
        var mnemonic: uint = this._findMnemonic__Ljava_lang_String_2(items[i].getText__());
        if (mnemonic != 0) {
          if (Character.toLowerCase__C(key) == mnemonic) {
            this.setSelection__IZ(i, true);
            return true;
          }
        }
      }
    }
    return false;
  }
  public function onMouseDoubleClick__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (event.button != 1 || (event.stateMask & 1048576) != 0 || (event.stateMask & 2097152) != 0)
      return;
    var e: Event = new Event();
    e.item = this.getItem__Lorg_eclipse_swt_graphics_Point_2(new Point(event.x, event.y));
    if (e.item !== null) {
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(14, e);
    }
    return;
  }
  public function onMouse__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var x_1: int = event.x;
    var y_1: int = event.y;
    switch (event.type) {
      case 6 :
        {
          this.setToolTipText__Ljava_lang_String_2(null);
          break;
        }
      case 7 :
        {
          if (minImageState != 1) {
            minImageState = 1;
            this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
          }
          if (maxImageState != 1) {
            maxImageState = 1;
            this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
          }
          if (chevronImageState != 1) {
            chevronImageState = 1;
            this.redraw__IIIIZ(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, false);
          }
          for (var i: int = 0; i < items.length; i++) {
            var item: CTabItem = items[i];
            if (i != selectedIndex && item.closeImageState != 0) {
              item.closeImageState = 0;
              this.redraw__IIIIZ(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
            }
            if (i == selectedIndex && item.closeImageState != 1) {
              item.closeImageState = 1;
              this.redraw__IIIIZ(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
            }
          }
          break;
        }
      case 3 :
        {
          if (event.button != 1)
            return;
          if (minRect.contains__II(x_1, y_1)) {
            minImageState = 3;
            this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
            this.update__();
            return;
          }
          if (maxRect.contains__II(x_1, y_1)) {
            maxImageState = 3;
            this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
            this.update__();
            return;
          }
          if (chevronRect.contains__II(x_1, y_1)) {
            if (chevronImageState != 2) {
              chevronImageState = 2;
            } else {
              chevronImageState = 3;
            }
            this.redraw__IIIIZ(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, false);
            this.update__();
            return;
          }
          var item_1: CTabItem = null;
          if (single) {
            if (selectedIndex != -1) {
              var bounds: Rectangle = items[selectedIndex].getBounds__();
              if (bounds.contains__II(x_1, y_1)) {
                item_1 = items[selectedIndex];
              }
            }
          } else {
            for (var i_1: int = 0; i_1 < items.length; i_1++) {
              var bounds_1: Rectangle = items[i_1].getBounds__();
              if (bounds_1.contains__II(x_1, y_1)) {
                item_1 = items[i_1];
              }
            }
          }
          if (item_1 !== null) {
            if (item_1.closeRect.contains__II(x_1, y_1)) {
              item_1.closeImageState = 3;
              this.redraw__IIIIZ(item_1.closeRect.x, item_1.closeRect.y, item_1.closeRect.width, item_1.closeRect.height, false);
              this.update__();
              return;
            }
            var index: int = this.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(item_1);
            if (item_1.showing) {
              this.setSelection__IZ(index, true);
            }
            return;
          }
          break;
        }
      case 5 :
        {
          this._setToolTipText__II(event.x, event.y);
          var close: Boolean = false;
          var minimize: Boolean = false;
          var maximize: Boolean = false;
          var chevron: Boolean = false;
          if (minRect.contains__II(x_1, y_1)) {
            minimize = true;
            if (minImageState != 3 && minImageState != 2) {
              minImageState = 2;
              this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
            }
          }
          if (maxRect.contains__II(x_1, y_1)) {
            maximize = true;
            if (maxImageState != 3 && maxImageState != 2) {
              maxImageState = 2;
              this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
            }
          }
          if (chevronRect.contains__II(x_1, y_1)) {
            chevron = true;
            if (chevronImageState != 3 && chevronImageState != 2) {
              chevronImageState = 2;
              this.redraw__IIIIZ(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, false);
            }
          }
          if (minImageState != 1 && !minimize) {
            minImageState = 1;
            this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
          }
          if (maxImageState != 1 && !maximize) {
            maxImageState = 1;
            this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
          }
          if (chevronImageState != 1 && !chevron) {
            chevronImageState = 1;
            this.redraw__IIIIZ(chevronRect.x, chevronRect.y, chevronRect.width, chevronRect.height, false);
          }
          for (var i_2: int = 0; i_2 < items.length; i_2++) {
            var item_2: CTabItem = items[i_2];
            close = false;
            if (item_2.getBounds__().contains__II(x_1, y_1)) {
              close = true;
              if (item_2.closeRect.contains__II(x_1, y_1)) {
                if (item_2.closeImageState != 3 && item_2.closeImageState != 2) {
                  item_2.closeImageState = 2;
                  this.redraw__IIIIZ(item_2.closeRect.x, item_2.closeRect.y, item_2.closeRect.width, item_2.closeRect.height, false);
                }
              } else {
                if (item_2.closeImageState != 1) {
                  item_2.closeImageState = 1;
                  this.redraw__IIIIZ(item_2.closeRect.x, item_2.closeRect.y, item_2.closeRect.width, item_2.closeRect.height, false);
                }
              }
            }
            if (i_2 != selectedIndex && item_2.closeImageState != 0 && !close) {
              item_2.closeImageState = 0;
              this.redraw__IIIIZ(item_2.closeRect.x, item_2.closeRect.y, item_2.closeRect.width, item_2.closeRect.height, false);
            }
            if (i_2 == selectedIndex && item_2.closeImageState != 1 && !close) {
              item_2.closeImageState = 1;
              this.redraw__IIIIZ(item_2.closeRect.x, item_2.closeRect.y, item_2.closeRect.width, item_2.closeRect.height, false);
            }
          }
          break;
        }
      case 4 :
        {
          if (event.button != 1)
            return;
          if (chevronRect.contains__II(x_1, y_1)) {
            var selected: Boolean = chevronImageState == 3;
            if (!selected)
              return;
            var e: CTabFolderEvent = new CTabFolderEvent(this);
            e.widget = this;
            e.time = event.time;
            e.x = chevronRect.x;
            e.y = chevronRect.y;
            e.width = chevronRect.width;
            e.height = chevronRect.height;
            e.doit = true;
            for (var i_3: int = 0; i_3 < folderListeners.length; i_3++) {
              folderListeners[i_3].showList__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e);
            }
            if (e.doit && !this.isDisposed__()) {
              this.showList__Lorg_eclipse_swt_graphics_Rectangle_2(chevronRect);
            }
            return;
          }
          if (minRect.contains__II(x_1, y_1)) {
            var selected_1: Boolean = minImageState == 3;
            minImageState = 2;
            this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
            if (!selected_1)
              return;
            var e_1: CTabFolderEvent = new CTabFolderEvent(this);
            e_1.widget = this;
            e_1.time = event.time;
            for (var i_4: int = 0; i_4 < folderListeners.length; i_4++) {
              if (minimized) {
                folderListeners[i_4].restore__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_1);
              } else {
                folderListeners[i_4].minimize__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_1);
              }
            }
            return;
          }
          if (maxRect.contains__II(x_1, y_1)) {
            var selected_2: Boolean = maxImageState == 3;
            maxImageState = 2;
            this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
            if (!selected_2)
              return;
            var e_2: CTabFolderEvent = new CTabFolderEvent(this);
            e_2.widget = this;
            e_2.time = event.time;
            for (var i_5: int = 0; i_5 < folderListeners.length; i_5++) {
              if (maximized) {
                folderListeners[i_5].restore__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_2);
              } else {
                folderListeners[i_5].maximize__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_2);
              }
            }
            return;
          }
          var item_3: CTabItem = null;
          if (single) {
            if (selectedIndex != -1) {
              var bounds_2: Rectangle = items[selectedIndex].getBounds__();
              if (bounds_2.contains__II(x_1, y_1)) {
                item_3 = items[selectedIndex];
              }
            }
          } else {
            for (var i_6: int = 0; i_6 < items.length; i_6++) {
              var bounds_3: Rectangle = items[i_6].getBounds__();
              if (bounds_3.contains__II(x_1, y_1)) {
                item_3 = items[i_6];
              }
            }
          }
          if (item_3 !== null) {
            if (item_3.closeRect.contains__II(x_1, y_1)) {
              var selected_3: Boolean = item_3.closeImageState == 3;
              item_3.closeImageState = 2;
              this.redraw__IIIIZ(item_3.closeRect.x, item_3.closeRect.y, item_3.closeRect.width, item_3.closeRect.height, false);
              if (!selected_3)
                return;
              var e_3: CTabFolderEvent = new CTabFolderEvent(this);
              e_3.widget = this;
              e_3.time = event.time;
              e_3.item = item_3;
              e_3.doit = true;
              for (var j: int = 0; j < folderListeners.length; j++) {
                var listener_1: CTabFolder2Listener = folderListeners[j];
                listener_1.close__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_3);
              }
              for (var j_1: int = 0; j_1 < tabListeners.length; j_1++) {
                var listener_2: CTabFolderListener = tabListeners[j_1];
                listener_2.itemClosed__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e_3);
              }
              if (e_3.doit)
                item_3.dispose__();
              if (!this.isDisposed__() && item_3.isDisposed__()) {
                var display_1: Display = this.getDisplay__();
                var pt: Point = display_1.getCursorLocation__();
                pt = display_1.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(null, this, pt.x, pt.y);
                var nextItem: CTabItem = this.getItem__Lorg_eclipse_swt_graphics_Point_2(pt);
                if (nextItem !== null) {
                  if (nextItem.closeRect.contains__Lorg_eclipse_swt_graphics_Point_2(pt)) {
                    if (nextItem.closeImageState != 3 && nextItem.closeImageState != 2) {
                      nextItem.closeImageState = 2;
                      this.redraw__IIIIZ(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                    }
                  } else {
                    if (nextItem.closeImageState != 1) {
                      nextItem.closeImageState = 1;
                      this.redraw__IIIIZ(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                    }
                  }
                }
              }
              return;
            }
          }
        }
    }
    return;
  }
  public function onPageTraversal__Lorg_eclipse_swt_widgets_Event_2(event: Event): Boolean {
    var count: int = items.length;
    if (count == 0)
      return false;
    var index: int = selectedIndex;
    if (index == -1) {
      index = 0;
    } else {
      var offset: int = (event.detail == 512) ? 1 : -1;
      if (!mru) {
        index = (selectedIndex + offset + count) % count;
      } else {
        var visible: JavaArray = new JavaArray("[I").lengths(items.length);
        var idx: int = 0;
        var current: int = -1;
        for (var i: int = 0; i < items.length; i++) {
          if (items[i].showing) {
            if (i == selectedIndex)
              current = idx;
            visible[idx++] = i;
          }
        }
        if (current + offset >= 0 && current + offset < idx) {
          index = visible[current + offset];
        } else {
          if (showChevron) {
            var e: CTabFolderEvent = new CTabFolderEvent(this);
            e.widget = this;
            e.time = event.time;
            e.x = chevronRect.x;
            e.y = chevronRect.y;
            e.width = chevronRect.width;
            e.height = chevronRect.height;
            e.doit = true;
            for (var i_1: int = 0; i_1 < folderListeners.length; i_1++) {
              folderListeners[i_1].showList__Lorg_eclipse_swt_custom_CTabFolderEvent_2(e);
            }
            if (e.doit && !this.isDisposed__()) {
              this.showList__Lorg_eclipse_swt_graphics_Rectangle_2(chevronRect);
            }
          }
          return true;
        }
      }
    }
    this.setSelection__IZ(index, true);
    return true;
  }
  public function onPaint__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (inDispose)
      return;
    var font_1: Font = this.getFont__();
    if (oldFont === null || !oldFont.equals__Ljava_lang_Object_2(font_1)) {
      oldFont = font_1;
      if (!this.updateTabHeight__Z(false)) {
        this.updateItems__();
        this.redraw__();
        return;
      }
    }
    var gc: GC = event.gc;
    var gcFont: Font = gc.getFont__();
    var gcBackground: Color = gc.getBackground__();
    var gcForeground: Color = gc.getForeground__();
    this.drawBody__Lorg_eclipse_swt_widgets_Event_2(event);
    gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gcForeground);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(gcBackground);
    this.drawTabArea__Lorg_eclipse_swt_widgets_Event_2(event);
    gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gcForeground);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(gcBackground);
    return;
  }
  public function onResize__(): void {
    if (this.updateItems__())
      this.redrawTabs__();
    var size: Point = this.getSize__();
    if (oldSize === null) {
      this.redraw__();
    } else {
      if (onBottom && size.y != oldSize.y) {
        this.redraw__();
      } else {
        var x1: int = Math__.min__II(size.x, oldSize.x);
        if (size.x != oldSize.x)
          x1 -= borderRight + highlight_margin + 2;
        if (!simple)
          x1 -= 5;
        var y1: int = Math__.min__II(size.y, oldSize.y);
        if (size.y != oldSize.y)
          y1 -= borderBottom + highlight_margin;
        var x2: int = Math__.max__II(size.x, oldSize.x);
        var y2: int = Math__.max__II(size.y, oldSize.y);
        this.redraw__IIIIZ(0, y1, x2, y2 - y1, false);
        this.redraw__IIIIZ(x1, 0, x2 - x1, y2, false);
      }
    }
    oldSize = size;
    return;
  }
  public function onTraverse__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.detail) {
      case 2 :
      case 4 :
      case 16 :
      case 8 :
        var focusControl: Control = this.getDisplay__().getFocusControl__();
        if (focusControl === this)
          event.doit = true;
        break;
      case 128 :
        event.doit = this.onMnemonic__Lorg_eclipse_swt_widgets_Event_2(event);
        if (event.doit)
          event.detail = 0;
        break;
      case 512 :
      case 256 :
        event.doit = this.onPageTraversal__Lorg_eclipse_swt_widgets_Event_2(event);
        event.detail = 0;
        break;
    }
    return;
  }
  public function redrawTabs__(): void {
    var size: Point = this.getSize__();
    if (onBottom) {
      this.redraw__IIIIZ(0, size.y - borderBottom - tabHeight - highlight_header - 1, size.x, borderBottom + tabHeight + highlight_header + 1, false);
    } else {
      this.redraw__IIIIZ(0, 0, size.x, borderTop + tabHeight + highlight_header + 1, false);
    }
    return;
  }
  public function removeCTabFolder2Listener__Lorg_eclipse_swt_custom_CTabFolder2Listener_2(listener_1: CTabFolder2Listener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    if (folderListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < folderListeners.length; i++) {
      if (listener_1 === folderListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (folderListeners.length == 1) {
      folderListeners = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolder2Listener;").lengths(0);
      return;
    }
    var newTabListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolder2Listener;").lengths(folderListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(folderListeners, 0, newTabListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(folderListeners, index + 1, newTabListeners, index, folderListeners.length - index - 1);
    folderListeners = newTabListeners;
    return;
  }
  public function removeCTabFolderListener__Lorg_eclipse_swt_custom_CTabFolderListener_2(listener_1: CTabFolderListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    if (tabListeners.length == 0)
      return;
    var index: int = -1;
    for (var i: int = 0; i < tabListeners.length; i++) {
      if (listener_1 === tabListeners[i]) {
        index = i;
        break;
      }
    }
    if (index == -1)
      return;
    if (tabListeners.length == 1) {
      tabListeners = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolderListener;").lengths(0);
      return;
    }
    var newTabListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/CTabFolderListener;").lengths(tabListeners.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(tabListeners, 0, newTabListeners, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(tabListeners, index + 1, newTabListeners, index, tabListeners.length - index - 1);
    tabListeners = newTabListeners;
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null) {
      SWT.error__I(4);
    }
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener_1);
    return;
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    this.redraw__();
    return;
  }
  public function setBackground___3Lorg_eclipse_swt_graphics_Color_2_3I(colors: JavaArray, percents: JavaArray): void {
    this.setBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors, percents, false);
    return;
  }
  public function setBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors: JavaArray, percents: JavaArray, vertical: Boolean): void {
    this.checkWidget__();
    if (colors !== null) {
      if (percents === null || percents.length != colors.length - 1) {
        SWT.error__I(5);
      }
      for (var i: int = 0; i < percents.length; i++) {
        if (percents[i] < 0 || percents[i] > 100) {
          SWT.error__I(5);
        }
        if (i > 0 && percents[i] < percents[i - 1]) {
          SWT.error__I(5);
        }
      }
      if (this.getDisplay__().getDepth__() < 15) {
        colors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(colors[colors.length - 1]);
        percents = new JavaArray("[I").lengths();
      }
    }
    if (bgImage === null) {
      if ((gradientColors !== null) && (colors !== null) && (gradientColors.length == colors.length)) {
        var same: Boolean = false;
        for (var i_1: int = 0; i_1 < gradientColors.length; i_1++) {
          if (gradientColors[i_1] === null) {
            same = colors[i_1] === null;
          } else {
            same = gradientColors[i_1].equals__Ljava_lang_Object_2(colors[i_1]);
          }
          if (!same)
            break;
        }
        if (same) {
          for (var i_2: int = 0; i_2 < gradientPercents.length; i_2++) {
            same = gradientPercents[i_2] == percents[i_2];
            if (!same)
              break;
          }
        }
        if (same && this.gradientVertical == vertical)
          return;
      }
    } else {
      bgImage = null;
    }
    if (colors === null) {
      gradientColors = null;
      gradientPercents = null;
      gradientVertical = false;
      this.setBackground__Lorg_eclipse_swt_graphics_Color_2(Color(null));
    } else {
      gradientColors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").lengths(colors.length);
      for (var i_3: int = 0; i_3 < colors.length; ++i_3) {
        gradientColors[i_3] = colors[i_3];
      }
      gradientPercents = new JavaArray("[I").lengths(percents.length);
      for (var i_4: int = 0; i_4 < percents.length; ++i_4) {
        gradientPercents[i_4] = percents[i_4];
      }
      gradientVertical = vertical;
      this.setBackground__Lorg_eclipse_swt_graphics_Color_2(gradientColors[gradientColors.length - 1]);
    }
    this.redraw__();
    return;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
    this.checkWidget__();
    if (image === bgImage)
      return;
    if (image !== null) {
      gradientColors = null;
      gradientPercents = null;
    }
    bgImage = image;
    this.redraw__();
    return;
  }
  public function setBorderVisible__Z(show: Boolean): void {
    this.checkWidget__();
    if ((borderLeft == 1) == show)
      return;
    borderLeft = borderRight = show ? 1 : 0;
    borderTop = onBottom ? borderLeft : 0;
    borderBottom = onBottom ? 0 : borderLeft;
    var rectBefore: Rectangle = this.getClientArea__();
    this.updateItems__();
    var rectAfter: Rectangle = this.getClientArea__();
    if (!rectBefore.equals__Ljava_lang_Object_2(rectAfter)) {
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(11, new Event());
    }
    this.redraw__();
    return;
  }
  public function setButtonBounds__(): void {
    var size: Point = this.getSize__();
    var oldX: int;
    var oldY: int;
    var oldWidth: int;
    var oldHeight: int;
    oldX = maxRect.x;
    oldY = maxRect.y;
    oldWidth = maxRect.width;
    oldHeight = maxRect.height;
    maxRect.x = maxRect.y = maxRect.width = maxRect.height = 0;
    if (showMax) {
      maxRect.x = size.x - borderRight - 18 - 3;
      if (borderRight > 0)
        maxRect.x += 1;
      maxRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - 18) / 2) : borderTop + int((tabHeight - 18) / 2);
      maxRect.width = 18;
      maxRect.height = 18;
    }
    if (oldX != maxRect.x || oldWidth != maxRect.width || oldY != maxRect.y || oldHeight != maxRect.height) {
      var left: int = Math__.min__II(oldX, maxRect.x);
      var right: int = Math__.max__II(oldX + oldWidth, maxRect.x + maxRect.width);
      var top: int = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
      this.redraw__IIIIZ(left, top, right - left, tabHeight, false);
    }
    oldX = minRect.x;
    oldY = minRect.y;
    oldWidth = minRect.width;
    oldHeight = minRect.height;
    minRect.x = minRect.y = minRect.width = minRect.height = 0;
    if (showMin) {
      minRect.x = size.x - borderRight - maxRect.width - 18 - 3;
      if (borderRight > 0)
        minRect.x += 1;
      minRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - 18) / 2) : borderTop + int((tabHeight - 18) / 2);
      minRect.width = 18;
      minRect.height = 18;
    }
    if (oldX != minRect.x || oldWidth != minRect.width || oldY != minRect.y || oldHeight != minRect.height) {
      var left_1: int = Math__.min__II(oldX, minRect.x);
      var right_1: int = Math__.max__II(oldX + oldWidth, minRect.x + minRect.width);
      var top_1: int = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
      this.redraw__IIIIZ(left_1, top_1, right_1 - left_1, tabHeight, false);
    }
    oldX = topRightRect.x;
    oldY = topRightRect.y;
    oldWidth = topRightRect.width;
    oldHeight = topRightRect.height;
    topRightRect.x = topRightRect.y = topRightRect.width = topRightRect.height = 0;
    if (topRight !== null) {
      switch (topRightAlignment) {
        case 4 :
          {
            var rightEdge: int = size.x - borderRight - 3 - maxRect.width - minRect.width;
            if (!simple && borderRight > 0 && !showMax && !showMin)
              rightEdge -= 2;
            if (single) {
              if (items.length == 0 || selectedIndex == -1) {
                topRightRect.x = borderLeft + 3;
                topRightRect.width = rightEdge - topRightRect.x;
              } else {
                var item: CTabItem = items[selectedIndex];
                if (item.x + item.width + 7 + int(3 * 18 / 2) >= rightEdge)
                  break;
                topRightRect.x = item.x + item.width + 7 + int(3 * 18 / 2);
                topRightRect.width = rightEdge - topRightRect.x;
              }
            } else {
              if (showChevron)
                break;
              if (items.length == 0) {
                topRightRect.x = borderLeft + 3;
              } else {
                var item_1: CTabItem = items[items.length - 1];
                topRightRect.x = item_1.x + item_1.width;
                if (!simple && items.length - 1 == selectedIndex)
                  topRightRect.x += curveWidth - curveIndent;
              }
              topRightRect.width = Math__.max__II(0, rightEdge - topRightRect.x);
            }
            topRightRect.y = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
            topRightRect.height = tabHeight - 1;
            break;
          }
        case 131072 :
          {
            var topRightSize: Point = topRight.computeSize__IIZ(-1, tabHeight, false);
            var rightEdge_1: int = size.x - borderRight - 3 - maxRect.width - minRect.width;
            if (!simple && borderRight > 0 && !showMax && !showMin)
              rightEdge_1 -= 2;
            topRightRect.x = rightEdge_1 - topRightSize.x;
            topRightRect.width = topRightSize.x;
            topRightRect.y = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
            topRightRect.height = tabHeight - 1;
          }
      }
      topRight.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(topRightRect);
    }
    if (oldX != topRightRect.x || oldWidth != topRightRect.width || oldY != topRightRect.y || oldHeight != topRightRect.height) {
      var left_2: int = Math__.min__II(oldX, topRightRect.x);
      var right_2: int = Math__.max__II(oldX + oldWidth, topRightRect.x + topRightRect.width);
      var top_2: int = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
      this.redraw__IIIIZ(left_2, top_2, right_2 - left_2, tabHeight, false);
    }
    oldX = chevronRect.x;
    oldY = chevronRect.y;
    oldWidth = chevronRect.width;
    oldHeight = chevronRect.height;
    chevronRect.x = chevronRect.y = chevronRect.height = chevronRect.width = 0;
    if (single) {
      if (selectedIndex == -1 || items.length > 1) {
        chevronRect.width = int(3 * 18 / 2);
        chevronRect.height = 18;
        chevronRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - chevronRect.height) / 2) : borderTop + int((tabHeight - chevronRect.height) / 2);
        if (selectedIndex == -1) {
          chevronRect.x = size.x - borderRight - 3 - minRect.width - maxRect.width - topRightRect.width - chevronRect.width;
        } else {
          var item_2: CTabItem = items[selectedIndex];
          var w: int = size.x - borderRight - 3 - minRect.width - maxRect.width - chevronRect.width;
          if (topRightRect.width > 0)
            w -= topRightRect.width + 3;
          chevronRect.x = Math__.min__II(item_2.x + item_2.width + 3, w);
        }
        if (borderRight > 0)
          chevronRect.x += 1;
      }
    } else {
      if (showChevron) {
        chevronRect.width = int(3 * 18 / 2);
        chevronRect.height = 18;
        var i: int = 0;
        var lastIndex: int = -1;
        while (i < priority.length && items[priority[i]].showing) {
          lastIndex = Math__.max__II(lastIndex, priority[i++]);
        }
        if (lastIndex == -1)
          lastIndex = firstIndex;
        var lastItem: CTabItem = items[lastIndex];
        var w_1: int = lastItem.x + lastItem.width + 3;
        if (!simple && lastIndex == selectedIndex)
          w_1 += curveWidth - 2 * curveIndent;
        chevronRect.x = Math__.min__II(w_1, this.getRightItemEdge__());
        chevronRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - chevronRect.height) / 2) : borderTop + int((tabHeight - chevronRect.height) / 2);
      }
    }
    if (oldX != chevronRect.x || oldWidth != chevronRect.width || oldY != chevronRect.y || oldHeight != chevronRect.height) {
      var left_3: int = Math__.min__II(oldX, chevronRect.x);
      var right_3: int = Math__.max__II(oldX + oldWidth, chevronRect.x + chevronRect.width);
      var top_3: int = onBottom ? size.y - borderBottom - tabHeight : borderTop + 1;
      this.redraw__IIIIZ(left_3, top_3, right_3 - left_3, tabHeight, false);
    }
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (font_1 !== null && font_1.equals__Ljava_lang_Object_2(this.getFont__()))
      return;
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    oldFont = this.getFont__();
    if (!this.updateTabHeight__Z(false)) {
      this.updateItems__();
      this.redraw__();
    }
    return;
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    this.redraw__();
    return;
  }
  public function setInsertMark__Lorg_eclipse_swt_custom_CTabItem_2Z(item: CTabItem, after: Boolean): void {
    this.checkWidget__();
    return;
  }
  public function setInsertMark__IZ(index: int, after: Boolean): void {
    this.checkWidget__();
    if (index < -1 || index >= this.getItemCount__()) {
      SWT.error__I(5);
    }
    return;
  }
  public function setItemLocation__(): Boolean {
    var changed: Boolean = false;
    if (items.length == 0)
      return false;
    var size: Point = this.getSize__();
    var y_1: int = onBottom ? Math__.max__II(borderBottom, size.y - borderBottom - tabHeight) : borderTop;
    if (single) {
      var defaultX: int = this.getDisplay__().getBounds__().width + 10;
      for (var i: int = 0; i < items.length; i++) {
        var item: CTabItem = items[i];
        if (i == selectedIndex) {
          firstIndex = selectedIndex;
          var oldX: int = item.x;
          var oldY: int = item.y;
          item.x = borderLeft;
          item.y = y_1;
          item.showing = true;
          if (showClose || item.showClose) {
            item.closeRect.x = borderLeft + 4;
            item.closeRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - 18) / 2) : borderTop + int((tabHeight - 18) / 2);
          }
          if (item.x != oldX || item.y != oldY)
            changed = true;
        } else {
          item.x = defaultX;
          item.showing = false;
        }
      }
    } else {
      var rightItemEdge: int = this.getRightItemEdge__();
      var maxWidth: int = rightItemEdge - borderLeft;
      var width_1: int = 0;
      for (var i_1: int = 0; i_1 < priority.length; i_1++) {
        var item_1: CTabItem = items[priority[i_1]];
        width_1 += item_1.width;
        item_1.showing = i_1 == 0 ? true : item_1.width > 0 && width_1 <= maxWidth;
        if (!simple && priority[i_1] == selectedIndex)
          width_1 += curveWidth - 2 * curveIndent;
      }
      var x_1: int = 0;
      var defaultX_1: int = this.getDisplay__().getBounds__().width + 10;
      firstIndex = items.length - 1;
      for (var i_2: int = 0; i_2 < items.length; i_2++) {
        var item_2: CTabItem = items[i_2];
        if (!item_2.showing) {
          if (item_2.x != defaultX_1)
            changed = true;
          item_2.x = defaultX_1;
        } else {
          firstIndex = Math__.min__II(firstIndex, i_2);
          if (item_2.x != x_1 || item_2.y != y_1)
            changed = true;
          item_2.x = x_1;
          item_2.y = y_1;
          if (i_2 == selectedIndex) {
            var edge: int = Math__.min__II(item_2.x + item_2.width, rightItemEdge);
            item_2.closeRect.x = edge - 4 - 18;
          } else {
            item_2.closeRect.x = item_2.x + item_2.width - 4 - 18;
          }
          item_2.closeRect.y = onBottom ? size.y - borderBottom - tabHeight + int((tabHeight - 18) / 2) : borderTop + int((tabHeight - 18) / 2);
          x_1 = x_1 + item_2.width;
          if (!simple && i_2 == selectedIndex)
            x_1 += curveWidth - 2 * curveIndent;
        }
      }
    }
    return changed;
  }
  public function setItemSize__(): Boolean {
    var changed: Boolean = false;
    if (this.isDisposed__())
      return changed;
    var size: Point = this.getSize__();
    if (size.x <= 0 || size.y <= 0)
      return changed;
    xClient = borderLeft + marginWidth + highlight_margin;
    if (onBottom) {
      yClient = borderTop + highlight_margin + marginHeight;
    } else {
      yClient = borderTop + tabHeight + highlight_header + marginHeight;
    }
    showChevron = false;
    if (single) {
      showChevron = true;
      if (selectedIndex != -1) {
        var tab: CTabItem = items[selectedIndex];
        var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
        var width_1: int = tab.preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, true, false);
        gc.dispose__();
        width_1 = Math__.min__II(width_1, this.getRightItemEdge__() - borderLeft);
        if (tab.height != tabHeight || tab.width != width_1) {
          changed = true;
          tab.shortenedText = null;
          tab.shortenedTextWidth = 0;
          tab.height = tabHeight;
          tab.width = width_1;
          tab.closeRect.width = tab.closeRect.height = 0;
          if (showClose || tab.showClose) {
            tab.closeRect.width = 18;
            tab.closeRect.height = 18;
          }
        }
      }
      return changed;
    }
    if (items.length == 0)
      return changed;
    var widths: JavaArray;
    var gc_1: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
    var tabAreaWidth: int = size.x - borderLeft - borderRight - 3;
    if (showMin)
      tabAreaWidth -= 18;
    if (showMax)
      tabAreaWidth -= 18;
    if (topRightAlignment == 131072 && topRight !== null) {
      var rightSize: Point = topRight.computeSize__IIZ(-1, -1, false);
      tabAreaWidth -= rightSize.x + 3;
    }
    if (!simple)
      tabAreaWidth -= curveWidth - 2 * curveIndent;
    tabAreaWidth = Math__.max__II(0, tabAreaWidth);
    var minWidth: int = 0;
    var minWidths: JavaArray = new JavaArray("[I").lengths(items.length);
    for (var i: int = 0; i < priority.length; i++) {
      var index: int = priority[i];
      minWidths[index] = items[index].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc_1, index == selectedIndex, true);
      minWidth += minWidths[index];
      if (minWidth > tabAreaWidth)
        break;
    }
    if (minWidth > tabAreaWidth) {
      showChevron = items.length > 1;
      if (showChevron)
        tabAreaWidth -= int(3 * 18 / 2);
      widths = minWidths;
      var index_1: int = selectedIndex != -1 ? selectedIndex : 0;
      if (tabAreaWidth < widths[index_1]) {
        widths[index_1] = Math__.max__II(0, tabAreaWidth);
      }
    } else {
      var maxWidth: int = 0;
      var maxWidths: JavaArray = new JavaArray("[I").lengths(items.length);
      for (var i_1: int = 0; i_1 < items.length; i_1++) {
        maxWidths[i_1] = items[i_1].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc_1, i_1 == selectedIndex, false);
        maxWidth += maxWidths[i_1];
      }
      if (maxWidth <= tabAreaWidth) {
        widths = maxWidths;
      } else {
        var extra: int = int((tabAreaWidth - minWidth) / items.length);
        while (true) {
          var large: int = 0;
          var totalWidth: int = 0;
          for (var i_2: int = 0; i_2 < items.length; i_2++) {
            if (maxWidths[i_2] > minWidths[i_2] + extra) {
              totalWidth += minWidths[i_2] + extra;
              large++;
            } else {
              totalWidth += maxWidths[i_2];
            }
          }
          if (totalWidth >= tabAreaWidth) {
            extra--;
            break;
          }
          if (large == 0 || tabAreaWidth - totalWidth < large)
            break;
          extra++;
        }
        widths = new JavaArray("[I").lengths(items.length);
        for (var i_3: int = 0; i_3 < items.length; i_3++) {
          widths[i_3] = Math__.min__II(maxWidths[i_3], minWidths[i_3] + extra);
        }
      }
    }
    gc_1.dispose__();
    for (var i_4: int = 0; i_4 < items.length; i_4++) {
      var tab_1: CTabItem = items[i_4];
      var width_2: int = widths[i_4];
      if (tab_1.height != tabHeight || tab_1.width != width_2) {
        changed = true;
        tab_1.shortenedText = null;
        tab_1.shortenedTextWidth = 0;
        tab_1.height = tabHeight;
        tab_1.width = width_2;
        tab_1.closeRect.width = tab_1.closeRect.height = 0;
        if (showClose || tab_1.showClose) {
          if (i_4 == selectedIndex || showUnselectedClose) {
            tab_1.closeRect.width = 18;
            tab_1.closeRect.height = 18;
          }
        }
      }
    }
    return changed;
  }
  public function setMaximizeVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (showMax == visible)
      return;
    showMax = visible;
    this.updateItems__();
    this.redraw__();
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setMaximized__Z(maximize: Boolean): void {
    this.checkWidget__();
    if (this.maximized == maximize)
      return;
    if (maximize && this.minimized)
      this.setMinimized__Z(false);
    this.maximized = maximize;
    this.redraw__IIIIZ(maxRect.x, maxRect.y, maxRect.width, maxRect.height, false);
  }
  public function setMinimizeVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (showMin == visible)
      return;
    showMin = visible;
    this.updateItems__();
    this.redraw__();
  }
  public function setMinimized__Z(minimize: Boolean): void {
    this.checkWidget__();
    if (this.minimized == minimize)
      return;
    if (minimize && this.maximized)
      this.setMaximized__Z(false);
    this.minimized = minimize;
    this.redraw__IIIIZ(minRect.x, minRect.y, minRect.width, minRect.height, false);
  }
  public function setMinimumCharacters__I(count: int): void {
    this.checkWidget__();
    if (count < 0)
      SWT.error__I(6);
    if (minChars == count)
      return;
    minChars = count;
    if (this.updateItems__())
      this.redrawTabs__();
  }
  public function setMRUVisible__Z(show: Boolean): void {
    this.checkWidget__();
    if (mru == show)
      return;
    mru = show;
    if (!mru) {
      var idx: int = firstIndex;
      var next: int = 0;
      for (var i: int = firstIndex; i < items.length; i++) {
        priority[next++] = i;
      }
      for (var i_1: int = 0; i_1 < idx; i_1++) {
        priority[next++] = i_1;
      }
      if (this.updateItems__())
        this.redrawTabs__();
    }
    return;
  }
  public function setSelection__Lorg_eclipse_swt_custom_CTabItem_2(item: CTabItem): void {
    this.checkWidget__();
    if (item === null)
      SWT.error__I(4);
    var index: int = this.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(item);
    this.setSelection__I(index);
    return;
  }
  public function setSelection__I(index: int): void {
    this.checkWidget__();
    if (index < 0 || index >= items.length)
      return;
    var selection: CTabItem = items[index];
    if (selectedIndex == index) {
      this.showItem__Lorg_eclipse_swt_custom_CTabItem_2(selection);
      return;
    }
    var oldIndex: int = selectedIndex;
    selectedIndex = index;
    if (oldIndex != -1) {
      items[oldIndex].closeImageState = 0;
    }
    selection.closeImageState = 1;
    selection.showing = false;
    var newControl: Control = selection.control;
    var oldControl: Control = null;
    if (oldIndex != -1) {
      oldControl = items[oldIndex].control;
    }
    if (newControl !== oldControl) {
      if (newControl !== null && !newControl.isDisposed__()) {
        newControl.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(this.getClientArea__());
        newControl.setVisible__Z(true);
      }
      if (oldControl !== null && !oldControl.isDisposed__()) {
        oldControl.setVisible__Z(false);
      }
    }
    this.showItem__Lorg_eclipse_swt_custom_CTabItem_2(selection);
    this.redraw__();
    return;
  }
  public function setSelection__IZ(index: int, notify: Boolean): void {
    var oldSelectedIndex: int = selectedIndex;
    this.setSelection__I(index);
    if (notify && selectedIndex != oldSelectedIndex && selectedIndex != -1) {
      var event: Event = new Event();
      event.item = this.getItem__I(selectedIndex);
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, event);
    }
    return;
  }
  public function setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    this.setSelectionHighlightGradientColor__Lorg_eclipse_swt_graphics_Color_2(null);
    if (selectionBackground === color)
      return;
    if (color === null)
      color = this.getDisplay__().getSystemColor__I(25);
    selectionBackground = color;
    if (selectedIndex > -1)
      this.redraw__();
  }
  public function setSelectionBackground___3Lorg_eclipse_swt_graphics_Color_2_3I(colors: JavaArray, percents: JavaArray): void {
    this.setSelectionBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors, percents, false);
  }
  public function setSelectionBackground___3Lorg_eclipse_swt_graphics_Color_2_3IZ(colors: JavaArray, percents: JavaArray, vertical: Boolean): void {
    this.checkWidget__();
    var colorsLength: int;
    var highlightBeginColor: Color = null;
    if (colors !== null) {
      if (percents === null || !((percents.length == colors.length - 1) || (percents.length == colors.length - 2))) {
        SWT.error__I(5);
      }
      for (var i: int = 0; i < percents.length; i++) {
        if (percents[i] < 0 || percents[i] > 100) {
          SWT.error__I(5);
        }
        if (i > 0 && percents[i] < percents[i - 1]) {
          SWT.error__I(5);
        }
      }
      if (percents.length == colors.length - 2) {
        highlightBeginColor = colors[colors.length - 1];
        colorsLength = colors.length - 1;
      } else {
        colorsLength = colors.length;
      }
      if (this.getDisplay__().getDepth__() < 15) {
        colors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(colors[colorsLength - 1]);
        colorsLength = colors.length;
        percents = new JavaArray("[I").lengths();
      }
    } else {
      colorsLength = 0;
    }
    if (selectionBgImage === null) {
      if ((selectionGradientColors !== null) && (colors !== null) && (selectionGradientColors.length == colorsLength)) {
        var same: Boolean = false;
        for (var i_1: int = 0; i_1 < selectionGradientColors.length; i_1++) {
          if (selectionGradientColors[i_1] === null) {
            same = colors[i_1] === null;
          } else {
            same = selectionGradientColors[i_1].equals__Ljava_lang_Object_2(colors[i_1]);
          }
          if (!same)
            break;
        }
        if (same) {
          for (var i_2: int = 0; i_2 < selectionGradientPercents.length; i_2++) {
            same = selectionGradientPercents[i_2] == percents[i_2];
            if (!same)
              break;
          }
        }
        if (same && this.selectionGradientVertical == vertical)
          return;
      }
    } else {
      selectionBgImage = null;
    }
    if (colors === null) {
      selectionGradientColors = null;
      selectionGradientPercents = null;
      selectionGradientVertical = false;
      this.setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(Color(null));
      this.setSelectionHighlightGradientColor__Lorg_eclipse_swt_graphics_Color_2(null);
    } else {
      selectionGradientColors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").lengths(colorsLength);
      for (var i_3: int = 0; i_3 < colorsLength; ++i_3) {
        selectionGradientColors[i_3] = colors[i_3];
      }
      selectionGradientPercents = new JavaArray("[I").lengths(percents.length);
      for (var i_4: int = 0; i_4 < percents.length; ++i_4) {
        selectionGradientPercents[i_4] = percents[i_4];
      }
      selectionGradientVertical = vertical;
      this.setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(selectionGradientColors[selectionGradientColors.length - 1]);
      this.setSelectionHighlightGradientColor__Lorg_eclipse_swt_graphics_Color_2(highlightBeginColor);
    }
    if (selectedIndex > -1)
      this.redraw__();
    return;
  }
  public function setSelectionHighlightGradientColor__Lorg_eclipse_swt_graphics_Color_2(start: Color): void {
    selectionHighlightGradientBegin = null;
    if (start === null)
      return;
    if (this.getDisplay__().getDepth__() < 15)
      return;
    if (selectionGradientColors.length < 2)
      return;
    selectionHighlightGradientBegin = start;
    if (!this.isSelectionHighlightColorsCacheHit__Lorg_eclipse_swt_graphics_Color_2(start))
      this.createSelectionHighlightGradientColors__Lorg_eclipse_swt_graphics_Color_2(start);
  }
  public function isSelectionHighlightColorsCacheHit__Lorg_eclipse_swt_graphics_Color_2(start: Color): Boolean {
    if (selectionHighlightGradientColorsCache === null)
      return false;
    if (selectionHighlightGradientColorsCache.length < 2)
      return false;
    var highlightBegin: Color = selectionHighlightGradientColorsCache[0];
    var highlightEnd: Color = selectionHighlightGradientColorsCache[selectionHighlightGradientColorsCache.length - 1];
    if (!highlightBegin.equals__Ljava_lang_Object_2(start))
      return false;
    if (selectionHighlightGradientColorsCache.length != tabHeight)
      return false;
    if (!highlightEnd.equals__Ljava_lang_Object_2(selectionBackground))
      return false;
    return true;
  }
  public function setSelectionBackground__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
    this.checkWidget__();
    this.setSelectionHighlightGradientColor__Lorg_eclipse_swt_graphics_Color_2(null);
    if (image === selectionBgImage)
      return;
    if (image !== null) {
      selectionGradientColors = null;
      selectionGradientPercents = null;
      this.disposeSelectionHighlightGradientColors__();
    }
    selectionBgImage = image;
    if (selectedIndex > -1)
      this.redraw__();
    return;
  }
  public function setSelectionForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (selectionForeground === color)
      return;
    if (color === null)
      color = this.getDisplay__().getSystemColor__I(24);
    selectionForeground = color;
    if (selectedIndex > -1)
      this.redraw__();
  }
  public function createSelectionHighlightGradientColors__Lorg_eclipse_swt_graphics_Color_2(start: Color): void {
    this.disposeSelectionHighlightGradientColors__();
    if (start === null)
      return;
    var fadeGradientSize: int = tabHeight;
    var from: RGB = start.getRGB__();
    var to_1: RGB = selectionBackground.getRGB__();
    selectionHighlightGradientColorsCache = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").lengths(fadeGradientSize);
    var denom: int = fadeGradientSize - 1;
    for (var i: int = 0; i < fadeGradientSize; i++) {
      var propFrom: int = denom - i;
      var propTo: int = i;
      var red: int = int((to_1.red * propTo + from.red * propFrom) / denom);
      var green: int = int((to_1.green * propTo + from.green * propFrom) / denom);
      var blue: int = int((to_1.blue * propTo + from.blue * propFrom) / denom);
      selectionHighlightGradientColorsCache[i] = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [this.getDisplay__(), red, green, blue]));
    }
    return;
  }
  public function disposeSelectionHighlightGradientColors__(): void {
    if (selectionHighlightGradientColorsCache === null)
      return;
    for (var i: int = 0; i < selectionHighlightGradientColorsCache.length; i++) {
      selectionHighlightGradientColorsCache[i].dispose__();
    }
    selectionHighlightGradientColorsCache = null;
    return;
  }
  public function getSelectionBackgroundGradientBegin__(): Color {
    if (selectionGradientColors === null)
      return this.getSelectionBackground__();
    if (selectionGradientColors.length == 0)
      return this.getSelectionBackground__();
    return selectionGradientColors[0];
  }
  public function setSimple__Z(simple_1: Boolean): void {
    this.checkWidget__();
    if (this.simple != simple_1) {
      this.simple = simple_1;
      var rectBefore: Rectangle = this.getClientArea__();
      this.updateItems__();
      var rectAfter: Rectangle = this.getClientArea__();
      if (!rectBefore.equals__Ljava_lang_Object_2(rectAfter)) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(11, new Event());
      }
      this.redraw__();
    }
    return;
  }
  public function setSingle__Z(single_1: Boolean): void {
    this.checkWidget__();
    if (this.single != single_1) {
      this.single = single_1;
      if (!single_1) {
        for (var i: int = 0; i < items.length; i++) {
          if (i != selectedIndex && items[i].closeImageState == 1) {
            items[i].closeImageState = 0;
          }
        }
      }
      var rectBefore: Rectangle = this.getClientArea__();
      this.updateItems__();
      var rectAfter: Rectangle = this.getClientArea__();
      if (!rectBefore.equals__Ljava_lang_Object_2(rectAfter)) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(11, new Event());
      }
      this.redraw__();
    }
    return;
  }
  public function setTabHeight__I(height_1: int): void {
    this.checkWidget__();
    if (height_1 < -1) {
      SWT.error__I(5);
    }
    fixedTabHeight = height_1;
    this.updateTabHeight__Z(false);
    return;
  }
  public function setTabPosition__I(position: int): void {
    this.checkWidget__();
    if (position != 128 && position != 1024) {
      SWT.error__I(5);
    }
    if (onBottom != (position == 1024)) {
      onBottom = position == 1024;
      borderTop = onBottom ? borderLeft : 0;
      borderBottom = onBottom ? 0 : borderRight;
      this.updateTabHeight__Z(true);
      var rectBefore: Rectangle = this.getClientArea__();
      this.updateItems__();
      var rectAfter: Rectangle = this.getClientArea__();
      if (!rectBefore.equals__Ljava_lang_Object_2(rectAfter)) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(11, new Event());
      }
      this.redraw__();
    }
    return;
  }
  public function setTopRight__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.setTopRight__Lorg_eclipse_swt_widgets_Control_2I(control, 131072);
    return;
  }
  public function setTopRight__Lorg_eclipse_swt_widgets_Control_2I(control: Control, alignment: int): void {
    this.checkWidget__();
    if (alignment != 131072 && alignment != 4) {
      SWT.error__I(5);
    }
    if (control !== null && control.getParent__() !== this) {
      SWT.error__I(5);
    }
    topRight = control;
    topRightAlignment = alignment;
    if (this.updateItems__())
      this.redraw__();
    return;
  }
  public function setUnselectedCloseVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (showUnselectedClose == visible)
      return;
    showUnselectedClose = visible;
    this.updateItems__();
    this.redraw__();
  }
  public function setUnselectedImageVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (showUnselectedImage == visible)
      return;
    showUnselectedImage = visible;
    this.updateItems__();
    this.redraw__();
  }
  public function showItem__Lorg_eclipse_swt_custom_CTabItem_2(item: CTabItem): void {
    this.checkWidget__();
    if (item === null)
      SWT.error__I(4);
    if (item.isDisposed__())
      SWT.error__I(5);
    var index: int = this.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(item);
    if (index == -1)
      SWT.error__I(5);
    var idx: int = -1;
    for (var i: int = 0; i < priority.length; i++) {
      if (priority[i] == index) {
        idx = i;
        break;
      }
    }
    if (mru) {
      var newPriority: JavaArray = new JavaArray("[I").lengths(priority.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(priority, 0, newPriority, 1, idx);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(priority, idx + 1, newPriority, idx + 1, priority.length - idx - 1);
      newPriority[0] = index;
      priority = newPriority;
    }
    if (item.isShowing__())
      return;
    this.updateItems__I(index);
    this.redrawTabs__();
  }
  public function showList__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (items.length == 0 || !showChevron)
      return;
    if (showMenu === null || showMenu.isDisposed__()) {
      showMenu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Control_2, [this]));
    } else {
      var items_1: JavaArray = showMenu.getItems__();
      for (var i: int = 0; i < items_1.length; i++) {
        items_1[i].dispose__();
      }
    }
    var id: String = "CTabFolder_showList_Index";
    for (var i_1: int = 0; i_1 < items.length; i_1++) {
      var tab: CTabItem = items[i_1];
      if (tab.showing)
        continue;
      var item: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [showMenu, 0]));
      item.setText__Ljava_lang_String_2(tab.getText__());
      item.setImage__Lorg_eclipse_swt_graphics_Image_2(tab.getImage__());
      item.setData__Ljava_lang_String_2Ljava_lang_Object_2("CTabFolder_showList_Index", tab);
      item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.custom.CTabFolder$6(this));
    }
    var x_1: int = rect.x;
    var y_1: int = rect.y + rect.height;
    var location: Point = this.getDisplay__().map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(this, null, x_1, y_1);
    showMenu.setLocation__II(location.x, location.y);
    showMenu.setVisible__Z(true);
    return;
  }
  public function showSelection__(): void {
    this.checkWidget__();
    if (selectedIndex != -1) {
      this.showItem__Lorg_eclipse_swt_custom_CTabItem_2(this.getSelection__());
    }
    return;
  }
  public function _setToolTipText__II(x_1: int, y_1: int): void {
    var oldTip: String = this.getToolTipText__();
    var newTip: String = this._getToolTip__II(x_1, y_1);
    if (newTip === null || !Object(newTip).equals__Ljava_lang_Object_2(oldTip)) {
      this.setToolTipText__Ljava_lang_String_2(newTip);
    }
    return;
  }
  public function updateItems__(): Boolean {
    return this.updateItems__I(selectedIndex);
  }
  public function updateItems__I(showIndex: int): Boolean {
    if (!single && !mru && showIndex != -1) {
      var firstIndex_1: int = showIndex;
      if (priority[0] < showIndex) {
        var maxWidth: int = this.getRightItemEdge__() - borderLeft;
        if (!simple)
          maxWidth -= curveWidth - 2 * curveIndent;
        var width_1: int = 0;
        var widths: JavaArray = new JavaArray("[I").lengths(items.length);
        var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
        for (var i: int = priority[0]; i <= showIndex; i++) {
          widths[i] = items[i].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, i == selectedIndex, true);
          width_1 += widths[i];
          if (width_1 > maxWidth)
            break;
        }
        if (width_1 > maxWidth) {
          width_1 = 0;
          for (var i_1: int = showIndex; i_1 >= 0; i_1--) {
            if (widths[i_1] == 0)
              widths[i_1] = items[i_1].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, i_1 == selectedIndex, true);
            width_1 += widths[i_1];
            if (width_1 > maxWidth)
              break;
            firstIndex_1 = i_1;
          }
        } else {
          firstIndex_1 = priority[0];
          for (var i_2: int = showIndex + 1; i_2 < items.length; i_2++) {
            widths[i_2] = items[i_2].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, i_2 == selectedIndex, true);
            width_1 += widths[i_2];
            if (width_1 >= maxWidth)
              break;
          }
          if (width_1 < maxWidth) {
            for (var i_3: int = priority[0] - 1; i_3 >= 0; i_3--) {
              if (widths[i_3] == 0)
                widths[i_3] = items[i_3].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, i_3 == selectedIndex, true);
              width_1 += widths[i_3];
              if (width_1 > maxWidth)
                break;
              firstIndex_1 = i_3;
            }
          }
        }
        gc.dispose__();
      }
      if (firstIndex_1 != priority[0]) {
        var index: int = 0;
        for (var i_4: int = firstIndex_1; i_4 < items.length; i_4++) {
          priority[index++] = i_4;
        }
        for (var i_5: int = 0; i_5 < firstIndex_1; i_5++) {
          priority[index++] = i_5;
        }
      }
    }
    var oldShowChevron: Boolean = showChevron;
    var changed: Boolean = this.setItemSize__();
    changed = (changed) ? (this.setItemLocation__(), true) : (this.setItemLocation__());
    this.setButtonBounds__();
    changed = (changed) ? (showChevron != oldShowChevron, true) : (showChevron != oldShowChevron);
    if (changed && this.getToolTipText__() !== null) {
      var pt: Point = this.getDisplay__().getCursorLocation__();
      pt = this.toControl__Lorg_eclipse_swt_graphics_Point_2(pt);
      this._setToolTipText__II(pt.x, pt.y);
    }
    return changed;
  }
  public function updateTabHeight__Z(force: Boolean): Boolean {
    var style_1: int = this.getStyle__();
    if (fixedTabHeight == 0 && (style_1 & 8388608) != 0 && (style_1 & 2048) == 0)
      highlight_header = 0;
    var oldHeight: int = tabHeight;
    if (fixedTabHeight != -1) {
      tabHeight = fixedTabHeight == 0 ? 0 : fixedTabHeight + 1;
    } else {
      var tempHeight: int = 0;
      var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [this]));
      if (items.length == 0) {
        tempHeight = gc.textExtent__Ljava_lang_String_2I("Default", 9).y + 2 + 2;
      } else {
        for (var i: int = 0; i < items.length; i++) {
          tempHeight = Math__.max__II(tempHeight, items[i].preferredHeight__Lorg_eclipse_swt_graphics_GC_2(gc));
        }
      }
      gc.dispose__();
      tabHeight = tempHeight;
    }
    if (!force && tabHeight == oldHeight)
      return false;
    oldSize = null;
    if (onBottom) {
      var d: int = tabHeight - 12;
      curve = new JavaArray("[I").values(0, 13 + d, 0, 12 + d, 2, 12 + d, 3, 11 + d, 5, 11 + d, 6, 10 + d, 7, 10 + d, 9, 8 + d, 10, 8 + d, 11, 7 + d, 11 + d, 7, 12 + d, 6, 13 + d, 6, 15 + d, 4, 16 + d, 4, 17 + d, 3, 19 + d, 3, 20 + d, 2, 22 + d, 2, 23 + d, 1);
      curveWidth = 26 + d;
      curveIndent = int(curveWidth / 3);
    } else {
      var d_1: int = tabHeight - 12;
      curve = new JavaArray("[I").values(0, 0, 0, 1, 2, 1, 3, 2, 5, 2, 6, 3, 7, 3, 9, 5, 10, 5, 11, 6, 11 + d_1, 6 + d_1, 12 + d_1, 7 + d_1, 13 + d_1, 7 + d_1, 15 + d_1, 9 + d_1, 16 + d_1, 9 + d_1, 17 + d_1, 10 + d_1, 19 + d_1, 10 + d_1, 20 + d_1, 11 + d_1, 22 + d_1, 11 + d_1, 23 + d_1, 12 + d_1);
      curveWidth = 26 + d_1;
      curveIndent = int(curveWidth / 3);
      topCurveHighlightStart = new JavaArray("[I").values(0, 2, 1, 2, 2, 2, 3, 3, 4, 3, 5, 3, 6, 4, 7, 4, 8, 5, 9, 6, 10, 6);
      topCurveHighlightEnd = new JavaArray("[I").values(10 + d_1, 6 + d_1, 11 + d_1, 7 + d_1, 12 + d_1, 8 + d_1, 13 + d_1, 8 + d_1, 14 + d_1, 9 + d_1, 15 + d_1, 10 + d_1, 16 + d_1, 10 + d_1, 17 + d_1, 11 + d_1, 18 + d_1, 11 + d_1, 19 + d_1, 11 + d_1, 20 + d_1, 12 + d_1, 21 + d_1, 12 + d_1, 22 + d_1, 12 + d_1);
    }
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(11, new Event());
    return true;
  }
  public function _getToolTip__II(x_1: int, y_1: int): String {
    if (showMin && minRect.contains__II(x_1, y_1))
      return minimized ? SWT.getMessage__Ljava_lang_String_2("SWT_Restore") : SWT.getMessage__Ljava_lang_String_2("SWT_Minimize");
    if (showMax && maxRect.contains__II(x_1, y_1))
      return maximized ? SWT.getMessage__Ljava_lang_String_2("SWT_Restore") : SWT.getMessage__Ljava_lang_String_2("SWT_Maximize");
    if (showChevron && chevronRect.contains__II(x_1, y_1))
      return SWT.getMessage__Ljava_lang_String_2("SWT_ShowList");
    var item: CTabItem = this.getItem__Lorg_eclipse_swt_graphics_Point_2(new Point(x_1, y_1));
    if (item === null)
      return null;
    if (!item.showing)
      return null;
    if ((showClose || item.showClose) && item.closeRect.contains__II(x_1, y_1)) {
      return SWT.getMessage__Ljava_lang_String_2("SWT_Close");
    }
    return item.getToolTipText__();
  }
}
}
