package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.GC;
import java.lang.Math__;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabFolderLayout extends Layout {
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var folder: CTabFolder = CTabFolder(composite);
    var items: JavaArray = folder.items;
    var tabW: int = 0;
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [folder]));
    for (var i: int = 0; i < items.length; i++) {
      if (folder.single) {
        tabW = Math__.max__II(tabW, items[i].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, true, false));
      } else {
        tabW += items[i].preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc, i == folder.selectedIndex, false);
      }
    }
    gc.dispose__();
    tabW += 3;
    if (folder.showMax)
      tabW += 18;
    if (folder.showMin)
      tabW += 18;
    if (folder.single)
      tabW += int(3 * 18 / 2);
    if (folder.topRight !== null) {
      var pt: Point = folder.topRight.computeSize__IIZ(-1, folder.tabHeight, flushCache);
      tabW += 3 + pt.x;
    }
    if (!folder.single && !folder.simple)
      tabW += folder.curveWidth - 2 * folder.curveIndent;
    var controlW: int = 0;
    var controlH: int = 0;
    for (var i_1: int = 0; i_1 < items.length; i_1++) {
      var control: Control = items[i_1].getControl__();
      if (control !== null && !control.isDisposed__()) {
        var size: Point = control.computeSize__IIZ(wHint, hHint, flushCache);
        controlW = Math__.max__II(controlW, size.x);
        controlH = Math__.max__II(controlH, size.y);
      }
    }
    var minWidth: int = Math__.max__II(tabW, controlW);
    var minHeight: int = (folder.minimized) ? 0 : controlH;
    if (minWidth == 0)
      minWidth = 64;
    if (minHeight == 0)
      minHeight = 64;
    if (wHint != -1)
      minWidth = wHint;
    if (hHint != -1)
      minHeight = hHint;
    return new Point(minWidth, minHeight);
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var folder: CTabFolder = CTabFolder(composite);
    if (folder.selectedIndex != -1) {
      var control: Control = folder.items[folder.selectedIndex].getControl__();
      if (control !== null && !control.isDisposed__()) {
        control.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(folder.getClientArea__());
      }
    }
    return;
  }
}
}
