package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import java.lang.Math__;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabItem extends Item {
  internal var parent: CTabFolder;
  internal var x: int;
  internal var y: int;
  internal var width: int;
  internal var height: int = 0;
  internal var control: Control;
  internal var toolTipText: String;
  internal var shortenedText: String;
  internal var shortenedTextWidth: int;
  internal var font: Font;
  internal var disabledImage: Image;
  internal var closeRect: Rectangle = new Rectangle(0, 0, 0, 0);
  internal var closeImageState: int = 0;
  internal var showClose: Boolean = false;
  internal var showing: Boolean = false;
  public static const TOP_MARGIN: int = 2;
  public static const BOTTOM_MARGIN: int = 2;
  public static const LEFT_MARGIN: int = 4;
  public static const RIGHT_MARGIN: int = 4;
  public static const INTERNAL_SPACING: int = 4;
  public static const FLAGS: int = 1 | 8;
  public static const ELLIPSIS: String = "...";
  public function CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2I(parent: CTabFolder, style: int): Object {
    return this;
  }
  public function CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2II(parent: CTabFolder, style: int, index: int): Object {
    showClose = (style & 64) != 0;
    parent.createItem__Lorg_eclipse_swt_custom_CTabItem_2I(this, index);
    return this;
  }
  public function useEllipses__(): Boolean {
    return parent.simple;
  }
  public function shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2I(gc: GC, text_1: String, width_1: int): String {
    return this.useEllipses__() ? this.shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2ILjava_lang_String_2(gc, text_1, width_1, "...") : this.shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2ILjava_lang_String_2(gc, text_1, width_1, "");
  }
  public function shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2ILjava_lang_String_2(gc: GC, text_1: String, width_1: int, ellipses: String): String {
    if (gc.textExtent__Ljava_lang_String_2I(text_1, 9).x <= width_1)
      return text_1;
    var ellipseWidth: int = gc.textExtent__Ljava_lang_String_2I(ellipses, 9).x;
    var length: int = Object(text_1).length__();
    var layout: TextLayout = new TextLayout(this.getDisplay__());
    layout.setText__Ljava_lang_String_2(text_1);
    var end: int = layout.getPreviousOffset__II(length, 2);
    while (end > 0) {
      text_1 = Object(text_1).substring__II(0, end);
      var l: int = gc.textExtent__Ljava_lang_String_2I(text_1, 9).x;
      if (l + ellipseWidth <= width_1) {
        break;
      }
      end = layout.getPreviousOffset__II(end, 2);
    }
    layout.dispose__();
    return end == 0 ? Object(text_1).substring__II(0, 1) : text_1 + ellipses;
  }
  public override function dispose__(): void {
    if (this.isDisposed__())
      return;
    parent.destroyItem__Lorg_eclipse_swt_custom_CTabItem_2(this);
    super.dispose__();
    parent = null;
    control = null;
    toolTipText = null;
    shortenedText = null;
    font = null;
  }
  public function drawClose__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (closeRect.width == 0 || closeRect.height == 0)
      return;
    var display_1: Display = this.getDisplay__();
    var indent: int = Math__.max__II(1, int((18 - 9) / 2));
    var x_1: int = closeRect.x + indent;
    var y_1: int = closeRect.y + indent;
    y_1 += parent.onBottom ? -1 : 1;
    var closeBorder: Color = display_1.getSystemColor__I(17);
    switch (closeImageState) {
      case 1 :
        {
          var shape: JavaArray = new JavaArray("[I").values(x_1, y_1, x_1 + 2, y_1, x_1 + 4, y_1 + 2, x_1 + 5, y_1 + 2, x_1 + 7, y_1, x_1 + 9, y_1, x_1 + 9, y_1 + 2, x_1 + 7, y_1 + 4, x_1 + 7, y_1 + 5, x_1 + 9, y_1 + 7, x_1 + 9, y_1 + 9, x_1 + 7, y_1 + 9, x_1 + 5, y_1 + 7, x_1 + 4, y_1 + 7, x_1 + 2, y_1 + 9, x_1, y_1 + 9, x_1, y_1 + 7, x_1 + 2, y_1 + 5, x_1 + 2, y_1 + 4, x_1, y_1 + 2);
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(25));
          gc.fillPolygon___3I(shape);
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(closeBorder);
          gc.drawPolygon___3I(shape);
          break;
        }
      case 2 :
        {
          var shape_1: JavaArray = new JavaArray("[I").values(x_1, y_1, x_1 + 2, y_1, x_1 + 4, y_1 + 2, x_1 + 5, y_1 + 2, x_1 + 7, y_1, x_1 + 9, y_1, x_1 + 9, y_1 + 2, x_1 + 7, y_1 + 4, x_1 + 7, y_1 + 5, x_1 + 9, y_1 + 7, x_1 + 9, y_1 + 9, x_1 + 7, y_1 + 9, x_1 + 5, y_1 + 7, x_1 + 4, y_1 + 7, x_1 + 2, y_1 + 9, x_1, y_1 + 9, x_1, y_1 + 7, x_1 + 2, y_1 + 5, x_1 + 2, y_1 + 4, x_1, y_1 + 2);
          var fill: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display_1, CTabFolder.CLOSE_FILL]));
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(fill);
          gc.fillPolygon___3I(shape_1);
          fill.dispose__();
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(closeBorder);
          gc.drawPolygon___3I(shape_1);
          break;
        }
      case 3 :
        {
          var shape_2: JavaArray = new JavaArray("[I").values(x_1 + 1, y_1 + 1, x_1 + 3, y_1 + 1, x_1 + 5, y_1 + 3, x_1 + 6, y_1 + 3, x_1 + 8, y_1 + 1, x_1 + 10, y_1 + 1, x_1 + 10, y_1 + 3, x_1 + 8, y_1 + 5, x_1 + 8, y_1 + 6, x_1 + 10, y_1 + 8, x_1 + 10, y_1 + 10, x_1 + 8, y_1 + 10, x_1 + 6, y_1 + 8, x_1 + 5, y_1 + 8, x_1 + 3, y_1 + 10, x_1 + 1, y_1 + 10, x_1 + 1, y_1 + 8, x_1 + 3, y_1 + 6, x_1 + 3, y_1 + 5, x_1 + 1, y_1 + 3);
          var fill_1: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display_1, CTabFolder.CLOSE_FILL]));
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(fill_1);
          gc.fillPolygon___3I(shape_2);
          fill_1.dispose__();
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(closeBorder);
          gc.drawPolygon___3I(shape_2);
          break;
        }
      case 0 :
        {
          var shape_3: JavaArray = new JavaArray("[I").values(x_1, y_1, x_1 + 10, y_1, x_1 + 10, y_1 + 10, x_1, y_1 + 10);
          if (parent.gradientColors !== null && !parent.gradientVertical) {
            parent.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape_3, false);
          } else {
            var defaultBackground: Color = parent.getBackground__();
            var image_1: Image = parent.bgImage;
            var colors: JavaArray = parent.gradientColors;
            var percents: JavaArray = parent.gradientPercents;
            var vertical: Boolean = parent.gradientVertical;
            parent.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IIIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Image_2_3Lorg_eclipse_swt_graphics_Color_2_3IZ(gc, shape_3, x_1, y_1, 10, 10, defaultBackground, image_1, colors, percents, vertical);
          }
          break;
        }
    }
    return;
  }
  public function drawSelected__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    var size: Point = parent.getSize__();
    var rightEdge: int = Math__.min__II(x + width, parent.getRightItemEdge__());
    var xx: int = parent.borderLeft;
    var yy: int = parent.onBottom ? size.y - parent.borderBottom - parent.tabHeight - parent.highlight_header : parent.borderTop + parent.tabHeight + 1;
    var ww: int = size.x - parent.borderLeft - parent.borderRight;
    var hh: int = parent.highlight_header - 1;
    var shape: JavaArray = new JavaArray("[I").values(xx, yy, xx + ww, yy, xx + ww, yy + hh, xx, yy + hh);
    if (parent.selectionGradientColors !== null && !parent.selectionGradientVertical) {
      parent.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, true);
    } else {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(parent.selectionBackground);
      gc.fillRectangle__IIII(xx, yy, ww, hh);
    }
    if (parent.single) {
      if (!showing)
        return;
    } else {
      if (!showing) {
        var x1: int = Math__.max__II(0, parent.borderLeft - 1);
        var y1: int = (parent.onBottom) ? y - 1 : y + height;
        var x2: int = size.x - parent.borderRight;
        gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(CTabFolder.borderColor);
        gc.drawLine__IIII(x1, y1, x2, y1);
        return;
      }
      shape = null;
      if (this.parent.onBottom) {
        var left: JavaArray = parent.simple ? CTabFolder.SIMPLE_BOTTOM_LEFT_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
        var right: JavaArray = parent.simple ? CTabFolder.SIMPLE_BOTTOM_RIGHT_CORNER : parent.curve;
        if (parent.borderLeft == 0 && parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this) == parent.firstIndex) {
          left = new JavaArray("[I").values(x, y + height);
        }
        shape = new JavaArray("[I").lengths(left.length + right.length + 8);
        var index: int = 0;
        shape[index++] = x;
        shape[index++] = y - 1;
        shape[index++] = x;
        shape[index++] = y - 1;
        for (var i: int = 0; i < int(left.length / 2); i++) {
          shape[index++] = x + left[2 * i];
          shape[index++] = y + height + left[2 * i + 1] - 1;
        }
        for (var i_1: int = 0; i_1 < int(right.length / 2); i_1++) {
          shape[index++] = parent.simple ? rightEdge - 1 + right[2 * i_1] : rightEdge - parent.curveIndent + right[2 * i_1];
          shape[index++] = parent.simple ? y + height + right[2 * i_1 + 1] - 1 : y + right[2 * i_1 + 1] - 2;
        }
        shape[index++] = parent.simple ? rightEdge - 1 : rightEdge + parent.curveWidth - parent.curveIndent;
        shape[index++] = y - 1;
        shape[index++] = parent.simple ? rightEdge - 1 : rightEdge + parent.curveWidth - parent.curveIndent;
        shape[index++] = y - 1;
      } else {
        var left_1: JavaArray = parent.simple ? CTabFolder.SIMPLE_TOP_LEFT_CORNER : CTabFolder.TOP_LEFT_CORNER;
        var right_1: JavaArray = parent.simple ? CTabFolder.SIMPLE_TOP_RIGHT_CORNER : parent.curve;
        if (parent.borderLeft == 0 && parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this) == parent.firstIndex) {
          left_1 = new JavaArray("[I").values(x, y);
        }
        shape = new JavaArray("[I").lengths(left_1.length + right_1.length + 8);
        var index_1: int = 0;
        shape[index_1++] = x;
        shape[index_1++] = y + height + 1;
        shape[index_1++] = x;
        shape[index_1++] = y + height + 1;
        for (var i_2: int = 0; i_2 < int(left_1.length / 2); i_2++) {
          shape[index_1++] = x + left_1[2 * i_2];
          shape[index_1++] = y + left_1[2 * i_2 + 1];
        }
        for (var i_3: int = 0; i_3 < int(right_1.length / 2); i_3++) {
          shape[index_1++] = parent.simple ? rightEdge - 1 + right_1[2 * i_3] : rightEdge - parent.curveIndent + right_1[2 * i_3];
          shape[index_1++] = y + right_1[2 * i_3 + 1];
        }
        shape[index_1++] = parent.simple ? rightEdge - 1 : rightEdge + parent.curveWidth - parent.curveIndent;
        shape[index_1++] = y + height + 1;
        shape[index_1++] = parent.simple ? rightEdge - 1 : rightEdge + parent.curveWidth - parent.curveIndent;
        shape[index_1++] = y + height + 1;
      }
      var clipping: Rectangle = gc.getClipping__();
      var bounds: Rectangle = this.getBounds__();
      bounds.height += 1;
      if (parent.onBottom)
        bounds.y -= 1;
      var tabInPaint: Boolean = clipping.intersects__Lorg_eclipse_swt_graphics_Rectangle_2(bounds);
      if (tabInPaint) {
        if (parent.selectionGradientColors !== null && !parent.selectionGradientVertical) {
          parent.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IZ(gc, shape, true);
        } else {
          var defaultBackground: Color = parent.selectionBackground;
          var image_1: Image = parent.selectionBgImage;
          var colors: JavaArray = parent.selectionGradientColors;
          var percents: JavaArray = parent.selectionGradientPercents;
          var vertical: Boolean = parent.selectionGradientVertical;
          xx = x;
          yy = parent.onBottom ? y - 1 : y + 1;
          ww = width;
          hh = height;
          if (!parent.single && !parent.simple)
            ww += parent.curveWidth - parent.curveIndent;
          parent.drawBackground__Lorg_eclipse_swt_graphics_GC_2_3IIIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Image_2_3Lorg_eclipse_swt_graphics_Color_2_3IZ(gc, shape, xx, yy, ww, hh, defaultBackground, image_1, colors, percents, vertical);
        }
      }
      this.drawHighlight__Lorg_eclipse_swt_graphics_GC_2I(gc, rightEdge);
      shape[0] = Math__.max__II(0, parent.borderLeft - 1);
      if (parent.borderLeft == 0 && parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this) == parent.firstIndex) {
        shape[1] = parent.onBottom ? y + height - 1 : y;
        shape[5] = shape[3] = shape[1];
      }
      shape[shape.length - 2] = size.x - parent.borderRight + 1;
      for (var i_4: int = 0; i_4 < int(shape.length / 2); i_4++) {
        if (shape[2 * i_4 + 1] == y + height + 1)
          shape[2 * i_4 + 1] -= 1;
      }
      var inside: RGB = parent.selectionBackground.getRGB__();
      if (parent.selectionBgImage !== null || (parent.selectionGradientColors !== null && parent.selectionGradientColors.length > 1)) {
        inside = null;
      }
      var outside: RGB = parent.getBackground__().getRGB__();
      if (parent.bgImage !== null || (parent.gradientColors !== null && parent.gradientColors.length > 1)) {
        outside = null;
      }
      parent.antialias___3ILorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_GC_2(shape, CTabFolder.borderColor.getRGB__(), inside, outside, gc);
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(CTabFolder.borderColor);
      gc.drawPolyline___3I(shape);
      if (!tabInPaint)
        return;
    }
    var xDraw: int = x + 4;
    if (parent.single && (parent.showClose || showClose))
      xDraw += 18;
    var image_2: Image = this.getImage__();
    if (image_2 !== null) {
      var imageBounds: Rectangle = image_2.getBounds__();
      var maxImageWidth: int = rightEdge - xDraw - 4;
      if (!parent.single && closeRect.width > 0)
        maxImageWidth -= closeRect.width + 4;
      if (imageBounds.width < maxImageWidth) {
        var imageX: int = xDraw;
        var imageY: int = y + int((height - imageBounds.height) / 2);
        imageY += parent.onBottom ? -1 : 1;
        gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(image_2, imageX, imageY);
        xDraw += imageBounds.width + 4;
      }
    }
    var textWidth: int = rightEdge - xDraw - 4;
    if (!parent.single && closeRect.width > 0)
      textWidth -= closeRect.width + 4;
    if (textWidth > 0) {
      var gcFont: Font = gc.getFont__();
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font === null ? parent.getFont__() : font);
      if (shortenedText === null || shortenedTextWidth != textWidth) {
        shortenedText = this.shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2I(gc, this.getText__(), textWidth);
        shortenedTextWidth = textWidth;
      }
      var extent: Point = gc.textExtent__Ljava_lang_String_2I(shortenedText, 9);
      var textY: int = y + int((height - extent.y) / 2);
      textY += parent.onBottom ? -1 : 1;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(parent.selectionForeground);
      gc.drawText__Ljava_lang_String_2III(shortenedText, xDraw, textY, 9);
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
      if (parent.isFocusControl__()) {
        var display_1: Display = this.getDisplay__();
        if (parent.simple || parent.single) {
          gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(2));
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(1));
          gc.drawFocus__IIII(xDraw - 1, textY - 1, extent.x + 2, extent.y + 2);
        } else {
          gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(17));
          gc.drawLine__IIII(xDraw, textY + extent.y + 1, xDraw + extent.x + 1, textY + extent.y + 1);
        }
      }
    }
    if (parent.showClose || showClose)
      this.drawClose__Lorg_eclipse_swt_graphics_GC_2(gc);
    return;
  }
  public function drawHighlight__Lorg_eclipse_swt_graphics_GC_2I(gc: GC, rightEdge: int): void {
    if (parent.simple || this.parent.onBottom)
      return;
    if (parent.selectionHighlightGradientBegin === null)
      return;
    var gradients: JavaArray = parent.selectionHighlightGradientColorsCache;
    if (gradients === null)
      return;
    var gradientsSize: int = gradients.length;
    if (gradientsSize == 0)
      return;
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[0]);
    gc.drawLine__IIII(CTabFolder.TOP_LEFT_CORNER_HILITE[0] + x + 1, 1 + y, rightEdge - parent.curveIndent, 1 + y);
    var leftHighlightCurve: JavaArray = CTabFolder.TOP_LEFT_CORNER_HILITE;
    var d: int = parent.tabHeight - int(parent.topCurveHighlightEnd.length / 2);
    var lastX: int = 0;
    var lastY: int = 0;
    var lastColorIndex: int = 0;
    for (var i: int = 0; i < int(leftHighlightCurve.length / 2); i++) {
      var rawX: int = leftHighlightCurve[i * 2];
      var rawY: int = leftHighlightCurve[i * 2 + 1];
      lastX = rawX + x;
      lastY = rawY + y;
      lastColorIndex = rawY - 1;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[lastColorIndex]);
      gc.drawPoint__II(lastX, lastY);
    }
    for (var i_1: int = lastColorIndex; i_1 < gradientsSize; i_1++) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[i_1]);
      gc.drawPoint__II(lastX, 1 + lastY++);
    }
    var rightEdgeOffset: int = rightEdge - parent.curveIndent;
    for (var i_2: int = 0; i_2 < int(parent.topCurveHighlightStart.length / 2); i_2++) {
      var rawX_1: int = parent.topCurveHighlightStart[i_2 * 2];
      var rawY_1: int = parent.topCurveHighlightStart[i_2 * 2 + 1];
      lastX = rawX_1 + rightEdgeOffset;
      lastY = rawY_1 + y;
      lastColorIndex = rawY_1 - 1;
      if (lastColorIndex >= gradientsSize)
        break;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[lastColorIndex]);
      gc.drawPoint__II(lastX, lastY);
    }
    for (var i_3: int = lastColorIndex; i_3 < lastColorIndex + d; i_3++) {
      if (i_3 >= gradientsSize)
        break;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[i_3]);
      gc.drawPoint__II(1 + lastX++, 1 + lastY++);
    }
    for (var i_4: int = 0; i_4 < int(parent.topCurveHighlightEnd.length / 2); i_4++) {
      var rawX_2: int = parent.topCurveHighlightEnd[i_4 * 2];
      var rawY_2: int = parent.topCurveHighlightEnd[i_4 * 2 + 1];
      lastX = rawX_2 + rightEdgeOffset;
      lastY = rawY_2 + y;
      lastColorIndex = rawY_2 - 1;
      if (lastColorIndex >= gradientsSize)
        break;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gradients[lastColorIndex]);
      gc.drawPoint__II(lastX, lastY);
    }
    return;
  }
  public function drawRightUnselectedBorder__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    var shape: JavaArray = null;
    var startX: int = x + width - 1;
    if (this.parent.onBottom) {
      var right: JavaArray = parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_RIGHT_CORNER;
      shape = new JavaArray("[I").lengths(right.length + 2);
      var index: int = 0;
      for (var i: int = 0; i < int(right.length / 2); i++) {
        shape[index++] = startX + right[2 * i];
        shape[index++] = y + height + right[2 * i + 1] - 1;
      }
      shape[index++] = startX;
      shape[index++] = y - 1;
    } else {
      var right_1: JavaArray = parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_RIGHT_CORNER;
      shape = new JavaArray("[I").lengths(right_1.length + 2);
      var index_1: int = 0;
      for (var i_1: int = 0; i_1 < int(right_1.length / 2); i_1++) {
        shape[index_1++] = startX + right_1[2 * i_1];
        shape[index_1++] = y + right_1[2 * i_1 + 1];
      }
      shape[index_1++] = startX;
      shape[index_1++] = y + height;
    }
    this.drawBorder__Lorg_eclipse_swt_graphics_GC_2_3I(gc, shape);
    return;
  }
  public function drawBorder__Lorg_eclipse_swt_graphics_GC_2_3I(gc: GC, shape: JavaArray): void {
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(CTabFolder.borderColor);
    gc.drawPolyline___3I(shape);
    return;
  }
  public function drawLeftUnselectedBorder__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    var shape: JavaArray = null;
    if (this.parent.onBottom) {
      var left: JavaArray = parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
      shape = new JavaArray("[I").lengths(left.length + 2);
      var index: int = 0;
      shape[index++] = x;
      shape[index++] = y - 1;
      for (var i: int = 0; i < int(left.length / 2); i++) {
        shape[index++] = x + left[2 * i];
        shape[index++] = y + height + left[2 * i + 1] - 1;
      }
    } else {
      var left_1: JavaArray = parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_LEFT_CORNER;
      shape = new JavaArray("[I").lengths(left_1.length + 2);
      var index_1: int = 0;
      shape[index_1++] = x;
      shape[index_1++] = y + height;
      for (var i_1: int = 0; i_1 < int(left_1.length / 2); i_1++) {
        shape[index_1++] = x + left_1[2 * i_1];
        shape[index_1++] = y + left_1[2 * i_1 + 1];
      }
    }
    this.drawBorder__Lorg_eclipse_swt_graphics_GC_2_3I(gc, shape);
    return;
  }
  public function drawUnselected__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (!showing)
      return;
    var clipping: Rectangle = gc.getClipping__();
    var bounds: Rectangle = this.getBounds__();
    if (!clipping.intersects__Lorg_eclipse_swt_graphics_Rectangle_2(bounds))
      return;
    var index: int = parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this);
    if (index > 0 && index < parent.selectedIndex)
      this.drawLeftUnselectedBorder__Lorg_eclipse_swt_graphics_GC_2(gc);
    if (index > parent.selectedIndex)
      this.drawRightUnselectedBorder__Lorg_eclipse_swt_graphics_GC_2(gc);
    var xDraw: int = x + 4;
    var image_1: Image = this.getImage__();
    if (image_1 !== null && parent.showUnselectedImage) {
      var imageBounds: Rectangle = image_1.getBounds__();
      var maxImageWidth: int = x + width - xDraw - 4;
      if (parent.showUnselectedClose && (parent.showClose || showClose)) {
        maxImageWidth -= closeRect.width + 4;
      }
      if (imageBounds.width < maxImageWidth) {
        var imageX: int = xDraw;
        var imageHeight: int = imageBounds.height;
        var imageY: int = y + int((height - imageHeight) / 2);
        imageY += parent.onBottom ? -1 : 1;
        var imageWidth: int = int(imageBounds.width * imageHeight / imageBounds.height);
        gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image_1, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY, imageWidth, imageHeight);
        xDraw += imageWidth + 4;
      }
    }
    var textWidth: int = x + width - xDraw - 4;
    if (parent.showUnselectedClose && (parent.showClose || showClose)) {
      textWidth -= closeRect.width + 4;
    }
    if (textWidth > 0) {
      var gcFont: Font = gc.getFont__();
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font === null ? parent.getFont__() : font);
      if (shortenedText === null || shortenedTextWidth != textWidth) {
        shortenedText = this.shortenText__Lorg_eclipse_swt_graphics_GC_2Ljava_lang_String_2I(gc, this.getText__(), textWidth);
        shortenedTextWidth = textWidth;
      }
      var extent: Point = gc.textExtent__Ljava_lang_String_2I(shortenedText, 9);
      var textY: int = y + int((height - extent.y) / 2);
      textY += parent.onBottom ? -1 : 1;
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(parent.getForeground__());
      gc.drawText__Ljava_lang_String_2III(shortenedText, xDraw, textY, 9);
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
    }
    if (parent.showUnselectedClose && (parent.showClose || showClose))
      this.drawClose__Lorg_eclipse_swt_graphics_GC_2(gc);
    return;
  }
  public function getBounds__(): Rectangle {
    var w: int = width;
    if (!parent.simple && !parent.single && parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this) == parent.selectedIndex)
      w += parent.curveWidth - parent.curveIndent;
    return new Rectangle(x, y, w, height);
  }
  public function getControl__(): Control {
    this.checkWidget__();
    return control;
  }
  public function getDisabledImage__(): Image {
    this.checkWidget__();
    return disabledImage;
  }
  public function getFont__(): Font {
    this.checkWidget__();
    if (font !== null)
      return font;
    return parent.getFont__();
  }
  public function getParent__(): CTabFolder {
    return parent;
  }
  public function getShowClose__(): Boolean {
    this.checkWidget__();
    return showClose;
  }
  public function getToolTipText__(): String {
    this.checkWidget__();
    if (toolTipText === null && shortenedText !== null) {
      var text_1: String = this.getText__();
      if (!Object(shortenedText).equals__Ljava_lang_Object_2(text_1))
        return text_1;
    }
    return toolTipText;
  }
  public function isShowing__(): Boolean {
    this.checkWidget__();
    return showing;
  }
  public function onPaint__Lorg_eclipse_swt_graphics_GC_2Z(gc: GC, isSelected: Boolean): void {
    if (width == 0 || height == 0)
      return;
    if (isSelected) {
      this.drawSelected__Lorg_eclipse_swt_graphics_GC_2(gc);
    } else {
      this.drawUnselected__Lorg_eclipse_swt_graphics_GC_2(gc);
    }
    return;
  }
  public function preferredHeight__Lorg_eclipse_swt_graphics_GC_2(gc: GC): int {
    var image_1: Image = this.getImage__();
    var h: int = (image_1 === null) ? 0 : image_1.getBounds__().height;
    var text_1: String = this.getText__();
    if (font === null) {
      h = Math__.max__II(h, gc.textExtent__Ljava_lang_String_2I(text_1, 9).y);
    } else {
      var gcFont: Font = gc.getFont__();
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
      h = Math__.max__II(h, gc.textExtent__Ljava_lang_String_2I(text_1, 9).y);
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
    }
    return h + 2 + 2;
  }
  public function preferredWidth__Lorg_eclipse_swt_graphics_GC_2ZZ(gc: GC, isSelected: Boolean, minimum: Boolean): int {
    if (this.isDisposed__())
      return 0;
    var w: int = 0;
    var image_1: Image = this.getImage__();
    if (image_1 !== null && (isSelected || parent.showUnselectedImage)) {
      w += image_1.getBounds__().width;
    }
    var text_1: String = null;
    if (minimum) {
      var minChars: int = parent.minChars;
      text_1 = minChars == 0 ? null : this.getText__();
      if (text_1 !== null && Object(text_1).length__() > minChars) {
        if (this.useEllipses__()) {
          var end: int = minChars < Object("...").length__() + 1 ? minChars : minChars - Object("...").length__();
          text_1 = Object(text_1).substring__II(0, end);
          if (minChars > Object("...").length__() + 1)
            text_1 += "...";
        } else {
          var end_1: int = minChars;
          text_1 = Object(text_1).substring__II(0, end_1);
        }
      }
    } else {
      text_1 = this.getText__();
    }
    if (text_1 !== null) {
      if (w > 0)
        w += 4;
      if (font === null) {
        w += gc.textExtent__Ljava_lang_String_2I(text_1, 9).x;
      } else {
        var gcFont: Font = gc.getFont__();
        gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
        w += gc.textExtent__Ljava_lang_String_2I(text_1, 9).x;
        gc.setFont__Lorg_eclipse_swt_graphics_Font_2(gcFont);
      }
    }
    if (parent.showClose || showClose) {
      if (isSelected || parent.showUnselectedClose) {
        if (w > 0)
          w += 4;
        w += 18;
      }
    }
    return w + 4 + 4;
  }
  public function setControl__Lorg_eclipse_swt_widgets_Control_2(control_1: Control): void {
    this.checkWidget__();
    if (control_1 !== null) {
      if (control_1.isDisposed__())
        SWT.error__I(5);
      if (control_1.getParent__() !== parent)
        SWT.error__I(32);
    }
    if (this.control !== null && !this.control.isDisposed__()) {
      this.control.setVisible__Z(false);
    }
    this.control = control_1;
    if (this.control !== null) {
      var index: int = parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this);
      if (index == parent.getSelectionIndex__()) {
        this.control.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(parent.getClientArea__());
        this.control.setVisible__Z(true);
      } else {
        this.control.setVisible__Z(false);
      }
    }
    return;
  }
  public function setDisabledImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__()) {
      SWT.error__I(5);
    }
    this.disabledImage = image_1;
    return;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (font_1 !== null && font_1.isDisposed__()) {
      SWT.error__I(5);
    }
    if (font_1 === null && this.font === null)
      return;
    if (font_1 !== null && font_1.equals__Ljava_lang_Object_2(this.font))
      return;
    this.font = font_1;
    if (!parent.updateTabHeight__Z(false)) {
      parent.updateItems__();
      parent.redrawTabs__();
    }
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__()) {
      SWT.error__I(5);
    }
    var oldImage: Image = this.getImage__();
    if (image_1 === null && oldImage === null)
      return;
    if (image_1 !== null && image_1.equals__Ljava_lang_Object_2(oldImage))
      return;
    super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    if (!parent.updateTabHeight__Z(false)) {
      if (oldImage !== null && image_1 !== null) {
        var oldBounds: Rectangle = oldImage.getBounds__();
        var bounds: Rectangle = image_1.getBounds__();
        if (bounds.width == oldBounds.width && bounds.height == oldBounds.height) {
          if (showing) {
            var selected: Boolean = parent.indexOf__Lorg_eclipse_swt_custom_CTabItem_2(this) == parent.selectedIndex;
            if (selected || parent.showUnselectedImage) {
              var imageX: int = x + 4;
              var maxImageWidth: int;
              if (selected) {
                if (parent.single && (parent.showClose || showClose))
                  imageX += 18;
                var rightEdge: int = Math__.min__II(x + width, parent.getRightItemEdge__());
                maxImageWidth = rightEdge - imageX - 4;
                if (!parent.single && closeRect.width > 0)
                  maxImageWidth -= closeRect.width + 4;
              } else {
                maxImageWidth = x + width - imageX - 4;
                if (parent.showUnselectedClose && (parent.showClose || showClose)) {
                  maxImageWidth -= closeRect.width + 4;
                }
              }
              if (bounds.width < maxImageWidth) {
                var imageY: int = y + int((height - bounds.height) / 2) + (parent.onBottom ? -1 : 1);
                parent.redraw__IIIIZ(imageX, imageY, bounds.width, bounds.height, false);
              }
            }
          }
          return;
        }
      }
      parent.updateItems__();
      parent.redrawTabs__();
    }
    return;
  }
  public function setShowClose__Z(close: Boolean): void {
    this.checkWidget__();
    if (showClose == close)
      return;
    showClose = close;
    parent.updateItems__();
    parent.redrawTabs__();
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      SWT.error__I(4);
    if (Object(string).equals__Ljava_lang_Object_2(this.getText__()))
      return;
    super.setText__Ljava_lang_String_2(string);
    shortenedText = null;
    shortenedTextWidth = 0;
    if (!parent.updateTabHeight__Z(false)) {
      parent.updateItems__();
      parent.redrawTabs__();
    }
    return;
  }
  public function setToolTipText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    toolTipText = string;
    return;
  }
  public function CTabItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is CTabFolder && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is CTabFolder && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        args1 = [args0[0], args0[1], args0[0].getItemCount__()];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2II(args1[0], args1[1], args1[2]);
        CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2I(args0[0], args0[1]);
        break;
      case 1:
        CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2I : int = 0;
  public static const CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2II : int = 1;
}
}
