package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.JavaArray;
dynamic public class ControlEditor {
  public var horizontalAlignment: int = 16777216;
  public var grabHorizontal: Boolean = false;
  public var minimumWidth: int = 0;
  public var verticalAlignment: int = 16777216;
  public var grabVertical: Boolean = false;
  public var minimumHeight: int = 0;
  internal var parent: Composite;
  internal var editor: Control;
  private var hadFocus: Boolean;
  private var controlListener: Listener;
  private var scrollbarListener: Listener;
  public static var EVENTS: JavaArray = new JavaArray("[I").values(1, 2, 3, 4, 11);
  public function ControlEditor(parent: Composite) {
    this.parent = parent;
    controlListener = new org.eclipse.swt.custom.ControlEditor$1(this);
    for (var i: int = 0; i < EVENTS.length; i++) {
      parent.addListener__ILorg_eclipse_swt_widgets_Listener_2(EVENTS[i], controlListener);
    }
    scrollbarListener = new org.eclipse.swt.custom.ControlEditor$2(this);
    var hBar: ScrollBar = parent.getHorizontalBar__();
    if (hBar !== null)
      hBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, scrollbarListener);
    var vBar: ScrollBar = parent.getVerticalBar__();
    if (vBar !== null)
      vBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, scrollbarListener);
    return;
  }
  public function computeBounds__(): Rectangle {
    var clientArea: Rectangle = parent.getClientArea__();
    var editorRect: Rectangle = new Rectangle(clientArea.x, clientArea.y, minimumWidth, minimumHeight);
    if (grabHorizontal)
      editorRect.width = Math__.max__II(clientArea.width, minimumWidth);
    if (grabVertical)
      editorRect.height = Math__.max__II(clientArea.height, minimumHeight);
    switch (horizontalAlignment) {
      case 131072 :
        editorRect.x += clientArea.width - editorRect.width;
        break;
      case 16384 :
        break;
      default :
        editorRect.x += int((clientArea.width - editorRect.width) / 2);
    }
    switch (verticalAlignment) {
      case 1024 :
        editorRect.y += clientArea.height - editorRect.height;
        break;
      case 128 :
        break;
      default :
        editorRect.y += int((clientArea.height - editorRect.height) / 2);
    }
    return editorRect;
  }
  public function dispose__(): void {
    if (parent !== null && !parent.isDisposed__()) {
      for (var i: int = 0; i < EVENTS.length; i++) {
        parent.removeListener__ILorg_eclipse_swt_widgets_Listener_2(EVENTS[i], controlListener);
      }
      var hBar: ScrollBar = parent.getHorizontalBar__();
      if (hBar !== null)
        hBar.removeListener__ILorg_eclipse_swt_widgets_Listener_2(13, scrollbarListener);
      var vBar: ScrollBar = parent.getVerticalBar__();
      if (vBar !== null)
        vBar.removeListener__ILorg_eclipse_swt_widgets_Listener_2(13, scrollbarListener);
    }
    parent = null;
    editor = null;
    hadFocus = false;
    controlListener = null;
    scrollbarListener = null;
    return;
  }
  public function getEditor__(): Control {
    return editor;
  }
  public function layout__(): void {
    if (editor === null || editor.isDisposed__())
      return;
    if (editor.getVisible__()) {
      hadFocus = editor.isFocusControl__();
    }
    editor.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(this.computeBounds__());
    if (hadFocus) {
      if (editor === null || editor.isDisposed__())
        return;
      editor.setFocus__();
    }
    return;
  }
  public function scroll__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    if (editor === null || editor.isDisposed__())
      return;
    this.layout__();
  }
  public function setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1: Control): void {
    if (editor_1 === null) {
      this.editor = null;
      return;
    }
    this.editor = editor_1;
    this.layout__();
    if (this.editor === null || this.editor.isDisposed__())
      return;
    editor_1.setVisible__Z(true);
  }
}
}
