package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.*;
import java.util.Vector;
import java.lang.System;
import java.util.Vector;
import org.eclipse.swt.SWT;
import java.lang.StringBuffer;
import java.lang.Math__;
import org.eclipse.swt.widgets.TypedListener;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class DefaultContent implements StyledTextContent {
  public static var LineDelimiter: String = System.getProperty__Ljava_lang_String_2("line.separator");
  internal var textListeners: Vector = new Vector(new Arguments(java.util.Vector.Vector__, []));
  internal var textStore: JavaArray = new JavaArray("[C").lengths(0);
  internal var gapStart: int = -1;
  internal var gapEnd: int = -1;
  internal var gapLine: int = -1;
  internal var highWatermark: int = 300;
  internal var lowWatermark: int = 50;
  internal var lines: JavaArray = new JavaArray("[[I").lengths(50, 2);
  internal var lineCount: int = 0;
  internal var expandExp: int = 1;
  internal var replaceExpandExp: int = 1;
  function DefaultContent() {
    this.setText__Ljava_lang_String_2("");
    return;
  }
  public function addLineIndex__II(start: int, length: int): void {
    var size: int = lines.length;
    if (lineCount == size) {
      var newLines: JavaArray = new JavaArray("[[I").lengths(size + Compatibility.pow2__I(expandExp), 2);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines, 0, newLines, 0, size);
      lines = newLines;
      expandExp++;
    }
    var range: JavaArray = new JavaArray("[I").values(start, length);
    lines[lineCount] = range;
    lineCount++;
    return;
  }
  public function addLineIndex__II_3_3II(start: int, length: int, linesArray: JavaArray, count: int): JavaArray {
    var size: int = linesArray.length;
    var newLines: JavaArray = linesArray;
    if (count == size) {
      newLines = new JavaArray("[[I").lengths(size + Compatibility.pow2__I(replaceExpandExp), 2);
      replaceExpandExp++;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(linesArray, 0, newLines, 0, size);
    }
    var range: JavaArray = new JavaArray("[I").values(start, length);
    newLines[count] = range;
    return newLines;
  }
  public function addTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(listener: TextChangeListener): void {
    if (listener === null)
      this.error__I(4);
    var typedListener: StyledTextListener = new StyledTextListener(listener);
    textListeners.addElement__Ljava_lang_Object_2(typedListener);
  }
  public function adjustGap__III(position: int, sizeHint: int, line: int): void {
    if (position == gapStart) {
      var size: int = (gapEnd - gapStart) - sizeHint;
      if (lowWatermark <= size && size <= highWatermark)
        return;
    } else if ((position + sizeHint == gapStart) && (sizeHint < 0)) {
      var size_1: int = (gapEnd - gapStart) - sizeHint;
      if (lowWatermark <= size_1 && size_1 <= highWatermark)
        return;
    }
    this.moveAndResizeGap__III(position, sizeHint, line);
    return;
  }
  public function indexLines__(): void {
    var start: int = 0;
    lineCount = 0;
    var textLength: int = textStore.length;
    var i: int;
    for (i = start; i < textLength; i++) {
      var ch: uint = textStore[i];
      if (ch == 13) {
        if (i + 1 < textLength) {
          ch = textStore[i + 1];
          if (ch == 10) {
            i++;
          }
        }
        this.addLineIndex__II(start, i - start + 1);
        start = i + 1;
      } else if (ch == 10) {
        this.addLineIndex__II(start, i - start + 1);
        start = i + 1;
      }
    }
    this.addLineIndex__II(start, i - start);
    return;
  }
  public function isDelimiter__C(ch: uint): Boolean {
    if (ch == 13)
      return true;
    if (ch == 10)
      return true;
    return false;
  }
  public function isValidReplace__IILjava_lang_String_2(start: int, replaceLength: int, newText: String): Boolean {
    if (replaceLength == 0) {
      if (start == 0)
        return true;
      if (start == this.getCharCount__())
        return true;
      var before: uint = Object(this.getTextRange__II(start - 1, 1)).charAt__I(0);
      if (before == 13) {
        var after: uint = Object(this.getTextRange__II(start, 1)).charAt__I(0);
        if (after == 10)
          return false;
      }
    } else {
      var startChar: uint = Object(this.getTextRange__II(start, 1)).charAt__I(0);
      if (startChar == 10) {
        if (start != 0) {
          var before_1: uint = Object(this.getTextRange__II(start - 1, 1)).charAt__I(0);
          if (before_1 == 13)
            return false;
        }
      }
      var endChar: uint = Object(this.getTextRange__II(start + replaceLength - 1, 1)).charAt__I(0);
      if (endChar == 13) {
        if (start + replaceLength != this.getCharCount__()) {
          var after_1: uint = Object(this.getTextRange__II(start + replaceLength, 1)).charAt__I(0);
          if (after_1 == 10)
            return false;
        }
      }
    }
    return true;
  }
  public function indexLines__III(offset: int, length: int, numLines: int): JavaArray {
    var indexedLines: JavaArray = new JavaArray("[[I").lengths(numLines, 2);
    var start: int = 0;
    var lineCount_1: int = 0;
    var i: int;
    replaceExpandExp = 1;
    for (i = start; i < length; i++) {
      var location: int = i + offset;
      if ((location >= gapStart) && (location < gapEnd)) {
      } else {
        var ch: uint = textStore[location];
        if (ch == 13) {
          if (location + 1 < textStore.length) {
            ch = textStore[location + 1];
            if (ch == 10) {
              i++;
            }
          }
          indexedLines = this.addLineIndex__II_3_3II(start, i - start + 1, indexedLines, lineCount_1);
          lineCount_1++;
          start = i + 1;
        } else if (ch == 10) {
          indexedLines = this.addLineIndex__II_3_3II(start, i - start + 1, indexedLines, lineCount_1);
          lineCount_1++;
          start = i + 1;
        }
      }
    }
    var newLines: JavaArray = new JavaArray("[[I").lengths(lineCount_1 + 1, 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(indexedLines, 0, newLines, 0, lineCount_1);
    var range: JavaArray = new JavaArray("[I").values(start, i - start);
    newLines[lineCount_1] = range;
    return newLines;
  }
  public function insert__ILjava_lang_String_2(position: int, text: String): void {
    if (Object(text).length__() == 0)
      return;
    var startLine: int = this.getLineAtOffset__I(position);
    var change: int = Object(text).length__();
    var endInsert: Boolean = position == this.getCharCount__();
    this.adjustGap__III(position, change, startLine);
    var startLineOffset: int = this.getOffsetAtLine__I(startLine);
    var startLineLength: int = Object(this.getPhysicalLine__I(startLine)).length__();
    if (change > 0) {
      gapStart += (change);
      for (var i: int = 0; i < Object(text).length__(); i++) {
        textStore[position + i] = Object(text).charAt__I(i);
      }
    }
    var newLines: JavaArray = this.indexLines__III(startLineOffset, startLineLength, 10);
    var numNewLines: int = newLines.length - 1;
    if (newLines[numNewLines][1] == 0) {
      if (endInsert) {
        numNewLines += 1;
      } else {
        numNewLines -= 1;
      }
    }
    this.expandLinesBy__I(numNewLines);
    for (var i_1: int = lineCount - 1; i_1 > startLine; i_1--) {
      lines[i_1 + numNewLines] = lines[i_1];
    }
    for (var i_2: int = 0; i_2 < numNewLines; i_2++) {
      newLines[i_2][0] += startLineOffset;
      lines[startLine + i_2] = newLines[i_2];
    }
    if (numNewLines < newLines.length) {
      newLines[numNewLines][0] += startLineOffset;
      lines[startLine + numNewLines] = newLines[numNewLines];
    }
    lineCount += numNewLines;
    gapLine = this.getLineAtPhysicalOffset__I(gapStart);
    return;
  }
  public function moveAndResizeGap__III(position: int, size: int, newGapLine: int): void {
    var content: JavaArray = null;
    var oldSize: int = gapEnd - gapStart;
    var newSize: int;
    if (size > 0) {
      newSize = highWatermark + size;
    } else {
      newSize = lowWatermark - size;
    }
    if (this.gapExists__()) {
      lines[gapLine][1] = lines[gapLine][1] - oldSize;
      for (var i: int = gapLine + 1; i < lineCount; i++) {
        lines[i][0] = lines[i][0] - oldSize;
      }
    }
    if (newSize < 0) {
      if (oldSize > 0) {
        content = new JavaArray("[C").lengths(textStore.length - oldSize);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, 0, content, 0, gapStart);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, gapEnd, content, gapStart, content.length - gapStart);
        textStore = content;
      }
      gapStart = gapEnd = position;
      return;
    }
    content = new JavaArray("[C").lengths(textStore.length + (newSize - oldSize));
    var newGapStart: int = position;
    var newGapEnd: int = newGapStart + newSize;
    if (oldSize == 0) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, 0, content, 0, newGapStart);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, newGapStart, content, newGapEnd, content.length - newGapEnd);
    } else if (newGapStart < gapStart) {
      var delta: int = gapStart - newGapStart;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, 0, content, 0, newGapStart);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, newGapStart, content, newGapEnd, delta);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, gapEnd, content, newGapEnd + delta, textStore.length - gapEnd);
    } else {
      var delta_1: int = newGapStart - gapStart;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, 0, content, 0, gapStart);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, gapEnd, content, gapStart, delta_1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(textStore, gapEnd + delta_1, content, newGapEnd, content.length - newGapEnd);
    }
    textStore = content;
    gapStart = newGapStart;
    gapEnd = newGapEnd;
    if (this.gapExists__()) {
      gapLine = newGapLine;
      var gapLength: int = gapEnd - gapStart;
      lines[gapLine][1] = lines[gapLine][1] + (gapLength);
      for (var i_1: int = gapLine + 1; i_1 < lineCount; i_1++) {
        lines[i_1][0] = lines[i_1][0] + gapLength;
      }
    }
    return;
  }
  public function lineCount__II(startOffset: int, length: int): int {
    if (length == 0) {
      return 0;
    }
    var lineCount_1: int = 0;
    var count: int = 0;
    var i: int = startOffset;
    if (i >= gapStart) {
      i += gapEnd - gapStart;
    }
    while (count < length) {
      if ((i >= gapStart) && (i < gapEnd)) {
      } else {
        var ch: uint = textStore[i];
        if (ch == 13) {
          if (i + 1 < textStore.length) {
            ch = textStore[i + 1];
            if (ch == 10) {
              i++;
              count++;
            }
          }
          lineCount_1++;
        } else if (ch == 10) {
          lineCount_1++;
        }
        count++;
      }
      i++;
    }
    return lineCount_1;
  }
  public function lineCount__Ljava_lang_String_2(text: String): int {
    var lineCount_1: int = 0;
    var length: int = Object(text).length__();
    for (var i: int = 0; i < length; i++) {
      var ch: uint = Object(text).charAt__I(i);
      if (ch == 13) {
        if (i + 1 < length && Object(text).charAt__I(i + 1) == 10) {
          i++;
        }
        lineCount_1++;
      } else if (ch == 10) {
        lineCount_1++;
      }
    }
    return lineCount_1;
  }
  public function getCharCount__(): int {
    var length: int = gapEnd - gapStart;
    return (textStore.length - length);
  }
  public function getLine__I(index: int): String {
    if ((index >= lineCount) || (index < 0))
      this.error__I(5);
    var start: int = lines[index][0];
    var length: int = lines[index][1];
    var end: int = start + length - 1;
    if (!this.gapExists__() || (end < gapStart) || (start >= gapEnd)) {
      while ((length - 1 >= 0) && this.isDelimiter__C(textStore[start + length - 1])) {
        length--;
      }
      return Object(String).__init___3CII(textStore, start, length);
    } else {
      var buf: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
      var gapLength: int = gapEnd - gapStart;
      buf.append___3CII(textStore, start, gapStart - start);
      buf.append___3CII(textStore, gapEnd, length - gapLength - (gapStart - start));
      length = buf.length__();
      while ((length - 1 >= 0) && this.isDelimiter__C(buf.charAt__I(length - 1))) {
        length--;
      }
      return Object(buf.toString__()).substring__II(0, length);
    }
    return null;
  }
  public function getLineDelimiter__(): String {
    return LineDelimiter;
  }
  public function getFullLine__I(index: int): String {
    var start: int = lines[index][0];
    var length: int = lines[index][1];
    var end: int = start + length - 1;
    if (!this.gapExists__() || (end < gapStart) || (start >= gapEnd)) {
      return Object(String).__init___3CII(textStore, start, length);
    } else {
      var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
      var gapLength: int = gapEnd - gapStart;
      buffer.append___3CII(textStore, start, gapStart - start);
      buffer.append___3CII(textStore, gapEnd, length - gapLength - (gapStart - start));
      return buffer.toString__();
    }
    return null;
  }
  public function getPhysicalLine__I(index: int): String {
    var start: int = lines[index][0];
    var length: int = lines[index][1];
    return this.getPhysicalText__II(start, length);
  }
  public function getLineCount__(): int {
    return lineCount;
  }
  public function getLineAtOffset__I(charPosition: int): int {
    if ((charPosition > this.getCharCount__()) || (charPosition < 0))
      this.error__I(5);
    var position: int;
    if (charPosition < gapStart) {
      position = charPosition;
    } else {
      position = charPosition + (gapEnd - gapStart);
    }
    if (lineCount > 0) {
      var lastLine: int = lineCount - 1;
      if (position == lines[lastLine][0] + lines[lastLine][1])
        return lastLine;
    }
    var high: int = lineCount;
    var low: int = -1;
    var index: int = lineCount;
    while (high - low > 1) {
      index = int((high + low) / 2);
      var lineStart: int = lines[index][0];
      var lineEnd: int = lineStart + lines[index][1] - 1;
      if (position <= lineStart) {
        high = index;
      } else if (position <= lineEnd) {
        high = index;
        break;
      } else {
        low = index;
      }
    }
    return high;
  }
  public function getLineAtPhysicalOffset__I(position: int): int {
    var high: int = lineCount;
    var low: int = -1;
    var index: int = lineCount;
    while (high - low > 1) {
      index = int((high + low) / 2);
      var lineStart: int = lines[index][0];
      var lineEnd: int = lineStart + lines[index][1] - 1;
      if (position <= lineStart) {
        high = index;
      } else if (position <= lineEnd) {
        high = index;
        break;
      } else {
        low = index;
      }
    }
    return high;
  }
  public function getOffsetAtLine__I(lineIndex: int): int {
    if (lineIndex == 0)
      return 0;
    if ((lineIndex >= lineCount) || (lineIndex < 0))
      this.error__I(5);
    var start: int = lines[lineIndex][0];
    if (start > gapEnd) {
      return start - (gapEnd - gapStart);
    } else {
      return start;
    }
    return 0;
  }
  public function expandLinesBy__I(numLines: int): void {
    var size: int = lines.length;
    if (size - lineCount >= numLines) {
      return;
    }
    var newLines: JavaArray = new JavaArray("[[I").lengths(size + Math__.max__II(10, numLines), 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines, 0, newLines, 0, size);
    lines = newLines;
    return;
  }
  public function error__I(code: int): void {
    SWT.error__I(code);
    return;
  }
  public function gapExists__(): Boolean {
    return gapStart != gapEnd;
  }
  public function getPhysicalText__II(start: int, length: int): String {
    return Object(String).__init___3CII(textStore, start, length);
  }
  public function getTextRange__II(start: int, length: int): String {
    if (textStore === null)
      return "";
    if (length == 0)
      return "";
    var end: int = start + length;
    if (!this.gapExists__() || (end < gapStart))
      return Object(String).__init___3CII(textStore, start, length);
    if (gapStart < start) {
      var gapLength: int = gapEnd - gapStart;
      return Object(String).__init___3CII(textStore, start + gapLength, length);
    }
    var buf: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buf.append___3CII(textStore, start, gapStart - start);
    buf.append___3CII(textStore, gapEnd, end - gapStart);
    return buf.toString__();
  }
  public function removeTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(listener: TextChangeListener): void {
    if (listener === null)
      this.error__I(4);
    for (var i: int = 0; i < textListeners.size__(); i++) {
      var typedListener: TypedListener = TypedListener(textListeners.elementAt__I(i));
      if (typedListener.getEventListener__() === listener) {
        textListeners.removeElementAt__I(i);
        break;
      }
    }
    return;
  }
  public function replaceTextRange__IILjava_lang_String_2(start: int, replaceLength: int, newText: String): void {
    if (!this.isValidReplace__IILjava_lang_String_2(start, replaceLength, newText))
      SWT.error__I(5);
    var event: StyledTextEvent = new StyledTextEvent(this);
    event.type = 3003;
    event.start = start;
    event.replaceLineCount = this.lineCount__II(start, replaceLength);
    event.text = newText;
    event.newLineCount = this.lineCount__Ljava_lang_String_2(newText);
    event.replaceCharCount = replaceLength;
    event.newCharCount = Object(newText).length__();
    this.sendTextEvent__Lorg_eclipse_swt_custom_StyledTextEvent_2(event);
    this.delete__III(start, replaceLength, event.replaceLineCount + 1);
    this.insert__ILjava_lang_String_2(start, newText);
    event = new StyledTextEvent(this);
    event.type = 3006;
    this.sendTextEvent__Lorg_eclipse_swt_custom_StyledTextEvent_2(event);
    return;
  }
  public function sendTextEvent__Lorg_eclipse_swt_custom_StyledTextEvent_2(event: StyledTextEvent): void {
    for (var i: int = 0; i < textListeners.size__(); i++) {
      (StyledTextListener(textListeners.elementAt__I(i))).handleEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function setText__Ljava_lang_String_2(text: String): void {
    textStore = Object(text).toCharArray__();
    gapStart = -1;
    gapEnd = -1;
    expandExp = 1;
    this.indexLines__();
    var event: StyledTextEvent = new StyledTextEvent(this);
    event.type = 3004;
    event.text = "";
    this.sendTextEvent__Lorg_eclipse_swt_custom_StyledTextEvent_2(event);
    return;
  }
  public function delete__III(position: int, length: int, numLines: int): void {
    if (length == 0)
      return;
    var startLine: int = this.getLineAtOffset__I(position);
    var startLineOffset: int = this.getOffsetAtLine__I(startLine);
    var endLine: int = this.getLineAtOffset__I(position + length);
    var endText: String = "";
    var splittingDelimiter: Boolean = false;
    if (position + length < this.getCharCount__()) {
      endText = this.getTextRange__II(position + length - 1, 2);
      if ((Object(endText).charAt__I(0) == 13) && (Object(endText).charAt__I(1) == 10)) {
        splittingDelimiter = true;
      }
    }
    this.adjustGap__III(position + length, -length, startLine);
    var oldLines: JavaArray = this.indexLines__III(position, length + (gapEnd - gapStart), numLines);
    if (position + length == gapStart) {
      gapStart -= length;
    } else {
      gapEnd += length;
    }
    var j: int = position;
    var eol: Boolean = false;
    while (j < textStore.length && !eol) {
      if (j < gapStart || j >= gapEnd) {
        var ch: uint = textStore[j];
        if (this.isDelimiter__C(ch)) {
          if (j + 1 < textStore.length) {
            if (ch == 13 && (textStore[j + 1] == 10)) {
              j++;
            }
          }
          eol = true;
        }
      }
      j++;
    }
    lines[startLine][1] = (position - startLineOffset) + (j - position);
    var numOldLines: int = oldLines.length - 1;
    if (splittingDelimiter)
      numOldLines -= 1;
    for (var i: int = endLine + 1; i < lineCount; i++) {
      lines[i - numOldLines] = lines[i];
    }
    lineCount -= numOldLines;
    gapLine = this.getLineAtPhysicalOffset__I(gapStart);
    return;
  }
}
}
