package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PopupList {
  internal var shell: Shell;
  internal var list: List;
  internal var minimumWidth: int;
  public function PopupList__Lorg_eclipse_swt_widgets_Shell_2(parent: Shell): Object {
    return this;
  }
  public function PopupList__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): Object {
    shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [parent, PopupList.checkStyle__I(style)]));
    list = new List(shell, 4 | 512);
    shell.addListener__ILorg_eclipse_swt_widgets_Listener_2(27, new org.eclipse.swt.custom.PopupList$1(this));
    shell.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.custom.PopupList$2(this));
    list.addMouseListener__Lorg_eclipse_swt_events_MouseListener_2(new org.eclipse.swt.custom.PopupList$3(this));
    list.addKeyListener__Lorg_eclipse_swt_events_KeyListener_2(new org.eclipse.swt.custom.PopupList$4(this));
    return this;
  }
  private static function checkStyle__I(style: int): int {
    var mask: int = 33554432 | 67108864;
    return style & mask;
  }
  public function getFont__(): Font {
    return list.getFont__();
  }
  public function getItems__(): JavaArray {
    return list.getItems__();
  }
  public function getMinimumWidth__(): int {
    return minimumWidth;
  }
  public function open__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): String {
    var listSize: Point = list.computeSize__IIZ(rect.width, -1, false);
    var screenSize: Rectangle = shell.getDisplay__().getBounds__();
    var spaceBelow: int = screenSize.height - (rect.y + rect.height) - 30;
    var spaceAbove: int = rect.y - 30;
    var y: int = 0;
    if (spaceAbove > spaceBelow && listSize.y > spaceBelow) {
      if (listSize.y > spaceAbove) {
        listSize.y = spaceAbove;
      } else {
        listSize.y += 2;
      }
      y = rect.y - listSize.y;
    } else {
      if (listSize.y > spaceBelow) {
        listSize.y = spaceBelow;
      } else {
        listSize.y += 2;
      }
      y = rect.y + rect.height;
    }
    listSize.x = rect.width;
    if (listSize.x < minimumWidth)
      listSize.x = minimumWidth;
    var x: int = rect.x + rect.width - listSize.x;
    shell.setBounds__IIII(x, y, listSize.x, listSize.y);
    shell.open__();
    list.setFocus__();
    var display: Display = shell.getDisplay__();
    while (!shell.isDisposed__() && shell.isVisible__()) {
      if (!display.readAndDispatch__())
        display.sleep__();
    }
    var result: String = null;
    if (!shell.isDisposed__()) {
      var strings: JavaArray = list.getSelection__();
      shell.dispose__();
      if (strings.length != 0)
        result = strings[0];
    }
    return result;
  }
  public function select__Ljava_lang_String_2(string: String): void {
    var items: JavaArray = list.getItems__();
    if (string !== null) {
      for (var i: int = 0; i < items.length; i++) {
        if (Object(items[i]).startsWith__Ljava_lang_String_2(string)) {
          var index: int = list.indexOf__Ljava_lang_String_2(items[i]);
          list.select__I(index);
          break;
        }
      }
    }
    return;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font: Font): void {
    list.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
    return;
  }
  public function setItems___3Ljava_lang_String_2(strings: JavaArray): void {
    list.setItems___3Ljava_lang_String_2(strings);
    return;
  }
  public function setMinimumWidth__I(width: int): void {
    if (width < 0)
      SWT.error__I(5);
    minimumWidth = width;
    return;
  }
  public function PopupList(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Shell) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Shell && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 0];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PopupList__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        PopupList__Lorg_eclipse_swt_widgets_Shell_2(args0[0]);
        break;
      case 1:
        PopupList__Lorg_eclipse_swt_widgets_Shell_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const PopupList__Lorg_eclipse_swt_widgets_Shell_2 : int = 0;
  public static const PopupList__Lorg_eclipse_swt_widgets_Shell_2I : int = 1;
}
}
