package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import java.lang.System;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Layout;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SashForm extends Composite {
  public var SASH_WIDTH: int = 3;
  internal var sashStyle: int;
  internal var sashes: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Sash;").lengths(0);
  internal var background: Color = null;
  internal var foreground: Color = null;
  internal var controls: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
  internal var maxControl: Control = null;
  internal var sashListener: Listener;
  public static const DRAG_MINIMUM: int = 20;
  public function SashForm(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, SashForm.checkStyle__I(style)]));
    super.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new SashFormLayout());
    sashStyle = ((style & 512) != 0) ? 256 : 512;
    if ((style & 2048) != 0)
      sashStyle |= 2048;
    if ((style & 65536) != 0)
      sashStyle |= 65536;
    sashListener = new org.eclipse.swt.custom.SashForm$1(this);
    return;
  }
  public static function checkStyle__I(style: int): int {
    var mask: int = 2048 | 33554432 | 67108864;
    return style & mask;
  }
  public function getOrientation__(): int {
    return (sashStyle & 512) != 0 ? 256 : 512;
  }
  public function getSashWidth__(): int {
    this.checkWidget__();
    return SASH_WIDTH;
  }
  public override function getStyle__(): int {
    var style_1: int = super.getStyle__();
    style_1 |= this.getOrientation__() == 512 ? 512 : 256;
    if ((sashStyle & 65536) != 0)
      style_1 |= 65536;
    return style_1;
  }
  public function getMaximizedControl__(): Control {
    return this.maxControl;
  }
  public function getWeights__(): JavaArray {
    this.checkWidget__();
    var cArray: JavaArray = this.getControls__Z(false);
    var ratios: JavaArray = new JavaArray("[I").lengths(cArray.length);
    for (var i: int = 0; i < cArray.length; i++) {
      var data_1: Object = cArray[i].getLayoutData__();
      if (data_1 !== null && data_1 is SashFormData) {
        ratios[i] = int(((SashFormData(data_1)).weight * 1000 >> 16));
      } else {
        ratios[i] = 200;
      }
    }
    return ratios;
  }
  public function getControls__Z(onlyVisible: Boolean): JavaArray {
    var children_1: JavaArray = this.getChildren__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0);
    for (var i: int = 0; i < children_1.length; i++) {
      if (children_1[i] is Sash)
        continue;
      if (onlyVisible && !children_1[i].getVisible__())
        continue;
      var newResult: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(result.length + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, newResult, 0, result.length);
      newResult[result.length] = children_1[i];
      result = newResult;
    }
    return result;
  }
  public function onDragSash__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var sash: Sash = Sash(event.widget);
    var sashIndex: int = -1;
    for (var i: int = 0; i < sashes.length; i++) {
      if (sashes[i] === sash) {
        sashIndex = i;
        break;
      }
    }
    if (sashIndex == -1)
      return;
    var c1: Control = controls[sashIndex];
    var c2: Control = controls[sashIndex + 1];
    var b1: Rectangle = c1.getBounds__();
    var b2: Rectangle = c2.getBounds__();
    var sashBounds: Rectangle = sash.getBounds__();
    var area: Rectangle = this.getClientArea__();
    var correction: Boolean = false;
    if (this.getOrientation__() == 256) {
      correction = b1.width < 20 || b2.width < 20;
      var totalWidth: int = b2.x + b2.width - b1.x;
      var shift: int = event.x - sashBounds.x;
      b1.width += shift;
      b2.x += shift;
      b2.width -= shift;
      if (b1.width < 20) {
        b1.width = 20;
        b2.x = b1.x + b1.width + sashBounds.width;
        b2.width = totalWidth - b2.x;
        event.x = b1.x + b1.width;
        event.doit = false;
      }
      if (b2.width < 20) {
        b1.width = totalWidth - 20 - sashBounds.width;
        b2.x = b1.x + b1.width + sashBounds.width;
        b2.width = 20;
        event.x = b1.x + b1.width;
        event.doit = false;
      }
      var data1: Object = c1.getLayoutData__();
      if (data1 === null || !(data1 is SashFormData)) {
        data1 = new SashFormData();
        c1.setLayoutData__Ljava_lang_Object_2(data1);
      }
      var data2: Object = c2.getLayoutData__();
      if (data2 === null || !(data2 is SashFormData)) {
        data2 = new SashFormData();
        c2.setLayoutData__Ljava_lang_Object_2(data2);
      }
      (SashFormData(data1)).weight = ((Number(b1.width) << 16) + area.width - 1) / area.width;
      (SashFormData(data2)).weight = ((Number(b2.width) << 16) + area.width - 1) / area.width;
    } else {
      correction = b1.height < 20 || b2.height < 20;
      var totalHeight: int = b2.y + b2.height - b1.y;
      var shift_1: int = event.y - sashBounds.y;
      b1.height += shift_1;
      b2.y += shift_1;
      b2.height -= shift_1;
      if (b1.height < 20) {
        b1.height = 20;
        b2.y = b1.y + b1.height + sashBounds.height;
        b2.height = totalHeight - b2.y;
        event.y = b1.y + b1.height;
        event.doit = false;
      }
      if (b2.height < 20) {
        b1.height = totalHeight - 20 - sashBounds.height;
        b2.y = b1.y + b1.height + sashBounds.height;
        b2.height = 20;
        event.y = b1.y + b1.height;
        event.doit = false;
      }
      var data1_1: Object = c1.getLayoutData__();
      if (data1_1 === null || !(data1_1 is SashFormData)) {
        data1_1 = new SashFormData();
        c1.setLayoutData__Ljava_lang_Object_2(data1_1);
      }
      var data2_1: Object = c2.getLayoutData__();
      if (data2_1 === null || !(data2_1 is SashFormData)) {
        data2_1 = new SashFormData();
        c2.setLayoutData__Ljava_lang_Object_2(data2_1);
      }
      (SashFormData(data1_1)).weight = ((Number(b1.height) << 16) + area.height - 1) / area.height;
      (SashFormData(data2_1)).weight = ((Number(b2.height) << 16) + area.height - 1) / area.height;
    }
    if (correction || (event.doit && event.detail != 1)) {
      c1.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(b1);
      sash.setBounds__IIII(event.x, event.y, event.width, event.height);
      c2.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(b2);
    }
    return;
  }
  public function setOrientation__I(orientation: int): void {
    this.checkWidget__();
    if (this.getOrientation__() == orientation)
      return;
    if (orientation != 256 && orientation != 512) {
      SWT.error__I(5);
    }
    sashStyle &= ~(256 | 512);
    sashStyle |= orientation == 512 ? 256 : 512;
    for (var i: int = 0; i < sashes.length; i++) {
      sashes[i].dispose__();
      sashes[i] = new Sash(this, sashStyle);
      sashes[i].setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
      sashes[i].setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
      sashes[i].addListener__ILorg_eclipse_swt_widgets_Listener_2(13, sashListener);
    }
    this.layout__Z(false);
    return;
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    background = color;
    for (var i: int = 0; i < sashes.length; i++) {
      sashes[i].setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
    }
    return;
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    foreground = color;
    for (var i: int = 0; i < sashes.length; i++) {
      sashes[i].setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
    }
    return;
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setMaximizedControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control === null) {
      if (maxControl !== null) {
        this.maxControl = null;
        this.layout__Z(false);
        for (var i: int = 0; i < sashes.length; i++) {
          sashes[i].setVisible__Z(true);
        }
      }
      return;
    }
    for (var i_1: int = 0; i_1 < sashes.length; i_1++) {
      sashes[i_1].setVisible__Z(false);
    }
    maxControl = control;
    this.layout__Z(false);
    return;
  }
  public function setSashWidth__I(width_1: int): void {
    this.checkWidget__();
    if (SASH_WIDTH == width_1)
      return;
    SASH_WIDTH = width_1;
    this.layout__Z(false);
  }
  public function setWeights___3I(weights: JavaArray): void {
    this.checkWidget__();
    var cArray: JavaArray = this.getControls__Z(false);
    if (weights === null || weights.length != cArray.length) {
      SWT.error__I(5);
    }
    var total: int = 0;
    for (var i: int = 0; i < weights.length; i++) {
      if (weights[i] < 0) {
        SWT.error__I(5);
      }
      total += weights[i];
    }
    if (total == 0) {
      SWT.error__I(5);
    }
    for (var i_1: int = 0; i_1 < cArray.length; i_1++) {
      var data_1: Object = cArray[i_1].getLayoutData__();
      if (data_1 === null || !(data_1 is SashFormData)) {
        data_1 = new SashFormData();
        cArray[i_1].setLayoutData__Ljava_lang_Object_2(data_1);
      }
      (SashFormData(data_1)).weight = ((Number(weights[i_1]) << 16) + total - 1) / total;
    }
    this.layout__Z(false);
    return;
  }
}
}
