package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Sash;
import java.lang.System;
import java.lang.JavaArray;
dynamic public class SashFormLayout extends Layout {
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var sashForm: SashForm = SashForm(composite);
    var cArray: JavaArray = sashForm.getControls__Z(true);
    var width: int = 0;
    var height: int = 0;
    if (cArray.length == 0) {
      if (wHint != -1)
        width = wHint;
      if (hHint != -1)
        height = hHint;
      return new Point(width, height);
    }
    var vertical: Boolean = sashForm.getOrientation__() == 512;
    var maxIndex: int = 0;
    var maxValue: int = 0;
    for (var i: int = 0; i < cArray.length; i++) {
      if (vertical) {
        var size: Point = cArray[i].computeSize__IIZ(wHint, -1, flushCache);
        if (size.y > maxValue) {
          maxIndex = i;
          maxValue = size.y;
        }
        width = Math__.max__II(width, size.x);
      } else {
        var size_1: Point = cArray[i].computeSize__IIZ(-1, hHint, flushCache);
        if (size_1.x > maxValue) {
          maxIndex = i;
          maxValue = size_1.x;
        }
        height = Math__.max__II(height, size_1.y);
      }
    }
    var ratios: JavaArray = new JavaArray("[J").lengths(cArray.length);
    var total: Number = 0;
    for (var i_1: int = 0; i_1 < cArray.length; i_1++) {
      var data: Object = cArray[i_1].getLayoutData__();
      if (data !== null && data is SashFormData) {
        ratios[i_1] = (SashFormData(data)).weight;
      } else {
        data = new SashFormData();
        cArray[i_1].setLayoutData__Ljava_lang_Object_2(data);
        (SashFormData(data)).weight = ratios[i_1] = int(((200 << 16) + 999) / 1000);
      }
      total += ratios[i_1];
    }
    if (ratios[maxIndex] > 0) {
      var sashwidth: int = sashForm.sashes.length > 0 ? sashForm.SASH_WIDTH + sashForm.sashes[0].getBorderWidth__() * 2 : sashForm.SASH_WIDTH;
      if (vertical) {
        height += int((total * maxValue / ratios[maxIndex])) + (cArray.length - 1) * sashwidth;
      } else {
        width += int((total * maxValue / ratios[maxIndex])) + (cArray.length - 1) * sashwidth;
      }
    }
    width += sashForm.getBorderWidth__() * 2;
    height += sashForm.getBorderWidth__() * 2;
    if (wHint != -1)
      width = wHint;
    if (hHint != -1)
      height = hHint;
    return new Point(width, height);
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var sashForm: SashForm = SashForm(composite);
    var area: Rectangle = sashForm.getClientArea__();
    if (area.width <= 1 || area.height <= 1)
      return;
    var newControls: JavaArray = sashForm.getControls__Z(true);
    if (sashForm.controls.length == 0 && newControls.length == 0)
      return;
    sashForm.controls = newControls;
    var controls: JavaArray = sashForm.controls;
    if (sashForm.maxControl !== null && !sashForm.maxControl.isDisposed__()) {
      for (var i: int = 0; i < controls.length; i++) {
        if (controls[i] !== sashForm.maxControl) {
          controls[i].setBounds__IIII(-200, -200, 0, 0);
        } else {
          controls[i].setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(area);
        }
      }
      return;
    }
    if (sashForm.sashes.length < controls.length - 1) {
      var newSashes: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Sash;").lengths(controls.length - 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(sashForm.sashes, 0, newSashes, 0, sashForm.sashes.length);
      for (var i_1: int = sashForm.sashes.length; i_1 < newSashes.length; i_1++) {
        newSashes[i_1] = new Sash(sashForm, sashForm.sashStyle);
        newSashes[i_1].setBackground__Lorg_eclipse_swt_graphics_Color_2(sashForm.background);
        newSashes[i_1].setForeground__Lorg_eclipse_swt_graphics_Color_2(sashForm.foreground);
        newSashes[i_1].addListener__ILorg_eclipse_swt_widgets_Listener_2(13, sashForm.sashListener);
      }
      sashForm.sashes = newSashes;
    }
    if (sashForm.sashes.length > controls.length - 1) {
      if (controls.length == 0) {
        for (var i_2: int = 0; i_2 < sashForm.sashes.length; i_2++) {
          sashForm.sashes[i_2].dispose__();
        }
        sashForm.sashes = new JavaArray("[Lorg/eclipse/swt/widgets/Sash;").lengths(0);
      } else {
        var newSashes_1: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Sash;").lengths(controls.length - 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(sashForm.sashes, 0, newSashes_1, 0, newSashes_1.length);
        for (var i_3: int = controls.length - 1; i_3 < sashForm.sashes.length; i_3++) {
          sashForm.sashes[i_3].dispose__();
        }
        sashForm.sashes = newSashes_1;
      }
    }
    if (controls.length == 0)
      return;
    var sashes: JavaArray = sashForm.sashes;
    var ratios: JavaArray = new JavaArray("[J").lengths(controls.length);
    var total: Number = 0;
    for (var i_4: int = 0; i_4 < controls.length; i_4++) {
      var data: Object = controls[i_4].getLayoutData__();
      if (data !== null && data is SashFormData) {
        ratios[i_4] = (SashFormData(data)).weight;
      } else {
        data = new SashFormData();
        controls[i_4].setLayoutData__Ljava_lang_Object_2(data);
        (SashFormData(data)).weight = ratios[i_4] = int(((200 << 16) + 999) / 1000);
      }
      total += ratios[i_4];
    }
    var sashwidth: int = sashes.length > 0 ? sashForm.SASH_WIDTH + sashes[0].getBorderWidth__() * 2 : sashForm.SASH_WIDTH;
    if (sashForm.getOrientation__() == 256) {
      var width: int = int((ratios[0] * (area.width - sashes.length * sashwidth) / total));
      var x: int = area.x;
      controls[0].setBounds__IIII(x, area.y, width, area.height);
      x += width;
      for (var i_5: int = 1; i_5 < controls.length - 1; i_5++) {
        sashes[i_5 - 1].setBounds__IIII(x, area.y, sashwidth, area.height);
        x += sashwidth;
        width = int((ratios[i_5] * (area.width - sashes.length * sashwidth) / total));
        controls[i_5].setBounds__IIII(x, area.y, width, area.height);
        x += width;
      }
      if (controls.length > 1) {
        sashes[sashes.length - 1].setBounds__IIII(x, area.y, sashwidth, area.height);
        x += sashwidth;
        width = area.width - x;
        controls[controls.length - 1].setBounds__IIII(x, area.y, width, area.height);
      }
    } else {
      var height: int = int((ratios[0] * (area.height - sashes.length * sashwidth) / total));
      var y: int = area.y;
      controls[0].setBounds__IIII(area.x, y, area.width, height);
      y += height;
      for (var i_6: int = 1; i_6 < controls.length - 1; i_6++) {
        sashes[i_6 - 1].setBounds__IIII(area.x, y, area.width, sashwidth);
        y += sashwidth;
        height = int((ratios[i_6] * (area.height - sashes.length * sashwidth) / total));
        controls[i_6].setBounds__IIII(area.x, y, area.width, height);
        y += height;
      }
      if (controls.length > 1) {
        sashes[sashes.length - 1].setBounds__IIII(area.x, y, area.width, sashwidth);
        y += sashwidth;
        height = area.height - y;
        controls[controls.length - 1].setBounds__IIII(area.x, y, area.width, height);
      }
    }
    return;
  }
}
}
