package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Layout;
import java.lang.Math__;
import org.eclipse.swt.widgets.Display;
import java.lang.Arguments;
dynamic public class ScrolledComposite extends Composite {
  internal var content: Control;
  internal var contentListener: Listener;
  internal var filter: Listener;
  internal var minHeight: int = 0;
  internal var minWidth: int = 0;
  internal var expandHorizontal: Boolean = false;
  internal var expandVertical: Boolean = false;
  internal var alwaysShowScroll: Boolean = false;
  internal var showFocusedControl: Boolean = false;
  public function ScrolledComposite(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, ScrolledComposite.checkStyle__I(style)]));
    super.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new ScrolledCompositeLayout());
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (hBar !== null) {
      hBar.setVisible__Z(false);
      hBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.custom.ScrolledComposite$1(this));
    }
    var vBar: ScrollBar = this.getVerticalBar__();
    if (vBar !== null) {
      vBar.setVisible__Z(false);
      vBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.custom.ScrolledComposite$2(this));
    }
    contentListener = new org.eclipse.swt.custom.ScrolledComposite$3(this);
    filter = new org.eclipse.swt.custom.ScrolledComposite$4(this);
    this.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.custom.ScrolledComposite$5(this));
    return;
  }
  public static function checkStyle__I(style: int): int {
    var mask: int = 256 | 512 | 2048 | 33554432 | 67108864;
    return style & mask;
  }
  public function contains__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    if (control === null || control.isDisposed__())
      return false;
    var parent_1: Composite = control.getParent__();
    while (parent_1 !== null && !(parent_1 is Shell)) {
      if (this === parent_1)
        return true;
      parent_1 = parent_1.getParent__();
    }
    return false;
  }
  public function getAlwaysShowScrollBars__(): Boolean {
    return alwaysShowScroll;
  }
  public function getExpandHorizontal__(): Boolean {
    this.checkWidget__();
    return expandHorizontal;
  }
  public function getExpandVertical__(): Boolean {
    this.checkWidget__();
    return expandVertical;
  }
  public function getMinWidth__(): int {
    this.checkWidget__();
    return minWidth;
  }
  public function getMinHeight__(): int {
    this.checkWidget__();
    return minHeight;
  }
  public function getContent__(): Control {
    return content;
  }
  public function getShowFocusedControl__(): Boolean {
    this.checkWidget__();
    return showFocusedControl;
  }
  public function hScroll__(): void {
    if (content === null)
      return;
    var location: Point = content.getLocation__();
    var hBar: ScrollBar = this.getHorizontalBar__();
    var hSelection: int = hBar.getSelection__();
    content.setLocation__II(-hSelection, location.y);
  }
  public function needHScroll__Lorg_eclipse_swt_graphics_Rectangle_2Z(contentRect: Rectangle, vVisible: Boolean): Boolean {
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (hBar === null)
      return false;
    var hostRect: Rectangle = this.getBounds__();
    var border: int = this.getBorderWidth__();
    hostRect.width -= 2 * border;
    var vBar: ScrollBar = this.getVerticalBar__();
    if (vVisible && vBar !== null)
      hostRect.width -= vBar.getSize__().x;
    if (!expandHorizontal && contentRect.width > hostRect.width)
      return true;
    if (expandHorizontal && minWidth > hostRect.width)
      return true;
    return false;
  }
  public function needVScroll__Lorg_eclipse_swt_graphics_Rectangle_2Z(contentRect: Rectangle, hVisible: Boolean): Boolean {
    var vBar: ScrollBar = this.getVerticalBar__();
    if (vBar === null)
      return false;
    var hostRect: Rectangle = this.getBounds__();
    var border: int = this.getBorderWidth__();
    hostRect.height -= 2 * border;
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (hVisible && hBar !== null)
      hostRect.height -= hBar.getSize__().y;
    if (!expandVertical && contentRect.height > hostRect.height)
      return true;
    if (expandVertical && minHeight > hostRect.height)
      return true;
    return false;
  }
  public function getOrigin__(): Point {
    this.checkWidget__();
    if (content === null)
      return new Point(0, 0);
    var location: Point = content.getLocation__();
    return new Point(-location.x, -location.y);
  }
  public function setOrigin__Lorg_eclipse_swt_graphics_Point_2(origin: Point): void {
    this.setOrigin__II(origin.x, origin.y);
  }
  public function setOrigin__II(x_1: int, y_1: int): void {
    this.checkWidget__();
    if (content === null)
      return;
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (hBar !== null) {
      hBar.setSelection__I(x_1);
      x_1 = -hBar.getSelection__();
    } else {
      x_1 = 0;
    }
    var vBar: ScrollBar = this.getVerticalBar__();
    if (vBar !== null) {
      vBar.setSelection__I(y_1);
      y_1 = -vBar.getSelection__();
    } else {
      y_1 = 0;
    }
    content.setLocation__II(x_1, y_1);
    return;
  }
  public function setAlwaysShowScrollBars__Z(show: Boolean): void {
    this.checkWidget__();
    if (show == alwaysShowScroll)
      return;
    alwaysShowScroll = show;
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (hBar !== null && alwaysShowScroll)
      hBar.setVisible__Z(true);
    var vBar: ScrollBar = this.getVerticalBar__();
    if (vBar !== null && alwaysShowScroll)
      vBar.setVisible__Z(true);
    this.layout__Z(false);
  }
  public function setContent__Lorg_eclipse_swt_widgets_Control_2(content_1: Control): void {
    this.checkWidget__();
    if (this.content !== null && !this.content.isDisposed__()) {
      this.content.removeListener__ILorg_eclipse_swt_widgets_Listener_2(11, contentListener);
      this.content.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(new Rectangle(-200, -200, 0, 0));
    }
    this.content = content_1;
    var vBar: ScrollBar = this.getVerticalBar__();
    var hBar: ScrollBar = this.getHorizontalBar__();
    if (this.content !== null) {
      if (vBar !== null) {
        vBar.setMaximum__I(0);
        vBar.setThumb__I(0);
        vBar.setSelection__I(0);
      }
      if (hBar !== null) {
        hBar.setMaximum__I(0);
        hBar.setThumb__I(0);
        hBar.setSelection__I(0);
      }
      content_1.setLocation__II(0, 0);
      this.layout__Z(false);
      this.content.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, contentListener);
    } else {
      if (hBar !== null)
        hBar.setVisible__Z(alwaysShowScroll);
      if (vBar !== null)
        vBar.setVisible__Z(alwaysShowScroll);
    }
    return;
  }
  public function setExpandHorizontal__Z(expand: Boolean): void {
    this.checkWidget__();
    if (expand == expandHorizontal)
      return;
    expandHorizontal = expand;
    this.layout__Z(false);
  }
  public function setExpandVertical__Z(expand: Boolean): void {
    this.checkWidget__();
    if (expand == expandVertical)
      return;
    expandVertical = expand;
    this.layout__Z(false);
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setMinHeight__I(height_1: int): void {
    this.setMinSize__II(minWidth, height_1);
  }
  public function setMinSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    if (size === null) {
      this.setMinSize__II(0, 0);
    } else {
      this.setMinSize__II(size.x, size.y);
    }
    return;
  }
  public function setMinSize__II(width_1: int, height_1: int): void {
    this.checkWidget__();
    if (width_1 == minWidth && height_1 == minHeight)
      return;
    minWidth = Math__.max__II(0, width_1);
    minHeight = Math__.max__II(0, height_1);
    this.layout__Z(false);
  }
  public function setMinWidth__I(width_1: int): void {
    this.setMinSize__II(width_1, minHeight);
  }
  public function setShowFocusedControl__Z(show: Boolean): void {
    this.checkWidget__();
    if (showFocusedControl == show)
      return;
    var display_1: Display = this.getDisplay__();
    display_1.removeFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
    showFocusedControl = show;
    if (!showFocusedControl)
      return;
    display_1.addFilter__ILorg_eclipse_swt_widgets_Listener_2(15, filter);
    var control: Control = display_1.getFocusControl__();
    if (this.contains__Lorg_eclipse_swt_widgets_Control_2(control))
      this.showControl__Lorg_eclipse_swt_widgets_Control_2(control);
  }
  public function showControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    this.checkWidget__();
    if (control === null)
      SWT.error__I(4);
    if (control.isDisposed__())
      SWT.error__I(5);
    if (!this.contains__Lorg_eclipse_swt_widgets_Control_2(control))
      SWT.error__I(5);
    var itemRect: Rectangle = this.getDisplay__().map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_graphics_Rectangle_2(control.getParent__(), this, control.getBounds__());
    var area: Rectangle = this.getClientArea__();
    var origin: Point = this.getOrigin__();
    if (itemRect.x < 0) {
      origin.x = Math__.max__II(0, origin.x + itemRect.x);
    } else {
      if (area.width < itemRect.x + itemRect.width)
        origin.x = Math__.max__II(0, origin.x + itemRect.x + Math__.min__II(itemRect.width, area.width) - area.width);
    }
    if (itemRect.y < 0) {
      origin.y = Math__.max__II(0, origin.y + itemRect.y);
    } else {
      if (area.height < itemRect.y + itemRect.height)
        origin.y = Math__.max__II(0, origin.y + itemRect.y + Math__.min__II(itemRect.height, area.height) - area.height);
    }
    this.setOrigin__Lorg_eclipse_swt_graphics_Point_2(origin);
    return;
  }
  public function vScroll__(): void {
    if (content === null)
      return;
    var location: Point = content.getLocation__();
    var vBar: ScrollBar = this.getVerticalBar__();
    var vSelection: int = vBar.getSelection__();
    content.setLocation__II(location.x, -vSelection);
  }
}
}
