package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import java.lang.Math__;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.graphics.Rectangle;
dynamic public class ScrolledCompositeLayout extends Layout {
  internal var inLayout: Boolean = false;
  public static const DEFAULT_WIDTH: int = 64;
  public static const DEFAULT_HEIGHT: int = 64;
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var sc: ScrolledComposite = ScrolledComposite(composite);
    var size: Point = new Point(64, 64);
    if (sc.content !== null) {
      var preferredSize: Point = sc.content.computeSize__IIZ(wHint, hHint, flushCache);
      var currentSize: Point = sc.content.getSize__();
      size.x = sc.getExpandHorizontal__() ? preferredSize.x : currentSize.x;
      size.y = sc.getExpandVertical__() ? preferredSize.y : currentSize.y;
    }
    size.x = Math__.max__II(size.x, sc.minWidth);
    size.y = Math__.max__II(size.y, sc.minHeight);
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    return size;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    if (inLayout)
      return;
    var sc: ScrolledComposite = ScrolledComposite(composite);
    if (sc.content === null)
      return;
    var hBar: ScrollBar = sc.getHorizontalBar__();
    var vBar: ScrollBar = sc.getVerticalBar__();
    if (hBar !== null) {
      if (hBar.getSize__().y >= sc.getSize__().y) {
        return;
      }
    }
    if (vBar !== null) {
      if (vBar.getSize__().x >= sc.getSize__().x) {
        return;
      }
    }
    inLayout = true;
    var contentRect: Rectangle = sc.content.getBounds__();
    if (!sc.alwaysShowScroll) {
      var hVisible: Boolean = sc.needHScroll__Lorg_eclipse_swt_graphics_Rectangle_2Z(contentRect, false);
      var vVisible: Boolean = sc.needVScroll__Lorg_eclipse_swt_graphics_Rectangle_2Z(contentRect, hVisible);
      if (!hVisible && vVisible)
        hVisible = sc.needHScroll__Lorg_eclipse_swt_graphics_Rectangle_2Z(contentRect, vVisible);
      if (hBar !== null)
        hBar.setVisible__Z(hVisible);
      if (vBar !== null)
        vBar.setVisible__Z(vVisible);
    }
    var hostRect: Rectangle = sc.getClientArea__();
    if (sc.expandHorizontal) {
      contentRect.width = Math__.max__II(sc.minWidth, hostRect.width);
    }
    if (sc.expandVertical) {
      contentRect.height = Math__.max__II(sc.minHeight, hostRect.height);
    }
    if (hBar !== null) {
      hBar.setMaximum__I(contentRect.width);
      hBar.setThumb__I(Math__.min__II(contentRect.width, hostRect.width));
      var hPage: int = contentRect.width - hostRect.width;
      var hSelection: int = hBar.getSelection__();
      if (hSelection >= hPage) {
        if (hPage <= 0) {
          hSelection = 0;
          hBar.setSelection__I(0);
        }
        contentRect.x = -hSelection;
      }
    }
    if (vBar !== null) {
      vBar.setMaximum__I(contentRect.height);
      vBar.setThumb__I(Math__.min__II(contentRect.height, hostRect.height));
      var vPage: int = contentRect.height - hostRect.height;
      var vSelection: int = vBar.getSelection__();
      if (vSelection >= vPage) {
        if (vPage <= 0) {
          vSelection = 0;
          vBar.setSelection__I(0);
        }
        contentRect.y = -vSelection;
      }
    }
    sc.content.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(contentRect);
    inLayout = false;
    return;
  }
}
}
