package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import java.lang.Math__;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class StackLayout extends Layout {
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var topControl: Control;
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var children: JavaArray = composite.getChildren__();
    var maxWidth: int = 0;
    var maxHeight: int = 0;
    for (var i: int = 0; i < children.length; i++) {
      var size: Point = children[i].computeSize__IIZ(wHint, hHint, flushCache);
      maxWidth = Math__.max__II(size.x, maxWidth);
      maxHeight = Math__.max__II(size.y, maxHeight);
    }
    var width: int = maxWidth + 2 * marginWidth;
    var height: int = maxHeight + 2 * marginHeight;
    if (wHint != -1)
      width = wHint;
    if (hHint != -1)
      height = hHint;
    return new Point(width, height);
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var children: JavaArray = composite.getChildren__();
    var rect: Rectangle = composite.getClientArea__();
    rect.x += marginWidth;
    rect.y += marginHeight;
    rect.width -= 2 * marginWidth;
    rect.height -= 2 * marginHeight;
    for (var i: int = 0; i < children.length; i++) {
      children[i].setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
      children[i].setVisible__Z(children[i] === topControl);
    }
    return;
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function toString__(): String {
    var string: String = this.getName__() + " {";
    if (marginWidth != 0)
      string += "marginWidth=" + marginWidth + " ";
    if (marginHeight != 0)
      string += "marginHeight=" + marginHeight + " ";
    if (topControl !== null)
      string += "topControl=" + java.lang.System.stringValueOf(topControl) + " ";
    string = Object(string).trim__();
    string += "}";
    return string;
  }
}
}
