package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.CloneableCompatibility;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import java.lang.CloneNotSupportedException;
import java.lang.StringBuffer;
import java.lang.Arguments;
dynamic public class StyleRange extends TextStyle implements CloneableCompatibility {
  public var start: int;
  public var length: int;
  public var fontStyle: int = 0;
  public function StyleRange__(): Object {
    return this;
  }
  public function StyleRange__Lorg_eclipse_swt_graphics_TextStyle_2(style: TextStyle): Object {
    return this;
  }
  public function StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(start: int, length: int, foreground: Color, background: Color): Object {
    this.start = start;
    this.length = length;
    return this;
  }
  public function StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I(start: int, length: int, foreground: Color, background: Color, fontStyle: int): Object {
    this.fontStyle = fontStyle;
    return this;
  }
  public override function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (object is StyleRange) {
      var style: StyleRange = StyleRange(object);
      if (start != style.start)
        return false;
      if (length != style.length)
        return false;
      return this.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(style);
    }
    return false;
  }
  public override function hashCode__(): int {
    return super.hashCode__() ^ fontStyle;
  }
  public function isVariableHeight__(): Boolean {
    return font !== null || metrics !== null || rise != 0;
  }
  public function isUnstyled__(): Boolean {
    if (font !== null)
      return false;
    if (rise != 0)
      return false;
    if (metrics !== null)
      return false;
    if (foreground !== null)
      return false;
    if (background !== null)
      return false;
    if (fontStyle != 0)
      return false;
    if (underline)
      return false;
    if (strikeout)
      return false;
    if (borderStyle != 0)
      return false;
    return true;
  }
  public function similarTo__Lorg_eclipse_swt_custom_StyleRange_2(style: StyleRange): Boolean {
    if (!super.equals__Ljava_lang_Object_2(style))
      return false;
    if (fontStyle != style.fontStyle)
      return false;
    return true;
  }
  public function clone__(): Object {
    try {
      return Object(Object.prototype).clone__.call(this);
    } catch (e : CloneNotSupportedException) {
      return null;
    }
    return null;
  }
  public override function toString__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buffer.append__Ljava_lang_String_2("StyleRange {");
    buffer.append__I(start);
    buffer.append__Ljava_lang_String_2(", ");
    buffer.append__I(length);
    buffer.append__Ljava_lang_String_2(", fontStyle=");
    switch (fontStyle) {
      case 1 :
        buffer.append__Ljava_lang_String_2("bold");
        break;
      case 2 :
        buffer.append__Ljava_lang_String_2("italic");
        break;
      case 1 | 2 :
        buffer.append__Ljava_lang_String_2("bold-italic");
        break;
      default :
        buffer.append__Ljava_lang_String_2("normal");
    }
    var str: String = super.toString__();
    var index: int = Object(str).indexOf__I(123);
    str = Object(str).substring__I(index + 1);
    if (Object(str).length__() > 1)
      buffer.append__Ljava_lang_String_2(", ");
    buffer.append__Ljava_lang_String_2(str);
    return buffer.toString__();
  }
  public function StyleRange(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is TextStyle) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is Color && vargs[3] is Color) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 5 && vargs[0] is int && vargs[1] is int && vargs[2] is Color && vargs[3] is Color && vargs[4] is int) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_TextStyle_2, [args1[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3]];
        superArgs = new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [null, args2[2], args2[3]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2], args[3], args[4]];
        args2 = [args3[0], args3[1], args3[2], args3[3]];
        superArgs = new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [null, args2[2], args2[3]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        StyleRange__();
        break;
      case 1:
        StyleRange__Lorg_eclipse_swt_graphics_TextStyle_2(args1[0]);
        break;
      case 2:
        StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(args2[0], args2[1], args2[2], args2[3]);
        break;
      case 3:
        StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(args2[0], args2[1], args2[2], args2[3]);
        StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I(args3[0], args3[1], args3[2], args3[3], args3[4]);
        break;
    }
  }
  public static const StyleRange__ : int = 0;
  public static const StyleRange__Lorg_eclipse_swt_graphics_TextStyle_2 : int = 1;
  public static const StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2 : int = 2;
  public static const StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I : int = 3;
}
}
