package org.eclipse.swt.custom {
import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.printing.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Canvas;
import java.lang.Runnable;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Font;
import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import java.util.Enumeration;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.Math__;
import java.lang.StringBuffer;
import org.eclipse.swt.graphics.FontMetrics;
import java.util.Vector;
import java.lang.System;
import java.lang.NumberFormatException;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Event;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.dnd.RTFTransfer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledText$Printing implements Runnable {
  public static const LEFT: int = 0;
  public static const CENTER: int = 1;
  public static const RIGHT: int = 2;
  public var printer: Printer;
  public var printerRenderer: StyledTextRenderer;
  public var printOptions: StyledTextPrintOptions;
  public var clientArea: Rectangle;
  public var fontData: FontData;
  public var printerFont: Font;
  public var resources: Hashtable;
  public var tabLength: int;
  public var gc: GC;
  public var pageWidth: int;
  public var startPage: int;
  public var endPage: int;
  public var startLine: int;
  public var endLine: int;
  public var singleLine: Boolean;
  public var selection: Point = null;
  public var mirrored: Boolean;
  public var lineSpacing: int;
  public var printMargin: int;
  public function StyledText$Printing(styledText: StyledText, printer: Printer, printOptions: StyledTextPrintOptions) {
    this.printer = printer;
    this.printOptions = printOptions;
    this.mirrored = (styledText.getStyle__() & 134217728) != 0;
    singleLine = styledText.isSingleLine__();
    startPage = 1;
    endPage = 2147483647;
    var data: PrinterData = printer.getPrinterData__();
    if (data.scope == 1) {
      startPage = data.startPage;
      endPage = data.endPage;
      if (endPage < startPage) {
        var temp: int = endPage;
        endPage = startPage;
        startPage = temp;
      }
    } else if (data.scope == 2) {
      selection = styledText.getSelectionRange__();
    }
    printerRenderer = new StyledTextRenderer(printer, null);
    printerRenderer.setContent__Lorg_eclipse_swt_custom_StyledTextContent_2(this.copyContent__Lorg_eclipse_swt_custom_StyledTextContent_2(styledText.getContent__()));
    this.cacheLineData__Lorg_eclipse_swt_custom_StyledText_2(styledText);
    return;
  }
  public function cacheLineData__Lorg_eclipse_swt_custom_StyledText_2(styledText: StyledText): void {
    var renderer: StyledTextRenderer = styledText.renderer;
    renderer.copyInto__Lorg_eclipse_swt_custom_StyledTextRenderer_2(printerRenderer);
    fontData = styledText.getFont__().getFontData__()[0];
    tabLength = styledText.tabLength;
    var lineCount: int = printerRenderer.lineCount;
    if (styledText.isListening__I(3001) || (styledText.isBidi__() && styledText.isListening__I(3007)) || styledText.isListening__I(3002)) {
      var content: StyledTextContent = printerRenderer.content;
      for (var i: int = 0; i < lineCount; i++) {
        var line: String = content.getLine__I(i);
        var lineOffset: int = content.getOffsetAtLine__I(i);
        var event: StyledTextEvent = styledText.getLineBackgroundData__ILjava_lang_String_2(lineOffset, line);
        if (event !== null && event.lineBackground !== null) {
          printerRenderer.setLineBackground__IILorg_eclipse_swt_graphics_Color_2(i, 1, event.lineBackground);
        }
        if (styledText.isBidi__()) {
          var segments: JavaArray = styledText.getBidiSegments__ILjava_lang_String_2(lineOffset, line);
          printerRenderer.setLineSegments__II_3I(i, 1, segments);
        }
        event = styledText.getLineStyleData__ILjava_lang_String_2(lineOffset, line);
        if (event !== null) {
          printerRenderer.setLineIndent__III(i, 1, event.indent);
          printerRenderer.setLineAlignment__III(i, 1, event.alignment);
          printerRenderer.setLineJustify__IIZ(i, 1, event.justify);
          printerRenderer.setLineBullet__IILorg_eclipse_swt_custom_Bullet_2(i, 1, event.bullet);
          var styles: JavaArray = event.styles;
          if (styles !== null && styles.length > 0) {
            printerRenderer.setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(event.ranges, styles);
          }
        }
      }
    }
    var screenDPI: Point = styledText.getDisplay__().getDPI__();
    var printerDPI: Point = printer.getDPI__();
    resources = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
    for (var i_1: int = 0; i_1 < lineCount; i_1++) {
      var color: Color = printerRenderer.getLineBackground__ILorg_eclipse_swt_graphics_Color_2(i_1, null);
      if (color !== null) {
        if (printOptions.printLineBackground) {
          var printerColor: Color = Color(resources.get__Ljava_lang_Object_2(color));
          if (printerColor === null) {
            printerColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [printer, color.getRGB__()]));
            resources.put__Ljava_lang_Object_2Ljava_lang_Object_2(color, printerColor);
          }
          printerRenderer.setLineBackground__IILorg_eclipse_swt_graphics_Color_2(i_1, 1, printerColor);
        } else {
          printerRenderer.setLineBackground__IILorg_eclipse_swt_graphics_Color_2(i_1, 1, null);
        }
      }
      var indent: int = printerRenderer.getLineIndent__II(i_1, 0);
      if (indent != 0) {
        printerRenderer.setLineIndent__III(i_1, 1, int(indent * printerDPI.x / screenDPI.x));
      }
    }
    var styles_1: JavaArray = printerRenderer.styles;
    for (var i_2: int = 0; i_2 < printerRenderer.styleCount; i_2++) {
      var style: StyleRange = styles_1[i_2];
      var font: Font = style.font;
      if (style.font !== null) {
        var printerFont_1: Font = Font(resources.get__Ljava_lang_Object_2(font));
        if (printerFont_1 === null) {
          printerFont_1 = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2, [printer, font.getFontData__()]));
          resources.put__Ljava_lang_Object_2Ljava_lang_Object_2(font, printerFont_1);
        }
        style.font = printerFont_1;
      }
      var color_1: Color = style.foreground;
      if (color_1 !== null) {
        var printerColor_1: Color = Color(resources.get__Ljava_lang_Object_2(color_1));
        if (printOptions.printTextForeground) {
          if (printerColor_1 === null) {
            printerColor_1 = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [printer, color_1.getRGB__()]));
            resources.put__Ljava_lang_Object_2Ljava_lang_Object_2(color_1, printerColor_1);
          }
          style.foreground = printerColor_1;
        } else {
          style.foreground = null;
        }
      }
      color_1 = style.background;
      if (color_1 !== null) {
        var printerColor_2: Color = Color(resources.get__Ljava_lang_Object_2(color_1));
        if (printOptions.printTextBackground) {
          if (printerColor_2 === null) {
            printerColor_2 = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [printer, color_1.getRGB__()]));
            resources.put__Ljava_lang_Object_2Ljava_lang_Object_2(color_1, printerColor_2);
          }
          style.background = printerColor_2;
        } else {
          style.background = null;
        }
      }
      if (!printOptions.printTextFontStyle) {
        style.fontStyle = 0;
      }
      style.rise = int(style.rise * printerDPI.y / screenDPI.y);
      var metrics: GlyphMetrics = style.metrics;
      if (metrics !== null) {
        metrics.ascent = int(metrics.ascent * printerDPI.y / screenDPI.y);
        metrics.descent = int(metrics.descent * printerDPI.y / screenDPI.y);
        metrics.width = int(metrics.width * printerDPI.x / screenDPI.x);
      }
    }
    lineSpacing = int(styledText.lineSpacing * printerDPI.y / screenDPI.y);
    if (printOptions.printLineNumbers) {
      printMargin = int(3 * printerDPI.x / screenDPI.x);
    }
    return;
  }
  public function copyContent__Lorg_eclipse_swt_custom_StyledTextContent_2(original: StyledTextContent): StyledTextContent {
    var printerContent: StyledTextContent = new DefaultContent();
    var insertOffset: int = 0;
    for (var i: int = 0; i < original.getLineCount__(); i++) {
      var insertEndOffset: int;
      if (i < original.getLineCount__() - 1) {
        insertEndOffset = original.getOffsetAtLine__I(i + 1);
      } else {
        insertEndOffset = original.getCharCount__();
      }
      printerContent.replaceTextRange__IILjava_lang_String_2(insertOffset, 0, original.getTextRange__II(insertOffset, insertEndOffset - insertOffset));
      insertOffset = insertEndOffset;
    }
    return printerContent;
  }
  public function dispose__(): void {
    if (gc !== null) {
      gc.dispose__();
      gc = null;
    }
    if (resources !== null) {
      var enumeration: Enumeration = resources.elements__();
      while (enumeration.hasMoreElements__()) {
        var resource: Resource = Resource(enumeration.nextElement__());
        resource.dispose__();
      }
      resources = null;
    }
    if (printerFont !== null) {
      printerFont.dispose__();
      printerFont = null;
    }
    if (printerRenderer !== null) {
      printerRenderer.dispose__();
      printerRenderer = null;
    }
    return;
  }
  public function init__(): void {
    var trim: Rectangle = printer.computeTrim__IIII(0, 0, 0, 0);
    var dpi: Point = printer.getDPI__();
    printerFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II, [printer, fontData.getName__(), fontData.getHeight__(), 0]));
    clientArea = printer.getClientArea__();
    pageWidth = clientArea.width;
    clientArea.x = dpi.x + trim.x;
    clientArea.y = dpi.y + trim.y;
    clientArea.width -= (clientArea.x + trim.width);
    clientArea.height -= (clientArea.y + trim.height);
    var style: int = mirrored ? 67108864 : 33554432;
    gc = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [printer, style]));
    gc.setFont__Lorg_eclipse_swt_graphics_Font_2(printerFont);
    printerRenderer.setFont__Lorg_eclipse_swt_graphics_Font_2I(printerFont, tabLength);
    var lineHeight: int = printerRenderer.getLineHeight__();
    if (printOptions.header !== null) {
      clientArea.y += lineHeight * 2;
      clientArea.height -= lineHeight * 2;
    }
    if (printOptions.footer !== null) {
      clientArea.height -= lineHeight * 2;
    }
    var content: StyledTextContent = printerRenderer.content;
    startLine = 0;
    endLine = singleLine ? 0 : content.getLineCount__() - 1;
    var data: PrinterData = printer.getPrinterData__();
    if (data.scope == 1) {
      var pageSize: int = int(clientArea.height / lineHeight);
      startLine = (startPage - 1) * pageSize;
    } else if (data.scope == 2) {
      startLine = content.getLineAtOffset__I(selection.x);
      if (selection.y > 0) {
        endLine = content.getLineAtOffset__I(selection.x + selection.y - 1);
      } else {
        endLine = startLine - 1;
      }
    }
    return;
  }
  public function print__(): void {
    var background: Color = gc.getBackground__();
    var foreground: Color = gc.getForeground__();
    var paintY: int = clientArea.y;
    var paintX: int = clientArea.x;
    var width: int = clientArea.width;
    var page: int = startPage;
    var pageBottom: int = clientArea.y + clientArea.height;
    var orientation: int = gc.getStyle__() & (67108864 | 33554432);
    var printLayout: TextLayout = null;
    if (printOptions.printLineNumbers || printOptions.header !== null || printOptions.footer !== null) {
      printLayout = new TextLayout(printer);
      printLayout.setFont__Lorg_eclipse_swt_graphics_Font_2(printerFont);
    }
    if (printOptions.printLineNumbers) {
      var numberingWidth: int = 0;
      var count: int = endLine - startLine + 1;
      var lineLabels: JavaArray = printOptions.lineLabels;
      if (lineLabels !== null) {
        for (var i: int = startLine; i < Math__.min__II(count, lineLabels.length); i++) {
          if (lineLabels[i] !== null) {
            printLayout.setText__Ljava_lang_String_2(lineLabels[i]);
            var lineWidth: int = printLayout.getBounds__().width;
            numberingWidth = Math__.max__II(numberingWidth, lineWidth);
          }
        }
      } else {
        var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["0"]));
        while ((count /= 10) > 0)
          buffer.append__Ljava_lang_String_2("0");
        printLayout.setText__Ljava_lang_String_2(buffer.toString__());
        numberingWidth = printLayout.getBounds__().width;
      }
      numberingWidth += printMargin;
      if (numberingWidth > width)
        numberingWidth = width;
      paintX += numberingWidth;
      width -= numberingWidth;
    }
    for (var i_1: int = startLine; i_1 <= endLine && page <= endPage; i_1++) {
      if (paintY == clientArea.y) {
        printer.startPage__();
        this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, true, printLayout);
      }
      var layout: TextLayout = printerRenderer.getTextLayout__IIII(i_1, orientation, width, lineSpacing);
      var lineBackground: Color = printerRenderer.getLineBackground__ILorg_eclipse_swt_graphics_Color_2(i_1, background);
      var paragraphBottom: int = paintY + layout.getBounds__().height;
      if (paragraphBottom <= pageBottom) {
        this.printLine__IILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_TextLayout_2Lorg_eclipse_swt_graphics_TextLayout_2I(paintX, paintY, gc, foreground, lineBackground, layout, printLayout, i_1);
        paintY = paragraphBottom;
      } else {
        var lineCount: int = layout.getLineCount__();
        while (paragraphBottom > pageBottom && lineCount > 0) {
          lineCount--;
          paragraphBottom -= layout.getLineBounds__I(lineCount).height + layout.getSpacing__();
        }
        if (lineCount == 0) {
          this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, false, printLayout);
          printer.endPage__();
          page++;
          if (page <= endPage) {
            printer.startPage__();
            this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, true, printLayout);
            paintY = clientArea.y;
            this.printLine__IILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_TextLayout_2Lorg_eclipse_swt_graphics_TextLayout_2I(paintX, paintY, gc, foreground, lineBackground, layout, printLayout, i_1);
            paintY += layout.getBounds__().height;
          }
        } else {
          var height: int = paragraphBottom - paintY;
          gc.setClipping__IIII(clientArea.x, paintY, clientArea.width, height);
          this.printLine__IILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_TextLayout_2Lorg_eclipse_swt_graphics_TextLayout_2I(paintX, paintY, gc, foreground, lineBackground, layout, printLayout, i_1);
          gc.setClipping__Lorg_eclipse_swt_graphics_Rectangle_2(Rectangle(null));
          this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, false, printLayout);
          printer.endPage__();
          page++;
          if (page <= endPage) {
            printer.startPage__();
            this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, true, printLayout);
            paintY = clientArea.y - height;
            var layoutHeight: int = layout.getBounds__().height;
            gc.setClipping__IIII(clientArea.x, clientArea.y, clientArea.width, layoutHeight - height);
            this.printLine__IILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_TextLayout_2Lorg_eclipse_swt_graphics_TextLayout_2I(paintX, paintY, gc, foreground, lineBackground, layout, printLayout, i_1);
            gc.setClipping__Lorg_eclipse_swt_graphics_Rectangle_2(Rectangle(null));
            paintY += layoutHeight;
          }
        }
      }
      printerRenderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout);
    }
    if (page <= endPage && paintY > clientArea.y) {
      this.printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page, false, printLayout);
      printer.endPage__();
    }
    if (printLayout !== null)
      printLayout.dispose__();
    return;
  }
  public function printDecoration__IZLorg_eclipse_swt_graphics_TextLayout_2(page: int, header: Boolean, layout: TextLayout): void {
    var text: String = header ? printOptions.header : printOptions.footer;
    if (text === null)
      return;
    var lastSegmentIndex: int = 0;
    for (var i: int = 0; i < 3; i++) {
      var segmentIndex: int = Object(text).indexOf__Ljava_lang_String_2I("\t", lastSegmentIndex);
      var segment: String;
      if (segmentIndex == -1) {
        segment = Object(text).substring__I(lastSegmentIndex);
        this.printDecorationSegment__Ljava_lang_String_2IIZLorg_eclipse_swt_graphics_TextLayout_2(segment, i, page, header, layout);
        break;
      } else {
        segment = Object(text).substring__II(lastSegmentIndex, segmentIndex);
        this.printDecorationSegment__Ljava_lang_String_2IIZLorg_eclipse_swt_graphics_TextLayout_2(segment, i, page, header, layout);
        lastSegmentIndex = segmentIndex + Object("\t").length__();
      }
    }
    return;
  }
  public function printDecorationSegment__Ljava_lang_String_2IIZLorg_eclipse_swt_graphics_TextLayout_2(segment: String, alignment: int, page: int, header: Boolean, layout: TextLayout): void {
    var pageIndex: int = Object(segment).indexOf__Ljava_lang_String_2("<page>");
    if (pageIndex != -1) {
      var pageTagLength: int = Object("<page>").length__();
      var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, [Object(segment).substring__II(0, pageIndex)]));
      buffer.append__I(page);
      buffer.append__Ljava_lang_String_2(Object(segment).substring__I(pageIndex + pageTagLength));
      segment = buffer.toString__();
    }
    if (Object(segment).length__() > 0) {
      layout.setText__Ljava_lang_String_2(segment);
      var segmentWidth: int = layout.getBounds__().width;
      var segmentHeight: int = printerRenderer.getLineHeight__();
      var drawX: int = 0;
      var drawY: int;
      if (alignment == 0) {
        drawX = clientArea.x;
      } else if (alignment == 1) {
        drawX = int((pageWidth - segmentWidth) / 2);
      } else if (alignment == 2) {
        drawX = clientArea.x + clientArea.width - segmentWidth;
      }
      if (header) {
        drawY = clientArea.y - segmentHeight * 2;
      } else {
        drawY = clientArea.y + clientArea.height + segmentHeight;
      }
      layout.draw__Lorg_eclipse_swt_graphics_GC_2II(gc, drawX, drawY);
    }
    return;
  }
  public function printLine__IILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_TextLayout_2Lorg_eclipse_swt_graphics_TextLayout_2I(x: int, y: int, gc_1: GC, foreground: Color, background: Color, layout: TextLayout, printLayout: TextLayout, index: int): void {
    if (background !== null) {
      var rect: Rectangle = layout.getBounds__();
      gc_1.setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
      gc_1.fillRectangle__IIII(x, y, rect.width, rect.height);
    }
    if (printOptions.printLineNumbers) {
      var metrics: FontMetrics = layout.getLineMetrics__I(0);
      printLayout.setAscent__I(metrics.getAscent__() + metrics.getLeading__());
      printLayout.setDescent__I(metrics.getDescent__());
      var lineLabels: JavaArray = printOptions.lineLabels;
      if (lineLabels !== null) {
        if (0 <= index && index < lineLabels.length && lineLabels[index] !== null) {
          printLayout.setText__Ljava_lang_String_2(lineLabels[index]);
        } else {
          printLayout.setText__Ljava_lang_String_2("");
        }
      } else {
        printLayout.setText__Ljava_lang_String_2(Object(String).valueOf__I(index));
      }
      var paintX: int = x - printMargin - printLayout.getBounds__().width;
      printLayout.draw__Lorg_eclipse_swt_graphics_GC_2II(gc_1, paintX, y);
      printLayout.setAscent__I(-1);
      printLayout.setDescent__I(-1);
    }
    gc_1.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
    layout.draw__Lorg_eclipse_swt_graphics_GC_2II(gc_1, x, y);
    return;
  }
  public function run__(): void {
    var jobName: String = printOptions.jobName;
    if (jobName === null) {
      jobName = "Printing";
    }
    if (printer.startJob__Ljava_lang_String_2(jobName)) {
      this.init__();
      this.print__();
      this.dispose__();
      printer.endJob__();
    }
    return;
  }
}
}
