package org.eclipse.swt.custom {
import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.printing.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Canvas;
import java.lang.Runnable;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Font;
import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import java.util.Enumeration;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.Math__;
import java.lang.StringBuffer;
import org.eclipse.swt.graphics.FontMetrics;
import java.util.Vector;
import java.lang.System;
import java.lang.NumberFormatException;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Event;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.dnd.RTFTransfer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledText$RTFWriter extends StyledText$TextWriter {
  public static const DEFAULT_FOREGROUND: int = 0;
  public static const DEFAULT_BACKGROUND: int = 1;
  public var colorTable: Vector;
  public var fontTable: Vector;
  public var WriteUnicode: Boolean;
  private var this$0: StyledText;
  public function StyledText$RTFWriter(this$0: StyledText, start: int, length: int) {
    this.this$0 = this$0;
    super(this$0, start, length);
    colorTable = new Vector(new Arguments(java.util.Vector.Vector__, []));
    fontTable = new Vector(new Arguments(java.util.Vector.Vector__, []));
    colorTable.addElement__Ljava_lang_Object_2(this$0.getForeground__());
    colorTable.addElement__Ljava_lang_Object_2(this$0.getBackground__());
    fontTable.addElement__Ljava_lang_Object_2(this$0.getFont__());
    this.setUnicode__();
    return;
  }
  public override function close__(): void {
    if (!this.isClosed__()) {
      this.writeHeader__();
      this.write__Ljava_lang_String_2("\n}}\u0000");
      super.close__();
    }
    return;
  }
  public function getColorIndex__Lorg_eclipse_swt_graphics_Color_2I(color: Color, defaultIndex: int): int {
    if (color === null)
      return defaultIndex;
    var index: int = colorTable.indexOf__Ljava_lang_Object_2(color);
    if (index == -1) {
      index = colorTable.size__();
      colorTable.addElement__Ljava_lang_Object_2(color);
    }
    return index;
  }
  public function getFontIndex__Lorg_eclipse_swt_graphics_Font_2(font: Font): int {
    var index: int = fontTable.indexOf__Ljava_lang_Object_2(font);
    if (index == -1) {
      index = fontTable.size__();
      fontTable.addElement__Ljava_lang_Object_2(font);
    }
    return index;
  }
  public function setUnicode__(): void {
    var Win95: String = "windows 95";
    var Win98: String = "windows 98";
    var WinME: String = "windows me";
    var WinNT: String = "windows nt";
    var osName: String = Object(System.getProperty__Ljava_lang_String_2("os.name")).toLowerCase__();
    var osVersion: String = System.getProperty__Ljava_lang_String_2("os.version");
    var majorVersion: int = 0;
    if (Object(osName).startsWith__Ljava_lang_String_2("windows nt") && osVersion !== null) {
      var majorIndex: int = Object(osVersion).indexOf__I(46);
      if (majorIndex != -1) {
        osVersion = Object(osVersion).substring__II(0, majorIndex);
        try {
          majorVersion = Integer.parseInt__Ljava_lang_String_2(osVersion);
        } catch (exception : NumberFormatException) {
        }
      }
    }
    WriteUnicode = !Object(osName).startsWith__Ljava_lang_String_2("windows 95") && !Object(osName).startsWith__Ljava_lang_String_2("windows 98") && !Object(osName).startsWith__Ljava_lang_String_2("windows me") && (!Object(osName).startsWith__Ljava_lang_String_2("windows nt") || majorVersion > 4);
    return;
  }
  public function write__Ljava_lang_String_2II(string: String, start: int, end: int): void {
    for (var index: int = start; index < end; index++) {
      var ch: uint = Object(string).charAt__I(index);
      if (ch > 0xFF && WriteUnicode) {
        if (index > start) {
          this.write__Ljava_lang_String_2(Object(string).substring__II(start, index));
        }
        this.write__Ljava_lang_String_2("\\u");
        this.write__Ljava_lang_String_2(Integer.toString__I(int(ch)));
        this.write__C(32);
        start = index + 1;
      } else if (ch == 125 || ch == 123 || ch == 92) {
        if (index > start) {
          this.write__Ljava_lang_String_2(Object(string).substring__II(start, index));
        }
        this.write__C(92);
        this.write__C(ch);
        start = index + 1;
      }
    }
    if (start < end) {
      this.write__Ljava_lang_String_2(Object(string).substring__II(start, end));
    }
    return;
  }
  public function writeHeader__(): void {
    var header: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var fontData: FontData = this$0.getFont__().getFontData__()[0];
    header.append__Ljava_lang_String_2("{\\rtf1\\ansi");
    var cpg: String = Object(System.getProperty__Ljava_lang_String_2("file.encoding")).toLowerCase__();
    if (Object(cpg).startsWith__Ljava_lang_String_2("cp") || Object(cpg).startsWith__Ljava_lang_String_2("ms")) {
      cpg = Object(cpg).substring__II(2, Object(cpg).length__());
      header.append__Ljava_lang_String_2("\\ansicpg");
      header.append__Ljava_lang_String_2(cpg);
    }
    header.append__Ljava_lang_String_2("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
    header.append__Ljava_lang_String_2(fontData.getName__());
    header.append__Ljava_lang_String_2(";");
    for (var i: int = 1; i < fontTable.size__(); i++) {
      header.append__Ljava_lang_String_2("\\f");
      header.append__I(i);
      header.append__Ljava_lang_String_2(" ");
      var fd: FontData = (Font(fontTable.elementAt__I(i))).getFontData__()[0];
      header.append__Ljava_lang_String_2(fd.getName__());
      header.append__Ljava_lang_String_2(";");
    }
    header.append__Ljava_lang_String_2("}}\n{\\colortbl");
    for (var i_1: int = 0; i_1 < colorTable.size__(); i_1++) {
      var color: Color = Color(colorTable.elementAt__I(i_1));
      header.append__Ljava_lang_String_2("\\red");
      header.append__I(color.getRed__());
      header.append__Ljava_lang_String_2("\\green");
      header.append__I(color.getGreen__());
      header.append__Ljava_lang_String_2("\\blue");
      header.append__I(color.getBlue__());
      header.append__Ljava_lang_String_2(";");
    }
    header.append__Ljava_lang_String_2("}\n{\\f0\\fs");
    header.append__I(fontData.getHeight__() * 2);
    header.append__Ljava_lang_String_2(" ");
    this.write__Ljava_lang_String_2I(header.toString__(), 0);
    return;
  }
  public override function writeLine__Ljava_lang_String_2I(line: String, lineOffset: int): void {
    if (this.isClosed__()) {
      SWT.error__I(39);
    }
    var lineIndex: int = this$0.content.getLineAtOffset__I(lineOffset);
    var lineAlignment: int;
    var lineIndent: int;
    var lineJustify: Boolean;
    var ranges: JavaArray;
    var styles: JavaArray;
    var event: StyledTextEvent = this$0.getLineStyleData__ILjava_lang_String_2(lineOffset, line);
    if (event !== null) {
      lineAlignment = event.alignment;
      lineIndent = event.indent;
      lineJustify = event.justify;
      ranges = event.ranges;
      styles = event.styles;
    } else {
      lineAlignment = this$0.renderer.getLineAlignment__II(lineIndex, this$0.alignment);
      lineIndent = this$0.renderer.getLineIndent__II(lineIndex, this$0.indent);
      lineJustify = this$0.renderer.getLineJustify__IZ(lineIndex, this$0.justify);
      ranges = this$0.renderer.getRanges__II(lineOffset, Object(line).length__());
      styles = this$0.renderer.getStyleRanges__IIZ(lineOffset, Object(line).length__(), false);
    }
    if (styles === null)
      styles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(0);
    var lineBackground: Color = this$0.renderer.getLineBackground__ILorg_eclipse_swt_graphics_Color_2(lineIndex, null);
    event = this$0.getLineBackgroundData__ILjava_lang_String_2(lineOffset, line);
    if (event !== null && event.lineBackground !== null)
      lineBackground = event.lineBackground;
    this.writeStyledLine__Ljava_lang_String_2I_3I_3Lorg_eclipse_swt_custom_StyleRange_2Lorg_eclipse_swt_graphics_Color_2IIZ(line, lineOffset, ranges, styles, lineBackground, lineIndent, lineAlignment, lineJustify);
    return;
  }
  public override function writeLineDelimiter__Ljava_lang_String_2(lineDelimiter: String): void {
    if (this.isClosed__()) {
      SWT.error__I(39);
    }
    this.write__Ljava_lang_String_2II(lineDelimiter, 0, Object(lineDelimiter).length__());
    this.write__Ljava_lang_String_2("\\par ");
    return;
  }
  public function writeStyledLine__Ljava_lang_String_2I_3I_3Lorg_eclipse_swt_custom_StyleRange_2Lorg_eclipse_swt_graphics_Color_2IIZ(line: String, lineOffset: int, ranges: JavaArray, styles: JavaArray, lineBackground: Color, indent: int, alignment: int, justify: Boolean): void {
    var lineLength: int = Object(line).length__();
    var startOffset_1: int = this.getStart__();
    var writeOffset: int = startOffset_1 - lineOffset;
    if (writeOffset >= lineLength)
      return;
    var lineIndex: int = Math__.max__II(0, writeOffset);
    this.write__Ljava_lang_String_2("\\fi");
    this.write__I(indent);
    switch (alignment) {
      case 16384 :
        this.write__Ljava_lang_String_2("\\ql");
        break;
      case 16777216 :
        this.write__Ljava_lang_String_2("\\qc");
        break;
      case 131072 :
        this.write__Ljava_lang_String_2("\\qr");
        break;
    }
    if (justify)
      this.write__Ljava_lang_String_2("\\qj");
    this.write__Ljava_lang_String_2(" ");
    if (lineBackground !== null) {
      this.write__Ljava_lang_String_2("{\\highlight");
      this.write__I(this.getColorIndex__Lorg_eclipse_swt_graphics_Color_2I(lineBackground, 1));
      this.write__Ljava_lang_String_2(" ");
    }
    var endOffset_1: int = startOffset_1 + super.getCharCount__();
    var lineEndOffset: int = Math__.min__II(lineLength, endOffset_1 - lineOffset);
    for (var i: int = 0; i < styles.length; i++) {
      var style: StyleRange = styles[i];
      var start: int;
      var end: int;
      if (ranges !== null) {
        start = ranges[i << 1] - lineOffset;
        end = start + ranges[(i << 1) + 1];
      } else {
        start = style.start - lineOffset;
        end = start + style.length;
      }
      if (end < writeOffset) {
        continue;
      }
      if (start >= lineEndOffset) {
        break;
      }
      if (lineIndex < start) {
        this.write__Ljava_lang_String_2II(line, lineIndex, start);
        lineIndex = start;
      }
      this.write__Ljava_lang_String_2("{\\cf");
      this.write__I(this.getColorIndex__Lorg_eclipse_swt_graphics_Color_2I(style.foreground, 0));
      var colorIndex: int = this.getColorIndex__Lorg_eclipse_swt_graphics_Color_2I(style.background, 1);
      if (colorIndex != 1) {
        this.write__Ljava_lang_String_2("\\highlight");
        this.write__I(colorIndex);
      }
      var font: Font = style.font;
      if (font !== null) {
        var fontIndex: int = this.getFontIndex__Lorg_eclipse_swt_graphics_Font_2(font);
        this.write__Ljava_lang_String_2("\\f");
        this.write__I(fontIndex);
        var fontData: FontData = font.getFontData__()[0];
        this.write__Ljava_lang_String_2("\\fs");
        this.write__I(fontData.getHeight__() * 2);
      } else {
        if ((style.fontStyle & 1) != 0) {
          this.write__Ljava_lang_String_2("\\b");
        }
        if ((style.fontStyle & 2) != 0) {
          this.write__Ljava_lang_String_2("\\i");
        }
      }
      if (style.underline) {
        this.write__Ljava_lang_String_2("\\ul");
      }
      if (style.strikeout) {
        this.write__Ljava_lang_String_2("\\strike");
      }
      this.write__Ljava_lang_String_2(" ");
      var copyEnd: int = Math__.min__II(end, lineEndOffset);
      copyEnd = Math__.max__II(copyEnd, lineIndex);
      this.write__Ljava_lang_String_2II(line, lineIndex, copyEnd);
      if (font === null) {
        if ((style.fontStyle & 1) != 0) {
          this.write__Ljava_lang_String_2("\\b0");
        }
        if ((style.fontStyle & 2) != 0) {
          this.write__Ljava_lang_String_2("\\i0");
        }
      }
      if (style.underline) {
        this.write__Ljava_lang_String_2("\\ul0");
      }
      if (style.strikeout) {
        this.write__Ljava_lang_String_2("\\strike0");
      }
      this.write__Ljava_lang_String_2("}");
      lineIndex = copyEnd;
    }
    if (lineIndex < lineEndOffset) {
      this.write__Ljava_lang_String_2II(line, lineIndex, lineEndOffset);
    }
    if (lineBackground !== null)
      this.write__Ljava_lang_String_2("}");
    return;
  }
}
}
