package org.eclipse.swt.custom {
import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.printing.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Canvas;
import java.lang.Runnable;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Font;
import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import java.util.Enumeration;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.Math__;
import java.lang.StringBuffer;
import org.eclipse.swt.graphics.FontMetrics;
import java.util.Vector;
import java.lang.System;
import java.lang.NumberFormatException;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Event;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.dnd.RTFTransfer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledText$TextWriter {
  public var buffer: StringBuffer;
  public var startOffset: int;
  public var endOffset: int;
  public var isClosed: Boolean = false;
  private var this$0: StyledText;
  public function StyledText$TextWriter(this$0: StyledText, start: int, length: int) {
    this.this$0 = this$0;
    buffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [length]));
    startOffset = start;
    endOffset = start + length;
    return;
  }
  public function close__(): void {
    if (!isClosed) {
      isClosed = true;
    }
    return;
  }
  public function getCharCount__(): int {
    return endOffset - startOffset;
  }
  public function getStart__(): int {
    return startOffset;
  }
  public function isClosed__(): Boolean {
    return isClosed;
  }
  public function toString__(): String {
    return buffer.toString__();
  }
  public function write__Ljava_lang_String_2(string: String): void {
    buffer.append__Ljava_lang_String_2(string);
  }
  public function write__Ljava_lang_String_2I(string: String, offset: int): void {
    if (offset < 0 || offset > buffer.length__()) {
      return;
    }
    buffer.insert__ILjava_lang_String_2(offset, string);
    return;
  }
  public function write__I(i: int): void {
    buffer.append__I(i);
    return;
  }
  public function write__C(i: uint): void {
    buffer.append__C(i);
    return;
  }
  public function writeLine__Ljava_lang_String_2I(line: String, lineOffset: int): void {
    if (isClosed) {
      SWT.error__I(39);
    }
    var writeOffset: int = startOffset - lineOffset;
    var lineLength: int = Object(line).length__();
    var lineIndex: int;
    if (writeOffset >= lineLength) {
      return;
    } else if (writeOffset > 0) {
      lineIndex = writeOffset;
    } else {
      lineIndex = 0;
    }
    var copyEnd: int = Math__.min__II(lineLength, endOffset - lineOffset);
    if (lineIndex < copyEnd) {
      this.write__Ljava_lang_String_2(Object(line).substring__II(lineIndex, copyEnd));
    }
    return;
  }
  public function writeLineDelimiter__Ljava_lang_String_2(lineDelimiter: String): void {
    if (isClosed) {
      SWT.error__I(39);
    }
    this.write__Ljava_lang_String_2(lineDelimiter);
    return;
  }
}
}
