package org.eclipse.swt.custom {
import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.accessibility.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.printing.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Canvas;
import java.lang.Runnable;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Font;
import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import java.util.Enumeration;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.Math__;
import java.lang.StringBuffer;
import org.eclipse.swt.graphics.FontMetrics;
import java.util.Vector;
import java.lang.System;
import java.lang.NumberFormatException;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Event;
import java.lang.Character;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.dnd.RTFTransfer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledText extends Canvas {
  public static const TAB: uint = 9;
  public static var PlatformLineDelimiter: String = System.getProperty__Ljava_lang_String_2("line.separator");
  public static const BIDI_CARET_WIDTH: int = 3;
  public static const DEFAULT_WIDTH: int = 64;
  public static const DEFAULT_HEIGHT: int = 64;
  public static const V_SCROLL_RATE: int = 50;
  public static const H_SCROLL_RATE: int = 10;
  public static const ExtendedModify: int = 3000;
  public static const LineGetBackground: int = 3001;
  public static const LineGetStyle: int = 3002;
  public static const TextChanging: int = 3003;
  public static const TextSet: int = 3004;
  public static const VerifyKey: int = 3005;
  public static const TextChanged: int = 3006;
  public static const LineGetSegments: int = 3007;
  public static const PaintObject: int = 3008;
  public static const WordNext: int = 3009;
  public static const WordPrevious: int = 3010;
  public static const CaretMoved: int = 3011;
  public static const PREVIOUS_OFFSET_TRAILING: int = 0;
  public static const OFFSET_LEADING: int = 1;
  internal var selectionBackground: Color;
  internal var selectionForeground: Color;
  internal var content: StyledTextContent;
  internal var renderer: StyledTextRenderer;
  internal var listener: Listener;
  internal var textChangeListener: TextChangeListener;
  internal var verticalScrollOffset: int = 0;
  internal var horizontalScrollOffset: int = 0;
  internal var topIndex: int = 0;
  internal var topIndexY: int;
  internal var clientAreaHeight: int = 0;
  internal var clientAreaWidth: int = 0;
  internal var tabLength: int = 4;
  internal var leftMargin: int;
  internal var topMargin: int;
  internal var rightMargin: int;
  internal var bottomMargin: int;
  internal var columnX: int;
  internal var caretOffset: int;
  internal var caretAlignment: int;
  internal var selection: Point = new Point(0, 0);
  internal var clipboardSelection: Point;
  internal var selectionAnchor: int;
  internal var doubleClickSelection: Point;
  internal var editable: Boolean = true;
  internal var wordWrap: Boolean = false;
  internal var doubleClickEnabled: Boolean = true;
  internal var overwrite: Boolean = false;
  internal var textLimit: int = -1;
  internal var keyActionMap: Hashtable = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
  internal var background: Color = null;
  internal var foreground: Color = null;
  internal var clipboard: Clipboard;
  internal var clickCount: int;
  internal var autoScrollDirection: int = 0;
  internal var autoScrollDistance: int = 0;
  internal var lastTextChangeStart: int;
  internal var lastTextChangeNewLineCount: int;
  internal var lastTextChangeNewCharCount: int;
  internal var lastTextChangeReplaceLineCount: int;
  internal var lastTextChangeReplaceCharCount: int;
  internal var lastLineBottom: int;
  internal var isMirrored: Boolean;
  internal var bidiColoring: Boolean = false;
  internal var leftCaretBitmap: Image = null;
  internal var rightCaretBitmap: Image = null;
  internal var caretDirection: int = 0;
  internal var caretWidth: int = 0;
  internal var defaultCaret: Caret = null;
  internal var updateCaretDirection: Boolean = true;
  internal var fixedLineHeight: Boolean;
  internal var dragDetect: Boolean = true;
  internal var ime: IME;
  internal var cursor: Cursor;
  internal var alignment: int;
  internal var justify: Boolean;
  internal var indent: int;
  internal var lineSpacing: int;
  internal var blockSelection: Boolean;
  internal var blockXAnchor: int = -1;
  internal var blockYAnchor: int = -1;
  internal var blockXLocation: int = -1;
  internal var blockYLocation: int = -1;
  public static var IS_MAC: Boolean;
  public static var IS_GTK: Boolean;
  public static var IS_MOTIF: Boolean;

  __clinit();

  static private function __clinit(): void {
    {
      var platform: String = SWT.getPlatform__();
      IS_MAC = Object("carbon").equals__Ljava_lang_Object_2(platform) || Object("cocoa").equals__Ljava_lang_Object_2(platform);
      IS_GTK = Object("gtk").equals__Ljava_lang_Object_2(platform);
      IS_MOTIF = Object("motif").equals__Ljava_lang_Object_2(platform);
    }
  }
  public function StyledText(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [parent, StyledText.checkStyle__I(style)]));
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getForeground__());
    super.setDragDetect__Z(false);
    var display: Display = this.getDisplay__();
    isMirrored = (super.getStyle__() & 134217728) != 0;
    fixedLineHeight = true;
    if ((style & 8) != 0) {
      this.setEditable__Z(false);
    }
    leftMargin = rightMargin = this.isBidiCaret__() ? 3 - 1 : 0;
    if ((style & 4) != 0 && (style & 2048) != 0) {
      leftMargin = topMargin = rightMargin = bottomMargin = 2;
    }
    alignment = style & (16384 | 131072 | 16777216);
    if (alignment == 0)
      alignment = 16384;
    clipboard = new Clipboard(display);
    this.installDefaultContent__();
    renderer = new StyledTextRenderer(this.getDisplay__(), this);
    renderer.setContent__Lorg_eclipse_swt_custom_StyledTextContent_2(content);
    renderer.setFont__Lorg_eclipse_swt_graphics_Font_2I(this.getFont__(), tabLength);
    ime = new IME(new Arguments(org.eclipse.swt.widgets.IME.IME__Lorg_eclipse_swt_widgets_Canvas_2I, [this, 0]));
    defaultCaret = new Caret(this, 0);
    if ((style & 64) != 0) {
      this.setWordWrap__Z(true);
    }
    if (this.isBidiCaret__()) {
      this.createCaretBitmaps__();
      var runnable: Runnable = new org.eclipse.swt.custom.StyledText$1(this);
      BidiUtil.addLanguageListener__Lorg_eclipse_swt_widgets_Control_2Ljava_lang_Runnable_2(this, runnable);
    }
    this.setCaret__Lorg_eclipse_swt_widgets_Caret_2(defaultCaret);
    this.calculateScrollBars__();
    this.createKeyBindings__();
    super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(display.getSystemCursor__I(19));
    this.installListeners__();
    this.initializeAccessible__();
    this.setData__Ljava_lang_String_2Ljava_lang_Object_2("DEFAULT_DROP_TARGET_EFFECT", new StyledTextDropTargetEffect(this));
    return;
  }
  public function addExtendedModifyListener__Lorg_eclipse_swt_custom_ExtendedModifyListener_2(extendedModifyListener: ExtendedModifyListener): void {
    this.checkWidget__();
    if (extendedModifyListener === null)
      SWT.error__I(4);
    var typedListener: StyledTextListener = new StyledTextListener(extendedModifyListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3000, typedListener);
    return;
  }
  public function addBidiSegmentListener__Lorg_eclipse_swt_custom_BidiSegmentListener_2(listener_1: BidiSegmentListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3007, new StyledTextListener(listener_1));
    return;
  }
  public function addCaretListener__Lorg_eclipse_swt_custom_CaretListener_2(listener_1: CaretListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3011, new StyledTextListener(listener_1));
    return;
  }
  public function addLineBackgroundListener__Lorg_eclipse_swt_custom_LineBackgroundListener_2(listener_1: LineBackgroundListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    if (!this.isListening__I(3001)) {
      renderer.clearLineBackground__II(0, content.getLineCount__());
    }
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3001, new StyledTextListener(listener_1));
    return;
  }
  public function addLineStyleListener__Lorg_eclipse_swt_custom_LineStyleListener_2(listener_1: LineStyleListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    if (!this.isListening__I(3002)) {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(0, 0, null, null, true);
      renderer.clearLineStyle__II(0, content.getLineCount__());
    }
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3002, new StyledTextListener(listener_1));
    this.setCaretLocation__();
    return;
  }
  public function addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(modifyListener: ModifyListener): void {
    this.checkWidget__();
    if (modifyListener === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(24, new TypedListener(modifyListener));
    return;
  }
  public function addPaintObjectListener__Lorg_eclipse_swt_custom_PaintObjectListener_2(listener_1: PaintObjectListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3008, new StyledTextListener(listener_1));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new TypedListener(listener_1));
    return;
  }
  public function addVerifyKeyListener__Lorg_eclipse_swt_custom_VerifyKeyListener_2(listener_1: VerifyKeyListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3005, new StyledTextListener(listener_1));
    return;
  }
  public function addVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(verifyListener: VerifyListener): void {
    this.checkWidget__();
    if (verifyListener === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(25, new TypedListener(verifyListener));
    return;
  }
  public function addWordMovementListener__Lorg_eclipse_swt_custom_MovementListener_2(movementListener: MovementListener): void {
    this.checkWidget__();
    if (listener === null)
      SWT.error__I(4);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3009, new StyledTextListener(movementListener));
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3010, new StyledTextListener(movementListener));
    return;
  }
  public function append__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null) {
      SWT.error__I(4);
    }
    var lastChar: int = Math__.max__II(this.getCharCount__(), 0);
    this.replaceTextRange__IILjava_lang_String_2(lastChar, 0, string);
    return;
  }
  public function calculateScrollBars__(): void {
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    var verticalBar_1: ScrollBar = this.getVerticalBar__();
    this.setScrollBars__Z(true);
    if (verticalBar_1 !== null) {
      verticalBar_1.setIncrement__I(this.getVerticalIncrement__());
    }
    if (horizontalBar_1 !== null) {
      horizontalBar_1.setIncrement__I(this.getHorizontalIncrement__());
    }
    return;
  }
  public function calculateTopIndex__I(delta: int): void {
    var oldTopIndex: int = topIndex;
    var oldTopIndexY: int = topIndexY;
    if (this.isFixedLineHeight__()) {
      var verticalIncrement: int = this.getVerticalIncrement__();
      if (verticalIncrement == 0) {
        return;
      }
      topIndex = Compatibility.ceil__II(this.getVerticalScrollOffset__(), verticalIncrement);
      if (topIndex > 0) {
        if (clientAreaHeight > 0) {
          var bottomPixel: int = this.getVerticalScrollOffset__() + clientAreaHeight;
          var fullLineTopPixel: int = topIndex * verticalIncrement;
          var fullLineVisibleHeight: int = bottomPixel - fullLineTopPixel;
          if (fullLineVisibleHeight < verticalIncrement) {
            topIndex--;
          }
        } else if (topIndex >= content.getLineCount__()) {
          topIndex = content.getLineCount__() - 1;
        }
      }
    } else {
      if (delta >= 0) {
        delta -= topIndexY;
        var lineIndex: int = topIndex;
        var lineCount: int = content.getLineCount__();
        while (lineIndex < lineCount) {
          if (delta <= 0)
            break;
          delta -= renderer.getLineHeight__I(lineIndex++);
        }
        if (lineIndex < lineCount && -delta + renderer.getLineHeight__I(lineIndex) <= clientAreaHeight - topMargin - bottomMargin) {
          topIndex = lineIndex;
          topIndexY = -delta;
        } else {
          topIndex = lineIndex - 1;
          topIndexY = -renderer.getLineHeight__I(topIndex) - delta;
        }
      } else {
        delta -= topIndexY;
        var lineIndex_1: int = topIndex;
        while (lineIndex_1 > 0) {
          var lineHeight: int = renderer.getLineHeight__I(lineIndex_1 - 1);
          if (delta + lineHeight > 0)
            break;
          delta += lineHeight;
          lineIndex_1--;
        }
        if (lineIndex_1 == 0 || -delta + renderer.getLineHeight__I(lineIndex_1) <= clientAreaHeight - topMargin - bottomMargin) {
          topIndex = lineIndex_1;
          topIndexY = -delta;
        } else {
          topIndex = lineIndex_1 - 1;
          topIndexY = -renderer.getLineHeight__I(topIndex) - delta;
        }
      }
    }
    if (topIndex != oldTopIndex || oldTopIndexY != topIndexY) {
      renderer.calculateClientArea__();
      this.setScrollBars__Z(false);
    }
    return;
  }
  public static function checkStyle__I(style: int): int {
    if ((style & 4) != 0) {
      style &= ~(256 | 512 | 64 | 2);
    } else {
      style |= 2;
      if ((style & 64) != 0) {
        style &= ~256;
      }
    }
    style |= 1048576 | 536870912 | 262144;
    return style & ~16777216;
  }
  public function claimBottomFreeSpace__(): void {
    var clientAreaHeight_1: int = this.clientAreaHeight - topMargin - bottomMargin;
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      var newVerticalOffset: int = Math__.max__II(0, content.getLineCount__() * lineHeight - clientAreaHeight_1);
      if (newVerticalOffset < this.getVerticalScrollOffset__()) {
        this.scrollVertical__IZ(newVerticalOffset - this.getVerticalScrollOffset__(), true);
      }
    } else {
      var bottomIndex: int = this.getPartialBottomIndex__();
      var height_1: int = this.getLinePixel__I(bottomIndex + 1);
      if (clientAreaHeight_1 > height_1) {
        this.scrollVertical__IZ(-this.getAvailableHeightAbove__I(clientAreaHeight_1 - height_1), true);
      }
    }
    return;
  }
  public function claimRightFreeSpace__(): void {
    var newHorizontalOffset: int = Math__.max__II(0, renderer.getWidth__() - (clientAreaWidth - leftMargin - rightMargin));
    if (newHorizontalOffset < horizontalScrollOffset) {
      this.scrollHorizontal__IZ(newHorizontalOffset - horizontalScrollOffset, true);
    }
    return;
  }
  public function clearBlockSelection__ZZ(reset: Boolean, sendEvent: Boolean): void {
    if (reset)
      this.resetSelection__();
    blockXAnchor = blockYAnchor = -1;
    blockXLocation = blockYLocation = -1;
    caretDirection = 0;
    this.getCaret__().setVisible__Z(true);
    super.redraw__();
    if (sendEvent)
      this.sendSelectionEvent__();
    return;
  }
  public function clearSelection__Z(sendEvent: Boolean): void {
    var selectionStart: int = selection.x;
    var selectionEnd: int = selection.y;
    this.resetSelection__();
    if (selectionEnd - selectionStart > 0) {
      var length: int = content.getCharCount__();
      var redrawStart: int = Math__.min__II(selectionStart, length);
      var redrawEnd: int = Math__.min__II(selectionEnd, length);
      if (redrawEnd - redrawStart > 0) {
        this.internalRedrawRange__II(redrawStart, redrawEnd - redrawStart);
      }
      if (sendEvent) {
        this.sendSelectionEvent__();
      }
    }
    return;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var lineCount: int = (this.getStyle__() & 4) != 0 ? 1 : content.getLineCount__();
    var width_1: int = 0;
    var height_1: int = 0;
    if (wHint == -1 || hHint == -1) {
      var display_1: Display = this.getDisplay__();
      var maxHeight: int = display_1.getClientArea__().height;
      for (var lineIndex: int = 0; lineIndex < lineCount; lineIndex++) {
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
        var wrapWidth: int = layout_1.getWidth__();
        if (wordWrap)
          layout_1.setWidth__I(wHint == 0 ? 1 : wHint);
        var rect: Rectangle = layout_1.getBounds__();
        height_1 += rect.height;
        width_1 = Math__.max__II(width_1, rect.width);
        layout_1.setWidth__I(wrapWidth);
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
        if (this.isFixedLineHeight__() && height_1 > maxHeight)
          break;
      }
      if (this.isFixedLineHeight__()) {
        height_1 = lineCount * renderer.getLineHeight__();
      }
    }
    if (width_1 == 0)
      width_1 = 64;
    if (height_1 == 0)
      height_1 = 64;
    if (wHint != -1)
      width_1 = wHint;
    if (hHint != -1)
      height_1 = hHint;
    var wTrim: int = leftMargin + rightMargin + this.getCaretWidth__();
    var hTrim: int = topMargin + bottomMargin;
    var rect_1: Rectangle = this.computeTrim__IIII(0, 0, width_1 + wTrim, height_1 + hTrim);
    return new Point(rect_1.width, rect_1.height);
  }
  public function copy__(): void {
    this.checkWidget__();
    this.copySelection__I(1);
  }
  public function copy__I(clipboardType: int): void {
    this.checkWidget__();
    this.copySelection__I(clipboardType);
  }
  public function copySelection__I(type: int): Boolean {
    if (type != 1 && type != 2)
      return false;
    try {
      if (blockSelection && blockXLocation != -1) {
        var text: String = this.getBlockSelectionText__Ljava_lang_String_2(PlatformLineDelimiter);
        if (Object(text).length__() > 0) {
          var plainTextTransfer: TextTransfer = TextTransfer.getInstance__();
          var data_1: JavaArray = new JavaArray("[Ljava/lang/Object;").values(text);
          var types: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/Transfer;").values(plainTextTransfer);
          clipboard.setContents___3Ljava_lang_Object_2_3Lorg_eclipse_swt_dnd_Transfer_2I(data_1, types, type);
          return true;
        }
      } else {
        var length: int = selection.y - selection.x;
        if (length > 0) {
          this.setClipboardContent__III(selection.x, length, type);
          return true;
        }
      }
    } catch (error : SWTError) {
      if (error.code != 2002) {
        throw error;
      }
    }
    return false;
  }
  public function getAlignment__(): int {
    this.checkWidget__();
    return alignment;
  }
  public function getAvailableHeightAbove__I(height_1: int): int {
    var maxHeight: int = verticalScrollOffset;
    if (maxHeight == -1) {
      var lineIndex: int = topIndex - 1;
      maxHeight = -topIndexY;
      if (topIndexY > 0) {
        maxHeight += renderer.getLineHeight__I(lineIndex--);
      }
      while (height_1 > maxHeight && lineIndex >= 0) {
        maxHeight += renderer.getLineHeight__I(lineIndex--);
      }
    }
    return Math__.min__II(height_1, maxHeight);
  }
  public function getAvailableHeightBellow__I(height_1: int): int {
    var partialBottomIndex: int = this.getPartialBottomIndex__();
    var topY: int = this.getLinePixel__I(partialBottomIndex);
    var lineHeight: int = renderer.getLineHeight__I(partialBottomIndex);
    var availableHeight: int = 0;
    var clientAreaHeight_1: int = this.clientAreaHeight - topMargin - bottomMargin;
    if (topY + lineHeight > clientAreaHeight_1) {
      availableHeight = lineHeight - (clientAreaHeight_1 - topY);
    }
    var lineIndex: int = partialBottomIndex + 1;
    var lineCount: int = content.getLineCount__();
    while (height_1 > availableHeight && lineIndex < lineCount) {
      availableHeight += renderer.getLineHeight__I(lineIndex++);
    }
    return Math__.min__II(height_1, availableHeight);
  }
  public function getModelDelimitedText__Ljava_lang_String_2(text: String): String {
    var length: int = Object(text).length__();
    if (length == 0) {
      return text;
    }
    var crIndex: int = 0;
    var lfIndex: int = 0;
    var i: int = 0;
    var convertedText: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [length]));
    var delimiter: String = this.getLineDelimiter__();
    while (i < length) {
      if (crIndex != -1) {
        crIndex = Object(text).indexOf__II(13, i);
      }
      if (lfIndex != -1) {
        lfIndex = Object(text).indexOf__II(10, i);
      }
      if (lfIndex == -1 && crIndex == -1) {
        break;
      } else if ((crIndex < lfIndex && crIndex != -1) || lfIndex == -1) {
        convertedText.append__Ljava_lang_String_2(Object(text).substring__II(i, crIndex));
        if (lfIndex == crIndex + 1) {
          i = lfIndex + 1;
        } else {
          i = crIndex + 1;
        }
      } else {
        convertedText.append__Ljava_lang_String_2(Object(text).substring__II(i, lfIndex));
        i = lfIndex + 1;
      }
      if (this.isSingleLine__()) {
        break;
      }
      convertedText.append__Ljava_lang_String_2(delimiter);
    }
    if (i < length && (!this.isSingleLine__() || convertedText.length__() == 0)) {
      convertedText.append__Ljava_lang_String_2(Object(text).substring__I(i));
    }
    return convertedText.toString__();
  }
  public function checkDragDetect__Lorg_eclipse_swt_widgets_Event_2(event: Event): Boolean {
    if (!this.isListening__I(29))
      return false;
    if (IS_MOTIF) {
      if (event.button != 2)
        return false;
    } else {
      if (event.button != 1)
        return false;
    }
    if (blockSelection && blockXLocation != -1) {
      var rect: Rectangle = this.getBlockSelectionRectangle__();
      if (rect.contains__II(event.x, event.y)) {
        return this.dragDetect__Lorg_eclipse_swt_widgets_Event_2(event);
      }
    } else {
      if (selection.x == selection.y)
        return false;
      var offset: int = this.getOffsetAtPoint__II_3IZ(event.x, event.y, null, true);
      if (selection.x <= offset && offset < selection.y) {
        return this.dragDetect__Lorg_eclipse_swt_widgets_Event_2(event);
      }
    }
    return false;
  }
  public function createKeyBindings__(): void {
    var nextKey: int = this.isMirrored__() ? 16777219 : 16777220;
    var previousKey: int = this.isMirrored__() ? 16777220 : 16777219;
    this.setKeyBinding__II(16777217, 16777217);
    this.setKeyBinding__II(16777218, 16777218);
    if (IS_MAC) {
      this.setKeyBinding__II(previousKey | SWT.MOD1, 16777223);
      this.setKeyBinding__II(nextKey | SWT.MOD1, 16777224);
      this.setKeyBinding__II(16777223, 17039367);
      this.setKeyBinding__II(16777224, 17039368);
      this.setKeyBinding__II(16777217 | SWT.MOD1, 17039367);
      this.setKeyBinding__II(16777218 | SWT.MOD1, 17039368);
      this.setKeyBinding__II(nextKey | SWT.MOD3, 17039364);
      this.setKeyBinding__II(previousKey | SWT.MOD3, 17039363);
    } else {
      this.setKeyBinding__II(16777223, 16777223);
      this.setKeyBinding__II(16777224, 16777224);
      this.setKeyBinding__II(16777223 | SWT.MOD1, 17039367);
      this.setKeyBinding__II(16777224 | SWT.MOD1, 17039368);
      this.setKeyBinding__II(nextKey | SWT.MOD1, 17039364);
      this.setKeyBinding__II(previousKey | SWT.MOD1, 17039363);
    }
    this.setKeyBinding__II(16777221, 16777221);
    this.setKeyBinding__II(16777222, 16777222);
    this.setKeyBinding__II(16777221 | SWT.MOD1, 17039365);
    this.setKeyBinding__II(16777222 | SWT.MOD1, 17039366);
    this.setKeyBinding__II(nextKey, 16777220);
    this.setKeyBinding__II(previousKey, 16777219);
    this.setKeyBinding__II(16777217 | SWT.MOD2, 16908289);
    this.setKeyBinding__II(16777218 | SWT.MOD2, 16908290);
    if (IS_MAC) {
      this.setKeyBinding__II(previousKey | SWT.MOD1 | SWT.MOD2, 16908295);
      this.setKeyBinding__II(nextKey | SWT.MOD1 | SWT.MOD2, 16908296);
      this.setKeyBinding__II(16777223 | SWT.MOD2, 17170439);
      this.setKeyBinding__II(16777224 | SWT.MOD2, 17170440);
      this.setKeyBinding__II(16777217 | SWT.MOD1 | SWT.MOD2, 17170439);
      this.setKeyBinding__II(16777218 | SWT.MOD1 | SWT.MOD2, 17170440);
      this.setKeyBinding__II(nextKey | SWT.MOD2 | SWT.MOD3, 17170436);
      this.setKeyBinding__II(previousKey | SWT.MOD2 | SWT.MOD3, 17170435);
    } else {
      this.setKeyBinding__II(16777223 | SWT.MOD2, 16908295);
      this.setKeyBinding__II(16777224 | SWT.MOD2, 16908296);
      this.setKeyBinding__II(16777223 | SWT.MOD1 | SWT.MOD2, 17170439);
      this.setKeyBinding__II(16777224 | SWT.MOD1 | SWT.MOD2, 17170440);
      this.setKeyBinding__II(nextKey | SWT.MOD1 | SWT.MOD2, 17170436);
      this.setKeyBinding__II(previousKey | SWT.MOD1 | SWT.MOD2, 17170435);
    }
    this.setKeyBinding__II(16777221 | SWT.MOD2, 16908293);
    this.setKeyBinding__II(16777222 | SWT.MOD2, 16908294);
    this.setKeyBinding__II(16777221 | SWT.MOD1 | SWT.MOD2, 17170437);
    this.setKeyBinding__II(16777222 | SWT.MOD1 | SWT.MOD2, 17170438);
    this.setKeyBinding__II(nextKey | SWT.MOD2, 16908292);
    this.setKeyBinding__II(previousKey | SWT.MOD2, 16908291);
    this.setKeyBinding__II(88 | SWT.MOD1, 131199);
    this.setKeyBinding__II(67 | SWT.MOD1, 17039369);
    this.setKeyBinding__II(86 | SWT.MOD1, 16908297);
    if (IS_MAC) {
      this.setKeyBinding__II(127 | SWT.MOD2, 127);
      this.setKeyBinding__II(8 | SWT.MOD3, 262152);
      this.setKeyBinding__II(127 | SWT.MOD3, 262271);
    } else {
      this.setKeyBinding__II(127 | SWT.MOD2, 131199);
      this.setKeyBinding__II(16777225 | SWT.MOD1, 17039369);
      this.setKeyBinding__II(16777225 | SWT.MOD2, 16908297);
    }
    this.setKeyBinding__II(8 | SWT.MOD2, 8);
    this.setKeyBinding__II(8, 8);
    this.setKeyBinding__II(127, 127);
    this.setKeyBinding__II(8 | SWT.MOD1, 262152);
    this.setKeyBinding__II(127 | SWT.MOD1, 262271);
    this.setKeyBinding__II(16777225, 16777225);
    return;
  }
  public function createCaretBitmaps__(): void {
    var caretWidth_1: int = 3;
    var display_1: Display = this.getDisplay__();
    if (leftCaretBitmap !== null) {
      if (defaultCaret !== null && leftCaretBitmap.equals__Ljava_lang_Object_2(defaultCaret.getImage__())) {
        defaultCaret.setImage__Lorg_eclipse_swt_graphics_Image_2(null);
      }
      leftCaretBitmap.dispose__();
    }
    var lineHeight: int = renderer.getLineHeight__();
    leftCaretBitmap = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display_1, caretWidth_1, lineHeight]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [leftCaretBitmap]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(2));
    gc.fillRectangle__IIII(0, 0, caretWidth_1, lineHeight);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(1));
    gc.drawLine__IIII(0, 0, 0, lineHeight);
    gc.drawLine__IIII(0, 0, caretWidth_1 - 1, 0);
    gc.drawLine__IIII(0, 1, 1, 1);
    gc.dispose__();
    if (rightCaretBitmap !== null) {
      if (defaultCaret !== null && rightCaretBitmap.equals__Ljava_lang_Object_2(defaultCaret.getImage__())) {
        defaultCaret.setImage__Lorg_eclipse_swt_graphics_Image_2(null);
      }
      rightCaretBitmap.dispose__();
    }
    rightCaretBitmap = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display_1, caretWidth_1, lineHeight]));
    gc = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [rightCaretBitmap]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(2));
    gc.fillRectangle__IIII(0, 0, caretWidth_1, lineHeight);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(1));
    gc.drawLine__IIII(caretWidth_1 - 1, 0, caretWidth_1 - 1, lineHeight);
    gc.drawLine__IIII(0, 0, caretWidth_1 - 1, 0);
    gc.drawLine__IIII(caretWidth_1 - 1, 1, 1, 1);
    gc.dispose__();
    return;
  }
  public function cut__(): void {
    this.checkWidget__();
    if (this.copySelection__I(1)) {
      if (blockSelection && blockXLocation != -1) {
        this.insertBlockSelectionText__CI(uint(0), 0);
        this.clearBlockSelection__ZZ(true, true);
      } else {
        this.doDelete__();
      }
    }
    return;
  }
  public function doAutoScroll__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (event.y > clientAreaHeight) {
      this.doAutoScroll__II(1024, event.y - clientAreaHeight);
    } else if (event.y < 0) {
      this.doAutoScroll__II(128, -event.y);
    } else if (event.x < leftMargin && !wordWrap) {
      this.doAutoScroll__II(16777219, leftMargin - event.x);
    } else if (event.x > clientAreaWidth - leftMargin - rightMargin && !wordWrap) {
      this.doAutoScroll__II(16777220, event.x - (clientAreaWidth - leftMargin - rightMargin));
    } else {
      this.endAutoScroll__();
    }
    return;
  }
  public function doAutoScroll__II(direction: int, distance: int): void {
    autoScrollDistance = distance;
    if (autoScrollDirection == direction) {
      return;
    }
    var timer: Runnable = null;
    var display_1: Display = this.getDisplay__();
    if (direction == 128) {
      timer = new org.eclipse.swt.custom.StyledText$2(this, display_1);
      autoScrollDirection = direction;
      display_1.timerExec__ILjava_lang_Runnable_2(50, timer);
    } else if (direction == 1024) {
      timer = new org.eclipse.swt.custom.StyledText$3(this, display_1);
      autoScrollDirection = direction;
      display_1.timerExec__ILjava_lang_Runnable_2(50, timer);
    } else if (direction == 16777220) {
      timer = new org.eclipse.swt.custom.StyledText$4(this, display_1);
      autoScrollDirection = direction;
      display_1.timerExec__ILjava_lang_Runnable_2(10, timer);
    } else if (direction == 16777219) {
      timer = new org.eclipse.swt.custom.StyledText$5(this, display_1);
      autoScrollDirection = direction;
      display_1.timerExec__ILjava_lang_Runnable_2(10, timer);
    }
    return;
  }
  public function doBackspace__(): void {
    var event: Event = new Event();
    event.text = "";
    if (selection.x != selection.y) {
      event.start = selection.x;
      event.end = selection.y;
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    } else if (caretOffset > 0) {
      var lineIndex: int = content.getLineAtOffset__I(caretOffset);
      var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
      if (caretOffset == lineOffset) {
        lineOffset = content.getOffsetAtLine__I(lineIndex - 1);
        event.start = lineOffset + Object(content.getLine__I(lineIndex - 1)).length__();
        event.end = caretOffset;
      } else {
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
        var start: int = layout_1.getPreviousOffset__II(caretOffset - lineOffset, 1);
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
        event.start = start + lineOffset;
        event.end = caretOffset;
      }
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function doBlockColumn__Z(next: Boolean): void {
    if (blockXLocation == -1)
      this.setBlockSelectionOffset__IZ(caretOffset, false);
    var x_1: int = blockXLocation - horizontalScrollOffset;
    var y_1: int = blockYLocation - this.getVerticalScrollOffset__();
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, trailing, true);
    if (offset != -1) {
      offset += trailing[0];
      var lineIndex: int = content.getLineAtOffset__I(offset);
      var newOffset: int;
      if (next) {
        newOffset = this.getClusterNext__II(offset, lineIndex);
      } else {
        newOffset = this.getClusterPrevious__II(offset, lineIndex);
      }
      offset = newOffset != offset ? newOffset : -1;
    }
    if (offset != -1) {
      this.setBlockSelectionOffset__IZ(offset, true);
      this.showCaret__();
    } else {
      var width_1: int = next ? renderer.averageCharWidth : -renderer.averageCharWidth;
      var maxWidth: int = Math__.max__II(clientAreaWidth - rightMargin - leftMargin, renderer.getWidth__());
      x_1 = Math__.max__II(0, Math__.min__II(blockXLocation + width_1, maxWidth)) - horizontalScrollOffset;
      this.setBlockSelectionLocation__IIZ(x_1, y_1, true);
      var rect: Rectangle = new Rectangle(x_1, y_1, 0, 0);
      this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(rect, true);
    }
    return;
  }
  public function doBlockWord__Z(next: Boolean): void {
    if (blockXLocation == -1)
      this.setBlockSelectionOffset__IZ(caretOffset, false);
    var x_1: int = blockXLocation - horizontalScrollOffset;
    var y_1: int = blockYLocation - this.getVerticalScrollOffset__();
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, trailing, true);
    if (offset != -1) {
      offset += trailing[0];
      var lineIndex: int = content.getLineAtOffset__I(offset);
      var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
      var lineText: String = content.getLine__I(lineIndex);
      var lineLength: int = Object(lineText).length__();
      var newOffset: int = offset;
      if (next) {
        if (offset < lineOffset + lineLength) {
          newOffset = this.getWordNext__II(offset, 4);
        }
      } else {
        if (offset > lineOffset) {
          newOffset = this.getWordPrevious__II(offset, 4);
        }
      }
      offset = newOffset != offset ? newOffset : -1;
    }
    if (offset != -1) {
      this.setBlockSelectionOffset__IZ(offset, true);
      this.showCaret__();
    } else {
      var width_1: int = (next ? renderer.averageCharWidth : -renderer.averageCharWidth) * 6;
      var maxWidth: int = Math__.max__II(clientAreaWidth - rightMargin - leftMargin, renderer.getWidth__());
      x_1 = Math__.max__II(0, Math__.min__II(blockXLocation + width_1, maxWidth)) - horizontalScrollOffset;
      this.setBlockSelectionLocation__IIZ(x_1, y_1, true);
      var rect: Rectangle = new Rectangle(x_1, y_1, 0, 0);
      this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(rect, true);
    }
    return;
  }
  public function doBlockLineVertical__Z(up: Boolean): void {
    if (blockXLocation == -1)
      this.setBlockSelectionOffset__IZ(caretOffset, false);
    var y_1: int = blockYLocation - this.getVerticalScrollOffset__();
    var lineIndex: int = this.getLineIndex__I(y_1);
    if (up) {
      if (lineIndex > 0) {
        y_1 = this.getLinePixel__I(lineIndex - 1);
        this.setBlockSelectionLocation__IIZ(blockXLocation - horizontalScrollOffset, y_1, true);
        if (y_1 < topMargin) {
          this.scrollVertical__IZ(y_1 - topMargin, true);
        }
      }
    } else {
      var lineCount: int = content.getLineCount__();
      if (lineIndex + 1 < lineCount) {
        y_1 = this.getLinePixel__I(lineIndex + 2) - 1;
        this.setBlockSelectionLocation__IIZ(blockXLocation - horizontalScrollOffset, y_1, true);
        var bottom: int = clientAreaHeight - bottomMargin;
        if (y_1 > bottom) {
          this.scrollVertical__IZ(y_1 - bottom, true);
        }
      }
    }
    return;
  }
  public function doBlockLineHorizontal__Z(end: Boolean): void {
    if (blockXLocation == -1)
      this.setBlockSelectionOffset__IZ(caretOffset, false);
    var x_1: int = blockXLocation - horizontalScrollOffset;
    var y_1: int = blockYLocation - this.getVerticalScrollOffset__();
    var lineIndex: int = this.getLineIndex__I(y_1);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var lineText: String = content.getLine__I(lineIndex);
    var lineLength: int = Object(lineText).length__();
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, trailing, true);
    if (offset != -1) {
      offset += trailing[0];
      var newOffset: int = offset;
      if (end) {
        if (offset < lineOffset + lineLength) {
          newOffset = lineOffset + lineLength;
        }
      } else {
        if (offset > lineOffset) {
          newOffset = lineOffset;
        }
      }
      offset = newOffset != offset ? newOffset : -1;
    } else {
      if (!end)
        offset = lineOffset + lineLength;
    }
    if (offset != -1) {
      this.setBlockSelectionOffset__IZ(offset, true);
      this.showCaret__();
    } else {
      var maxWidth: int = Math__.max__II(clientAreaWidth - rightMargin - leftMargin, renderer.getWidth__());
      x_1 = (end ? maxWidth : 0) - horizontalScrollOffset;
      this.setBlockSelectionLocation__IIZ(x_1, y_1, true);
      var rect: Rectangle = new Rectangle(x_1, y_1, 0, 0);
      this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(rect, true);
    }
    return;
  }
  public function doBlockSelection__Z(sendEvent: Boolean): void {
    if (caretOffset > selectionAnchor) {
      selection.x = selectionAnchor;
      selection.y = caretOffset;
    } else {
      selection.x = caretOffset;
      selection.y = selectionAnchor;
    }
    this.getCaret__().setVisible__Z(false);
    this.setCaretLocation__();
    super.redraw__();
    if (sendEvent) {
      this.sendSelectionEvent__();
    }
    return;
  }
  public function doContent__C(key: uint): void {
    if (blockSelection && blockXLocation != -1) {
      this.insertBlockSelectionText__CI(key, 0);
      return;
    }
    var event: Event = new Event();
    event.start = selection.x;
    event.end = selection.y;
    if (key == 13 || key == 10) {
      if (!this.isSingleLine__()) {
        event.text = this.getLineDelimiter__();
      }
    } else if (selection.x == selection.y && overwrite && key != 9) {
      var lineIndex: int = content.getLineAtOffset__I(event.end);
      var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
      var line: String = content.getLine__I(lineIndex);
      if (event.end < lineOffset + Object(line).length__()) {
        event.end++;
      }
      event.text = Object(String).__init___3C(new JavaArray("[C").values(key));
    } else {
      event.text = Object(String).__init___3C(new JavaArray("[C").values(key));
    }
    if (event.text !== null) {
      if (textLimit > 0 && content.getCharCount__() - (event.end - event.start) >= textLimit) {
        return;
      }
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function doContentEnd__(): void {
    if (this.isSingleLine__()) {
      this.doLineEnd__();
    } else {
      var length: int = content.getCharCount__();
      if (caretOffset < length) {
        this.setCaretOffset__II(length, -1);
        this.showCaret__();
      }
    }
    return;
  }
  public function doContentStart__(): void {
    if (caretOffset > 0) {
      this.setCaretOffset__II(0, -1);
      this.showCaret__();
    }
    return;
  }
  public function doCursorPrevious__(): void {
    if (selection.y - selection.x > 0) {
      this.setCaretOffset__II(selection.x, 1);
      this.showCaret__();
    } else {
      this.doSelectionCursorPrevious__();
    }
    return;
  }
  public function doCursorNext__(): void {
    if (selection.y - selection.x > 0) {
      this.setCaretOffset__II(selection.y, 0);
      this.showCaret__();
    } else {
      this.doSelectionCursorNext__();
    }
    return;
  }
  public function doDelete__(): void {
    var event: Event = new Event();
    event.text = "";
    if (selection.x != selection.y) {
      event.start = selection.x;
      event.end = selection.y;
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    } else if (caretOffset < content.getCharCount__()) {
      var line: int = content.getLineAtOffset__I(caretOffset);
      var lineOffset: int = content.getOffsetAtLine__I(line);
      var lineLength: int = Object(content.getLine__I(line)).length__();
      if (caretOffset == lineOffset + lineLength) {
        event.start = caretOffset;
        event.end = content.getOffsetAtLine__I(line + 1);
      } else {
        event.start = caretOffset;
        event.end = this.getClusterNext__II(caretOffset, line);
      }
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function doDeleteWordNext__(): void {
    if (selection.x != selection.y) {
      this.doDelete__();
    } else {
      var event: Event = new Event();
      event.text = "";
      event.start = caretOffset;
      event.end = this.getWordNext__II(caretOffset, 4);
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function doDeleteWordPrevious__(): void {
    if (selection.x != selection.y) {
      this.doBackspace__();
    } else {
      var event: Event = new Event();
      event.text = "";
      event.start = this.getWordPrevious__II(caretOffset, 4);
      event.end = caretOffset;
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function doLineDown__Z(select: Boolean): void {
    var caretLine: int = this.getCaretLine__();
    var lineCount: int = content.getLineCount__();
    var y_1: int = 0;
    var lastLine: Boolean = false;
    if (wordWrap) {
      var lineOffset: int = content.getOffsetAtLine__I(caretLine);
      var offsetInLine: int = caretOffset - lineOffset;
      var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
      var lineIndex: int = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, offsetInLine);
      var layoutLineCount: int = layout_1.getLineCount__();
      if (lineIndex == layoutLineCount - 1) {
        lastLine = caretLine == lineCount - 1;
        caretLine++;
      } else {
        y_1 = layout_1.getLineBounds__I(lineIndex + 1).y;
      }
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    } else {
      lastLine = caretLine == lineCount - 1;
      caretLine++;
    }
    if (lastLine) {
      if (select) {
        this.setCaretOffset__II(content.getCharCount__(), -1);
      }
    } else {
      var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
      var offset: int = this.getOffsetAtPoint__III_3I(columnX, y_1, caretLine, alignment_1);
      this.setCaretOffset__II(offset, alignment_1[0]);
    }
    var oldColumnX: int = columnX;
    var oldHScrollOffset: int = horizontalScrollOffset;
    if (select) {
      this.setMouseWordSelectionAnchor__();
      this.doSelection__I(16777220);
    }
    this.showCaret__();
    var hScrollChange: int = oldHScrollOffset - horizontalScrollOffset;
    columnX = oldColumnX + hScrollChange;
    return;
  }
  public function doLineEnd__(): void {
    var caretLine: int = this.getCaretLine__();
    var lineOffset: int = content.getOffsetAtLine__I(caretLine);
    var lineEndOffset: int;
    if (wordWrap) {
      var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
      var offsetInLine: int = caretOffset - lineOffset;
      var lineIndex: int = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, offsetInLine);
      var offsets: JavaArray = layout_1.getLineOffsets__();
      lineEndOffset = lineOffset + offsets[lineIndex + 1];
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    } else {
      var lineLength: int = Object(content.getLine__I(caretLine)).length__();
      lineEndOffset = lineOffset + lineLength;
    }
    if (caretOffset < lineEndOffset) {
      this.setCaretOffset__II(lineEndOffset, 0);
      this.showCaret__();
    }
    return;
  }
  public function doLineStart__(): void {
    var caretLine: int = this.getCaretLine__();
    var lineOffset: int = content.getOffsetAtLine__I(caretLine);
    if (wordWrap) {
      var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
      var offsetInLine: int = caretOffset - lineOffset;
      var lineIndex: int = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, offsetInLine);
      var offsets: JavaArray = layout_1.getLineOffsets__();
      lineOffset += offsets[lineIndex];
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    }
    if (caretOffset > lineOffset) {
      this.setCaretOffset__II(lineOffset, 1);
      this.showCaret__();
    }
    return;
  }
  public function doLineUp__Z(select: Boolean): void {
    var caretLine: int = this.getCaretLine__();
    var y_1: int = 0;
    var firstLine: Boolean = false;
    if (wordWrap) {
      var lineOffset: int = content.getOffsetAtLine__I(caretLine);
      var offsetInLine: int = caretOffset - lineOffset;
      var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
      var lineIndex: int = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1, offsetInLine);
      if (lineIndex == 0) {
        firstLine = caretLine == 0;
        if (!firstLine) {
          caretLine--;
          y_1 = renderer.getLineHeight__I(caretLine) - 1;
        }
      } else {
        y_1 = layout_1.getLineBounds__I(lineIndex - 1).y;
      }
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    } else {
      firstLine = caretLine == 0;
      caretLine--;
    }
    if (firstLine) {
      if (select) {
        this.setCaretOffset__II(0, -1);
      }
    } else {
      var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
      var offset: int = this.getOffsetAtPoint__III_3I(columnX, y_1, caretLine, alignment_1);
      this.setCaretOffset__II(offset, alignment_1[0]);
    }
    var oldColumnX: int = columnX;
    var oldHScrollOffset: int = horizontalScrollOffset;
    if (select)
      this.setMouseWordSelectionAnchor__();
    this.showCaret__();
    if (select)
      this.doSelection__I(16777219);
    var hScrollChange: int = oldHScrollOffset - horizontalScrollOffset;
    columnX = oldColumnX + hScrollChange;
    return;
  }
  public function doMouseLinkCursor__(): void {
    var display_1: Display = this.getDisplay__();
    var point: Point = display_1.getCursorLocation__();
    point = display_1.map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_graphics_Point_2(null, this, point);
    this.doMouseLinkCursor__II(point.x, point.y);
    return;
  }
  public function doMouseLinkCursor__II(x_1: int, y_1: int): void {
    var offset: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, null, true);
    var display_1: Display = this.getDisplay__();
    var newCursor: Cursor = cursor;
    if (renderer.hasLink__I(offset)) {
      newCursor = display_1.getSystemCursor__I(21);
    } else {
      if (cursor === null) {
        var type: int = blockSelection ? 2 : 19;
        newCursor = display_1.getSystemCursor__I(type);
      }
    }
    if (newCursor !== this.getCursor__())
      super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(newCursor);
    return;
  }
  public function doMouseLocationChange__IIZ(x_1: int, y_1: int, select: Boolean): void {
    var line: int = this.getLineIndex__I(y_1);
    updateCaretDirection = true;
    if (blockSelection) {
      x_1 = Math__.max__II(leftMargin, Math__.min__II(x_1, clientAreaWidth - rightMargin));
      y_1 = Math__.max__II(topMargin, Math__.min__II(y_1, clientAreaHeight - bottomMargin));
      if (doubleClickEnabled && clickCount > 1) {
        var wordSelect: Boolean = (clickCount & 1) == 0;
        if (wordSelect) {
          var left: Point = this.getPointAtOffset__I(doubleClickSelection.x);
          var trailing: JavaArray = new JavaArray("[I").lengths(1);
          var offset: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, trailing, true);
          if (offset != -1) {
            if (x_1 > left.x) {
              offset = this.getWordNext__II(offset + trailing[0], 8);
              this.setBlockSelectionOffset__IIZ(doubleClickSelection.x, offset, true);
            } else {
              offset = this.getWordPrevious__II(offset + trailing[0], 16);
              this.setBlockSelectionOffset__IIZ(doubleClickSelection.y, offset, true);
            }
          } else {
            if (x_1 > left.x) {
              this.setBlockSelectionLocation__IIIIZ(left.x, left.y, x_1, y_1, true);
            } else {
              var right: Point = this.getPointAtOffset__I(doubleClickSelection.y);
              this.setBlockSelectionLocation__IIIIZ(right.x, right.y, x_1, y_1, true);
            }
          }
        } else {
          this.setBlockSelectionLocation__IIZ(blockXLocation, y_1, true);
        }
        return;
      } else {
        if (!select)
          this.clearBlockSelection__ZZ(true, false);
        var trailing_1: JavaArray = new JavaArray("[I").lengths(1);
        var offset_1: int = this.getOffsetAtPoint__II_3IZ(x_1, y_1, trailing_1, true);
        if (offset_1 != -1) {
          if (select) {
            this.setBlockSelectionOffset__IZ(offset_1 + trailing_1[0], true);
            return;
          }
        } else {
          if (this.isFixedLineHeight__() && renderer.fixedPitch) {
            var avg: int = renderer.averageCharWidth;
            x_1 = (int((x_1 + horizontalScrollOffset) / avg) * avg) - horizontalScrollOffset + leftMargin;
          }
          this.setBlockSelectionLocation__IIZ(x_1, y_1, true);
          return;
        }
      }
    }
    if (line < 0 || (this.isSingleLine__() && line > 0)) {
      return;
    }
    var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
    var newCaretOffset: int = this.getOffsetAtPoint__II_3I(x_1, y_1, alignment_1);
    var newCaretAlignemnt: int = alignment_1[0];
    if (doubleClickEnabled && clickCount > 1) {
      newCaretOffset = this.doMouseWordSelect__III(x_1, newCaretOffset, line);
    }
    var newCaretLine: int = content.getLineAtOffset__I(newCaretOffset);
    if (0 <= y_1 && y_1 < clientAreaHeight && (0 <= x_1 && x_1 < clientAreaWidth || wordWrap || newCaretLine != content.getLineAtOffset__I(caretOffset))) {
      if (newCaretOffset != caretOffset || newCaretAlignemnt != caretAlignment) {
        this.setCaretOffset__II(newCaretOffset, newCaretAlignemnt);
        if (select)
          this.doMouseSelection__();
        this.showCaret__();
      }
    }
    if (!select) {
      this.setCaretOffset__II(newCaretOffset, newCaretAlignemnt);
      this.clearSelection__Z(true);
    }
    return;
  }
  public function doMouseSelection__(): void {
    if (caretOffset <= selection.x || (caretOffset > selection.x && caretOffset < selection.y && selectionAnchor == selection.x)) {
      this.doSelection__I(16777219);
    } else {
      this.doSelection__I(16777220);
    }
    return;
  }
  public function doMouseWordSelect__III(x_1: int, newCaretOffset: int, line: int): int {
    if (newCaretOffset < selectionAnchor && selectionAnchor == selection.x) {
      selectionAnchor = doubleClickSelection.y;
    } else if (newCaretOffset > selectionAnchor && selectionAnchor == selection.y) {
      selectionAnchor = doubleClickSelection.x;
    }
    if (0 <= x_1 && x_1 < clientAreaWidth) {
      var wordSelect: Boolean = (clickCount & 1) == 0;
      if (caretOffset == selection.x) {
        if (wordSelect) {
          newCaretOffset = this.getWordPrevious__II(newCaretOffset, 16);
        } else {
          newCaretOffset = content.getOffsetAtLine__I(line);
        }
      } else {
        if (wordSelect) {
          newCaretOffset = this.getWordNext__II(newCaretOffset, 8);
        } else {
          var lineEnd: int = content.getCharCount__();
          if (line + 1 < content.getLineCount__()) {
            lineEnd = content.getOffsetAtLine__I(line + 1);
          }
          newCaretOffset = lineEnd;
        }
      }
    }
    return newCaretOffset;
  }
  public function doPageDown__ZI(select: Boolean, height_1: int): void {
    if (this.isSingleLine__())
      return;
    var oldColumnX: int = columnX;
    var oldHScrollOffset: int = horizontalScrollOffset;
    if (this.isFixedLineHeight__()) {
      var lineCount: int = content.getLineCount__();
      var caretLine: int = this.getCaretLine__();
      if (caretLine < lineCount - 1) {
        var lineHeight: int = renderer.getLineHeight__();
        var lines: int = int((height_1 == -1 ? clientAreaHeight : height_1) / lineHeight);
        var scrollLines: int = Math__.min__II(lineCount - caretLine - 1, lines);
        scrollLines = Math__.max__II(1, scrollLines);
        var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
        var offset: int = this.getOffsetAtPoint__II_3I(columnX, this.getLinePixel__I(caretLine + scrollLines), alignment_1);
        this.setCaretOffset__II(offset, alignment_1[0]);
        if (select) {
          this.doSelection__I(16777220);
        }
        var verticalMaximum: int = lineCount * this.getVerticalIncrement__();
        var pageSize: int = clientAreaHeight;
        var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
        var scrollOffset: int = verticalScrollOffset_1 + scrollLines * this.getVerticalIncrement__();
        if (scrollOffset + pageSize > verticalMaximum) {
          scrollOffset = verticalMaximum - pageSize;
        }
        if (scrollOffset > verticalScrollOffset_1) {
          this.scrollVertical__IZ(scrollOffset - verticalScrollOffset_1, true);
        }
      }
    } else {
      var lineCount_1: int = content.getLineCount__();
      var caretLine_1: int = this.getCaretLine__();
      var lineIndex: int;
      var lineHeight_1: int;
      if (height_1 == -1) {
        lineIndex = this.getPartialBottomIndex__();
        var topY: int = this.getLinePixel__I(lineIndex);
        lineHeight_1 = renderer.getLineHeight__I(lineIndex);
        height_1 = topY;
        if (topY + lineHeight_1 <= clientAreaHeight) {
          height_1 += lineHeight_1;
        } else {
          if (wordWrap) {
            var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
            var y_1: int = clientAreaHeight - topY;
            for (var i: int = 0; i < layout_1.getLineCount__(); i++) {
              var bounds: Rectangle = layout_1.getLineBounds__I(i);
              if (bounds.contains__II(bounds.x, y_1)) {
                height_1 += bounds.y;
                break;
              }
            }
            renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
          }
        }
      } else {
        lineIndex = this.getLineIndex__I(height_1);
        var topLineY: int = this.getLinePixel__I(lineIndex);
        if (wordWrap) {
          var layout_2: TextLayout = renderer.getTextLayout__I(lineIndex);
          var y_2: int = height_1 - topLineY;
          for (var i_1: int = 0; i_1 < layout_2.getLineCount__(); i_1++) {
            var bounds_1: Rectangle = layout_2.getLineBounds__I(i_1);
            if (bounds_1.contains__II(bounds_1.x, y_2)) {
              height_1 = topLineY + bounds_1.y + bounds_1.height;
              break;
            }
          }
          renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_2);
        } else {
          height_1 = topLineY + renderer.getLineHeight__I(lineIndex);
        }
      }
      var caretHeight: int = height_1;
      if (wordWrap) {
        var layout_3: TextLayout = renderer.getTextLayout__I(caretLine_1);
        var offsetInLine: int = caretOffset - content.getOffsetAtLine__I(caretLine_1);
        lineIndex = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_3, offsetInLine);
        caretHeight += layout_3.getLineBounds__I(lineIndex).y;
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_3);
      }
      lineIndex = caretLine_1;
      lineHeight_1 = renderer.getLineHeight__I(lineIndex);
      while (caretHeight - lineHeight_1 >= 0 && lineIndex < lineCount_1 - 1) {
        caretHeight -= lineHeight_1;
        lineHeight_1 = renderer.getLineHeight__I(++lineIndex);
      }
      var alignment_2: JavaArray = new JavaArray("[I").lengths(1);
      var offset_1: int = this.getOffsetAtPoint__III_3I(columnX, caretHeight, lineIndex, alignment_2);
      this.setCaretOffset__II(offset_1, alignment_2[0]);
      if (select)
        this.doSelection__I(16777220);
      height_1 = this.getAvailableHeightBellow__I(height_1);
      this.scrollVertical__IZ(height_1, true);
      if (height_1 == 0)
        this.setCaretLocation__();
    }
    this.showCaret__();
    var hScrollChange: int = oldHScrollOffset - horizontalScrollOffset;
    columnX = oldColumnX + hScrollChange;
    return;
  }
  public function doPageEnd__(): void {
    if (this.isSingleLine__()) {
      this.doLineEnd__();
    } else {
      var bottomOffset: int;
      if (wordWrap) {
        var lineIndex: int = this.getPartialBottomIndex__();
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
        var y_1: int = (clientAreaHeight - bottomMargin) - this.getLinePixel__I(lineIndex);
        var index: int = layout_1.getLineCount__() - 1;
        while (index >= 0) {
          var bounds: Rectangle = layout_1.getLineBounds__I(index);
          if (y_1 >= bounds.y + bounds.height)
            break;
          index--;
        }
        if (index == -1 && lineIndex > 0) {
          bottomOffset = content.getOffsetAtLine__I(lineIndex - 1) + Object(content.getLine__I(lineIndex - 1)).length__();
        } else {
          bottomOffset = content.getOffsetAtLine__I(lineIndex) + Math__.max__II(0, layout_1.getLineOffsets__()[index + 1] - 1);
        }
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      } else {
        var lineIndex_1: int = this.getBottomIndex__();
        bottomOffset = content.getOffsetAtLine__I(lineIndex_1) + Object(content.getLine__I(lineIndex_1)).length__();
      }
      if (caretOffset < bottomOffset) {
        this.setCaretOffset__II(bottomOffset, 1);
        this.showCaret__();
      }
    }
    return;
  }
  public function doPageStart__(): void {
    var topOffset: int;
    if (wordWrap) {
      var y_1: int;
      var lineIndex: int;
      if (topIndexY > 0) {
        lineIndex = topIndex - 1;
        y_1 = renderer.getLineHeight__I(lineIndex) - topIndexY;
      } else {
        lineIndex = topIndex;
        y_1 = -topIndexY;
      }
      var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
      var index: int = 0;
      var lineCount: int = layout_1.getLineCount__();
      while (index < lineCount) {
        var bounds: Rectangle = layout_1.getLineBounds__I(index);
        if (y_1 <= bounds.y)
          break;
        index++;
      }
      if (index == lineCount) {
        topOffset = content.getOffsetAtLine__I(lineIndex + 1);
      } else {
        topOffset = content.getOffsetAtLine__I(lineIndex) + layout_1.getLineOffsets__()[index];
      }
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    } else {
      topOffset = content.getOffsetAtLine__I(topIndex);
    }
    if (caretOffset > topOffset) {
      this.setCaretOffset__II(topOffset, 1);
      this.showCaret__();
    }
    return;
  }
  public function doPageUp__ZI(select: Boolean, height_1: int): void {
    if (this.isSingleLine__())
      return;
    var oldHScrollOffset: int = horizontalScrollOffset;
    var oldColumnX: int = columnX;
    if (this.isFixedLineHeight__()) {
      var caretLine: int = this.getCaretLine__();
      if (caretLine > 0) {
        var lineHeight: int = renderer.getLineHeight__();
        var lines: int = int((height_1 == -1 ? clientAreaHeight : height_1) / lineHeight);
        var scrollLines: int = Math__.max__II(1, Math__.min__II(caretLine, lines));
        caretLine -= scrollLines;
        var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
        var offset: int = this.getOffsetAtPoint__II_3I(columnX, this.getLinePixel__I(caretLine), alignment_1);
        this.setCaretOffset__II(offset, alignment_1[0]);
        if (select) {
          this.doSelection__I(16777219);
        }
        var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
        var scrollOffset: int = Math__.max__II(0, verticalScrollOffset_1 - scrollLines * this.getVerticalIncrement__());
        if (scrollOffset < verticalScrollOffset_1) {
          this.scrollVertical__IZ(scrollOffset - verticalScrollOffset_1, true);
        }
      }
    } else {
      var caretLine_1: int = this.getCaretLine__();
      var lineHeight_1: int;
      var lineIndex: int;
      if (height_1 == -1) {
        if (topIndexY == 0) {
          height_1 = clientAreaHeight;
        } else {
          var y_1: int;
          if (topIndex > 0) {
            lineIndex = topIndex - 1;
            lineHeight_1 = renderer.getLineHeight__I(lineIndex);
            height_1 = clientAreaHeight - topIndexY;
            y_1 = lineHeight_1 - topIndexY;
          } else {
            lineIndex = topIndex;
            lineHeight_1 = renderer.getLineHeight__I(lineIndex);
            height_1 = clientAreaHeight - (lineHeight_1 + topIndexY);
            y_1 = -topIndexY;
          }
          if (wordWrap) {
            var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
            for (var i: int = 0; i < layout_1.getLineCount__(); i++) {
              var bounds: Rectangle = layout_1.getLineBounds__I(i);
              if (bounds.contains__II(bounds.x, y_1)) {
                height_1 += lineHeight_1 - (bounds.y + bounds.height);
                break;
              }
            }
            renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
          }
        }
      } else {
        lineIndex = this.getLineIndex__I(clientAreaHeight - height_1);
        var topLineY: int = this.getLinePixel__I(lineIndex);
        if (wordWrap) {
          var layout_2: TextLayout = renderer.getTextLayout__I(lineIndex);
          var y_2: int = topLineY;
          for (var i_1: int = 0; i_1 < layout_2.getLineCount__(); i_1++) {
            var bounds_1: Rectangle = layout_2.getLineBounds__I(i_1);
            if (bounds_1.contains__II(bounds_1.x, y_2)) {
              height_1 = clientAreaHeight - (topLineY + bounds_1.y);
              break;
            }
          }
          renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_2);
        } else {
          height_1 = clientAreaHeight - topLineY;
        }
      }
      var caretHeight: int = height_1;
      if (wordWrap) {
        var layout_3: TextLayout = renderer.getTextLayout__I(caretLine_1);
        var offsetInLine: int = caretOffset - content.getOffsetAtLine__I(caretLine_1);
        lineIndex = this.getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_3, offsetInLine);
        caretHeight += layout_3.getBounds__().height - layout_3.getLineBounds__I(lineIndex).y;
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_3);
      }
      lineIndex = caretLine_1;
      lineHeight_1 = renderer.getLineHeight__I(lineIndex);
      while (caretHeight - lineHeight_1 >= 0 && lineIndex > 0) {
        caretHeight -= lineHeight_1;
        lineHeight_1 = renderer.getLineHeight__I(--lineIndex);
      }
      lineHeight_1 = renderer.getLineHeight__I(lineIndex);
      var alignment_2: JavaArray = new JavaArray("[I").lengths(1);
      var offset_1: int = this.getOffsetAtPoint__III_3I(columnX, lineHeight_1 - caretHeight, lineIndex, alignment_2);
      this.setCaretOffset__II(offset_1, alignment_2[0]);
      if (select)
        this.doSelection__I(16777219);
      height_1 = this.getAvailableHeightAbove__I(height_1);
      this.scrollVertical__IZ(-height_1, true);
      if (height_1 == 0)
        this.setCaretLocation__();
    }
    this.showCaret__();
    var hScrollChange: int = oldHScrollOffset - horizontalScrollOffset;
    columnX = oldColumnX + hScrollChange;
    return;
  }
  public function doSelection__I(direction: int): void {
    var redrawStart: int = -1;
    var redrawEnd: int = -1;
    if (selectionAnchor == -1) {
      selectionAnchor = selection.x;
    }
    if (direction == 16777219) {
      if (caretOffset < selection.x) {
        redrawEnd = selection.x;
        redrawStart = selection.x = caretOffset;
        if (selection.y != selectionAnchor) {
          redrawEnd = selection.y;
          selection.y = selectionAnchor;
        }
      } else if (selectionAnchor == selection.x && caretOffset < selection.y) {
        redrawEnd = selection.y;
        redrawStart = selection.y = caretOffset;
      }
    } else {
      if (caretOffset > selection.y) {
        redrawStart = selection.y;
        redrawEnd = selection.y = caretOffset;
        if (selection.x != selectionAnchor) {
          redrawStart = selection.x;
          selection.x = selectionAnchor;
        }
      } else if (selectionAnchor == selection.y && caretOffset > selection.x) {
        redrawStart = selection.x;
        redrawEnd = selection.x = caretOffset;
      }
    }
    if (redrawStart != -1 && redrawEnd != -1) {
      this.internalRedrawRange__II(redrawStart, redrawEnd - redrawStart);
      this.sendSelectionEvent__();
    }
    return;
  }
  public function doSelectionCursorNext__(): void {
    var caretLine: int = this.getCaretLine__();
    var lineOffset: int = content.getOffsetAtLine__I(caretLine);
    var offsetInLine: int = caretOffset - lineOffset;
    var offset: int;
    var alignment_1: int;
    if (offsetInLine < Object(content.getLine__I(caretLine)).length__()) {
      var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
      offsetInLine = layout_1.getNextOffset__II(offsetInLine, 2);
      var lineStart: int = layout_1.getLineOffsets__()[layout_1.getLineIndex__I(offsetInLine)];
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      offset = offsetInLine + lineOffset;
      alignment_1 = offsetInLine == lineStart ? 1 : 0;
      this.setCaretOffset__II(offset, alignment_1);
      this.showCaret__();
    } else if (caretLine < content.getLineCount__() - 1 && !this.isSingleLine__()) {
      caretLine++;
      offset = content.getOffsetAtLine__I(caretLine);
      alignment_1 = 0;
      this.setCaretOffset__II(offset, alignment_1);
      this.showCaret__();
    }
    return;
  }
  public function doSelectionCursorPrevious__(): void {
    var caretLine: int = this.getCaretLine__();
    var lineOffset: int = content.getOffsetAtLine__I(caretLine);
    var offsetInLine: int = caretOffset - lineOffset;
    if (offsetInLine > 0) {
      var offset: int = this.getClusterPrevious__II(caretOffset, caretLine);
      this.setCaretOffset__II(offset, 1);
      this.showCaret__();
    } else if (caretLine > 0) {
      caretLine--;
      lineOffset = content.getOffsetAtLine__I(caretLine);
      var offset_1: int = lineOffset + Object(content.getLine__I(caretLine)).length__();
      this.setCaretOffset__II(offset_1, 1);
      this.showCaret__();
    }
    return;
  }
  public function doSelectionLineDown__(): void {
    var oldColumnX: int = columnX = this.getPointAtOffset__I(caretOffset).x;
    this.doLineDown__Z(true);
    columnX = oldColumnX;
    return;
  }
  public function doSelectionLineUp__(): void {
    var oldColumnX: int = columnX = this.getPointAtOffset__I(caretOffset).x;
    this.doLineUp__Z(true);
    columnX = oldColumnX;
    return;
  }
  public function doSelectionPageDown__I(pixels: int): void {
    var oldColumnX: int = columnX = this.getPointAtOffset__I(caretOffset).x;
    this.doPageDown__ZI(true, pixels);
    columnX = oldColumnX;
    return;
  }
  public function doSelectionPageUp__I(pixels: int): void {
    var oldColumnX: int = columnX = this.getPointAtOffset__I(caretOffset).x;
    this.doPageUp__ZI(true, pixels);
    columnX = oldColumnX;
    return;
  }
  public function doSelectionWordNext__(): void {
    var offset: int = this.getWordNext__II(caretOffset, 4);
    if (!this.isSingleLine__() || content.getLineAtOffset__I(caretOffset) == content.getLineAtOffset__I(offset)) {
      this.setCaretOffset__II(offset, 1);
      this.showCaret__();
    }
    return;
  }
  public function doSelectionWordPrevious__(): void {
    var offset: int = this.getWordPrevious__II(caretOffset, 4);
    this.setCaretOffset__II(offset, 1);
    this.showCaret__();
    return;
  }
  public function doVisualPrevious__(): void {
    var offset: int = this.getClusterPrevious__II(caretOffset, this.getCaretLine__());
    this.setCaretOffset__II(offset, -1);
    this.showCaret__();
    return;
  }
  public function doVisualNext__(): void {
    var offset: int = this.getClusterNext__II(caretOffset, this.getCaretLine__());
    this.setCaretOffset__II(offset, -1);
    this.showCaret__();
    return;
  }
  public function doWordNext__(): void {
    if (selection.y - selection.x > 0) {
      this.setCaretOffset__II(selection.y, -1);
      this.showCaret__();
    } else {
      this.doSelectionWordNext__();
    }
    return;
  }
  public function doWordPrevious__(): void {
    if (selection.y - selection.x > 0) {
      this.setCaretOffset__II(selection.x, -1);
      this.showCaret__();
    } else {
      this.doSelectionWordPrevious__();
    }
    return;
  }
  public function endAutoScroll__(): void {
    autoScrollDirection = 0;
    return;
  }
  public override function getBackground__(): Color {
    this.checkWidget__();
    if (background === null) {
      return this.getDisplay__().getSystemColor__I(25);
    }
    return background;
  }
  public function getBaseline__(): int {
    this.checkWidget__();
    return renderer.getBaseline__();
  }
  public function getBaseline__I(offset: int): int {
    this.checkWidget__();
    if (!(0 <= offset && offset <= content.getCharCount__())) {
      SWT.error__I(6);
    }
    if (this.isFixedLineHeight__()) {
      return renderer.getBaseline__();
    }
    var lineIndex: int = content.getLineAtOffset__I(offset);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    var lineInParagraph: int = layout_1.getLineIndex__I(Math__.min__II(offset - lineOffset, Object(layout_1.getText__()).length__()));
    var metrics: FontMetrics = layout_1.getLineMetrics__I(lineInParagraph);
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return metrics.getAscent__() + metrics.getLeading__();
  }
  public function getBidiColoring__(): Boolean {
    this.checkWidget__();
    return bidiColoring;
  }
  public function getBlockSelection__(): Boolean {
    this.checkWidget__();
    return blockSelection;
  }
  public function getBlockSelectonPosition__(): Rectangle {
    var firstLine: int = this.getLineIndex__I(blockYAnchor - this.getVerticalScrollOffset__());
    var lastLine: int = this.getLineIndex__I(blockYLocation - this.getVerticalScrollOffset__());
    if (firstLine > lastLine) {
      var temp: int = firstLine;
      firstLine = lastLine;
      lastLine = temp;
    }
    var left: int = blockXAnchor;
    var right: int = blockXLocation;
    if (left > right) {
      left = blockXLocation;
      right = blockXAnchor;
    }
    return new Rectangle(left - horizontalScrollOffset, firstLine, right - horizontalScrollOffset, lastLine);
  }
  public function getBlockSelectionRectangle__(): Rectangle {
    var rect: Rectangle = this.getBlockSelectonPosition__();
    rect.y = this.getLinePixel__I(rect.y);
    rect.width = rect.width - rect.x;
    rect.height = this.getLinePixel__I(rect.height + 1) - rect.y - 1;
    return rect;
  }
  public function getBlockSelectionText__Ljava_lang_String_2(delimiter: String): String {
    var rect: Rectangle = this.getBlockSelectonPosition__();
    var firstLine: int = rect.y;
    var lastLine: int = rect.height;
    var left: int = rect.x;
    var right: int = rect.width;
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    for (var lineIndex: int = firstLine; lineIndex <= lastLine; lineIndex++) {
      var start: int = this.getOffsetAtPoint__III_3I(left, 0, lineIndex, null);
      var end: int = this.getOffsetAtPoint__III_3I(right, 0, lineIndex, null);
      var text: String = content.getTextRange__II(start, end - start);
      buffer.append__Ljava_lang_String_2(text);
      if (lineIndex < lastLine)
        buffer.append__Ljava_lang_String_2(delimiter);
    }
    return buffer.toString__();
  }
  public function getBottomIndex__(): int {
    var bottomIndex: int;
    if (this.isFixedLineHeight__()) {
      var lineCount: int = 1;
      var lineHeight: int = renderer.getLineHeight__();
      if (lineHeight != 0) {
        var partialTopLineHeight: int = topIndex * lineHeight - this.getVerticalScrollOffset__();
        lineCount = int((clientAreaHeight - partialTopLineHeight) / lineHeight);
      }
      bottomIndex = Math__.min__II(content.getLineCount__() - 1, topIndex + Math__.max__II(0, lineCount - 1));
    } else {
      var clientAreaHeight_1: int = this.clientAreaHeight - bottomMargin;
      bottomIndex = this.getLineIndex__I(clientAreaHeight_1);
      if (bottomIndex > 0) {
        var linePixel: int = this.getLinePixel__I(bottomIndex);
        var lineHeight_1: int = renderer.getLineHeight__I(bottomIndex);
        if (linePixel + lineHeight_1 > clientAreaHeight_1) {
          if (this.getLinePixel__I(bottomIndex - 1) >= topMargin) {
            bottomIndex--;
          }
        }
      }
    }
    return bottomIndex;
  }
  public function getBoundsAtOffset__I(offset: int): Rectangle {
    var lineIndex: int = content.getLineAtOffset__I(offset);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var line: String = content.getLine__I(lineIndex);
    var bounds: Rectangle;
    if (Object(line).length__() != 0) {
      var offsetInLine: int = offset - lineOffset;
      var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
      bounds = layout_1.getBounds__II(offsetInLine, offsetInLine);
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    } else {
      bounds = new Rectangle(0, 0, 0, renderer.getLineHeight__());
    }
    if (offset == caretOffset) {
      var lineEnd: int = lineOffset + Object(line).length__();
      if (offset == lineEnd && caretAlignment == 0) {
        bounds.width += this.getCaretWidth__();
      }
    }
    bounds.x += leftMargin - horizontalScrollOffset;
    bounds.y += this.getLinePixel__I(lineIndex);
    return bounds;
  }
  public function getCaretOffset__(): int {
    this.checkWidget__();
    return caretOffset;
  }
  public function getCaretWidth__(): int {
    var caret_1: Caret = this.getCaret__();
    if (caret_1 === null)
      return 0;
    return caret_1.getSize__().x;
  }
  public function getClipboardContent__I(clipboardType: int): Object {
    var plainTextTransfer: TextTransfer = TextTransfer.getInstance__();
    return clipboard.getContents__Lorg_eclipse_swt_dnd_Transfer_2I(plainTextTransfer, clipboardType);
  }
  public function getClusterNext__II(offset: int, lineIndex: int): int {
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    offset -= lineOffset;
    offset = layout_1.getNextOffset__II(offset, 2);
    offset += lineOffset;
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return offset;
  }
  public function getClusterPrevious__II(offset: int, lineIndex: int): int {
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    offset -= lineOffset;
    offset = layout_1.getPreviousOffset__II(offset, 2);
    offset += lineOffset;
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return offset;
  }
  public function getContent__(): StyledTextContent {
    this.checkWidget__();
    return content;
  }
  public override function getDragDetect__(): Boolean {
    this.checkWidget__();
    return dragDetect;
  }
  public function getDoubleClickEnabled__(): Boolean {
    this.checkWidget__();
    return doubleClickEnabled;
  }
  public function getEditable__(): Boolean {
    this.checkWidget__();
    return editable;
  }
  public override function getForeground__(): Color {
    this.checkWidget__();
    if (foreground === null) {
      return this.getDisplay__().getSystemColor__I(24);
    }
    return foreground;
  }
  public function getHorizontalIncrement__(): int {
    return renderer.averageCharWidth;
  }
  public function getHorizontalIndex__(): int {
    this.checkWidget__();
    return int(horizontalScrollOffset / this.getHorizontalIncrement__());
  }
  public function getHorizontalPixel__(): int {
    this.checkWidget__();
    return horizontalScrollOffset;
  }
  public function getIndent__(): int {
    this.checkWidget__();
    return indent;
  }
  public function getJustify__(): Boolean {
    this.checkWidget__();
    return justify;
  }
  public function getKeyBinding__I(key: int): int {
    this.checkWidget__();
    var action: Integer = Integer(keyActionMap.get__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [key]))));
    return action === null ? 0 : action.intValue__();
  }
  public function getCharCount__(): int {
    this.checkWidget__();
    return content.getCharCount__();
  }
  public function getLine__I(lineIndex: int): String {
    this.checkWidget__();
    if (lineIndex < 0 || (lineIndex > 0 && lineIndex >= content.getLineCount__())) {
      SWT.error__I(6);
    }
    return content.getLine__I(lineIndex);
  }
  public function getLineAlignment__I(index: int): int {
    this.checkWidget__();
    if (index < 0 || index > content.getLineCount__()) {
      SWT.error__I(5);
    }
    return renderer.getLineAlignment__II(index, alignment);
  }
  public function getLineAtOffset__I(offset: int): int {
    this.checkWidget__();
    if (offset < 0 || offset > this.getCharCount__()) {
      SWT.error__I(6);
    }
    return content.getLineAtOffset__I(offset);
  }
  public function getLineBackground__I(index: int): Color {
    this.checkWidget__();
    if (index < 0 || index > content.getLineCount__()) {
      SWT.error__I(5);
    }
    return this.isListening__I(3001) ? null : renderer.getLineBackground__ILorg_eclipse_swt_graphics_Color_2(index, null);
  }
  public function getLineBullet__I(index: int): Bullet {
    this.checkWidget__();
    if (index < 0 || index > content.getLineCount__()) {
      SWT.error__I(5);
    }
    return this.isListening__I(3002) ? null : renderer.getLineBullet__ILorg_eclipse_swt_custom_Bullet_2(index, null);
  }
  public function getLineBackgroundData__ILjava_lang_String_2(lineOffset: int, line: String): StyledTextEvent {
    return this.sendLineEvent__IILjava_lang_String_2(3001, lineOffset, line);
  }
  public function getLineCount__(): int {
    this.checkWidget__();
    return content.getLineCount__();
  }
  public function getLineCountWhole__(): int {
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      return lineHeight != 0 ? int(clientAreaHeight / lineHeight) : 1;
    }
    return this.getBottomIndex__() - topIndex + 1;
  }
  public function getLineDelimiter__(): String {
    this.checkWidget__();
    return content.getLineDelimiter__();
  }
  public function getLineHeight__(): int {
    this.checkWidget__();
    return renderer.getLineHeight__();
  }
  public function getLineHeight__I(offset: int): int {
    this.checkWidget__();
    if (!(0 <= offset && offset <= content.getCharCount__())) {
      SWT.error__I(6);
    }
    if (this.isFixedLineHeight__()) {
      return renderer.getLineHeight__();
    }
    var lineIndex: int = content.getLineAtOffset__I(offset);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    var lineInParagraph: int = layout_1.getLineIndex__I(Math__.min__II(offset - lineOffset, Object(layout_1.getText__()).length__()));
    var height_1: int = layout_1.getLineBounds__I(lineInParagraph).height;
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return height_1;
  }
  public function getLineIndent__I(index: int): int {
    this.checkWidget__();
    if (index < 0 || index > content.getLineCount__()) {
      SWT.error__I(5);
    }
    return this.isListening__I(3002) ? 0 : renderer.getLineIndent__II(index, indent);
  }
  public function getLineJustify__I(index: int): Boolean {
    this.checkWidget__();
    if (index < 0 || index > content.getLineCount__()) {
      SWT.error__I(5);
    }
    return this.isListening__I(3002) ? false : renderer.getLineJustify__IZ(index, justify);
  }
  public function getLineSpacing__(): int {
    this.checkWidget__();
    return lineSpacing;
  }
  public function getLineStyleData__ILjava_lang_String_2(lineOffset: int, line: String): StyledTextEvent {
    return this.sendLineEvent__IILjava_lang_String_2(3002, lineOffset, line);
  }
  public function getLinePixel__I(lineIndex: int): int {
    this.checkWidget__();
    var lineCount: int = content.getLineCount__();
    lineIndex = Math__.max__II(0, Math__.min__II(lineCount, lineIndex));
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      return lineIndex * lineHeight - this.getVerticalScrollOffset__() + topMargin;
    }
    if (lineIndex == topIndex)
      return topIndexY + topMargin;
    var height_1: int = topIndexY;
    if (lineIndex > topIndex) {
      for (var i: int = topIndex; i < lineIndex; i++) {
        height_1 += renderer.getLineHeight__I(i);
      }
    } else {
      for (var i_1: int = topIndex - 1; i_1 >= lineIndex; i_1--) {
        height_1 -= renderer.getLineHeight__I(i_1);
      }
    }
    return height_1 + topMargin;
  }
  public function getLineIndex__I(y_1: int): int {
    this.checkWidget__();
    y_1 -= topMargin;
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      var lineIndex: int = int((y_1 + this.getVerticalScrollOffset__()) / lineHeight);
      var lineCount: int = content.getLineCount__();
      lineIndex = Math__.max__II(0, Math__.min__II(lineCount - 1, lineIndex));
      return lineIndex;
    }
    if (y_1 == topIndexY)
      return topIndex;
    var line: int = topIndex;
    if (y_1 < topIndexY) {
      while (y_1 < topIndexY && line > 0) {
        y_1 += renderer.getLineHeight__I(--line);
      }
    } else {
      var lineCount_1: int = content.getLineCount__();
      var lineHeight_1: int = renderer.getLineHeight__I(line);
      while (y_1 - lineHeight_1 >= topIndexY && line < lineCount_1 - 1) {
        y_1 -= lineHeight_1;
        lineHeight_1 = renderer.getLineHeight__I(++line);
      }
    }
    return line;
  }
  public function getLocationAtOffset__I(offset: int): Point {
    this.checkWidget__();
    if (offset < 0 || offset > this.getCharCount__()) {
      SWT.error__I(6);
    }
    return this.getPointAtOffset__I(offset);
  }
  public function getOffsetAtLine__I(lineIndex: int): int {
    this.checkWidget__();
    if (lineIndex < 0 || (lineIndex > 0 && lineIndex >= content.getLineCount__())) {
      SWT.error__I(6);
    }
    return content.getOffsetAtLine__I(lineIndex);
  }
  public function getOffsetAtLocation__Lorg_eclipse_swt_graphics_Point_2(point: Point): int {
    this.checkWidget__();
    if (point === null) {
      SWT.error__I(4);
    }
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = this.getOffsetAtPoint__II_3IZ(point.x, point.y, trailing, true);
    if (offset == -1) {
      SWT.error__I(5);
    }
    return offset + trailing[0];
  }
  public function getOffsetAtPoint__II_3I(x_1: int, y_1: int, alignment_1: JavaArray): int {
    var lineIndex: int = this.getLineIndex__I(y_1);
    y_1 -= this.getLinePixel__I(lineIndex);
    return this.getOffsetAtPoint__III_3I(x_1, y_1, lineIndex, alignment_1);
  }
  public function getOffsetAtPoint__III_3I(x_1: int, y_1: int, lineIndex: int, alignment_1: JavaArray): int {
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    x_1 += horizontalScrollOffset - leftMargin;
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offsetInLine: int = layout_1.getOffset__II_3I(x_1, y_1, trailing);
    if (alignment_1 !== null)
      alignment_1[0] = 1;
    if (trailing[0] != 0) {
      var lineInParagraph: int = layout_1.getLineIndex__I(offsetInLine + trailing[0]);
      var lineStart: int = layout_1.getLineOffsets__()[lineInParagraph];
      if (offsetInLine + trailing[0] == lineStart) {
        offsetInLine += trailing[0];
        if (alignment_1 !== null)
          alignment_1[0] = 0;
      } else {
        var line: String = content.getLine__I(lineIndex);
        var level: int = 0;
        if (alignment_1 !== null) {
          var offset: int = offsetInLine;
          while (offset > 0 && Character.isDigit__C(Object(line).charAt__I(offset)))
            offset--;
          if (offset == 0 && Character.isDigit__C(Object(line).charAt__I(offset))) {
            level = this.isMirrored__() ? 1 : 0;
          } else {
            level = layout_1.getLevel__I(offset) & 0x1;
          }
        }
        offsetInLine += trailing[0];
        if (alignment_1 !== null) {
          var trailingLevel: int = layout_1.getLevel__I(offsetInLine) & 0x1;
          if ((level ^ trailingLevel) != 0) {
            alignment_1[0] = 0;
          } else {
            alignment_1[0] = 1;
          }
        }
      }
    }
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return offsetInLine + content.getOffsetAtLine__I(lineIndex);
  }
  public function getOffsetAtPoint__II_3IZ(x_1: int, y_1: int, trailing: JavaArray, inTextOnly: Boolean): int {
    if (inTextOnly && y_1 + this.getVerticalScrollOffset__() < 0 || x_1 + horizontalScrollOffset < 0) {
      return -1;
    }
    var bottomIndex: int = this.getPartialBottomIndex__();
    var height_1: int = this.getLinePixel__I(bottomIndex + 1);
    if (inTextOnly && y_1 > height_1) {
      return -1;
    }
    var lineIndex: int = this.getLineIndex__I(y_1);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    x_1 += horizontalScrollOffset - leftMargin;
    y_1 -= this.getLinePixel__I(lineIndex);
    var offset: int = layout_1.getOffset__II_3I(x_1, y_1, trailing);
    var rect: Rectangle = layout_1.getLineBounds__I(layout_1.getLineIndex__I(offset));
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    if (inTextOnly && !(rect.x <= x_1 && x_1 <= rect.x + rect.width)) {
      return -1;
    }
    return offset + lineOffset;
  }
  public function getOrientation__(): int {
    this.checkWidget__();
    return this.isMirrored__() ? 67108864 : 33554432;
  }
  public function getPartialBottomIndex__(): int {
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      var partialLineCount: int = Compatibility.ceil__II(clientAreaHeight, lineHeight);
      return Math__.max__II(0, Math__.min__II(content.getLineCount__(), topIndex + partialLineCount) - 1);
    }
    return this.getLineIndex__I(clientAreaHeight - bottomMargin);
  }
  public function getPartialTopIndex__(): int {
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      return int(this.getVerticalScrollOffset__() / lineHeight);
    }
    return topIndexY <= 0 ? topIndex : topIndex - 1;
  }
  public function getPlatformDelimitedText__Lorg_eclipse_swt_custom_StyledText$TextWriter_2(writer: StyledText$TextWriter): String {
    var end: int = writer.getStart__() + writer.getCharCount__();
    var startLine: int = content.getLineAtOffset__I(writer.getStart__());
    var endLine: int = content.getLineAtOffset__I(end);
    var endLineText: String = content.getLine__I(endLine);
    var endLineOffset: int = content.getOffsetAtLine__I(endLine);
    for (var i: int = startLine; i <= endLine; i++) {
      writer.writeLine__Ljava_lang_String_2I(content.getLine__I(i), content.getOffsetAtLine__I(i));
      if (i < endLine) {
        writer.writeLineDelimiter__Ljava_lang_String_2(PlatformLineDelimiter);
      }
    }
    if (end > endLineOffset + Object(endLineText).length__()) {
      writer.writeLineDelimiter__Ljava_lang_String_2(PlatformLineDelimiter);
    }
    writer.close__();
    return writer.toString__();
  }
  public function getRanges__(): JavaArray {
    this.checkWidget__();
    if (!this.isListening__I(3002)) {
      var ranges: JavaArray = renderer.getRanges__II(0, content.getCharCount__());
      if (ranges !== null)
        return ranges;
    }
    return new JavaArray("[I").lengths(0);
  }
  public function getRanges__II(start: int, length: int): JavaArray {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    var end: int = start + length;
    if (start > end || start < 0 || end > contentLength) {
      SWT.error__I(6);
    }
    if (!this.isListening__I(3002)) {
      var ranges: JavaArray = renderer.getRanges__II(start, length);
      if (ranges !== null)
        return ranges;
    }
    return new JavaArray("[I").lengths(0);
  }
  public function getSelection__(): Point {
    this.checkWidget__();
    return new Point(selection.x, selection.y);
  }
  public function getSelectionRange__(): Point {
    this.checkWidget__();
    return new Point(selection.x, selection.y - selection.x);
  }
  public function getSelectionRanges__(): JavaArray {
    this.checkWidget__();
    if (blockSelection && blockXLocation != -1) {
      var rect: Rectangle = this.getBlockSelectonPosition__();
      var firstLine: int = rect.y;
      var lastLine: int = rect.height;
      var left: int = rect.x;
      var right: int = rect.width;
      var ranges: JavaArray = new JavaArray("[I").lengths((lastLine - firstLine + 1) * 2);
      var index: int = 0;
      for (var lineIndex: int = firstLine; lineIndex <= lastLine; lineIndex++) {
        var start: int = this.getOffsetAtPoint__III_3I(left, 0, lineIndex, null);
        ranges[index++] = start;
        ranges[index++] = this.getOffsetAtPoint__III_3I(right, 0, lineIndex, null) - start;
      }
      return ranges;
    }
    return new JavaArray("[I").values(selection.x, selection.y - selection.x);
  }
  public function getSelectionBackground__(): Color {
    this.checkWidget__();
    if (selectionBackground === null) {
      return this.getDisplay__().getSystemColor__I(26);
    }
    return selectionBackground;
  }
  public function getSelectionCount__(): int {
    this.checkWidget__();
    if (blockSelection && blockXLocation != -1) {
      return Object(this.getBlockSelectionText__Ljava_lang_String_2(content.getLineDelimiter__())).length__();
    }
    return this.getSelectionRange__().y;
  }
  public function getSelectionForeground__(): Color {
    this.checkWidget__();
    if (selectionForeground === null) {
      return this.getDisplay__().getSystemColor__I(27);
    }
    return selectionForeground;
  }
  public function getSelectionText__(): String {
    this.checkWidget__();
    if (blockSelection && blockXLocation != -1) {
      return this.getBlockSelectionText__Ljava_lang_String_2(content.getLineDelimiter__());
    }
    return content.getTextRange__II(selection.x, selection.y - selection.x);
  }
  public override function getStyle__(): int {
    var style_1: int = super.getStyle__();
    style_1 &= ~(33554432 | 67108864 | 134217728);
    if (this.isMirrored__()) {
      style_1 |= 67108864 | 134217728;
    } else {
      style_1 |= 33554432;
    }
    return style_1;
  }
  public function getBidiSegments__ILjava_lang_String_2(lineOffset: int, line: String): JavaArray {
    if (!this.isBidi__())
      return null;
    if (!this.isListening__I(3007)) {
      return this.getBidiSegmentsCompatibility__Ljava_lang_String_2I(line, lineOffset);
    }
    var event: StyledTextEvent = this.sendLineEvent__IILjava_lang_String_2(3007, lineOffset, line);
    var lineLength: int = Object(line).length__();
    var segments: JavaArray;
    if (event === null || event.segments === null || event.segments.length == 0) {
      segments = new JavaArray("[I").values(0, lineLength);
    } else {
      var segmentCount: int = event.segments.length;
      if (event.segments[0] != 0) {
        SWT.error__I(5);
      }
      for (var i: int = 1; i < segmentCount; i++) {
        if (event.segments[i] <= event.segments[i - 1] || event.segments[i] > lineLength) {
          SWT.error__I(5);
        }
      }
      if (event.segments[segmentCount - 1] != lineLength) {
        segments = new JavaArray("[I").lengths(segmentCount + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(event.segments, 0, segments, 0, segmentCount);
        segments[segmentCount] = lineLength;
      } else {
        segments = event.segments;
      }
    }
    return segments;
  }
  public function getBidiSegmentsCompatibility__Ljava_lang_String_2I(line: String, lineOffset: int): JavaArray {
    var lineLength: int = Object(line).length__();
    if (!bidiColoring) {
      return new JavaArray("[I").values(0, lineLength);
    }
    var styles: JavaArray = null;
    var event: StyledTextEvent = this.getLineStyleData__ILjava_lang_String_2(lineOffset, line);
    if (event !== null) {
      styles = event.styles;
    } else {
      styles = renderer.getStyleRanges__IIZ(lineOffset, lineLength, true);
    }
    if (styles === null || styles.length == 0) {
      return new JavaArray("[I").values(0, lineLength);
    }
    var k: int = 0;
    var count: int = 1;
    while (k < styles.length && styles[k].start == 0 && styles[k].length == lineLength) {
      k++;
    }
    var offsets: JavaArray = new JavaArray("[I").lengths((styles.length - k) * 2 + 2);
    for (var i: int = k; i < styles.length; i++) {
      var style_1: StyleRange = styles[i];
      var styleLineStart: int = Math__.max__II(style_1.start - lineOffset, 0);
      var styleLineEnd: int = Math__.max__II(style_1.start + style_1.length - lineOffset, styleLineStart);
      styleLineEnd = Math__.min__II(styleLineEnd, Object(line).length__());
      if (i > 0 && count > 1 && ((styleLineStart >= offsets[count - 2] && styleLineStart <= offsets[count - 1]) || (styleLineEnd >= offsets[count - 2] && styleLineEnd <= offsets[count - 1])) && style_1.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(styles[i - 1])) {
        offsets[count - 2] = Math__.min__II(offsets[count - 2], styleLineStart);
        offsets[count - 1] = Math__.max__II(offsets[count - 1], styleLineEnd);
      } else {
        if (styleLineStart > offsets[count - 1]) {
          offsets[count] = styleLineStart;
          count++;
        }
        offsets[count] = styleLineEnd;
        count++;
      }
    }
    if (lineLength > offsets[count - 1]) {
      offsets[count] = lineLength;
      count++;
    }
    if (count == offsets.length) {
      return offsets;
    }
    var result: JavaArray = new JavaArray("[I").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(offsets, 0, result, 0, count);
    return result;
  }
  public function getStyleRangeAtOffset__I(offset: int): StyleRange {
    this.checkWidget__();
    if (offset < 0 || offset >= this.getCharCount__()) {
      SWT.error__I(5);
    }
    if (!this.isListening__I(3002)) {
      var ranges: JavaArray = renderer.getStyleRanges__IIZ(offset, 1, true);
      if (ranges !== null)
        return ranges[0];
    }
    return null;
  }
  public function getStyleRanges__(): JavaArray {
    this.checkWidget__();
    return this.getStyleRanges__IIZ(0, content.getCharCount__(), true);
  }
  public function getStyleRanges__Z(includeRanges: Boolean): JavaArray {
    this.checkWidget__();
    return this.getStyleRanges__IIZ(0, content.getCharCount__(), includeRanges);
  }
  public function getStyleRanges__II(start: int, length: int): JavaArray {
    this.checkWidget__();
    return this.getStyleRanges__IIZ(start, length, true);
  }
  public function getStyleRanges__IIZ(start: int, length: int, includeRanges: Boolean): JavaArray {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    var end: int = start + length;
    if (start > end || start < 0 || end > contentLength) {
      SWT.error__I(6);
    }
    if (!this.isListening__I(3002)) {
      var ranges: JavaArray = renderer.getStyleRanges__IIZ(start, length, includeRanges);
      if (ranges !== null)
        return ranges;
    }
    return new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(0);
  }
  public function getTabs__(): int {
    this.checkWidget__();
    return tabLength;
  }
  public function getText__(): String {
    this.checkWidget__();
    return content.getTextRange__II(0, this.getCharCount__());
  }
  public function getText__II(start: int, end: int): String {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    if (start < 0 || start >= contentLength || end < 0 || end >= contentLength || start > end) {
      SWT.error__I(6);
    }
    return content.getTextRange__II(start, end - start + 1);
  }
  public function getTextBounds__II(start: int, end: int): Rectangle {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    if (start < 0 || start >= contentLength || end < 0 || end >= contentLength || start > end) {
      SWT.error__I(6);
    }
    var lineStart: int = content.getLineAtOffset__I(start);
    var lineEnd: int = content.getLineAtOffset__I(end);
    var rect: Rectangle;
    var y_1: int = this.getLinePixel__I(lineStart);
    var height_1: int = 0;
    var left: int = 0x7fffffff;
    var right: int = 0;
    for (var i: int = lineStart; i <= lineEnd; i++) {
      var lineOffset: int = content.getOffsetAtLine__I(i);
      var layout_1: TextLayout = renderer.getTextLayout__I(i);
      var length: int = Object(layout_1.getText__()).length__();
      if (length > 0) {
        if (i == lineStart) {
          if (i == lineEnd) {
            rect = layout_1.getBounds__II(start - lineOffset, end - lineOffset);
          } else {
            rect = layout_1.getBounds__II(start - lineOffset, length);
          }
          y_1 += rect.y;
        } else if (i == lineEnd) {
          rect = layout_1.getBounds__II(0, end - lineOffset);
        } else {
          rect = layout_1.getBounds__();
        }
        left = Math__.min__II(left, rect.x);
        right = Math__.max__II(right, rect.x + rect.width);
        height_1 += rect.height;
      } else {
        height_1 += renderer.getLineHeight__();
      }
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    }
    rect = new Rectangle(left, y_1, right - left, height_1);
    rect.x += leftMargin - horizontalScrollOffset;
    return rect;
  }
  public function getTextRange__II(start: int, length: int): String {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    var end: int = start + length;
    if (start > end || start < 0 || end > contentLength) {
      SWT.error__I(6);
    }
    return content.getTextRange__II(start, length);
  }
  public function getTextLimit__(): int {
    this.checkWidget__();
    return textLimit;
  }
  public function getTopIndex__(): int {
    this.checkWidget__();
    return topIndex;
  }
  public function getTopPixel__(): int {
    this.checkWidget__();
    return this.getVerticalScrollOffset__();
  }
  public function getVerticalIncrement__(): int {
    return renderer.getLineHeight__();
  }
  public function getVerticalScrollOffset__(): int {
    if (verticalScrollOffset == -1) {
      renderer.calculate__II(0, topIndex);
      var height_1: int = 0;
      for (var i: int = 0; i < topIndex; i++) {
        height_1 += renderer.getLineHeight__I(i);
      }
      height_1 -= topIndexY;
      verticalScrollOffset = height_1;
    }
    return verticalScrollOffset;
  }
  public function getVisualLineIndex__Lorg_eclipse_swt_graphics_TextLayout_2I(layout_1: TextLayout, offsetInLine: int): int {
    var lineIndex: int = layout_1.getLineIndex__I(offsetInLine);
    var offsets: JavaArray = layout_1.getLineOffsets__();
    if (lineIndex != 0 && offsetInLine == offsets[lineIndex]) {
      var lineY: int = layout_1.getLineBounds__I(lineIndex).y;
      var caretY: int = this.getCaret__().getLocation__().y - topMargin - this.getLinePixel__I(this.getCaretLine__());
      if (lineY > caretY)
        lineIndex--;
    }
    return lineIndex;
  }
  public function getCaretDirection__(): int {
    if (!this.isBidiCaret__())
      return -1;
    if (ime.getCompositionOffset__() != -1)
      return -1;
    if (!updateCaretDirection && caretDirection != 0)
      return caretDirection;
    updateCaretDirection = false;
    var caretLine: int = this.getCaretLine__();
    var lineOffset: int = content.getOffsetAtLine__I(caretLine);
    var line: String = content.getLine__I(caretLine);
    var offset: int = caretOffset - lineOffset;
    var lineLength: int = Object(line).length__();
    if (lineLength == 0)
      return this.isMirrored__() ? 131072 : 16384;
    if (caretAlignment == 0 && offset > 0)
      offset--;
    if (offset == lineLength && offset > 0)
      offset--;
    while (offset > 0 && Character.isDigit__C(Object(line).charAt__I(offset)))
      offset--;
    if (offset == 0 && Character.isDigit__C(Object(line).charAt__I(offset))) {
      return this.isMirrored__() ? 131072 : 16384;
    }
    var layout_1: TextLayout = renderer.getTextLayout__I(caretLine);
    var level: int = layout_1.getLevel__I(offset);
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    return ((level & 1) != 0) ? 131072 : 16384;
  }
  public function getCaretLine__(): int {
    return content.getLineAtOffset__I(caretOffset);
  }
  public function getWrapWidth__(): int {
    if (wordWrap && !this.isSingleLine__()) {
      var width_1: int = clientAreaWidth - leftMargin - rightMargin - this.getCaretWidth__();
      return width_1 > 0 ? width_1 : 1;
    }
    return -1;
  }
  public function getWordNext__II(offset: int, movement: int): int {
    var newOffset: int;
    var lineOffset: int;
    var lineText: String;
    if (offset >= this.getCharCount__()) {
      newOffset = offset;
      var lineIndex: int = content.getLineCount__() - 1;
      lineOffset = content.getOffsetAtLine__I(lineIndex);
      lineText = content.getLine__I(lineIndex);
    } else {
      var lineIndex_1: int = content.getLineAtOffset__I(offset);
      lineOffset = content.getOffsetAtLine__I(lineIndex_1);
      lineText = content.getLine__I(lineIndex_1);
      var lineLength: int = Object(lineText).length__();
      if (offset == lineOffset + lineLength) {
        newOffset = content.getOffsetAtLine__I(lineIndex_1 + 1);
      } else {
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex_1);
        newOffset = lineOffset + layout_1.getNextOffset__II(offset - lineOffset, movement);
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      }
    }
    return this.sendWordBoundaryEvent__IIIILjava_lang_String_2I(3009, movement, offset, newOffset, lineText, lineOffset);
  }
  public function getWordPrevious__II(offset: int, movement: int): int {
    var newOffset: int;
    var lineOffset: int;
    var lineText: String;
    if (offset <= 0) {
      newOffset = 0;
      var lineIndex: int = content.getLineAtOffset__I(newOffset);
      lineOffset = content.getOffsetAtLine__I(lineIndex);
      lineText = content.getLine__I(lineIndex);
    } else {
      var lineIndex_1: int = content.getLineAtOffset__I(offset);
      lineOffset = content.getOffsetAtLine__I(lineIndex_1);
      lineText = content.getLine__I(lineIndex_1);
      if (offset == lineOffset) {
        var nextLineText: String = content.getLine__I(lineIndex_1 - 1);
        var nextLineOffset: int = content.getOffsetAtLine__I(lineIndex_1 - 1);
        newOffset = nextLineOffset + Object(nextLineText).length__();
      } else {
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex_1);
        newOffset = lineOffset + layout_1.getPreviousOffset__II(offset - lineOffset, movement);
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      }
    }
    return this.sendWordBoundaryEvent__IIIILjava_lang_String_2I(3010, movement, offset, newOffset, lineText, lineOffset);
  }
  public function getWordWrap__(): Boolean {
    this.checkWidget__();
    return wordWrap;
  }
  public function getPointAtOffset__I(offset: int): Point {
    var lineIndex: int = content.getLineAtOffset__I(offset);
    var line: String = content.getLine__I(lineIndex);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var offsetInLine: int = offset - lineOffset;
    var lineLength: int = Object(line).length__();
    if (lineIndex < content.getLineCount__() - 1) {
      var endLineOffset: int = content.getOffsetAtLine__I(lineIndex + 1) - 1;
      if (lineLength < offsetInLine && offsetInLine <= endLineOffset) {
        offsetInLine = lineLength;
      }
    }
    var point: Point;
    var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
    if (lineLength != 0 && offsetInLine <= lineLength) {
      if (offsetInLine == lineLength) {
        point = layout_1.getLocation__IZ(offsetInLine - 1, true);
      } else {
        switch (caretAlignment) {
          case 1 :
            point = layout_1.getLocation__IZ(offsetInLine, false);
            break;
          case 0 :
          default :
            if (offsetInLine == 0) {
              point = layout_1.getLocation__IZ(offsetInLine, false);
            } else {
              point = layout_1.getLocation__IZ(offsetInLine - 1, true);
            }
            break;
        }
      }
    } else {
      point = new Point(layout_1.getIndent__(), 0);
    }
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    point.x += leftMargin - horizontalScrollOffset;
    point.y += this.getLinePixel__I(lineIndex);
    return point;
  }
  public function insert__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null) {
      SWT.error__I(4);
    }
    if (blockSelection) {
      this.insertBlockSelectionText__Ljava_lang_String_2Z(string, false);
    } else {
      var sel: Point = this.getSelectionRange__();
      this.replaceTextRange__IILjava_lang_String_2(sel.x, sel.y, string);
    }
    return;
  }
  public function insertBlockSelectionText__Ljava_lang_String_2Z(text: String, fillWithSpaces: Boolean): int {
    var lineCount: int = 1;
    for (var i: int = 0; i < Object(text).length__(); i++) {
      var ch: uint = Object(text).charAt__I(i);
      if (ch == 10 || ch == 13) {
        lineCount++;
        if (ch == 13 && i + 1 < Object(text).length__() && Object(text).charAt__I(i + 1) == 10) {
          i++;
        }
      }
    }
    var lines: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(lineCount);
    var start: int = 0;
    lineCount = 0;
    for (var i_1: int = 0; i_1 < Object(text).length__(); i_1++) {
      var ch_1: uint = Object(text).charAt__I(i_1);
      if (ch_1 == 10 || ch_1 == 13) {
        lines[lineCount++] = Object(text).substring__II(start, i_1);
        if (ch_1 == 13 && i_1 + 1 < Object(text).length__() && Object(text).charAt__I(i_1 + 1) == 10) {
          i_1++;
        }
        start = i_1 + 1;
      }
    }
    lines[lineCount++] = Object(text).substring__I(start);
    var firstLine: int;
    var lastLine: int;
    var left: int;
    var right: int;
    if (blockXLocation != -1) {
      var rect: Rectangle = this.getBlockSelectonPosition__();
      firstLine = rect.y;
      lastLine = rect.height;
      left = rect.x;
      right = rect.width;
    } else {
      firstLine = lastLine = this.getCaretLine__();
      left = right = this.getPointAtOffset__I(caretOffset).x;
    }
    start = caretOffset;
    var index: int = 0;
    var lineIndex: int = firstLine;
    while (lineIndex <= lastLine) {
      var string: String = index < lineCount ? lines[index++] : "";
      start = this.sendTextEvent__IIILjava_lang_String_2Z(left, right, lineIndex, string, fillWithSpaces);
      lineIndex++;
    }
    while (index < lineCount) {
      start = this.sendTextEvent__IIILjava_lang_String_2Z(left, left, lineIndex, lines[index++], fillWithSpaces);
      lineIndex++;
    }
    return start;
  }
  public function insertBlockSelectionText__CI(key: uint, action: int): void {
    if (key == 13 || key == 10)
      return;
    var rect: Rectangle = this.getBlockSelectonPosition__();
    var firstLine: int = rect.y;
    var lastLine: int = rect.height;
    var left: int = rect.x;
    var right: int = rect.width;
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = 0;
    var delta: int = 0;
    var text: String = key != 0 ? Object(String).__init___3C(new JavaArray("[C").values(key)) : "";
    var length: int = Object(text).length__();
    for (var lineIndex: int = firstLine; lineIndex <= lastLine; lineIndex++) {
      var line: String = content.getLine__I(lineIndex);
      var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
      var lineEndOffset: int = lineOffset + Object(line).length__();
      var linePixel: int = this.getLinePixel__I(lineIndex);
      var start: int = this.getOffsetAtPoint__II_3IZ(left, linePixel, trailing, true);
      var outOfLine: Boolean = start == -1;
      if (outOfLine) {
        start = left < leftMargin ? lineOffset : lineEndOffset;
      } else {
        start += trailing[0];
      }
      var end: int = this.getOffsetAtPoint__II_3IZ(right, linePixel, trailing, true);
      if (end == -1) {
        end = right < leftMargin ? lineOffset : lineEndOffset;
      } else {
        end += trailing[0];
      }
      if (start == end && !outOfLine) {
        switch (action) {
          case 8 :
            if (start > lineOffset)
              start = this.getClusterPrevious__II(start, lineIndex);
            break;
          case 127 :
            if (end < lineEndOffset)
              end = this.getClusterNext__II(end, lineIndex);
            break;
        }
      }
      if (outOfLine) {
        if (Object(line).length__() > delta) {
          delta = Object(line).length__();
          offset = lineEndOffset + length;
        }
      } else {
        offset = start + length;
        delta = content.getCharCount__();
      }
      var event: Event = new Event();
      event.text = text;
      event.start = start;
      event.end = end;
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    var x_1: int = this.getPointAtOffset__I(offset).x;
    var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
    this.setBlockSelectionLocation__IIIIZ(x_1, blockYAnchor - verticalScrollOffset_1, x_1, blockYLocation - verticalScrollOffset_1, false);
    return;
  }
  public function installDefaultContent__(): void {
    textChangeListener = new org.eclipse.swt.custom.StyledText$6(this);
    content = new DefaultContent();
    content.addTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(textChangeListener);
    return;
  }
  public function installListeners__(): void {
    var verticalBar_1: ScrollBar = this.getVerticalBar__();
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    listener = new org.eclipse.swt.custom.StyledText$7(this);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(1, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(3, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(4, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(5, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(9, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(31, listener);
    ime.addListener__ILorg_eclipse_swt_widgets_Listener_2(43, new org.eclipse.swt.custom.StyledText$8(this));
    if (verticalBar_1 !== null) {
      verticalBar_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.custom.StyledText$9(this));
    }
    if (horizontalBar_1 !== null) {
      horizontalBar_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.custom.StyledText$10(this));
    }
    return;
  }
  public function internalRedrawRange__II(start: int, length: int): void {
    if (length <= 0)
      return;
    var end: int = start + length;
    var startLine: int = content.getLineAtOffset__I(start);
    var endLine: int = content.getLineAtOffset__I(end);
    var partialBottomIndex: int = this.getPartialBottomIndex__();
    var partialTopIndex: int = this.getPartialTopIndex__();
    if (startLine > partialBottomIndex || endLine < partialTopIndex) {
      return;
    }
    if (partialTopIndex > startLine) {
      startLine = partialTopIndex;
      start = 0;
    } else {
      start -= content.getOffsetAtLine__I(startLine);
    }
    if (partialBottomIndex < endLine) {
      endLine = partialBottomIndex + 1;
      end = 0;
    } else {
      end -= content.getOffsetAtLine__I(endLine);
    }
    var layout_1: TextLayout = renderer.getTextLayout__I(startLine);
    var lineX: int = leftMargin - horizontalScrollOffset;
    var startLineY: int = this.getLinePixel__I(startLine);
    var offsets: JavaArray = layout_1.getLineOffsets__();
    var startIndex: int = layout_1.getLineIndex__I(Math__.min__II(start, Object(layout_1.getText__()).length__()));
    if (wordWrap && startIndex > 0 && offsets[startIndex] == start) {
      var rect: Rectangle = layout_1.getLineBounds__I(startIndex - 1);
      rect.x = rect.width;
      rect.width = clientAreaWidth - rightMargin - rect.x;
      rect.x += lineX;
      rect.y += startLineY;
      super.redraw__IIIIZ(rect.x, rect.y, rect.width, rect.height, false);
    }
    if (startLine == endLine) {
      var endIndex: int = layout_1.getLineIndex__I(Math__.min__II(end, Object(layout_1.getText__()).length__()));
      if (startIndex == endIndex) {
        var rect_1: Rectangle = layout_1.getBounds__II(start, end - 1);
        rect_1.x += lineX;
        rect_1.y += startLineY;
        super.redraw__IIIIZ(rect_1.x, rect_1.y, rect_1.width, rect_1.height, false);
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
        return;
      }
    }
    var startRect: Rectangle = layout_1.getBounds__II(start, offsets[startIndex + 1] - 1);
    if (startRect.height == 0) {
      var bounds: Rectangle = layout_1.getLineBounds__I(startIndex);
      startRect.x = bounds.width;
      startRect.y = bounds.y;
      startRect.height = bounds.height;
    }
    startRect.x += lineX;
    startRect.y += startLineY;
    startRect.width = clientAreaWidth - rightMargin - startRect.x;
    super.redraw__IIIIZ(startRect.x, startRect.y, startRect.width, startRect.height, false);
    if (startLine != endLine) {
      renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      layout_1 = renderer.getTextLayout__I(endLine);
      offsets = layout_1.getLineOffsets__();
    }
    var endIndex_1: int = layout_1.getLineIndex__I(Math__.min__II(end, Object(layout_1.getText__()).length__()));
    var endRect: Rectangle = layout_1.getBounds__II(offsets[endIndex_1], end - 1);
    if (endRect.height == 0) {
      var bounds_1: Rectangle = layout_1.getLineBounds__I(endIndex_1);
      endRect.y = bounds_1.y;
      endRect.height = bounds_1.height;
    }
    endRect.x += lineX;
    endRect.y += this.getLinePixel__I(endLine);
    super.redraw__IIIIZ(endRect.x, endRect.y, endRect.width, endRect.height, false);
    renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
    var y_1: int = startRect.y + startRect.height;
    if (endRect.y > y_1) {
      super.redraw__IIIIZ(leftMargin, y_1, clientAreaWidth - rightMargin - leftMargin, endRect.y - y_1, false);
    }
    return;
  }
  public function handleCompositionOffset__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var trailing: JavaArray = new JavaArray("[I").lengths(1);
    event.index = this.getOffsetAtPoint__II_3IZ(event.x, event.y, trailing, true);
    event.count = trailing[0];
    return;
  }
  public function handleCompositionSelection__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    event.start = selection.x;
    event.end = selection.y;
    event.text = this.getSelectionText__();
    return;
  }
  public function handleCompositionChanged__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var text: String = event.text;
    var start: int = event.start;
    var end: int = event.end;
    var length: int = Object(text).length__();
    if (length == ime.getCommitCount__()) {
      content.replaceTextRange__IILjava_lang_String_2(start, end - start, "");
      this.setCaretOffset__II(ime.getCompositionOffset__(), -1);
      caretWidth = 0;
      caretDirection = 0;
    } else {
      content.replaceTextRange__IILjava_lang_String_2(start, end - start, text);
      this.setCaretOffset__II(ime.getCompositionOffset__(), -1);
      if (ime.getWideCaret__()) {
        start = ime.getCompositionOffset__();
        var lineIndex: int = this.getCaretLine__();
        var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
        var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
        caretWidth = layout_1.getBounds__II(start - lineOffset, start + length - 1 - lineOffset).width;
        renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
      }
    }
    this.showCaret__();
    return;
  }
  public function handleDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    clipboard.dispose__();
    if (renderer !== null) {
      renderer.dispose__();
      renderer = null;
    }
    if (content !== null) {
      content.removeTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(textChangeListener);
      content = null;
    }
    if (defaultCaret !== null) {
      defaultCaret.dispose__();
      defaultCaret = null;
    }
    if (leftCaretBitmap !== null) {
      leftCaretBitmap.dispose__();
      leftCaretBitmap = null;
    }
    if (rightCaretBitmap !== null) {
      rightCaretBitmap.dispose__();
      rightCaretBitmap = null;
    }
    if (this.isBidiCaret__()) {
      BidiUtil.removeLanguageListener__Lorg_eclipse_swt_widgets_Control_2(this);
    }
    selectionBackground = null;
    selectionForeground = null;
    textChangeListener = null;
    selection = null;
    doubleClickSelection = null;
    keyActionMap = null;
    background = null;
    foreground = null;
    clipboard = null;
    return;
  }
  public function handleHorizontalScroll__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var scrollPixel: int = this.getHorizontalBar__().getSelection__() - horizontalScrollOffset;
    this.scrollHorizontal__IZ(scrollPixel, false);
    return;
  }
  public function handleKey__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var action: int;
    caretAlignment = 0;
    if (event.keyCode != 0) {
      action = this.getKeyBinding__I(event.keyCode | event.stateMask);
    } else {
      action = this.getKeyBinding__I(event.character | event.stateMask);
      if (action == 0) {
        if ((event.stateMask & 262144) != 0 && (event.character >= 0) && event.character <= 31) {
          var c: int = event.character + 64;
          action = this.getKeyBinding__I(c | event.stateMask);
        }
      }
    }
    if (action == 0) {
      var ignore: Boolean = false;
      if (IS_MAC) {
        ignore = (event.stateMask ^ 4194304) == 0 || (event.stateMask ^ (4194304 | 131072)) == 0;
      } else if (IS_MOTIF) {
        ignore = (event.stateMask ^ 262144) == 0 || (event.stateMask ^ (262144 | 131072)) == 0;
      } else {
        ignore = (event.stateMask ^ 65536) == 0 || (event.stateMask ^ 262144) == 0 || (event.stateMask ^ (65536 | 131072)) == 0 || (event.stateMask ^ (262144 | 131072)) == 0;
      }
      if (!ignore && event.character > 31 && event.character != 127 || event.character == 13 || event.character == 10 || event.character == 9) {
        this.doContent__C(event.character);
        this.update__();
      }
    } else {
      this.invokeAction__I(action);
    }
    return;
  }
  public function handleKeyDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (clipboardSelection === null) {
      clipboardSelection = new Point(selection.x, selection.y);
    }
    var verifyEvent: Event = new Event();
    verifyEvent.character = event.character;
    verifyEvent.keyCode = event.keyCode;
    verifyEvent.stateMask = event.stateMask;
    verifyEvent.doit = true;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3005, verifyEvent);
    if (verifyEvent.doit) {
      this.handleKey__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function handleKeyUp__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (clipboardSelection !== null) {
      if (clipboardSelection.x != selection.x || clipboardSelection.y != selection.y) {
        this.copySelection__I(2);
      }
    }
    clipboardSelection = null;
    return;
  }
  public function handleMouseDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.forceFocus__();
    if (dragDetect && this.checkDragDetect__Lorg_eclipse_swt_widgets_Event_2(event))
      return;
    if (event.button == 2) {
      var text: String = String(this.getClipboardContent__I(2));
      if (text !== null && Object(text).length__() > 0) {
        this.doMouseLocationChange__IIZ(event.x, event.y, false);
        var e: Event = new Event();
        e.start = selection.x;
        e.end = selection.y;
        e.text = this.getModelDelimitedText__Ljava_lang_String_2(text);
        this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(e);
      }
    }
    if ((event.button != 1) || (IS_MAC && (event.stateMask & SWT.MOD4) != 0)) {
      return;
    }
    clickCount = event.count;
    if (clickCount == 1) {
      var select: Boolean = (event.stateMask & SWT.MOD2) != 0;
      this.doMouseLocationChange__IIZ(event.x, event.y, select);
    } else {
      if (doubleClickEnabled) {
        var wordSelect: Boolean = (clickCount & 1) == 0;
        var offset: int = this.getOffsetAtPoint__II_3I(event.x, event.y, null);
        var lineIndex: int = content.getLineAtOffset__I(offset);
        var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
        if (wordSelect) {
          var min: int = blockSelection ? lineOffset : 0;
          var max: int = blockSelection ? lineOffset + Object(content.getLine__I(lineIndex)).length__() : content.getCharCount__();
          var start: int = Math__.max__II(min, this.getWordPrevious__II(offset, 16));
          var end: int = Math__.min__II(max, this.getWordNext__II(start, 8));
          this.setSelection__IIZZ(start, end - start, true, true);
        } else {
          if (blockSelection) {
            this.setBlockSelectionLocation__IIIIZ(leftMargin, event.y, clientAreaWidth - rightMargin, event.y, true);
          } else {
            var lineEnd: int = content.getCharCount__();
            if (lineIndex + 1 < content.getLineCount__()) {
              lineEnd = content.getOffsetAtLine__I(lineIndex + 1);
            }
            this.setSelection__IIZZ(lineOffset, lineEnd - lineOffset, true, false);
          }
        }
        doubleClickSelection = new Point(selection.x, selection.y);
        this.showCaret__();
      }
    }
    return;
  }
  public function handleMouseMove__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (clickCount > 0) {
      this.update__();
      this.doAutoScroll__Lorg_eclipse_swt_widgets_Event_2(event);
      this.doMouseLocationChange__IIZ(event.x, event.y, true);
    }
    if (renderer.hasLinks) {
      this.doMouseLinkCursor__II(event.x, event.y);
    }
    return;
  }
  public function handleMouseUp__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    clickCount = 0;
    this.endAutoScroll__();
    if (event.button == 1) {
      this.copySelection__I(2);
    }
    return;
  }
  public function handlePaint__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (event.width == 0 || event.height == 0)
      return;
    if (clientAreaWidth == 0 || clientAreaHeight == 0)
      return;
    var startLine: int = this.getLineIndex__I(event.y);
    var y_1: int = this.getLinePixel__I(startLine);
    var endY: int = event.y + event.height;
    var gc: GC = event.gc;
    var background_1: Color = this.getBackground__();
    var foreground_1: Color = this.getForeground__();
    if (endY > 0) {
      var lineCount: int = this.isSingleLine__() ? 1 : content.getLineCount__();
      var x_1: int = leftMargin - horizontalScrollOffset;
      for (var i: int = startLine; y_1 < endY && i < lineCount; i++) {
        y_1 += renderer.drawLine__IIILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(i, x_1, y_1, gc, background_1, foreground_1);
      }
      if (y_1 < endY) {
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background_1);
        this.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, 0, y_1, clientAreaWidth, endY - y_1);
      }
    }
    if (blockSelection && blockXLocation != -1) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getSelectionBackground__());
      var rect: Rectangle = this.getBlockSelectionRectangle__();
      gc.drawRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
      gc.setAdvanced__Z(true);
      if (gc.getAdvanced__()) {
        gc.setAlpha__I(100);
        gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect);
        gc.setAdvanced__Z(false);
      }
    }
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background_1);
    if (topMargin > 0) {
      this.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, 0, 0, clientAreaWidth, topMargin);
    }
    if (bottomMargin > 0) {
      this.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, 0, clientAreaHeight - bottomMargin, clientAreaWidth, bottomMargin);
    }
    if (leftMargin > 0) {
      this.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, 0, 0, leftMargin, clientAreaHeight);
    }
    if (rightMargin > 0) {
      this.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, clientAreaWidth - rightMargin, 0, rightMargin, clientAreaHeight);
    }
    return;
  }
  public function handleResize__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var oldHeight: int = clientAreaHeight;
    var oldWidth: int = clientAreaWidth;
    var clientArea: Rectangle = this.getClientArea__();
    clientAreaHeight = clientArea.height;
    clientAreaWidth = clientArea.width;
    if (oldWidth != clientAreaWidth) {
      if (rightMargin > 0) {
        var x_1: int = (oldWidth < clientAreaWidth ? oldWidth : clientAreaWidth) - rightMargin;
        super.redraw__IIIIZ(x_1, 0, rightMargin, oldHeight, false);
      }
    }
    if (oldHeight != clientAreaHeight) {
      if (bottomMargin > 0) {
        var y_1: int = (oldHeight < clientAreaHeight ? oldHeight : clientAreaHeight) - bottomMargin;
        super.redraw__IIIIZ(0, y_1, oldWidth, bottomMargin, false);
      }
    }
    if (wordWrap) {
      if (oldWidth != clientAreaWidth) {
        renderer.reset__II(0, content.getLineCount__());
        verticalScrollOffset = -1;
        renderer.calculateIdle__();
        super.redraw__();
      }
      if (oldHeight != clientAreaHeight) {
        if (oldHeight == 0)
          topIndexY = 0;
        this.setScrollBars__Z(true);
      }
      this.setCaretLocation__();
    } else {
      renderer.calculateClientArea__();
      this.setScrollBars__Z(true);
      this.claimRightFreeSpace__();
      if (clientAreaWidth != 0) {
        var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
        if (horizontalBar_1 !== null && horizontalBar_1.getVisible__()) {
          if (horizontalScrollOffset != horizontalBar_1.getSelection__()) {
            horizontalBar_1.setSelection__I(horizontalScrollOffset);
            horizontalScrollOffset = horizontalBar_1.getSelection__();
          }
        }
      }
    }
    this.claimBottomFreeSpace__();
    return;
  }
  public function handleTextChanged__Lorg_eclipse_swt_custom_TextChangedEvent_2(event: TextChangedEvent): void {
    var offset: int = ime.getCompositionOffset__();
    if (offset != -1 && lastTextChangeStart < offset) {
      ime.setCompositionOffset__I(offset + lastTextChangeNewCharCount - lastTextChangeReplaceCharCount);
    }
    var firstLine: int = content.getLineAtOffset__I(lastTextChangeStart);
    this.resetCache__II(firstLine, 0);
    if (!this.isFixedLineHeight__() && topIndex > firstLine) {
      topIndex = firstLine;
      topIndexY = 0;
      super.redraw__();
    } else {
      var lastLine: int = firstLine + lastTextChangeNewLineCount;
      var firstLineTop: int = this.getLinePixel__I(firstLine);
      var newLastLineBottom: int = this.getLinePixel__I(lastLine + 1);
      if (lastLineBottom != newLastLineBottom) {
        super.redraw__();
      } else {
        super.redraw__IIIIZ(0, firstLineTop, clientAreaWidth, newLastLineBottom - firstLineTop, false);
        this.redrawLinesBullet___3I(renderer.redrawLines);
      }
    }
    renderer.redrawLines = null;
    if (!(blockSelection && blockXLocation != -1)) {
      this.updateSelection__III(lastTextChangeStart, lastTextChangeReplaceCharCount, lastTextChangeNewCharCount);
    }
    if (lastTextChangeReplaceLineCount > 0 || wordWrap) {
      this.claimBottomFreeSpace__();
    }
    if (lastTextChangeReplaceCharCount > 0) {
      this.claimRightFreeSpace__();
    }
    return;
  }
  public function handleTextChanging__Lorg_eclipse_swt_custom_TextChangingEvent_2(event: TextChangingEvent): void {
    if (event.replaceCharCount < 0) {
      event.start += event.replaceCharCount;
      event.replaceCharCount *= -1;
    }
    lastTextChangeStart = event.start;
    lastTextChangeNewLineCount = event.newLineCount;
    lastTextChangeNewCharCount = event.newCharCount;
    lastTextChangeReplaceLineCount = event.replaceLineCount;
    lastTextChangeReplaceCharCount = event.replaceCharCount;
    var lineIndex: int = content.getLineAtOffset__I(event.start);
    var srcY: int = this.getLinePixel__I(lineIndex + event.replaceLineCount + 1);
    var destY: int = this.getLinePixel__I(lineIndex + 1) + event.newLineCount * renderer.getLineHeight__();
    lastLineBottom = destY;
    if (srcY < 0 && destY < 0) {
      lastLineBottom += srcY - destY;
      verticalScrollOffset += destY - srcY;
      this.calculateTopIndex__I(destY - srcY);
      this.setScrollBars__Z(true);
    } else {
      this.scrollText__II(srcY, destY);
    }
    renderer.textChanging__Lorg_eclipse_swt_custom_TextChangingEvent_2(event);
    var newEndOfText: int = content.getCharCount__() - event.replaceCharCount + event.newCharCount;
    if (caretOffset > newEndOfText)
      this.setCaretOffset__II(newEndOfText, -1);
    return;
  }
  public function handleTextSet__Lorg_eclipse_swt_custom_TextChangedEvent_2(event: TextChangedEvent): void {
    this.reset__();
    return;
  }
  public function handleTraverse__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    switch (event.detail) {
      case 2 :
      case 512 :
      case 256 :
        event.doit = true;
        break;
      case 4 :
      case 16 :
      case 8 :
        if ((this.getStyle__() & 4) != 0) {
          event.doit = true;
        } else {
          if (!editable || (event.stateMask & SWT.MODIFIER_MASK) != 0) {
            event.doit = true;
          }
        }
        break;
    }
    return;
  }
  public function handleVerticalScroll__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var scrollPixel: int = this.getVerticalBar__().getSelection__() - this.getVerticalScrollOffset__();
    this.scrollVertical__IZ(scrollPixel, false);
    return;
  }
  public function initializeAccessible__(): void {
    var accessible_1: Accessible = this.getAccessible__();
    accessible_1.addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(new org.eclipse.swt.custom.StyledText$11(this));
    accessible_1.addAccessibleTextListener__Lorg_eclipse_swt_accessibility_AccessibleTextListener_2(new org.eclipse.swt.custom.StyledText$12(this));
    accessible_1.addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.swt.custom.StyledText$13(this));
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(15, new org.eclipse.swt.custom.StyledText$14(this, accessible_1));
    return;
  }
  public function getAssociatedLabel__(): Label {
    var siblings: JavaArray = this.getParent__().getChildren__();
    for (var i: int = 0; i < siblings.length; i++) {
      if (siblings[i] === this) {
        if (i > 0 && siblings[i - 1] is Label) {
          return Label(siblings[i - 1]);
        }
      }
    }
    return null;
  }
  public function stripMnemonic__Ljava_lang_String_2(string: String): String {
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while ((index < length) && (Object(string).charAt__I(index) != 38))
        index++;
      if (++index >= length)
        return string;
      if (Object(string).charAt__I(index) != 38) {
        return Object(string).substring__II(0, index - 1) + Object(string).substring__II(index, length);
      }
      index++;
    } while (index < length);
    return string;
  }
  public function _findMnemonic__Ljava_lang_String_2(string: String): uint {
    if (string === null)
      return 0;
    var index: int = 0;
    var length: int = Object(string).length__();
    do {
      while (index < length && Object(string).charAt__I(index) != 38)
        index++;
      if (++index >= length)
        return 0;
      if (Object(string).charAt__I(index) != 38)
        return Character.toLowerCase__C(Object(string).charAt__I(index));
      index++;
    } while (index < length);
    return 0;
  }
  public function invokeAction__I(action: int): void {
    this.checkWidget__();
    if (blockSelection && this.invokeBlockAction__I(action))
      return;
    updateCaretDirection = true;
    switch (action) {
      case 16777217 :
        this.doLineUp__Z(false);
        this.clearSelection__Z(true);
        break;
      case 16777218 :
        this.doLineDown__Z(false);
        this.clearSelection__Z(true);
        break;
      case 16777223 :
        this.doLineStart__();
        this.clearSelection__Z(true);
        break;
      case 16777224 :
        this.doLineEnd__();
        this.clearSelection__Z(true);
        break;
      case 16777219 :
        this.doCursorPrevious__();
        this.clearSelection__Z(true);
        break;
      case 16777220 :
        this.doCursorNext__();
        this.clearSelection__Z(true);
        break;
      case 16777221 :
        this.doPageUp__ZI(false, -1);
        this.clearSelection__Z(true);
        break;
      case 16777222 :
        this.doPageDown__ZI(false, -1);
        this.clearSelection__Z(true);
        break;
      case 17039363 :
        this.doWordPrevious__();
        this.clearSelection__Z(true);
        break;
      case 17039364 :
        this.doWordNext__();
        this.clearSelection__Z(true);
        break;
      case 17039367 :
        this.doContentStart__();
        this.clearSelection__Z(true);
        break;
      case 17039368 :
        this.doContentEnd__();
        this.clearSelection__Z(true);
        break;
      case 17039365 :
        this.doPageStart__();
        this.clearSelection__Z(true);
        break;
      case 17039366 :
        this.doPageEnd__();
        this.clearSelection__Z(true);
        break;
      case 16908289 :
        this.doSelectionLineUp__();
        break;
      case 262209 :
        this.selectAll__();
        break;
      case 16908290 :
        this.doSelectionLineDown__();
        break;
      case 16908295 :
        this.doLineStart__();
        this.doSelection__I(16777219);
        break;
      case 16908296 :
        this.doLineEnd__();
        this.doSelection__I(16777220);
        break;
      case 16908291 :
        this.doSelectionCursorPrevious__();
        this.doSelection__I(16777219);
        break;
      case 16908292 :
        this.doSelectionCursorNext__();
        this.doSelection__I(16777220);
        break;
      case 16908293 :
        this.doSelectionPageUp__I(-1);
        break;
      case 16908294 :
        this.doSelectionPageDown__I(-1);
        break;
      case 17170435 :
        this.doSelectionWordPrevious__();
        this.doSelection__I(16777219);
        break;
      case 17170436 :
        this.doSelectionWordNext__();
        this.doSelection__I(16777220);
        break;
      case 17170439 :
        this.doContentStart__();
        this.doSelection__I(16777219);
        break;
      case 17170440 :
        this.doContentEnd__();
        this.doSelection__I(16777220);
        break;
      case 17170437 :
        this.doPageStart__();
        this.doSelection__I(16777219);
        break;
      case 17170438 :
        this.doPageEnd__();
        this.doSelection__I(16777220);
        break;
      case 131199 :
        this.cut__();
        break;
      case 17039369 :
        this.copy__();
        break;
      case 16908297 :
        this.paste__();
        break;
      case 8 :
        this.doBackspace__();
        break;
      case 127 :
        this.doDelete__();
        break;
      case 262152 :
        this.doDeleteWordPrevious__();
        break;
      case 262271 :
        this.doDeleteWordNext__();
        break;
      case 16777225 :
        overwrite = !overwrite;
        break;
      case 16777226 :
        this.setBlockSelection__Z(!blockSelection);
        break;
    }
  }
  public function invokeBlockAction__I(action: int): Boolean {
    switch (action) {
      case 16777217 :
      case 16777218 :
      case 16777223 :
      case 16777224 :
      case 16777219 :
      case 16777220 :
      case 16777221 :
      case 16777222 :
      case 17039363 :
      case 17039364 :
      case 17039367 :
      case 17039368 :
      case 17039365 :
      case 17039366 :
        this.clearBlockSelection__ZZ(true, blockXLocation != -1);
        return false;
      case 16908289 :
        this.doBlockLineVertical__Z(true);
        return true;
      case 16908290 :
        this.doBlockLineVertical__Z(false);
        return true;
      case 16908295 :
        this.doBlockLineHorizontal__Z(false);
        return true;
      case 16908296 :
        this.doBlockLineHorizontal__Z(true);
        return false;
      case 16908291 :
        this.doBlockColumn__Z(false);
        return true;
      case 16908292 :
        this.doBlockColumn__Z(true);
        return true;
      case 17170435 :
        this.doBlockWord__Z(false);
        return true;
      case 17170436 :
        this.doBlockWord__Z(true);
        return true;
      case 262209 :
      case 16908293 :
      case 16908294 :
      case 17170439 :
      case 17170440 :
      case 17170437 :
      case 17170438 :
        return true;
      case 131199 :
      case 17039369 :
      case 16908297 :
        return false;
      case 8 :
      case 127 :
        if (blockXLocation != -1) {
          this.insertBlockSelectionText__CI(uint(0), action);
          return true;
        }
        return false;
      case 262152 :
      case 262271 :
        return blockXLocation != -1;
    }
    return false;
  }
  public function isBidi__(): Boolean {
    return IS_GTK || IS_MAC || BidiUtil.isBidiPlatform__() || isMirrored;
  }
  public function isBidiCaret__(): Boolean {
    return BidiUtil.isBidiPlatform__();
  }
  public function isFixedLineHeight__(): Boolean {
    return fixedLineHeight;
  }
  public function isLineDelimiter__I(offset: int): Boolean {
    var line: int = content.getLineAtOffset__I(offset);
    var lineOffset: int = content.getOffsetAtLine__I(line);
    var offsetInLine: int = offset - lineOffset;
    return offsetInLine > Object(content.getLine__I(line)).length__();
  }
  public function isMirrored__(): Boolean {
    return isMirrored;
  }
  public function isSingleLine__(): Boolean {
    return (this.getStyle__() & 4) != 0;
  }
  public function modifyContent__Lorg_eclipse_swt_widgets_Event_2Z(event: Event, updateCaret: Boolean): void {
    event.doit = true;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(25, event);
    if (event.doit) {
      var styledTextEvent: StyledTextEvent = null;
      var replacedLength: int = event.end - event.start;
      if (this.isListening__I(3000)) {
        styledTextEvent = new StyledTextEvent(content);
        styledTextEvent.start = event.start;
        styledTextEvent.end = event.start + Object(event.text).length__();
        styledTextEvent.text = content.getTextRange__II(event.start, replacedLength);
      }
      if (updateCaret) {
        if (Object(event.text).length__() == 0) {
          var lineIndex: int = content.getLineAtOffset__I(event.start);
          var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
          var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
          var levelStart: int = layout_1.getLevel__I(event.start - lineOffset);
          var lineIndexEnd: int = content.getLineAtOffset__I(event.end);
          if (lineIndex != lineIndexEnd) {
            renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
            lineOffset = content.getOffsetAtLine__I(lineIndexEnd);
            layout_1 = renderer.getTextLayout__I(lineIndexEnd);
          }
          var levelEnd: int = layout_1.getLevel__I(event.end - lineOffset);
          renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
          if (levelStart != levelEnd) {
            caretAlignment = 0;
          } else {
            caretAlignment = 1;
          }
        }
      }
      content.replaceTextRange__IILjava_lang_String_2(event.start, replacedLength, event.text);
      if (updateCaret && !(blockSelection && blockXLocation != -1)) {
        this.setSelection__IIZZ(event.start + Object(event.text).length__(), 0, true, false);
        this.showCaret__();
      }
      this.sendModifyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
      if (this.isListening__I(3000)) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3000, styledTextEvent);
      }
    }
    return;
  }
  public function paintObject__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_custom_StyleRange_2Lorg_eclipse_swt_custom_Bullet_2I(gc: GC, x_1: int, y_1: int, ascent: int, descent: int, style_1: StyleRange, bullet: Bullet, bulletIndex: int): void {
    if (this.isListening__I(3008)) {
      var event: StyledTextEvent = new StyledTextEvent(content);
      event.gc = gc;
      event.x = x_1;
      event.y = y_1;
      event.ascent = ascent;
      event.descent = descent;
      event.style = style_1;
      event.bullet = bullet;
      event.bulletIndex = bulletIndex;
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3008, event);
    }
    return;
  }
  public function paste__(): void {
    this.checkWidget__();
    var text: String = String(this.getClipboardContent__I(1));
    if (text !== null && Object(text).length__() > 0) {
      if (blockSelection) {
        var fillWithSpaces: Boolean = this.isFixedLineHeight__() && renderer.fixedPitch;
        var offset: int = this.insertBlockSelectionText__Ljava_lang_String_2Z(text, fillWithSpaces);
        this.setCaretOffset__II(offset, -1);
        this.clearBlockSelection__ZZ(true, true);
        this.setCaretLocation__();
        return;
      }
      var event: Event = new Event();
      event.start = selection.x;
      event.end = selection.y;
      event.text = this.getModelDelimitedText__Ljava_lang_String_2(text);
      this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function print__(): void {
    this.checkWidget__();
    var printer: Printer = new Printer(new Arguments(org.eclipse.swt.printing.Printer.Printer__, []));
    var options: StyledTextPrintOptions = new StyledTextPrintOptions();
    options.printTextForeground = true;
    options.printTextBackground = true;
    options.printTextFontStyle = true;
    options.printLineBackground = true;
    new StyledText$Printing(this, printer, options).run__();
    printer.dispose__();
    return;
  }
  public function print__Lorg_eclipse_swt_printing_Printer_2(printer: Printer): Runnable {
    this.checkWidget__();
    if (printer === null) {
      SWT.error__I(4);
    }
    var options: StyledTextPrintOptions = new StyledTextPrintOptions();
    options.printTextForeground = true;
    options.printTextBackground = true;
    options.printTextFontStyle = true;
    options.printLineBackground = true;
    return this.print__Lorg_eclipse_swt_printing_Printer_2Lorg_eclipse_swt_custom_StyledTextPrintOptions_2(printer, options);
  }
  public function print__Lorg_eclipse_swt_printing_Printer_2Lorg_eclipse_swt_custom_StyledTextPrintOptions_2(printer: Printer, options: StyledTextPrintOptions): Runnable {
    this.checkWidget__();
    if (printer === null || options === null) {
      SWT.error__I(4);
    }
    return new StyledText$Printing(this, printer, options);
  }
  public override function redraw__(): void {
    super.redraw__();
    var itemCount: int = this.getPartialBottomIndex__() - topIndex + 1;
    renderer.reset__II(topIndex, itemCount);
    renderer.calculate__II(topIndex, itemCount);
    this.setScrollBars__Z(false);
    this.doMouseLinkCursor__();
  }
  public override function redraw__IIIIZ(x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    super.redraw__IIIIZ(x_1, y_1, width_1, height_1, all);
    if (height_1 > 0) {
      var firstLine: int = this.getLineIndex__I(y_1);
      var lastLine: int = this.getLineIndex__I(y_1 + height_1);
      this.resetCache__II(firstLine, lastLine - firstLine + 1);
      this.doMouseLinkCursor__();
    }
    return;
  }
  public function redrawLines__II(startLine: int, lineCount: int): void {
    var endLine: int = startLine + lineCount - 1;
    var partialBottomIndex: int = this.getPartialBottomIndex__();
    var partialTopIndex: int = this.getPartialTopIndex__();
    if (startLine > partialBottomIndex || endLine < partialTopIndex) {
      return;
    }
    if (startLine < partialTopIndex) {
      startLine = partialTopIndex;
    }
    if (endLine > partialBottomIndex) {
      endLine = partialBottomIndex;
      ;
    }
    var redrawTop: int = this.getLinePixel__I(startLine);
    var redrawBottom: int = this.getLinePixel__I(endLine + 1);
    var redrawWidth: int = clientAreaWidth - leftMargin - rightMargin;
    super.redraw__IIIIZ(leftMargin, redrawTop, redrawWidth, redrawBottom - redrawTop, true);
    return;
  }
  public function redrawLinesBullet___3I(redrawLines: JavaArray): void {
    if (redrawLines === null)
      return;
    var topIndex_1: int = this.getPartialTopIndex__();
    var bottomIndex: int = this.getPartialBottomIndex__();
    for (var i: int = 0; i < redrawLines.length; i++) {
      var lineIndex: int = redrawLines[i];
      if (!(topIndex_1 <= lineIndex && lineIndex <= bottomIndex))
        continue;
      var width_1: int = -1;
      var bullet: Bullet = renderer.getLineBullet__ILorg_eclipse_swt_custom_Bullet_2(lineIndex, null);
      if (bullet !== null) {
        var style_1: StyleRange = bullet.style;
        var metrics: GlyphMetrics = style_1.metrics;
        width_1 = metrics.width;
      }
      if (width_1 == -1)
        width_1 = this.getClientArea__().width;
      var height_1: int = renderer.getLineHeight__I(lineIndex);
      var y_1: int = this.getLinePixel__I(lineIndex);
      super.redraw__IIIIZ(0, y_1, width_1, height_1, false);
    }
    return;
  }
  public function redrawRange__IIZ(start: int, length: int, clearBackground: Boolean): void {
    this.checkWidget__();
    var end: int = start + length;
    var contentLength: int = content.getCharCount__();
    if (start > end || start < 0 || end > contentLength) {
      SWT.error__I(6);
    }
    var firstLine: int = content.getLineAtOffset__I(start);
    var lastLine: int = content.getLineAtOffset__I(end);
    this.resetCache__II(firstLine, lastLine - firstLine + 1);
    this.internalRedrawRange__II(start, length);
    this.doMouseLinkCursor__();
    return;
  }
  public function removeBidiSegmentListener__Lorg_eclipse_swt_custom_BidiSegmentListener_2(listener_1: BidiSegmentListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3007, listener_1);
    return;
  }
  public function removeCaretListener__Lorg_eclipse_swt_custom_CaretListener_2(listener_1: CaretListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3011, listener_1);
    return;
  }
  public function removeExtendedModifyListener__Lorg_eclipse_swt_custom_ExtendedModifyListener_2(extendedModifyListener: ExtendedModifyListener): void {
    this.checkWidget__();
    if (extendedModifyListener === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3000, extendedModifyListener);
    return;
  }
  public function removeLineBackgroundListener__Lorg_eclipse_swt_custom_LineBackgroundListener_2(listener_1: LineBackgroundListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3001, listener_1);
    return;
  }
  public function removeLineStyleListener__Lorg_eclipse_swt_custom_LineStyleListener_2(listener_1: LineStyleListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3002, listener_1);
    this.setCaretLocation__();
    return;
  }
  public function removeModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(modifyListener: ModifyListener): void {
    this.checkWidget__();
    if (modifyListener === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(24, modifyListener);
    return;
  }
  public function removePaintObjectListener__Lorg_eclipse_swt_custom_PaintObjectListener_2(listener_1: PaintObjectListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3008, listener_1);
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener_1);
    return;
  }
  public function removeVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(verifyListener: VerifyListener): void {
    this.checkWidget__();
    if (verifyListener === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(25, verifyListener);
    return;
  }
  public function removeVerifyKeyListener__Lorg_eclipse_swt_custom_VerifyKeyListener_2(listener_1: VerifyKeyListener): void {
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3005, listener_1);
    return;
  }
  public function removeWordMovementListener__Lorg_eclipse_swt_custom_MovementListener_2(listener_1: MovementListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3009, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(3010, listener_1);
    return;
  }
  public function replaceStyleRanges__II_3Lorg_eclipse_swt_custom_StyleRange_2(start: int, length: int, ranges: JavaArray): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (ranges === null)
      SWT.error__I(4);
    this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(start, length, null, ranges, false);
  }
  public function replaceTextRange__IILjava_lang_String_2(start: int, length: int, text: String): void {
    this.checkWidget__();
    if (text === null) {
      SWT.error__I(4);
    }
    var contentLength: int = this.getCharCount__();
    var end: int = start + length;
    if (start > end || start < 0 || end > contentLength) {
      SWT.error__I(6);
    }
    var event: Event = new Event();
    event.start = start;
    event.end = end;
    event.text = text;
    this.modifyContent__Lorg_eclipse_swt_widgets_Event_2Z(event, false);
    return;
  }
  public function reset__(): void {
    var verticalBar_1: ScrollBar = this.getVerticalBar__();
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    this.setCaretOffset__II(0, -1);
    topIndex = 0;
    topIndexY = 0;
    verticalScrollOffset = 0;
    horizontalScrollOffset = 0;
    this.resetSelection__();
    renderer.setContent__Lorg_eclipse_swt_custom_StyledTextContent_2(content);
    if (verticalBar_1 !== null) {
      verticalBar_1.setSelection__I(0);
    }
    if (horizontalBar_1 !== null) {
      horizontalBar_1.setSelection__I(0);
    }
    this.resetCache__II(0, 0);
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public function resetCache__II(firstLine: int, count: int): void {
    var maxLineIndex: int = renderer.maxWidthLineIndex;
    renderer.reset__II(firstLine, count);
    renderer.calculateClientArea__();
    if (0 <= maxLineIndex && maxLineIndex < content.getLineCount__()) {
      renderer.calculate__II(maxLineIndex, 1);
    }
    this.setScrollBars__Z(true);
    if (!this.isFixedLineHeight__()) {
      if (topIndex > firstLine) {
        verticalScrollOffset = -1;
      }
      renderer.calculateIdle__();
    }
    return;
  }
  public function resetSelection__(): void {
    selection.x = selection.y = caretOffset;
    selectionAnchor = -1;
    return;
  }
  public override function scroll__IIIIIIZ(destX: int, destY: int, x_1: int, y_1: int, width_1: int, height_1: int, all: Boolean): void {
    super.scroll__IIIIIIZ(destX, destY, x_1, y_1, width_1, height_1, false);
    if (all) {
      var deltaX: int = destX - x_1;
      var deltaY: int = destY - y_1;
      var children_1: JavaArray = this.getChildren__();
      for (var i: int = 0; i < children_1.length; i++) {
        var child: Control = children_1[i];
        var rect: Rectangle = child.getBounds__();
        child.setLocation__II(rect.x + deltaX, rect.y + deltaY);
      }
    }
    return;
  }
  public function scrollHorizontal__IZ(pixels: int, adjustScrollBar: Boolean): Boolean {
    if (pixels == 0) {
      return false;
    }
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    if (horizontalBar_1 !== null && adjustScrollBar) {
      horizontalBar_1.setSelection__I(horizontalScrollOffset + pixels);
    }
    var scrollHeight: int = clientAreaHeight - topMargin - bottomMargin;
    if (pixels > 0) {
      var sourceX: int = leftMargin + pixels;
      var scrollWidth: int = clientAreaWidth - sourceX - rightMargin;
      if (scrollWidth > 0) {
        this.scroll__IIIIIIZ(leftMargin, topMargin, sourceX, topMargin, scrollWidth, scrollHeight, true);
      }
      if (sourceX > scrollWidth) {
        super.redraw__IIIIZ(leftMargin + scrollWidth, topMargin, pixels - scrollWidth, scrollHeight, true);
      }
    } else {
      var destinationX: int = leftMargin - pixels;
      var scrollWidth_1: int = clientAreaWidth - destinationX - rightMargin;
      if (scrollWidth_1 > 0) {
        this.scroll__IIIIIIZ(destinationX, topMargin, leftMargin, topMargin, scrollWidth_1, scrollHeight, true);
      }
      if (destinationX > scrollWidth_1) {
        super.redraw__IIIIZ(leftMargin + scrollWidth_1, topMargin, -pixels - scrollWidth_1, scrollHeight, true);
      }
    }
    horizontalScrollOffset += pixels;
    this.setCaretLocation__();
    return true;
  }
  public function scrollVertical__IZ(pixels: int, adjustScrollBar: Boolean): Boolean {
    if (pixels == 0) {
      return false;
    }
    if (verticalScrollOffset != -1) {
      var verticalBar_1: ScrollBar = this.getVerticalBar__();
      if (verticalBar_1 !== null && adjustScrollBar) {
        verticalBar_1.setSelection__I(verticalScrollOffset + pixels);
      }
      var scrollWidth: int = clientAreaWidth - leftMargin - rightMargin;
      if (pixels > 0) {
        var sourceY: int = topMargin + pixels;
        var scrollHeight: int = clientAreaHeight - sourceY - bottomMargin;
        if (scrollHeight > 0) {
          this.scroll__IIIIIIZ(leftMargin, topMargin, leftMargin, sourceY, scrollWidth, scrollHeight, true);
        }
        if (sourceY > scrollHeight) {
          var redrawY: int = Math__.max__II(0, topMargin + scrollHeight);
          var redrawHeight: int = Math__.min__II(clientAreaHeight, pixels - scrollHeight);
          super.redraw__IIIIZ(leftMargin, redrawY, scrollWidth, redrawHeight, true);
        }
      } else {
        var destinationY: int = topMargin - pixels;
        var scrollHeight_1: int = clientAreaHeight - destinationY - bottomMargin;
        if (scrollHeight_1 > 0) {
          this.scroll__IIIIIIZ(leftMargin, destinationY, leftMargin, topMargin, scrollWidth, scrollHeight_1, true);
        }
        if (destinationY > scrollHeight_1) {
          var redrawY_1: int = Math__.max__II(0, topMargin + scrollHeight_1);
          var redrawHeight_1: int = Math__.min__II(clientAreaHeight, -pixels - scrollHeight_1);
          super.redraw__IIIIZ(leftMargin, redrawY_1, scrollWidth, redrawHeight_1, true);
        }
      }
      verticalScrollOffset += pixels;
      this.calculateTopIndex__I(pixels);
    } else {
      this.calculateTopIndex__I(pixels);
      super.redraw__();
    }
    this.setCaretLocation__();
    return true;
  }
  public function scrollText__II(srcY: int, destY: int): void {
    if (srcY == destY)
      return;
    var deltaY: int = destY - srcY;
    var scrollWidth: int = clientAreaWidth - leftMargin - rightMargin;
    var scrollHeight: int;
    if (deltaY > 0) {
      scrollHeight = clientAreaHeight - srcY - bottomMargin;
    } else {
      scrollHeight = clientAreaHeight - destY - bottomMargin;
    }
    this.scroll__IIIIIIZ(leftMargin, destY, leftMargin, srcY, scrollWidth, scrollHeight, true);
    if ((0 < srcY + scrollHeight) && (topMargin > srcY)) {
      super.redraw__IIIIZ(leftMargin, deltaY, scrollWidth, topMargin, false);
    }
    if ((0 < destY + scrollHeight) && (topMargin > destY)) {
      super.redraw__IIIIZ(leftMargin, 0, scrollWidth, topMargin, false);
    }
    if ((clientAreaHeight - bottomMargin < srcY + scrollHeight) && (clientAreaHeight > srcY)) {
      super.redraw__IIIIZ(leftMargin, clientAreaHeight - bottomMargin + deltaY, scrollWidth, bottomMargin, false);
    }
    if ((clientAreaHeight - bottomMargin < destY + scrollHeight) && (clientAreaHeight > destY)) {
      super.redraw__IIIIZ(leftMargin, clientAreaHeight - bottomMargin, scrollWidth, bottomMargin, false);
    }
    return;
  }
  public function selectAll__(): void {
    this.checkWidget__();
    this.setSelection__II(0, Math__.max__II(this.getCharCount__(), 0));
    return;
  }
  public function sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (editable) {
      this.modifyContent__Lorg_eclipse_swt_widgets_Event_2Z(event, true);
    }
    return;
  }
  public function sendLineEvent__IILjava_lang_String_2(eventType: int, lineOffset: int, line: String): StyledTextEvent {
    var event: StyledTextEvent = null;
    if (this.isListening__I(eventType)) {
      event = new StyledTextEvent(content);
      event.detail = lineOffset;
      event.text = line;
      event.alignment = alignment;
      event.indent = indent;
      event.justify = justify;
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(eventType, event);
    }
    return event;
  }
  public function sendModifyEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var accessible_1: Accessible = this.getAccessible__();
    if (Object(event.text).length__() == 0) {
      accessible_1.textChanged__III(1, event.start, event.end - event.start);
    } else {
      if (event.start == event.end) {
        accessible_1.textChanged__III(0, event.start, Object(event.text).length__());
      } else {
        accessible_1.textChanged__III(1, event.start, event.end - event.start);
        accessible_1.textChanged__III(0, event.start, Object(event.text).length__());
      }
    }
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(24, event);
    return;
  }
  public function sendSelectionEvent__(): void {
    this.getAccessible__().textSelectionChanged__();
    var event: Event = new Event();
    event.x = selection.x;
    event.y = selection.y;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, event);
    return;
  }
  public function sendTextEvent__IIILjava_lang_String_2Z(left: int, right: int, lineIndex: int, text: String, fillWithSpaces: Boolean): int {
    var lineWidth: int = 0;
    var start: int;
    var end: int;
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    if (lineIndex < content.getLineCount__()) {
      var trailing: JavaArray = new JavaArray("[I").lengths(1);
      start = this.getOffsetAtPoint__II_3IZ(left, this.getLinePixel__I(lineIndex), trailing, true);
      if (start == -1) {
        var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
        var lineLegth: int = Object(content.getLine__I(lineIndex)).length__();
        start = end = lineOffset + lineLegth;
        if (fillWithSpaces) {
          var layout_1: TextLayout = renderer.getTextLayout__I(lineIndex);
          lineWidth = layout_1.getBounds__().width;
          renderer.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout_1);
        }
      } else {
        start += trailing[0];
        end = left == right ? start : this.getOffsetAtPoint__III_3I(right, 0, lineIndex, null);
        fillWithSpaces = false;
      }
    } else {
      start = end = content.getCharCount__();
      buffer.append__Ljava_lang_String_2(content.getLineDelimiter__());
    }
    if (fillWithSpaces) {
      var spacesWidth: int = left - lineWidth + horizontalScrollOffset - leftMargin;
      var spacesCount: int = int(spacesWidth / renderer.averageCharWidth);
      for (var i: int = 0; i < spacesCount; i++) {
        buffer.append__C(32);
      }
    }
    buffer.append__Ljava_lang_String_2(text);
    var event: Event = new Event();
    event.start = start;
    event.end = end;
    event.text = buffer.toString__();
    this.sendKeyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    return event.start + Object(event.text).length__();
  }
  public function sendWordBoundaryEvent__IIIILjava_lang_String_2I(eventType: int, movement: int, offset: int, newOffset: int, lineText: String, lineOffset: int): int {
    if (this.isListening__I(eventType)) {
      var event: StyledTextEvent = new StyledTextEvent(content);
      event.detail = lineOffset;
      event.text = lineText;
      event.count = movement;
      event.start = offset;
      event.end = newOffset;
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(eventType, event);
      offset = event.end;
      if (offset != newOffset) {
        var length: int = this.getCharCount__();
        if (offset < 0) {
          offset = 0;
        } else if (offset > length) {
          offset = length;
        } else {
          if (this.isLineDelimiter__I(offset)) {
            SWT.error__I(5);
          }
        }
      }
      return offset;
    }
    return newOffset;
  }
  public function setAlignment__I(alignment_1: int): void {
    this.checkWidget__();
    alignment_1 &= (16384 | 131072 | 16777216);
    if (alignment_1 == 0 || this.alignment == alignment_1)
      return;
    this.alignment = alignment_1;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    background = color;
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public function setBlockSelection__Z(blockSelection_1: Boolean): void {
    this.checkWidget__();
    if ((this.getStyle__() & 4) != 0)
      return;
    if (blockSelection_1 == this.blockSelection)
      return;
    if (wordWrap)
      return;
    this.blockSelection = blockSelection_1;
    if (cursor === null) {
      var display_1: Display = this.getDisplay__();
      var type: int = blockSelection_1 ? 2 : 19;
      super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(display_1.getSystemCursor__I(type));
    }
    if (blockSelection_1) {
      var start: int = selection.x;
      var end: int = selection.y;
      if (start != end) {
        this.setBlockSelectionOffset__IIZ(start, end, false);
      }
    } else {
      this.clearBlockSelection__ZZ(false, false);
    }
    return;
  }
  public function setBlockSelectionLocation__IIZ(x_1: int, y_1: int, sendEvent: Boolean): void {
    var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
    blockXLocation = x_1 + horizontalScrollOffset;
    blockYLocation = y_1 + verticalScrollOffset_1;
    var alignment_1: JavaArray = new JavaArray("[I").lengths(1);
    var offset: int = this.getOffsetAtPoint__II_3I(x_1, y_1, alignment_1);
    this.setCaretOffset__II(offset, alignment_1[0]);
    if (blockXAnchor == -1) {
      blockXAnchor = blockXLocation;
      blockYAnchor = blockYLocation;
      selectionAnchor = caretOffset;
    }
    this.doBlockSelection__Z(sendEvent);
    return;
  }
  public function setBlockSelectionLocation__IIIIZ(anchorX: int, anchorY: int, x_1: int, y_1: int, sendEvent: Boolean): void {
    var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
    blockXAnchor = anchorX + horizontalScrollOffset;
    blockYAnchor = anchorY + verticalScrollOffset_1;
    selectionAnchor = this.getOffsetAtPoint__II_3I(anchorX, anchorY, null);
    this.setBlockSelectionLocation__IIZ(x_1, y_1, sendEvent);
    return;
  }
  public function setBlockSelectionOffset__IZ(offset: int, sendEvent: Boolean): void {
    var point: Point = this.getPointAtOffset__I(offset);
    var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
    blockXLocation = point.x + horizontalScrollOffset;
    blockYLocation = point.y + verticalScrollOffset_1;
    this.setCaretOffset__II(offset, -1);
    if (blockXAnchor == -1) {
      blockXAnchor = blockXLocation;
      blockYAnchor = blockYLocation;
      selectionAnchor = caretOffset;
    }
    this.doBlockSelection__Z(sendEvent);
    return;
  }
  public function setBlockSelectionOffset__IIZ(anchorOffset: int, offset: int, sendEvent: Boolean): void {
    var verticalScrollOffset_1: int = this.getVerticalScrollOffset__();
    var anchorPoint: Point = this.getPointAtOffset__I(anchorOffset);
    blockXAnchor = anchorPoint.x + horizontalScrollOffset;
    blockYAnchor = anchorPoint.y + verticalScrollOffset_1;
    selectionAnchor = anchorOffset;
    this.setBlockSelectionOffset__IZ(offset, sendEvent);
    return;
  }
  public override function setCaret__Lorg_eclipse_swt_widgets_Caret_2(caret_1: Caret): void {
    this.checkWidget__();
    super.setCaret__Lorg_eclipse_swt_widgets_Caret_2(caret_1);
    caretDirection = 0;
    if (caret_1 !== null) {
      this.setCaretLocation__();
    }
    return;
  }
  public function setBidiColoring__Z(mode: Boolean): void {
    this.checkWidget__();
    bidiColoring = mode;
    return;
  }
  public function setCaretLocation__(): void {
    var newCaretPos: Point = this.getPointAtOffset__I(caretOffset);
    this.setCaretLocation__Lorg_eclipse_swt_graphics_Point_2I(newCaretPos, this.getCaretDirection__());
    return;
  }
  public function setCaretLocation__Lorg_eclipse_swt_graphics_Point_2I(location: Point, direction: int): void {
    var caret_1: Caret = this.getCaret__();
    if (caret_1 !== null) {
      var isDefaultCaret: Boolean = caret_1 === defaultCaret;
      var lineHeight: int = renderer.getLineHeight__();
      var caretHeight: int = lineHeight;
      if (!this.isFixedLineHeight__() && isDefaultCaret) {
        caretHeight = this.getBoundsAtOffset__I(caretOffset).height;
        if (caretHeight != lineHeight) {
          direction = -1;
        }
      }
      var imageDirection: int = direction;
      if (this.isMirrored__()) {
        if (imageDirection == 16384) {
          imageDirection = 131072;
        } else if (imageDirection == 131072) {
          imageDirection = 16384;
        }
      }
      if (isDefaultCaret && imageDirection == 131072) {
        location.x -= (caret_1.getSize__().x - 1);
      }
      if (isDefaultCaret) {
        caret_1.setBounds__IIII(location.x, location.y, caretWidth, caretHeight);
      } else {
        caret_1.setLocation__Lorg_eclipse_swt_graphics_Point_2(location);
      }
      this.getAccessible__().textCaretMoved__I(this.getCaretOffset__());
      if (direction != caretDirection) {
        caretDirection = direction;
        if (isDefaultCaret) {
          if (imageDirection == -1) {
            defaultCaret.setImage__Lorg_eclipse_swt_graphics_Image_2(null);
          } else if (imageDirection == 16384) {
            defaultCaret.setImage__Lorg_eclipse_swt_graphics_Image_2(leftCaretBitmap);
          } else if (imageDirection == 131072) {
            defaultCaret.setImage__Lorg_eclipse_swt_graphics_Image_2(rightCaretBitmap);
          }
        }
        if (caretDirection == 16384) {
          BidiUtil.setKeyboardLanguage__I(0);
        } else if (caretDirection == 131072) {
          BidiUtil.setKeyboardLanguage__I(1);
        }
      }
    }
    columnX = location.x;
    return;
  }
  public function setCaretOffset__I(offset: int): void {
    this.checkWidget__();
    var length: int = this.getCharCount__();
    if (length > 0 && offset != caretOffset) {
      if (offset < 0) {
        offset = 0;
      } else if (offset > length) {
        offset = length;
      } else {
        if (this.isLineDelimiter__I(offset)) {
          SWT.error__I(5);
        }
      }
      this.setCaretOffset__II(offset, 0);
      if (blockSelection) {
        this.clearBlockSelection__ZZ(true, false);
      } else {
        this.clearSelection__Z(false);
      }
    }
    this.setCaretLocation__();
    return;
  }
  public function setCaretOffset__II(offset: int, alignment_1: int): void {
    if (caretOffset != offset) {
      caretOffset = offset;
      if (this.isListening__I(3011)) {
        var event: StyledTextEvent = new StyledTextEvent(content);
        event.end = caretOffset;
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3011, event);
      }
    }
    if (alignment_1 != -1) {
      caretAlignment = alignment_1;
    }
    return;
  }
  public function setClipboardContent__III(start: int, length: int, clipboardType: int): void {
    if (clipboardType == 2 && !(IS_MOTIF || IS_GTK))
      return;
    var plainTextTransfer: TextTransfer = TextTransfer.getInstance__();
    var plainTextWriter: StyledText$TextWriter = new StyledText$TextWriter(this, start, length);
    var plainText: String = this.getPlatformDelimitedText__Lorg_eclipse_swt_custom_StyledText$TextWriter_2(plainTextWriter);
    var data_1: JavaArray;
    var types: JavaArray;
    if (clipboardType == 2) {
      data_1 = new JavaArray("[Ljava/lang/Object;").values(plainText);
      types = new JavaArray("[Lorg/eclipse/swt/dnd/Transfer;").values(plainTextTransfer);
    } else {
      var rtfTransfer: RTFTransfer = RTFTransfer.getInstance__();
      var rtfWriter: StyledText$RTFWriter = new StyledText$RTFWriter(this, start, length);
      var rtfText: String = this.getPlatformDelimitedText__Lorg_eclipse_swt_custom_StyledText$TextWriter_2(rtfWriter);
      data_1 = new JavaArray("[Ljava/lang/Object;").values(rtfText, plainText);
      types = new JavaArray("[Lorg/eclipse/swt/dnd/Transfer;").values(rtfTransfer, plainTextTransfer);
    }
    clipboard.setContents___3Ljava_lang_Object_2_3Lorg_eclipse_swt_dnd_Transfer_2I(data_1, types, clipboardType);
    return;
  }
  public function setContent__Lorg_eclipse_swt_custom_StyledTextContent_2(newContent: StyledTextContent): void {
    this.checkWidget__();
    if (newContent === null) {
      SWT.error__I(4);
    }
    if (content !== null) {
      content.removeTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(textChangeListener);
    }
    content = newContent;
    content.addTextChangeListener__Lorg_eclipse_swt_custom_TextChangeListener_2(textChangeListener);
    this.reset__();
    return;
  }
  public override function setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1: Cursor): void {
    this.checkWidget__();
    if (cursor_1 !== null && cursor_1.isDisposed__())
      SWT.error__I(5);
    this.cursor = cursor_1;
    if (cursor_1 === null) {
      var display_1: Display = this.getDisplay__();
      var type: int = blockSelection ? 2 : 19;
      super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(display_1.getSystemCursor__I(type));
    } else {
      super.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1);
    }
    return;
  }
  public function setDoubleClickEnabled__Z(enable: Boolean): void {
    this.checkWidget__();
    doubleClickEnabled = enable;
    return;
  }
  public override function setDragDetect__Z(dragDetect_1: Boolean): void {
    this.checkWidget__();
    this.dragDetect = dragDetect_1;
    return;
  }
  public function setEditable__Z(editable_1: Boolean): void {
    this.checkWidget__();
    this.editable = editable_1;
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    var oldLineHeight: int = renderer.getLineHeight__();
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    renderer.setFont__Lorg_eclipse_swt_graphics_Font_2I(this.getFont__(), tabLength);
    if (this.isFixedLineHeight__()) {
      var lineHeight: int = renderer.getLineHeight__();
      if (lineHeight != oldLineHeight) {
        var vscroll: int = (int(this.getVerticalScrollOffset__() * lineHeight / oldLineHeight)) - this.getVerticalScrollOffset__();
        this.scrollVertical__IZ(vscroll, true);
      }
    }
    this.resetCache__II(0, content.getLineCount__());
    this.claimBottomFreeSpace__();
    this.calculateScrollBars__();
    if (this.isBidiCaret__())
      this.createCaretBitmaps__();
    caretDirection = 0;
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    foreground = color;
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getForeground__());
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public function setHorizontalIndex__I(offset: int): void {
    this.checkWidget__();
    if (this.getCharCount__() == 0) {
      return;
    }
    if (offset < 0) {
      offset = 0;
    }
    offset *= this.getHorizontalIncrement__();
    if (clientAreaWidth > 0) {
      var width_1: int = renderer.getWidth__();
      if (offset > width_1 - clientAreaWidth) {
        offset = Math__.max__II(0, width_1 - clientAreaWidth);
      }
    }
    this.scrollHorizontal__IZ(offset - horizontalScrollOffset, true);
    return;
  }
  public function setHorizontalPixel__I(pixel: int): void {
    this.checkWidget__();
    if (this.getCharCount__() == 0) {
      return;
    }
    if (pixel < 0) {
      pixel = 0;
    }
    if (clientAreaWidth > 0) {
      var width_1: int = renderer.getWidth__();
      if (pixel > width_1 - clientAreaWidth) {
        pixel = Math__.max__II(0, width_1 - clientAreaWidth);
      }
    }
    this.scrollHorizontal__IZ(pixel - horizontalScrollOffset, true);
    return;
  }
  public function setIndent__I(indent_1: int): void {
    this.checkWidget__();
    if (this.indent == indent_1 || indent_1 < 0)
      return;
    this.indent = indent_1;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public function setJustify__Z(justify_1: Boolean): void {
    this.checkWidget__();
    if (this.justify == justify_1)
      return;
    this.justify = justify_1;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public function setKeyBinding__II(key: int, action: int): void {
    this.checkWidget__();
    var modifierValue: int = key & SWT.MODIFIER_MASK;
    var keyChar: uint = uint((key & 16842751));
    if (Compatibility.isLetter__C(keyChar)) {
      var ch: uint = Character.toUpperCase__C(keyChar);
      var newKey: int = ch | modifierValue;
      if (action == 0) {
        keyActionMap.remove__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [newKey])));
      } else {
        keyActionMap.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [newKey])), new Integer(new Arguments(java.lang.Integer.Integer__I, [action])));
      }
      ch = Character.toLowerCase__C(keyChar);
      newKey = ch | modifierValue;
      if (action == 0) {
        keyActionMap.remove__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [newKey])));
      } else {
        keyActionMap.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [newKey])), new Integer(new Arguments(java.lang.Integer.Integer__I, [action])));
      }
    } else {
      if (action == 0) {
        keyActionMap.remove__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [key])));
      } else {
        keyActionMap.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [key])), new Integer(new Arguments(java.lang.Integer.Integer__I, [action])));
      }
    }
    return;
  }
  public function setLineAlignment__III(startLine: int, lineCount: int, alignment_1: int): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (startLine < 0 || startLine + lineCount > content.getLineCount__()) {
      SWT.error__I(5);
    }
    renderer.setLineAlignment__III(startLine, lineCount, alignment_1);
    this.resetCache__II(startLine, lineCount);
    this.redrawLines__II(startLine, lineCount);
    var caretLine: int = this.getCaretLine__();
    if (startLine <= caretLine && caretLine < startLine + lineCount) {
      this.setCaretLocation__();
    }
    return;
  }
  public function setLineBackground__IILorg_eclipse_swt_graphics_Color_2(startLine: int, lineCount: int, background_1: Color): void {
    this.checkWidget__();
    if (this.isListening__I(3001))
      return;
    if (startLine < 0 || startLine + lineCount > content.getLineCount__()) {
      SWT.error__I(5);
    }
    if (background_1 !== null) {
      renderer.setLineBackground__IILorg_eclipse_swt_graphics_Color_2(startLine, lineCount, background_1);
    } else {
      renderer.clearLineBackground__II(startLine, lineCount);
    }
    this.redrawLines__II(startLine, lineCount);
    return;
  }
  public function setLineBullet__IILorg_eclipse_swt_custom_Bullet_2(startLine: int, lineCount: int, bullet: Bullet): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (startLine < 0 || startLine + lineCount > content.getLineCount__()) {
      SWT.error__I(5);
    }
    renderer.setLineBullet__IILorg_eclipse_swt_custom_Bullet_2(startLine, lineCount, bullet);
    this.resetCache__II(startLine, lineCount);
    this.redrawLines__II(startLine, lineCount);
    var caretLine: int = this.getCaretLine__();
    if (startLine <= caretLine && caretLine < startLine + lineCount) {
      this.setCaretLocation__();
    }
    return;
  }
  public function setVariableLineHeight__(): void {
    if (!fixedLineHeight)
      return;
    fixedLineHeight = false;
    renderer.calculateIdle__();
  }
  public function setLineIndent__III(startLine: int, lineCount: int, indent_1: int): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (startLine < 0 || startLine + lineCount > content.getLineCount__()) {
      SWT.error__I(5);
    }
    renderer.setLineIndent__III(startLine, lineCount, indent_1);
    this.resetCache__II(startLine, lineCount);
    this.redrawLines__II(startLine, lineCount);
    var caretLine: int = this.getCaretLine__();
    if (startLine <= caretLine && caretLine < startLine + lineCount) {
      this.setCaretLocation__();
    }
    return;
  }
  public function setLineJustify__IIZ(startLine: int, lineCount: int, justify_1: Boolean): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (startLine < 0 || startLine + lineCount > content.getLineCount__()) {
      SWT.error__I(5);
    }
    renderer.setLineJustify__IIZ(startLine, lineCount, justify_1);
    this.resetCache__II(startLine, lineCount);
    this.redrawLines__II(startLine, lineCount);
    var caretLine: int = this.getCaretLine__();
    if (startLine <= caretLine && caretLine < startLine + lineCount) {
      this.setCaretLocation__();
    }
    return;
  }
  public function setLineSpacing__I(lineSpacing_1: int): void {
    this.checkWidget__();
    if (this.lineSpacing == lineSpacing_1 || lineSpacing_1 < 0)
      return;
    this.lineSpacing = lineSpacing_1;
    this.setVariableLineHeight__();
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public function setMargins__IIII(leftMargin_1: int, topMargin_1: int, rightMargin_1: int, bottomMargin_1: int): void {
    this.checkWidget__();
    this.leftMargin = leftMargin_1;
    this.topMargin = topMargin_1;
    this.rightMargin = rightMargin_1;
    this.bottomMargin = bottomMargin_1;
    this.setCaretLocation__();
  }
  public function setMouseWordSelectionAnchor__(): void {
    if (clickCount > 1) {
      if (caretOffset < doubleClickSelection.x) {
        selectionAnchor = doubleClickSelection.y;
      } else if (caretOffset > doubleClickSelection.y) {
        selectionAnchor = doubleClickSelection.x;
      }
    }
    return;
  }
  public function setOrientation__I(orientation: int): void {
    if ((orientation & (67108864 | 33554432)) == 0) {
      return;
    }
    if ((orientation & 67108864) != 0 && (orientation & 33554432) != 0) {
      return;
    }
    if ((orientation & 67108864) != 0 && this.isMirrored__()) {
      return;
    }
    if ((orientation & 33554432) != 0 && !this.isMirrored__()) {
      return;
    }
    if (!BidiUtil.setOrientation__Lorg_eclipse_swt_widgets_Control_2I(this, orientation)) {
      return;
    }
    isMirrored = (orientation & 67108864) != 0;
    caretDirection = 0;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    keyActionMap.clear__();
    this.createKeyBindings__();
    super.redraw__();
    return;
  }
  public function setScrollBars__Z(vertical: Boolean): void {
    var inactive: int = 1;
    if (vertical || !this.isFixedLineHeight__()) {
      var verticalBar_1: ScrollBar = this.getVerticalBar__();
      if (verticalBar_1 !== null) {
        var maximum: int = renderer.getHeight__();
        if (clientAreaHeight < maximum) {
          verticalBar_1.setMaximum__I(maximum);
          verticalBar_1.setThumb__I(clientAreaHeight);
          verticalBar_1.setPageIncrement__I(clientAreaHeight);
        } else if (verticalBar_1.getThumb__() != inactive || verticalBar_1.getMaximum__() != inactive) {
          verticalBar_1.setValues__IIIIII(verticalBar_1.getSelection__(), verticalBar_1.getMinimum__(), inactive, inactive, verticalBar_1.getIncrement__(), inactive);
        }
      }
    }
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    if (horizontalBar_1 !== null && horizontalBar_1.getVisible__()) {
      var maximum_1: int = renderer.getWidth__();
      if (clientAreaWidth < maximum_1) {
        horizontalBar_1.setMaximum__I(maximum_1);
        horizontalBar_1.setThumb__I(clientAreaWidth - leftMargin - rightMargin);
        horizontalBar_1.setPageIncrement__I(clientAreaWidth - leftMargin - rightMargin);
      } else if (horizontalBar_1.getThumb__() != inactive || horizontalBar_1.getMaximum__() != inactive) {
        horizontalBar_1.setValues__IIIIII(horizontalBar_1.getSelection__(), horizontalBar_1.getMinimum__(), inactive, inactive, horizontalBar_1.getIncrement__(), inactive);
      }
    }
    return;
  }
  public function setSelection__I(start: int): void {
    this.setSelection__II(start, start);
    return;
  }
  public function setSelection__Lorg_eclipse_swt_graphics_Point_2(point: Point): void {
    this.checkWidget__();
    if (point === null)
      SWT.error__I(4);
    this.setSelection__II(point.x, point.y);
    return;
  }
  public function setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null) {
      if (color.isDisposed__())
        SWT.error__I(5);
    }
    selectionBackground = color;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public function setSelectionForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null) {
      if (color.isDisposed__())
        SWT.error__I(5);
    }
    selectionForeground = color;
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public function setSelection__II(start: int, end: int): void {
    this.setSelectionRange__II(start, end - start);
    this.showSelection__();
    return;
  }
  public function setSelection__IIZZ(start: int, length: int, sendEvent: Boolean, doBlock: Boolean): void {
    var end: int = start + length;
    if (start > end) {
      var temp: int = end;
      end = start;
      start = temp;
    }
    if (selection.x != start || selection.y != end || (length > 0 && selectionAnchor != selection.x) || (length < 0 && selectionAnchor != selection.y)) {
      if (blockSelection && doBlock) {
        this.setBlockSelectionOffset__IIZ(start, end, sendEvent);
      } else {
        this.clearSelection__Z(sendEvent);
        if (length < 0) {
          selectionAnchor = selection.y = end;
          selection.x = start;
          this.setCaretOffset__II(start, 0);
        } else {
          selectionAnchor = selection.x = start;
          selection.y = end;
          this.setCaretOffset__II(end, 0);
        }
        this.internalRedrawRange__II(selection.x, selection.y - selection.x);
      }
    }
    return;
  }
  public function setSelectionRange__II(start: int, length: int): void {
    this.checkWidget__();
    var contentLength: int = this.getCharCount__();
    start = Math__.max__II(0, Math__.min__II(start, contentLength));
    var end: int = start + length;
    if (end < 0) {
      length = -start;
    } else {
      if (end > contentLength)
        length = contentLength - start;
    }
    if (this.isLineDelimiter__I(start) || this.isLineDelimiter__I(start + length)) {
      SWT.error__I(5);
    }
    this.setSelection__IIZZ(start, length, false, true);
    this.setCaretLocation__();
    return;
  }
  public function setStyleRange__Lorg_eclipse_swt_custom_StyleRange_2(range: StyleRange): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (range !== null) {
      if (range.isUnstyled__()) {
        this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(range.start, range.length, null, null, false);
      } else {
        this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(range.start, 0, null, new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").values(range), false);
      }
    } else {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(0, 0, null, null, true);
    }
    return;
  }
  public function setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2(start: int, length: int, ranges: JavaArray, styles: JavaArray): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (ranges === null || styles === null) {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(start, length, null, null, false);
    } else {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(start, length, ranges, styles, false);
    }
    return;
  }
  public function setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(ranges: JavaArray, styles: JavaArray): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (ranges === null || styles === null) {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(0, 0, null, null, true);
    } else {
      this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(0, 0, ranges, styles, true);
    }
    return;
  }
  public function setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(start: int, length: int, ranges: JavaArray, styles: JavaArray, reset: Boolean): void {
    var charCount: int = content.getCharCount__();
    var end: int = start + length;
    if (start > end || start < 0) {
      SWT.error__I(6);
    }
    if (styles !== null) {
      if (end > charCount) {
        SWT.error__I(6);
      }
      if (ranges !== null) {
        if (ranges.length != styles.length << 1)
          SWT.error__I(5);
      }
      var lastOffset: int = 0;
      var variableHeight: Boolean = false;
      for (var i: int = 0; i < styles.length; i++) {
        if (styles[i] === null)
          SWT.error__I(5);
        var rangeStart: int;
        var rangeLength: int;
        if (ranges !== null) {
          rangeStart = ranges[i << 1];
          rangeLength = ranges[(i << 1) + 1];
        } else {
          rangeStart = styles[i].start;
          rangeLength = styles[i].length;
        }
        if (rangeLength < 0)
          SWT.error__I(5);
        if (!(0 <= rangeStart && rangeStart + rangeLength <= charCount))
          SWT.error__I(5);
        if (lastOffset > rangeStart)
          SWT.error__I(5);
        variableHeight = (variableHeight) ? (styles[i].isVariableHeight__(), true) : (styles[i].isVariableHeight__());
        lastOffset = rangeStart + rangeLength;
      }
      if (variableHeight)
        this.setVariableLineHeight__();
    }
    var rangeStart_1: int = start;
    var rangeEnd: int = end;
    if (styles !== null && styles.length > 0) {
      if (ranges !== null) {
        rangeStart_1 = ranges[0];
        rangeEnd = ranges[ranges.length - 2] + ranges[ranges.length - 1];
      } else {
        rangeStart_1 = styles[0].start;
        rangeEnd = styles[styles.length - 1].start + styles[styles.length - 1].length;
      }
    }
    var expectedBottom: int = 0;
    if (!this.isFixedLineHeight__() && !reset) {
      var lineEnd: int = content.getLineAtOffset__I(Math__.max__II(end, rangeEnd));
      var partialTopIndex: int = this.getPartialTopIndex__();
      var partialBottomIndex: int = this.getPartialBottomIndex__();
      if (partialTopIndex <= lineEnd && lineEnd <= partialBottomIndex) {
        expectedBottom = this.getLinePixel__I(lineEnd + 1);
      }
    }
    if (reset) {
      renderer.setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(null, null);
    } else {
      renderer.updateRanges__III(start, length, length);
    }
    if (styles !== null && styles.length > 0) {
      renderer.setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(ranges, styles);
    }
    if (reset) {
      this.resetCache__II(0, content.getLineCount__());
      super.redraw__();
    } else {
      var lineStart: int = content.getLineAtOffset__I(Math__.min__II(start, rangeStart_1));
      var lineEnd_1: int = content.getLineAtOffset__I(Math__.max__II(end, rangeEnd));
      this.resetCache__II(lineStart, lineEnd_1 - lineStart + 1);
      var partialTopIndex_1: int = this.getPartialTopIndex__();
      var partialBottomIndex_1: int = this.getPartialBottomIndex__();
      if (!(lineStart > partialBottomIndex_1 || lineEnd_1 < partialTopIndex_1)) {
        var top: int = 0;
        var bottom: int = clientAreaHeight;
        if (partialTopIndex_1 <= lineStart && lineStart <= partialBottomIndex_1) {
          top = Math__.max__II(0, this.getLinePixel__I(lineStart));
        }
        if (partialTopIndex_1 <= lineEnd_1 && lineEnd_1 <= partialBottomIndex_1) {
          bottom = this.getLinePixel__I(lineEnd_1 + 1);
        }
        if (!this.isFixedLineHeight__() && bottom != expectedBottom) {
          bottom = clientAreaHeight;
        }
        super.redraw__IIIIZ(0, top, clientAreaWidth, bottom - top, false);
      }
    }
    this.setCaretLocation__();
    this.doMouseLinkCursor__();
    return;
  }
  public function setStyleRanges___3Lorg_eclipse_swt_custom_StyleRange_2(ranges: JavaArray): void {
    this.checkWidget__();
    if (this.isListening__I(3002))
      return;
    if (ranges === null)
      SWT.error__I(4);
    this.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2Z(0, 0, null, ranges, true);
  }
  public function setTabs__I(tabs: int): void {
    this.checkWidget__();
    tabLength = tabs;
    renderer.setFont__Lorg_eclipse_swt_graphics_Font_2I(null, tabs);
    this.resetCache__II(0, content.getLineCount__());
    this.setCaretLocation__();
    super.redraw__();
  }
  public function setText__Ljava_lang_String_2(text: String): void {
    this.checkWidget__();
    if (text === null) {
      SWT.error__I(4);
    }
    var event: Event = new Event();
    event.start = 0;
    event.end = this.getCharCount__();
    event.text = text;
    event.doit = true;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(25, event);
    if (event.doit) {
      var styledTextEvent: StyledTextEvent = null;
      if (this.isListening__I(3000)) {
        styledTextEvent = new StyledTextEvent(content);
        styledTextEvent.start = event.start;
        styledTextEvent.end = event.start + Object(event.text).length__();
        styledTextEvent.text = content.getTextRange__II(event.start, event.end - event.start);
      }
      content.setText__Ljava_lang_String_2(event.text);
      this.sendModifyEvent__Lorg_eclipse_swt_widgets_Event_2(event);
      if (styledTextEvent !== null) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(3000, styledTextEvent);
      }
    }
    return;
  }
  public function setTextLimit__I(limit: int): void {
    this.checkWidget__();
    if (limit == 0) {
      SWT.error__I(7);
    }
    textLimit = limit;
    return;
  }
  public function setTopIndex__I(topIndex_1: int): void {
    this.checkWidget__();
    if (this.getCharCount__() == 0) {
      return;
    }
    var lineCount: int = content.getLineCount__();
    var pixel: int;
    if (this.isFixedLineHeight__()) {
      var pageSize: int = Math__.max__II(1, Math__.min__II(lineCount, this.getLineCountWhole__()));
      if (topIndex_1 < 0) {
        topIndex_1 = 0;
      } else if (topIndex_1 > lineCount - pageSize) {
        topIndex_1 = lineCount - pageSize;
      }
      pixel = this.getLinePixel__I(topIndex_1);
    } else {
      topIndex_1 = Math__.max__II(0, Math__.min__II(lineCount - 1, topIndex_1));
      pixel = this.getLinePixel__I(topIndex_1);
      if (pixel > 0) {
        pixel = this.getAvailableHeightBellow__I(pixel);
      } else {
        pixel = this.getAvailableHeightAbove__I(pixel);
      }
    }
    this.scrollVertical__IZ(pixel, true);
    return;
  }
  public function setTopPixel__I(pixel: int): void {
    this.checkWidget__();
    if (this.getCharCount__() == 0) {
      return;
    }
    if (pixel < 0)
      pixel = 0;
    var lineCount: int = content.getLineCount__();
    var height_1: int = clientAreaHeight - topMargin - bottomMargin;
    var verticalOffset: int = this.getVerticalScrollOffset__();
    if (this.isFixedLineHeight__()) {
      var maxTopPixel: int = Math__.max__II(0, lineCount * this.getVerticalIncrement__() - height_1);
      if (pixel > maxTopPixel)
        pixel = maxTopPixel;
      pixel -= verticalOffset;
    } else {
      pixel -= verticalOffset;
      if (pixel > 0) {
        pixel = this.getAvailableHeightBellow__I(pixel);
      }
    }
    this.scrollVertical__IZ(pixel, true);
    return;
  }
  public function setWordWrap__Z(wrap: Boolean): void {
    this.checkWidget__();
    if ((this.getStyle__() & 4) != 0)
      return;
    if (wordWrap == wrap)
      return;
    if (wordWrap && blockSelection)
      this.setBlockSelection__Z(false);
    wordWrap = wrap;
    this.setVariableLineHeight__();
    this.resetCache__II(0, content.getLineCount__());
    horizontalScrollOffset = 0;
    var horizontalBar_1: ScrollBar = this.getHorizontalBar__();
    if (horizontalBar_1 !== null) {
      horizontalBar_1.setVisible__Z(!wordWrap);
    }
    this.setScrollBars__Z(true);
    this.setCaretLocation__();
    super.redraw__();
    return;
  }
  public function showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(rect: Rectangle, scrollPage: Boolean): Boolean {
    var clientAreaWidth_1: int = this.clientAreaWidth - leftMargin - rightMargin;
    var clientAreaHeight_1: int = this.clientAreaHeight - topMargin - bottomMargin;
    var scrolled: Boolean = false;
    if (rect.y <= topMargin) {
      scrolled = this.scrollVertical__IZ(rect.y - topMargin, true);
    } else if (rect.y + rect.height > clientAreaHeight_1) {
      if (clientAreaHeight_1 == 0) {
        scrolled = this.scrollVertical__IZ(rect.y, true);
      } else {
        scrolled = this.scrollVertical__IZ(rect.y + rect.height - clientAreaHeight_1, true);
      }
    }
    if (clientAreaWidth_1 > 0) {
      var minScroll: int = scrollPage ? int(clientAreaWidth_1 / 4) : 0;
      if (rect.x < leftMargin) {
        var scrollWidth: int = Math__.max__II(leftMargin - rect.x, minScroll);
        var maxScroll: int = horizontalScrollOffset;
        scrolled = this.scrollHorizontal__IZ(-Math__.min__II(maxScroll, scrollWidth), true);
      } else if (rect.x + rect.width > clientAreaWidth_1) {
        var scrollWidth_1: int = Math__.max__II(rect.x + rect.width - clientAreaWidth_1, minScroll);
        var maxScroll_1: int = renderer.getWidth__() - horizontalScrollOffset - this.clientAreaWidth;
        scrolled = this.scrollHorizontal__IZ(Math__.min__II(maxScroll_1, scrollWidth_1), true);
      }
    }
    return scrolled;
  }
  public function showCaret__(): void {
    var bounds: Rectangle = this.getBoundsAtOffset__I(caretOffset);
    if (!this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(bounds, true)) {
      this.setCaretLocation__();
    }
    return;
  }
  public function showSelection__(): void {
    this.checkWidget__();
    var rightToLeft: Boolean = caretOffset == selection.x;
    var startOffset: int;
    var endOffset: int;
    if (rightToLeft) {
      startOffset = selection.y;
      endOffset = selection.x;
    } else {
      startOffset = selection.x;
      endOffset = selection.y;
    }
    var startBounds: Rectangle = this.getBoundsAtOffset__I(startOffset);
    var endBounds: Rectangle = this.getBoundsAtOffset__I(endOffset);
    var w: int = clientAreaWidth - leftMargin - rightMargin;
    var selectionFits: Boolean = rightToLeft ? startBounds.x - endBounds.x <= w : endBounds.x - startBounds.x <= w;
    if (selectionFits) {
      if (this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(startBounds, false)) {
        endBounds = this.getBoundsAtOffset__I(endOffset);
      }
      endBounds.width = endOffset == caretOffset ? this.getCaretWidth__() : 0;
      this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(endBounds, false);
    } else {
      this.showLocation__Lorg_eclipse_swt_graphics_Rectangle_2Z(endBounds, true);
    }
    return;
  }
  public function updateSelection__III(startOffset: int, replacedLength: int, newLength: int): void {
    if (selection.y <= startOffset) {
      if (wordWrap)
        this.setCaretLocation__();
      return;
    }
    if (selection.x < startOffset) {
      this.internalRedrawRange__II(selection.x, startOffset - selection.x);
    }
    if (selection.y > startOffset + replacedLength && selection.x < startOffset + replacedLength) {
      var netNewLength: int = newLength - replacedLength;
      var redrawStart: int = startOffset + newLength;
      this.internalRedrawRange__II(redrawStart, selection.y + netNewLength - redrawStart);
    }
    if (selection.y > startOffset && selection.x < startOffset + replacedLength) {
      this.setSelection__IIZZ(startOffset + newLength, 0, true, false);
    } else {
      this.setSelection__IIZZ(selection.x + newLength - replacedLength, selection.y - selection.x, true, false);
    }
    this.setCaretLocation__();
    return;
  }
}
}
