package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DND;
import java.lang.System;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.FontMetrics;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledTextDropTargetEffect extends DropTargetEffect {
  public static const CARET_WIDTH: int = 2;
  public static const SCROLL_HYSTERESIS: int = 100;
  public static const SCROLL_TOLERANCE: int = 20;
  internal var currentOffset: int = -1;
  internal var scrollBeginTime: Number = 0;
  internal var scrollX: int = -1;
  internal var scrollY: int = -1;
  internal var paintListener: Listener;
  public function StyledTextDropTargetEffect(styledText: StyledText) {
    super(styledText);
    paintListener = new org.eclipse.swt.custom.StyledTextDropTargetEffect$1(this);
    return;
  }
  public override function dragEnter__Lorg_eclipse_swt_dnd_DropTargetEvent_2(event: DropTargetEvent): void {
    currentOffset = -1;
    scrollBeginTime = 0;
    scrollX = -1;
    scrollY = -1;
    this.getControl__().removeListener__ILorg_eclipse_swt_widgets_Listener_2(9, paintListener);
    this.getControl__().addListener__ILorg_eclipse_swt_widgets_Listener_2(9, paintListener);
    return;
  }
  public override function dragLeave__Lorg_eclipse_swt_dnd_DropTargetEvent_2(event: DropTargetEvent): void {
    var text: StyledText = StyledText(this.getControl__());
    if (currentOffset != -1) {
      this.refreshCaret__Lorg_eclipse_swt_custom_StyledText_2II(text, currentOffset, -1);
    }
    text.removeListener__ILorg_eclipse_swt_widgets_Listener_2(9, paintListener);
    scrollBeginTime = 0;
    scrollX = -1;
    scrollY = -1;
    return;
  }
  public override function dragOver__Lorg_eclipse_swt_dnd_DropTargetEvent_2(event: DropTargetEvent): void {
    var effect: int = event.feedback;
    var text: StyledText = StyledText(this.getControl__());
    var pt: Point = text.getDisplay__().map__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_Control_2II(null, text, event.x, event.y);
    if ((effect & 8) == 0) {
      scrollBeginTime = 0;
      scrollX = scrollY = -1;
    } else {
      if (text.getCharCount__() == 0) {
        scrollBeginTime = 0;
        scrollX = scrollY = -1;
      } else {
        if (scrollX != -1 && scrollY != -1 && scrollBeginTime != 0 && (pt.x >= scrollX && pt.x <= (scrollX + 20) || pt.y >= scrollY && pt.y <= (scrollY + 20))) {
          if (System.currentTimeMillis__() >= scrollBeginTime) {
            var area: Rectangle = text.getClientArea__();
            var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [text]));
            var fm: FontMetrics = gc.getFontMetrics__();
            gc.dispose__();
            var charWidth: int = fm.getAverageCharWidth__();
            var scrollAmount: int = 10 * charWidth;
            if (pt.x < area.x + 3 * charWidth) {
              var leftPixel: int = text.getHorizontalPixel__();
              text.setHorizontalPixel__I(leftPixel - scrollAmount);
            }
            if (pt.x > area.width - 3 * charWidth) {
              var leftPixel_1: int = text.getHorizontalPixel__();
              text.setHorizontalPixel__I(leftPixel_1 + scrollAmount);
            }
            var lineHeight: int = text.getLineHeight__();
            if (pt.y < area.y + lineHeight) {
              var topPixel: int = text.getTopPixel__();
              text.setTopPixel__I(topPixel - lineHeight);
            }
            if (pt.y > area.height - lineHeight) {
              var topPixel_1: int = text.getTopPixel__();
              text.setTopPixel__I(topPixel_1 + lineHeight);
            }
            scrollBeginTime = 0;
            scrollX = scrollY = -1;
          }
        } else {
          scrollBeginTime = System.currentTimeMillis__() + 100;
          scrollX = pt.x;
          scrollY = pt.y;
        }
      }
    }
    if ((effect & 1) != 0) {
      var trailing: JavaArray = new JavaArray("[I").lengths(1);
      var newOffset: int = text.getOffsetAtPoint__II_3IZ(pt.x, pt.y, trailing, false);
      newOffset += trailing[0];
      if (newOffset != currentOffset) {
        this.refreshCaret__Lorg_eclipse_swt_custom_StyledText_2II(text, currentOffset, newOffset);
        currentOffset = newOffset;
      }
    }
    return;
  }
  public function refreshCaret__Lorg_eclipse_swt_custom_StyledText_2II(text: StyledText, oldOffset: int, newOffset: int): void {
    if (oldOffset != newOffset) {
      if (oldOffset != -1) {
        var oldPos: Point = text.getLocationAtOffset__I(oldOffset);
        var oldHeight: int = text.getLineHeight__I(oldOffset);
        text.redraw__IIIIZ(oldPos.x, oldPos.y, 2, oldHeight, false);
      }
      if (newOffset != -1) {
        var newPos: Point = text.getLocationAtOffset__I(newOffset);
        var newHeight: int = text.getLineHeight__I(newOffset);
        text.redraw__IIIIZ(newPos.x, newPos.y, 2, newHeight, false);
      }
    }
    return;
  }
  public override function dropAccept__Lorg_eclipse_swt_dnd_DropTargetEvent_2(event: DropTargetEvent): void {
    if (currentOffset != -1) {
      var text: StyledText = StyledText(this.getControl__());
      text.setSelection__I(currentOffset);
      currentOffset = -1;
    }
    return;
  }
}
}
