package org.eclipse.swt.custom {
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.events.VerifyEvent;
import java.lang.Arguments;
dynamic public class StyledTextListener extends TypedListener {
  function StyledTextListener(listener: SWTEventListener) {
    super(listener);
    return;
  }
  public override function handleEvent__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    switch (e.type) {
      case 3000 :
        var extendedModifyEvent: ExtendedModifyEvent = new ExtendedModifyEvent(StyledTextEvent(e));
        (ExtendedModifyListener(eventListener)).modifyText__Lorg_eclipse_swt_custom_ExtendedModifyEvent_2(extendedModifyEvent);
        break;
      case 3001 :
        var lineBgEvent: LineBackgroundEvent = new LineBackgroundEvent(StyledTextEvent(e));
        (LineBackgroundListener(eventListener)).lineGetBackground__Lorg_eclipse_swt_custom_LineBackgroundEvent_2(lineBgEvent);
        (StyledTextEvent(e)).lineBackground = lineBgEvent.lineBackground;
        break;
      case 3007 :
        var segmentEvent: BidiSegmentEvent = new BidiSegmentEvent(StyledTextEvent(e));
        (BidiSegmentListener(eventListener)).lineGetSegments__Lorg_eclipse_swt_custom_BidiSegmentEvent_2(segmentEvent);
        (StyledTextEvent(e)).segments = segmentEvent.segments;
        break;
      case 3002 :
        var lineStyleEvent: LineStyleEvent = new LineStyleEvent(StyledTextEvent(e));
        (LineStyleListener(eventListener)).lineGetStyle__Lorg_eclipse_swt_custom_LineStyleEvent_2(lineStyleEvent);
        (StyledTextEvent(e)).ranges = lineStyleEvent.ranges;
        (StyledTextEvent(e)).styles = lineStyleEvent.styles;
        (StyledTextEvent(e)).alignment = lineStyleEvent.alignment;
        (StyledTextEvent(e)).indent = lineStyleEvent.indent;
        (StyledTextEvent(e)).justify = lineStyleEvent.justify;
        (StyledTextEvent(e)).bullet = lineStyleEvent.bullet;
        (StyledTextEvent(e)).bulletIndex = lineStyleEvent.bulletIndex;
        break;
      case 3008 :
        var paintObjectEvent: PaintObjectEvent = new PaintObjectEvent(StyledTextEvent(e));
        (PaintObjectListener(eventListener)).paintObject__Lorg_eclipse_swt_custom_PaintObjectEvent_2(paintObjectEvent);
        break;
      case 3005 :
        var verifyEvent: VerifyEvent = new VerifyEvent(e);
        (VerifyKeyListener(eventListener)).verifyKey__Lorg_eclipse_swt_events_VerifyEvent_2(verifyEvent);
        e.doit = verifyEvent.doit;
        break;
      case 3006 :
        {
          var textChangedEvent: TextChangedEvent = new TextChangedEvent(StyledTextContent(e.data));
          (TextChangeListener(eventListener)).textChanged__Lorg_eclipse_swt_custom_TextChangedEvent_2(textChangedEvent);
          break;
        }
      case 3003 :
        var textChangingEvent: TextChangingEvent = new TextChangingEvent(new Arguments(org.eclipse.swt.custom.TextChangingEvent.TextChangingEvent__Lorg_eclipse_swt_custom_StyledTextContent_2Lorg_eclipse_swt_custom_StyledTextEvent_2, [StyledTextContent(e.data), StyledTextEvent(e)]));
        (TextChangeListener(eventListener)).textChanging__Lorg_eclipse_swt_custom_TextChangingEvent_2(textChangingEvent);
        break;
      case 3004 :
        {
          var textChangedEvent_1: TextChangedEvent = new TextChangedEvent(StyledTextContent(e.data));
          (TextChangeListener(eventListener)).textSet__Lorg_eclipse_swt_custom_TextChangedEvent_2(textChangedEvent_1);
          break;
        }
      case 3009 :
        {
          var wordBoundaryEvent: MovementEvent = new MovementEvent(StyledTextEvent(e));
          (MovementListener(eventListener)).getNextOffset__Lorg_eclipse_swt_custom_MovementEvent_2(wordBoundaryEvent);
          (StyledTextEvent(e)).end = wordBoundaryEvent.newOffset;
          break;
        }
      case 3010 :
        {
          var wordBoundaryEvent_1: MovementEvent = new MovementEvent(StyledTextEvent(e));
          (MovementListener(eventListener)).getPreviousOffset__Lorg_eclipse_swt_custom_MovementEvent_2(wordBoundaryEvent_1);
          (StyledTextEvent(e)).end = wordBoundaryEvent_1.newOffset;
          break;
        }
      case 3011 :
        {
          var caretEvent: CaretEvent = new CaretEvent(StyledTextEvent(e));
          (CaretListener(eventListener)).caretMoved__Lorg_eclipse_swt_custom_CaretEvent_2(caretEvent);
          (StyledTextEvent(e)).end = caretEvent.caretOffset;
          break;
        }
    }
    return;
  }
}
}
