package org.eclipse.swt.custom {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import java.lang.System;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Runnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import java.lang.Math__;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.graphics.TextStyle;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StyledTextRenderer {
  internal var device: Device;
  internal var styledText: StyledText;
  internal var content: StyledTextContent;
  internal var regularFont: Font;
  internal var boldFont: Font;
  internal var italicFont: Font;
  internal var boldItalicFont: Font;
  internal var tabWidth: int;
  internal var ascent: int;
  internal var descent: int;
  internal var averageCharWidth: int;
  internal var topIndex: int = -1;
  internal var layouts: JavaArray;
  internal var lineCount: int;
  internal var lineWidth: JavaArray;
  internal var lineHeight: JavaArray;
  internal var lines: JavaArray;
  internal var maxWidth: int;
  internal var maxWidthLineIndex: int;
  internal var idleRunning: Boolean;
  internal var bullets: JavaArray;
  internal var bulletsIndices: JavaArray;
  internal var redrawLines: JavaArray;
  internal var ranges: JavaArray;
  internal var styleCount: int;
  internal var styles: JavaArray;
  internal var stylesSet: JavaArray;
  internal var stylesSetCount: int = 0;
  internal var hasLinks: Boolean;
  internal var fixedPitch: Boolean;
  public static const BULLET_MARGIN: int = 8;
  public static const COMPACT_STYLES: Boolean = true;
  public static const MERGE_STYLES: Boolean = true;
  public static const GROW: int = 32;
  public static const IDLE_TIME: int = 50;
  public static const CACHE_SIZE: int = 128;
  public static const BACKGROUND: int = 1 << 0;
  public static const ALIGNMENT: int = 1 << 1;
  public static const INDENT: int = 1 << 2;
  public static const JUSTIFY: int = 1 << 3;
  public static const SEGMENTS: int = 1 << 5;
  function StyledTextRenderer(device: Device, styledText: StyledText) {
    this.device = device;
    this.styledText = styledText;
    return;
  }
  public function addMerge___3I_3Lorg_eclipse_swt_custom_StyleRange_2III(mergeRanges: JavaArray, mergeStyles: JavaArray, mergeCount: int, modifyStart: int, modifyEnd: int): int {
    var rangeCount: int = styleCount << 1;
    var endStyle: StyleRange = null;
    var endStart: int = 0;
    var endLength: int = 0;
    if (modifyEnd < rangeCount) {
      endStyle = styles[modifyEnd >> 1];
      endStart = ranges[modifyEnd];
      endLength = ranges[modifyEnd + 1];
    }
    var grow: int = mergeCount - (modifyEnd - modifyStart);
    if (rangeCount + grow >= ranges.length) {
      var tmpRanges: JavaArray = new JavaArray("[I").lengths(ranges.length + grow + (32 << 1));
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, 0, tmpRanges, 0, modifyStart);
      var tmpStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.length + (grow >> 1) + 32);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, tmpStyles, 0, modifyStart >> 1);
      if (rangeCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, modifyEnd, tmpRanges, modifyStart + mergeCount, rangeCount - modifyEnd);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd >> 1, tmpStyles, (modifyStart + mergeCount) >> 1, styleCount - (modifyEnd >> 1));
      }
      ranges = tmpRanges;
      styles = tmpStyles;
    } else {
      if (rangeCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, modifyEnd, ranges, modifyStart + mergeCount, rangeCount - modifyEnd);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd >> 1, styles, (modifyStart + mergeCount) >> 1, styleCount - (modifyEnd >> 1));
      }
    }
    {
      var j: int = modifyStart;
      for (var i: int = 0; i < mergeCount; i += 2) {
        if (j > 0 && ranges[j - 2] + ranges[j - 1] == mergeRanges[i] && mergeStyles[i >> 1].similarTo__Lorg_eclipse_swt_custom_StyleRange_2(styles[(j - 2) >> 1])) {
          ranges[j - 1] += mergeRanges[i + 1];
        } else {
          styles[j >> 1] = mergeStyles[i >> 1];
          ranges[j++] = mergeRanges[i];
          ranges[j++] = mergeRanges[i + 1];
        }
      }
      if (endStyle !== null && ranges[j - 2] + ranges[j - 1] == endStart && endStyle.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(styles[(j - 2) >> 1])) {
        ranges[j - 1] += endLength;
        modifyEnd += 2;
        mergeCount += 2;
      }
      if (rangeCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, modifyStart + mergeCount, ranges, j, rangeCount - modifyEnd);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, (modifyStart + mergeCount) >> 1, styles, j >> 1, styleCount - (modifyEnd >> 1));
      }
      grow = (j - modifyStart) - (modifyEnd - modifyStart);
    }
    styleCount += grow >> 1;
    return grow;
  }
  public function addMerge___3Lorg_eclipse_swt_custom_StyleRange_2III(mergeStyles: JavaArray, mergeCount: int, modifyStart: int, modifyEnd: int): int {
    var grow: int = mergeCount - (modifyEnd - modifyStart);
    var endStyle: StyleRange = null;
    if (modifyEnd < styleCount)
      endStyle = styles[modifyEnd];
    if (styleCount + grow >= styles.length) {
      var tmpStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.length + grow + 32);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, tmpStyles, 0, modifyStart);
      if (styleCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd, tmpStyles, modifyStart + mergeCount, styleCount - modifyEnd);
      }
      styles = tmpStyles;
    } else {
      if (styleCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd, styles, modifyStart + mergeCount, styleCount - modifyEnd);
      }
    }
    {
      var j: int = modifyStart;
      for (var i: int = 0; i < mergeCount; i++) {
        var newStyle: StyleRange = mergeStyles[i];
        var style: StyleRange;
        if (j > 0 && (style = styles[j - 1]).start + style.length == newStyle.start && newStyle.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(style)) {
          style.length += newStyle.length;
        } else {
          styles[j++] = newStyle;
        }
      }
      var style_1: StyleRange = styles[j - 1];
      if (endStyle !== null && style_1.start + style_1.length == endStyle.start && endStyle.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(style_1)) {
        style_1.length += endStyle.length;
        modifyEnd++;
        mergeCount++;
      }
      if (styleCount > modifyEnd) {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyStart + mergeCount, styles, j, styleCount - modifyEnd);
      }
      grow = (j - modifyStart) - (modifyEnd - modifyStart);
    }
    styleCount += grow;
    return grow;
  }
  public function calculate__II(startLine: int, lineCount_1: int): void {
    var endLine: int = startLine + lineCount_1;
    if (startLine < 0 || endLine > lineWidth.length) {
      return;
    }
    var hTrim: int = styledText.leftMargin + styledText.rightMargin + styledText.getCaretWidth__();
    for (var i: int = startLine; i < endLine; i++) {
      if (lineWidth[i] == -1 || lineHeight[i] == -1) {
        var layout: TextLayout = this.getTextLayout__I(i);
        var rect: Rectangle = layout.getBounds__();
        lineWidth[i] = rect.width + hTrim;
        lineHeight[i] = rect.height;
        this.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout);
      }
      if (lineWidth[i] > maxWidth) {
        maxWidth = lineWidth[i];
        maxWidthLineIndex = i;
      }
    }
    return;
  }
  public function calculateClientArea__(): void {
    var index: int = styledText.getTopIndex__();
    var lineCount_1: int = content.getLineCount__();
    var height: int = styledText.getClientArea__().height;
    var y: int = 0;
    while (height > y && lineCount_1 > index) {
      this.calculate__II(index, 1);
      y += lineHeight[index++];
    }
    return;
  }
  public function calculateIdle__(): void {
    if (idleRunning)
      return;
    var runnable: Runnable = new org.eclipse.swt.custom.StyledTextRenderer$1(this);
    var display: Display = styledText.getDisplay__();
    display.asyncExec__Ljava_lang_Runnable_2(runnable);
    idleRunning = true;
    return;
  }
  public function clearLineBackground__II(startLine: int, count: int): void {
    if (lines === null)
      return;
    for (var i: int = startLine; i < startLine + count; i++) {
      var info: StyledTextRenderer$LineInfo = lines[i];
      if (info !== null) {
        info.flags &= ~1;
        info.background = null;
        if (info.flags == 0)
          lines[i] = null;
      }
    }
    return;
  }
  public function clearLineStyle__II(startLine: int, count: int): void {
    if (lines === null)
      return;
    for (var i: int = startLine; i < startLine + count; i++) {
      var info: StyledTextRenderer$LineInfo = lines[i];
      if (info !== null) {
        info.flags &= ~(2 | 4 | 8);
        if (info.flags == 0)
          lines[i] = null;
      }
    }
    return;
  }
  public function copyInto__Lorg_eclipse_swt_custom_StyledTextRenderer_2(renderer: StyledTextRenderer): void {
    if (ranges !== null) {
      var newRanges: JavaArray = renderer.ranges = new JavaArray("[I").lengths(styleCount << 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, 0, newRanges, 0, newRanges.length);
    }
    if (styles !== null) {
      var newStyles: JavaArray = renderer.styles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styleCount);
      for (var i: int = 0; i < newStyles.length; i++) {
        newStyles[i] = StyleRange(styles[i].clone__());
      }
      renderer.styleCount = styleCount;
    }
    if (lines !== null) {
      var newLines: JavaArray = renderer.lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
      for (var i_1: int = 0; i_1 < newLines.length; i_1++) {
        newLines[i_1] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__Lorg_eclipse_swt_custom_StyledTextRenderer$LineInfo_2, [lines[i_1]]));
      }
      renderer.lineCount = lineCount;
    }
    return;
  }
  public function dispose__(): void {
    if (boldFont !== null)
      boldFont.dispose__();
    if (italicFont !== null)
      italicFont.dispose__();
    if (boldItalicFont !== null)
      boldItalicFont.dispose__();
    boldFont = italicFont = boldItalicFont = null;
    this.reset__();
    content = null;
    device = null;
    styledText = null;
    return;
  }
  public function disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout: TextLayout): void {
    if (layouts !== null) {
      for (var i: int = 0; i < layouts.length; i++) {
        if (layouts[i] === layout)
          return;
      }
    }
    layout.dispose__();
    return;
  }
  public function drawBullet__Lorg_eclipse_swt_custom_Bullet_2Lorg_eclipse_swt_graphics_GC_2IIIII(bullet: Bullet, gc: GC, paintX: int, paintY: int, index: int, lineAscent: int, lineDescent: int): void {
    var style: StyleRange = bullet.style;
    var metrics: GlyphMetrics = style.metrics;
    var color: Color = style.foreground;
    if (color !== null)
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    if ((bullet.type & 1) != 0 && StyledText.IS_MOTIF) {
      var size: int = Math__.max__II(4, int((lineAscent + lineDescent) / 4));
      if ((size & 1) == 0)
        size++;
      if (color === null) {
        var display: Display = styledText.getDisplay__();
        color = display.getSystemColor__I(2);
      }
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
      var x: int = paintX + Math__.max__II(0, metrics.width - size - 8);
      gc.fillArc__IIIIII(x, paintY + size, size + 1, size + 1, 0, 360);
      return;
    }
    var font: Font = style.font;
    if (font !== null)
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
    var string: String = "";
    var type: int = bullet.type & (1 | 2 | 4 | 8);
    switch (type) {
      case 1 :
        string = "\u2022";
        break;
      case 2 :
        string = Object(String).valueOf__I(index);
        break;
      case 4 :
        string = Object(String).valueOf__C(uint((index % 26 + 97)));
        break;
      case 8 :
        string = Object(String).valueOf__C(uint((index % 26 + 65)));
        break;
    }
    if ((bullet.type & 16) != 0)
      string += bullet.text;
    var display_1: Display = styledText.getDisplay__();
    var layout: TextLayout = new TextLayout(display_1);
    layout.setText__Ljava_lang_String_2(string);
    layout.setAscent__I(lineAscent);
    layout.setDescent__I(lineDescent);
    style = StyleRange(style.clone__());
    style.metrics = null;
    if (style.font === null)
      style.font = this.getFont__I(style.fontStyle);
    layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(style, 0, Object(string).length__());
    var x_1: int = paintX + Math__.max__II(0, metrics.width - layout.getBounds__().width - 8);
    layout.draw__Lorg_eclipse_swt_graphics_GC_2II(gc, x_1, paintY);
    layout.dispose__();
    return;
  }
  public function drawLine__IIILorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(lineIndex: int, paintX: int, paintY: int, gc: GC, widgetBackground: Color, widgetForeground: Color): int {
    var layout: TextLayout = this.getTextLayout__I(lineIndex);
    var line: String = content.getLine__I(lineIndex);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var lineLength: int = Object(line).length__();
    var selection: Point = styledText.getSelection__();
    var selectionStart: int = selection.x - lineOffset;
    var selectionEnd: int = selection.y - lineOffset;
    if (styledText.getBlockSelection__()) {
      selectionStart = selectionEnd = 0;
    }
    var client: Rectangle = styledText.getClientArea__();
    var lineBackground: Color = this.getLineBackground__ILorg_eclipse_swt_graphics_Color_2(lineIndex, null);
    var event: StyledTextEvent = styledText.getLineBackgroundData__ILjava_lang_String_2(lineOffset, line);
    if (event !== null && event.lineBackground !== null)
      lineBackground = event.lineBackground;
    var height: int = layout.getBounds__().height;
    if (lineBackground !== null) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(lineBackground);
      gc.fillRectangle__IIII(client.x, paintY, client.width, height);
    } else {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(widgetBackground);
      styledText.drawBackground__Lorg_eclipse_swt_graphics_GC_2IIII(gc, client.x, paintY, client.width, height);
    }
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(widgetForeground);
    if (selectionStart == selectionEnd || (selectionEnd <= 0 && selectionStart > lineLength - 1)) {
      layout.draw__Lorg_eclipse_swt_graphics_GC_2II(gc, paintX, paintY);
    } else {
      var start: int = Math__.max__II(0, selectionStart);
      var end: int = Math__.min__II(lineLength, selectionEnd);
      var selectionFg: Color = styledText.getSelectionForeground__();
      var selectionBg: Color = styledText.getSelectionBackground__();
      var flags: int;
      if ((styledText.getStyle__() & 65536) != 0) {
        flags = 65536;
      } else {
        flags = 131072;
      }
      if (selectionStart <= lineLength && lineLength < selectionEnd) {
        flags |= 1048576;
      }
      layout.draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I(gc, paintX, paintY, start, end - 1, selectionFg, selectionBg, flags);
    }
    var bullet: Bullet = null;
    var bulletIndex: int = -1;
    if (bullets !== null) {
      if (bulletsIndices !== null) {
        var index: int = lineIndex - topIndex;
        if (0 <= index && index < 128) {
          bullet = bullets[index];
          bulletIndex = bulletsIndices[index];
        }
      } else {
        for (var i: int = 0; i < bullets.length; i++) {
          bullet = bullets[i];
          bulletIndex = bullet.indexOf__I(lineIndex);
          if (bulletIndex != -1)
            break;
        }
      }
    }
    if (bulletIndex != -1 && bullet !== null) {
      var metrics: FontMetrics = layout.getLineMetrics__I(0);
      var lineAscent: int = metrics.getAscent__() + metrics.getLeading__();
      if (bullet.type == 32) {
        bullet.style.start = lineOffset;
        styledText.paintObject__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_custom_StyleRange_2Lorg_eclipse_swt_custom_Bullet_2I(gc, paintX, paintY, lineAscent, metrics.getDescent__(), bullet.style, bullet, bulletIndex);
      } else {
        this.drawBullet__Lorg_eclipse_swt_custom_Bullet_2Lorg_eclipse_swt_graphics_GC_2IIIII(bullet, gc, paintX, paintY, bulletIndex, lineAscent, metrics.getDescent__());
      }
    }
    var styles_1: JavaArray = layout.getStyles__();
    var ranges_1: JavaArray = null;
    for (var i_1: int = 0; i_1 < styles_1.length; i_1++) {
      if (styles_1[i_1].metrics !== null) {
        if (ranges_1 === null)
          ranges_1 = layout.getRanges__();
        var start_1: int = ranges_1[i_1 << 1];
        var length: int = ranges_1[(i_1 << 1) + 1] - start_1;
        var point: Point = layout.getLocation__IZ(start_1, false);
        var metrics_1: FontMetrics = layout.getLineMetrics__I(layout.getLineIndex__I(start_1));
        var style: StyleRange = StyleRange((StyleRange(styles_1[i_1])).clone__());
        style.start = start_1 + lineOffset;
        style.length = length;
        var lineAscent_1: int = metrics_1.getAscent__() + metrics_1.getLeading__();
        styledText.paintObject__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_custom_StyleRange_2Lorg_eclipse_swt_custom_Bullet_2I(gc, point.x + paintX, point.y + paintY, lineAscent_1, metrics_1.getDescent__(), style, null, 0);
      }
    }
    this.disposeTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout);
    return height;
  }
  public function getBaseline__(): int {
    return ascent;
  }
  public function getFont__I(style: int): Font {
    switch (style) {
      case 1 :
        if (boldFont !== null)
          return boldFont;
        return boldFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2, [device, this.getFontData__I(style)]));
      case 2 :
        if (italicFont !== null)
          return italicFont;
        return italicFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2, [device, this.getFontData__I(style)]));
      case 1 | 2 :
        if (boldItalicFont !== null)
          return boldItalicFont;
        return boldItalicFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2, [device, this.getFontData__I(style)]));
      default :
        return regularFont;
    }
  }
  public function getFontData__I(style: int): JavaArray {
    var fontDatas: JavaArray = regularFont.getFontData__();
    for (var i: int = 0; i < fontDatas.length; i++) {
      fontDatas[i].setStyle__I(style);
    }
    return fontDatas;
  }
  public function getHeight__(): int {
    var defaultLineHeight: int = this.getLineHeight__();
    if (styledText.isFixedLineHeight__()) {
      return lineCount * defaultLineHeight;
    }
    var totalHeight: int = 0;
    var width: int = styledText.getWrapWidth__();
    for (var i: int = 0; i < lineCount; i++) {
      var height: int = lineHeight[i];
      if (height == -1) {
        if (width > 0) {
          var length: int = Object(content.getLine__I(i)).length__();
          height = ((int(length * averageCharWidth / width)) + 1) * defaultLineHeight;
        } else {
          height = defaultLineHeight;
        }
      }
      totalHeight += height;
    }
    return totalHeight + styledText.topMargin + styledText.bottomMargin;
  }
  public function hasLink__I(offset: int): Boolean {
    if (offset == -1)
      return false;
    var lineIndex: int = content.getLineAtOffset__I(offset);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var line: String = content.getLine__I(lineIndex);
    var event: StyledTextEvent = styledText.getLineStyleData__ILjava_lang_String_2(lineOffset, line);
    if (event !== null) {
      var styles_1: JavaArray = event.styles;
      if (styles_1 !== null) {
        var ranges_1: JavaArray = event.ranges;
        if (ranges_1 !== null) {
          for (var i: int = 0; i < ranges_1.length; i += 2) {
            if (ranges_1[i] <= offset && offset < ranges_1[i] + ranges_1[i + 1] && styles_1[i >> 1].underline && styles_1[i >> 1].underlineStyle == 4) {
              return true;
            }
          }
        } else {
          for (var i_1: int = 0; i_1 < styles_1.length; i_1++) {
            if (styles_1[i_1].start <= offset && offset < styles_1[i_1].start + styles_1[i_1].length && styles_1[i_1 >> 1].underline && styles_1[i_1 >> 1].underlineStyle == 4) {
              return true;
            }
          }
        }
      }
    } else {
      if (ranges !== null) {
        var rangeCount: int = styleCount << 1;
        var index: int = this.getRangeIndex__III(offset, -1, rangeCount);
        if (index >= rangeCount)
          return false;
        var rangeStart: int = ranges[index];
        var rangeLength: int = ranges[index + 1];
        var rangeStyle: StyleRange = styles[index >> 1];
        if (rangeStart <= offset && offset < rangeStart + rangeLength && rangeStyle.underline && rangeStyle.underlineStyle == 4) {
          return true;
        }
      }
    }
    return false;
  }
  public function getLineAlignment__II(index: int, defaultAlignment: int): int {
    if (lines === null)
      return defaultAlignment;
    var info: StyledTextRenderer$LineInfo = lines[index];
    if (info !== null && (info.flags & 2) != 0) {
      return info.alignment;
    }
    return defaultAlignment;
  }
  public function getLineBackground__ILorg_eclipse_swt_graphics_Color_2(index: int, defaultBackground: Color): Color {
    if (lines === null)
      return defaultBackground;
    var info: StyledTextRenderer$LineInfo = lines[index];
    if (info !== null && (info.flags & 1) != 0) {
      return info.background;
    }
    return defaultBackground;
  }
  public function getLineBullet__ILorg_eclipse_swt_custom_Bullet_2(index: int, defaultBullet: Bullet): Bullet {
    if (bullets === null)
      return defaultBullet;
    if (bulletsIndices !== null)
      return defaultBullet;
    for (var i: int = 0; i < bullets.length; i++) {
      var bullet: Bullet = bullets[i];
      if (bullet.indexOf__I(index) != -1)
        return bullet;
    }
    return defaultBullet;
  }
  public function getLineHeight__(): int {
    return ascent + descent;
  }
  public function getLineHeight__I(lineIndex: int): int {
    if (lineHeight[lineIndex] == -1) {
      this.calculate__II(lineIndex, 1);
    }
    return lineHeight[lineIndex];
  }
  public function getLineIndent__II(index: int, defaultIndent: int): int {
    if (lines === null)
      return defaultIndent;
    var info: StyledTextRenderer$LineInfo = lines[index];
    if (info !== null && (info.flags & 4) != 0) {
      return info.indent;
    }
    return defaultIndent;
  }
  public function getLineJustify__IZ(index: int, defaultJustify: Boolean): Boolean {
    if (lines === null)
      return defaultJustify;
    var info: StyledTextRenderer$LineInfo = lines[index];
    if (info !== null && (info.flags & 8) != 0) {
      return info.justify;
    }
    return defaultJustify;
  }
  public function getLineSegments__I_3I(index: int, defaultSegments: JavaArray): JavaArray {
    if (lines === null)
      return defaultSegments;
    var info: StyledTextRenderer$LineInfo = lines[index];
    if (info !== null && (info.flags & 32) != 0) {
      return info.segments;
    }
    return defaultSegments;
  }
  public function getRangeIndex__III(offset: int, low: int, high: int): int {
    if (styleCount == 0)
      return 0;
    if (ranges !== null) {
      while (high - low > 2) {
        var index: int = int((int((high + low) / 2)) / 2) * 2;
        var end: int = ranges[index] + ranges[index + 1];
        if (end > offset) {
          high = index;
        } else {
          low = index;
        }
      }
    } else {
      while (high - low > 1) {
        var index_1: int = (int((high + low) / 2));
        var end_1: int = styles[index_1].start + styles[index_1].length;
        if (end_1 > offset) {
          high = index_1;
        } else {
          low = index_1;
        }
      }
    }
    return high;
  }
  public function getRanges__II(start: int, length: int): JavaArray {
    if (length == 0)
      return null;
    var newRanges: JavaArray;
    var end: int = start + length - 1;
    if (ranges !== null) {
      var rangeCount: int = styleCount << 1;
      var rangeStart: int = this.getRangeIndex__III(start, -1, rangeCount);
      if (rangeStart >= rangeCount)
        return null;
      if (ranges[rangeStart] > end)
        return null;
      var rangeEnd: int = Math__.min__II(rangeCount - 2, this.getRangeIndex__III(end, rangeStart - 1, rangeCount));
      if (ranges[rangeEnd] > end)
        rangeEnd = Math__.max__II(rangeStart, rangeEnd - 2);
      newRanges = new JavaArray("[I").lengths(rangeEnd - rangeStart + 2);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, rangeStart, newRanges, 0, newRanges.length);
    } else {
      var rangeStart_1: int = this.getRangeIndex__III(start, -1, styleCount);
      if (rangeStart_1 >= styleCount)
        return null;
      if (styles[rangeStart_1].start > end)
        return null;
      var rangeEnd_1: int = Math__.min__II(styleCount - 1, this.getRangeIndex__III(end, rangeStart_1 - 1, styleCount));
      if (styles[rangeEnd_1].start > end)
        rangeEnd_1 = Math__.max__II(rangeStart_1, rangeEnd_1 - 1);
      newRanges = new JavaArray("[I").lengths((rangeEnd_1 - rangeStart_1 + 1) << 1);
      for (var i: int = rangeStart_1, j: int = 0; i <= rangeEnd_1; i++, j += 2) {
        var style: StyleRange = styles[i];
        newRanges[j] = style.start;
        newRanges[j + 1] = style.length;
      }
    }
    if (start > newRanges[0]) {
      newRanges[1] = newRanges[0] + newRanges[1] - start;
      newRanges[0] = start;
    }
    if (end < newRanges[newRanges.length - 2] + newRanges[newRanges.length - 1] - 1) {
      newRanges[newRanges.length - 1] = end - newRanges[newRanges.length - 2] + 1;
    }
    return newRanges;
  }
  public function getStyleRanges__IIZ(start: int, length: int, includeRanges: Boolean): JavaArray {
    if (length == 0)
      return null;
    var newStyles: JavaArray;
    var end: int = start + length - 1;
    if (ranges !== null) {
      var rangeCount: int = styleCount << 1;
      var rangeStart: int = this.getRangeIndex__III(start, -1, rangeCount);
      if (rangeStart >= rangeCount)
        return null;
      if (ranges[rangeStart] > end)
        return null;
      var rangeEnd: int = Math__.min__II(rangeCount - 2, this.getRangeIndex__III(end, rangeStart - 1, rangeCount));
      if (ranges[rangeEnd] > end)
        rangeEnd = Math__.max__II(rangeStart, rangeEnd - 2);
      newStyles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(((rangeEnd - rangeStart) >> 1) + 1);
      if (includeRanges) {
        for (var i: int = rangeStart, j: int = 0; i <= rangeEnd; i += 2, j++) {
          newStyles[j] = StyleRange(styles[i >> 1].clone__());
          newStyles[j].start = ranges[i];
          newStyles[j].length = ranges[i + 1];
        }
      } else {
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, rangeStart >> 1, newStyles, 0, newStyles.length);
      }
    } else {
      var rangeStart_1: int = this.getRangeIndex__III(start, -1, styleCount);
      if (rangeStart_1 >= styleCount)
        return null;
      if (styles[rangeStart_1].start > end)
        return null;
      var rangeEnd_1: int = Math__.min__II(styleCount - 1, this.getRangeIndex__III(end, rangeStart_1 - 1, styleCount));
      if (styles[rangeEnd_1].start > end)
        rangeEnd_1 = Math__.max__II(rangeStart_1, rangeEnd_1 - 1);
      newStyles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(rangeEnd_1 - rangeStart_1 + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, rangeStart_1, newStyles, 0, newStyles.length);
    }
    if (includeRanges || ranges === null) {
      var style: StyleRange = newStyles[0];
      if (start > style.start) {
        newStyles[0] = style = StyleRange(style.clone__());
        style.length = style.start + style.length - start;
        style.start = start;
      }
      style = newStyles[newStyles.length - 1];
      if (end < style.start + style.length - 1) {
        newStyles[newStyles.length - 1] = style = StyleRange(style.clone__());
        style.length = end - style.start + 1;
      }
    }
    return newStyles;
  }
  public function getStyleRange__Lorg_eclipse_swt_custom_StyleRange_2(style: StyleRange): StyleRange {
    if (style.underline && style.underlineStyle == 4)
      hasLinks = true;
    if (style.start == 0 && style.length == 0 && style.fontStyle == 0)
      return style;
    var clone: StyleRange = StyleRange(style.clone__());
    clone.start = clone.length = 0;
    clone.fontStyle = 0;
    if (clone.font === null)
      clone.font = this.getFont__I(style.fontStyle);
    return clone;
  }
  public function getTextLayout__I(lineIndex: int): TextLayout {
    return this.getTextLayout__IIII(lineIndex, styledText.getOrientation__(), styledText.getWrapWidth__(), styledText.lineSpacing);
  }
  public function getTextLayout__IIII(lineIndex: int, orientation: int, width: int, lineSpacing: int): TextLayout {
    var layout: TextLayout = null;
    if (styledText !== null) {
      var topIndex_1: int = styledText.topIndex > 0 ? styledText.topIndex - 1 : 0;
      if (layouts === null || topIndex_1 != this.topIndex) {
        var newLayouts: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/TextLayout;").lengths(128);
        if (layouts !== null) {
          for (var i: int = 0; i < layouts.length; i++) {
            if (layouts[i] !== null) {
              var layoutIndex: int = (i + this.topIndex) - topIndex_1;
              if (0 <= layoutIndex && layoutIndex < newLayouts.length) {
                newLayouts[layoutIndex] = layouts[i];
              } else {
                layouts[i].dispose__();
              }
            }
          }
        }
        if (bullets !== null && bulletsIndices !== null && topIndex_1 != this.topIndex) {
          var delta: int = topIndex_1 - this.topIndex;
          if (delta > 0) {
            if (delta < bullets.length) {
              System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bullets, delta, bullets, 0, bullets.length - delta);
              System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bulletsIndices, delta, bulletsIndices, 0, bulletsIndices.length - delta);
            }
            var startIndex: int = Math__.max__II(0, bullets.length - delta);
            for (var i_1: int = startIndex; i_1 < bullets.length; i_1++)
              bullets[i_1] = null;
          } else {
            if (-delta < bullets.length) {
              System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bullets, 0, bullets, -delta, bullets.length + delta);
              System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bulletsIndices, 0, bulletsIndices, -delta, bulletsIndices.length + delta);
            }
            var endIndex: int = Math__.min__II(bullets.length, -delta);
            for (var i_2: int = 0; i_2 < endIndex; i_2++)
              bullets[i_2] = null;
          }
        }
        this.topIndex = topIndex_1;
        layouts = newLayouts;
      }
      if (layouts !== null) {
        var layoutIndex_1: int = lineIndex - topIndex_1;
        if (0 <= layoutIndex_1 && layoutIndex_1 < layouts.length) {
          layout = layouts[layoutIndex_1];
          if (layout !== null) {
            if (lineWidth[lineIndex] != -1)
              return layout;
          } else {
            layout = layouts[layoutIndex_1] = new TextLayout(device);
          }
        }
      }
    }
    if (layout === null)
      layout = new TextLayout(device);
    var line: String = content.getLine__I(lineIndex);
    var lineOffset: int = content.getOffsetAtLine__I(lineIndex);
    var segments: JavaArray = null;
    var indent: int = 0;
    var alignment: int = 16384;
    var justify: Boolean = false;
    var bullet: Bullet = null;
    var ranges_1: JavaArray = null;
    var styles_1: JavaArray = null;
    var rangeStart: int = 0;
    var styleCount_1: int = 0;
    var event: StyledTextEvent = null;
    if (styledText !== null) {
      event = styledText.getLineStyleData__ILjava_lang_String_2(lineOffset, line);
      segments = styledText.getBidiSegments__ILjava_lang_String_2(lineOffset, line);
      indent = styledText.indent;
      alignment = styledText.alignment;
      justify = styledText.justify;
    }
    if (event !== null) {
      indent = event.indent;
      alignment = event.alignment;
      justify = event.justify;
      bullet = event.bullet;
      ranges_1 = event.ranges;
      styles_1 = event.styles;
      if (styles_1 !== null) {
        styleCount_1 = styles_1.length;
        if (styledText.isFixedLineHeight__()) {
          for (var i_3: int = 0; i_3 < styleCount_1; i_3++) {
            if (styles_1[i_3].isVariableHeight__()) {
              styledText.verticalScrollOffset = -1;
              styledText.setVariableLineHeight__();
              styledText.redraw__();
              break;
            }
          }
        }
      }
      if (bullets === null || bulletsIndices === null) {
        bullets = new JavaArray("[Lorg/eclipse/swt/custom/Bullet;").lengths(128);
        bulletsIndices = new JavaArray("[I").lengths(128);
      }
      var index: int = lineIndex - topIndex;
      if (0 <= index && index < 128) {
        bullets[index] = bullet;
        bulletsIndices[index] = event.bulletIndex;
      }
    } else {
      if (lines !== null) {
        var info: StyledTextRenderer$LineInfo = lines[lineIndex];
        if (info !== null) {
          if ((info.flags & 4) != 0)
            indent = info.indent;
          if ((info.flags & 2) != 0)
            alignment = info.alignment;
          if ((info.flags & 8) != 0)
            justify = info.justify;
          if ((info.flags & 32) != 0)
            segments = info.segments;
        }
      }
      if (bulletsIndices !== null) {
        bullets = null;
        bulletsIndices = null;
      }
      if (bullets !== null) {
        for (var i_4: int = 0; i_4 < bullets.length; i_4++) {
          if (bullets[i_4].indexOf__I(lineIndex) != -1) {
            bullet = bullets[i_4];
            break;
          }
        }
      }
      ranges_1 = this.ranges;
      styles_1 = this.styles;
      styleCount_1 = this.styleCount;
      if (ranges_1 !== null) {
        rangeStart = this.getRangeIndex__III(lineOffset, -1, styleCount_1 << 1);
      } else {
        rangeStart = this.getRangeIndex__III(lineOffset, -1, styleCount_1);
      }
    }
    if (bullet !== null) {
      var style: StyleRange = bullet.style;
      var metrics: GlyphMetrics = style.metrics;
      indent += metrics.width;
    }
    layout.setFont__Lorg_eclipse_swt_graphics_Font_2(regularFont);
    layout.setAscent__I(ascent);
    layout.setDescent__I(descent);
    layout.setText__Ljava_lang_String_2(line);
    layout.setOrientation__I(orientation);
    layout.setSegments___3I(segments);
    layout.setWidth__I(width);
    layout.setSpacing__I(lineSpacing);
    layout.setTabs___3I(new JavaArray("[I").values(tabWidth));
    layout.setIndent__I(indent);
    layout.setAlignment__I(alignment);
    layout.setJustify__Z(justify);
    var lastOffset: int = 0;
    var length: int = Object(line).length__();
    if (styles_1 !== null) {
      if (ranges_1 !== null) {
        var rangeCount: int = styleCount_1 << 1;
        for (var i_5: int = rangeStart; i_5 < rangeCount; i_5 += 2) {
          var start: int;
          var end: int;
          if (lineOffset > ranges_1[i_5]) {
            start = 0;
            end = Math__.min__II(length, ranges_1[i_5 + 1] - lineOffset + ranges_1[i_5]);
          } else {
            start = ranges_1[i_5] - lineOffset;
            end = Math__.min__II(length, start + ranges_1[i_5 + 1]);
          }
          if (start >= length)
            break;
          if (lastOffset < start) {
            layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(null, lastOffset, start - 1);
          }
          layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(this.getStyleRange__Lorg_eclipse_swt_custom_StyleRange_2(styles_1[i_5 >> 1]), start, end);
          lastOffset = Math__.max__II(lastOffset, end);
        }
      } else {
        for (var i_6: int = rangeStart; i_6 < styleCount_1; i_6++) {
          var start_1: int;
          var end_1: int;
          if (lineOffset > styles_1[i_6].start) {
            start_1 = 0;
            end_1 = Math__.min__II(length, styles_1[i_6].length - lineOffset + styles_1[i_6].start);
          } else {
            start_1 = styles_1[i_6].start - lineOffset;
            end_1 = Math__.min__II(length, start_1 + styles_1[i_6].length);
          }
          if (start_1 >= length)
            break;
          if (lastOffset < start_1) {
            layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(null, lastOffset, start_1 - 1);
          }
          layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(this.getStyleRange__Lorg_eclipse_swt_custom_StyleRange_2(styles_1[i_6]), start_1, end_1);
          lastOffset = Math__.max__II(lastOffset, end_1);
        }
      }
    }
    if (lastOffset < length)
      layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(null, lastOffset, length);
    if (styledText !== null && styledText.ime !== null) {
      var ime: IME = styledText.ime;
      var compositionOffset: int = ime.getCompositionOffset__();
      if (compositionOffset != -1) {
        var commitCount: int = ime.getCommitCount__();
        var compositionLength: int = Object(ime.getText__()).length__();
        if (compositionLength != commitCount) {
          var compositionLine: int = content.getLineAtOffset__I(compositionOffset);
          if (compositionLine == lineIndex) {
            var imeRanges: JavaArray = ime.getRanges__();
            var imeStyles: JavaArray = ime.getStyles__();
            if (imeRanges.length > 0) {
              for (var i_7: int = 0; i_7 < imeStyles.length; i_7++) {
                var start_2: int = imeRanges[i_7 * 2] - lineOffset;
                var end_2: int = imeRanges[i_7 * 2 + 1] - lineOffset;
                var imeStyle: TextStyle = imeStyles[i_7];
                var userStyle: TextStyle;
                for (var j: int = start_2; j <= end_2; j++) {
                  userStyle = layout.getStyle__I(j);
                  if (userStyle === null && j > 0)
                    userStyle = layout.getStyle__I(j - 1);
                  if (userStyle === null && j + 1 < length)
                    userStyle = layout.getStyle__I(j + 1);
                  if (userStyle === null) {
                    layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(imeStyle, j, j);
                  } else {
                    var newStyle: TextStyle = new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_TextStyle_2, [imeStyle]));
                    if (newStyle.font === null)
                      newStyle.font = userStyle.font;
                    if (newStyle.foreground === null)
                      newStyle.foreground = userStyle.foreground;
                    if (newStyle.background === null)
                      newStyle.background = userStyle.background;
                    layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(newStyle, j, j);
                  }
                }
              }
            } else {
              var start_3: int = compositionOffset - lineOffset;
              var end_3: int = start_3 + compositionLength - 1;
              var userStyle_1: TextStyle = layout.getStyle__I(start_3);
              if (userStyle_1 === null) {
                if (start_3 > 0)
                  userStyle_1 = layout.getStyle__I(start_3 - 1);
                if (userStyle_1 === null && end_3 + 1 < length)
                  userStyle_1 = layout.getStyle__I(end_3 + 1);
                if (userStyle_1 !== null) {
                  var newStyle_1: TextStyle = new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__, []));
                  newStyle_1.font = userStyle_1.font;
                  newStyle_1.foreground = userStyle_1.foreground;
                  newStyle_1.background = userStyle_1.background;
                  layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(newStyle_1, start_3, end_3);
                }
              }
            }
          }
        }
      }
    }
    if (styledText !== null && styledText.isFixedLineHeight__()) {
      var index_1: int = -1;
      var lineCount_1: int = layout.getLineCount__();
      var height: int = this.getLineHeight__();
      for (var i_8: int = 0; i_8 < lineCount_1; i_8++) {
        var lineHeight_1: int = layout.getLineBounds__I(i_8).height;
        if (lineHeight_1 > height) {
          height = lineHeight_1;
          index_1 = i_8;
        }
      }
      if (index_1 != -1) {
        var metrics_1: FontMetrics = layout.getLineMetrics__I(index_1);
        ascent = metrics_1.getAscent__() + metrics_1.getLeading__();
        descent = metrics_1.getDescent__();
        if (layouts !== null) {
          for (var i_9: int = 0; i_9 < layouts.length; i_9++) {
            if (layouts[i_9] !== null && layouts[i_9] !== layout) {
              layouts[i_9].setAscent__I(ascent);
              layouts[i_9].setDescent__I(descent);
            }
          }
        }
        if (styledText.verticalScrollOffset != 0) {
          var topIndex_2: int = styledText.topIndex;
          var topIndexY: int = styledText.topIndexY;
          var lineHeight_2: int = this.getLineHeight__();
          if (topIndexY >= 0) {
            styledText.verticalScrollOffset = (topIndex_2 - 1) * lineHeight_2 + lineHeight_2 - topIndexY;
          } else {
            styledText.verticalScrollOffset = topIndex_2 * lineHeight_2 - topIndexY;
          }
        }
        styledText.calculateScrollBars__();
        if (styledText.isBidiCaret__())
          styledText.createCaretBitmaps__();
        styledText.caretDirection = 0;
        styledText.setCaretLocation__();
        styledText.redraw__();
      }
    }
    return layout;
  }
  public function getWidth__(): int {
    return maxWidth;
  }
  public function reset__(): void {
    if (layouts !== null) {
      for (var i: int = 0; i < layouts.length; i++) {
        var layout: TextLayout = layouts[i];
        if (layout !== null)
          layout.dispose__();
      }
      layouts = null;
    }
    topIndex = -1;
    stylesSetCount = styleCount = lineCount = 0;
    ranges = null;
    styles = null;
    stylesSet = null;
    lines = null;
    lineWidth = null;
    lineHeight = null;
    bullets = null;
    bulletsIndices = null;
    redrawLines = null;
    hasLinks = false;
    return;
  }
  public function reset__II(startLine: int, lineCount_1: int): void {
    var endLine: int = startLine + lineCount_1;
    if (startLine < 0 || endLine > lineWidth.length)
      return;
    for (var i: int = startLine; i < endLine; i++) {
      lineWidth[i] = -1;
      lineHeight[i] = -1;
    }
    if (startLine <= maxWidthLineIndex && maxWidthLineIndex < endLine) {
      maxWidth = 0;
      maxWidthLineIndex = -1;
      if (lineCount_1 != this.lineCount) {
        for (var i_1: int = 0; i_1 < this.lineCount; i_1++) {
          if (lineWidth[i_1] > maxWidth) {
            maxWidth = lineWidth[i_1];
            maxWidthLineIndex = i_1;
          }
        }
      }
    }
    return;
  }
  public function setContent__Lorg_eclipse_swt_custom_StyledTextContent_2(content_1: StyledTextContent): void {
    this.reset__();
    this.content = content_1;
    lineCount = content_1.getLineCount__();
    lineWidth = new JavaArray("[I").lengths(lineCount);
    lineHeight = new JavaArray("[I").lengths(lineCount);
    this.reset__II(0, lineCount);
    return;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2I(font: Font, tabs: int): void {
    var layout: TextLayout = new TextLayout(device);
    layout.setFont__Lorg_eclipse_swt_graphics_Font_2(regularFont);
    if (font !== null) {
      if (boldFont !== null)
        boldFont.dispose__();
      if (italicFont !== null)
        italicFont.dispose__();
      if (boldItalicFont !== null)
        boldItalicFont.dispose__();
      boldFont = italicFont = boldItalicFont = null;
      regularFont = font;
      layout.setText__Ljava_lang_String_2("    ");
      layout.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
      layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [this.getFont__I(0), null, null])), 0, 0);
      layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [this.getFont__I(1), null, null])), 1, 1);
      layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [this.getFont__I(2), null, null])), 2, 2);
      layout.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [this.getFont__I(1 | 2), null, null])), 3, 3);
      var metrics: FontMetrics = layout.getLineMetrics__I(0);
      ascent = metrics.getAscent__() + metrics.getLeading__();
      descent = metrics.getDescent__();
      boldFont.dispose__();
      italicFont.dispose__();
      boldItalicFont.dispose__();
      boldFont = italicFont = boldItalicFont = null;
    }
    layout.dispose__();
    layout = new TextLayout(device);
    layout.setFont__Lorg_eclipse_swt_graphics_Font_2(regularFont);
    var tabBuffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [tabs]));
    for (var i: int = 0; i < tabs; i++) {
      tabBuffer.append__C(32);
    }
    layout.setText__Ljava_lang_String_2(tabBuffer.toString__());
    tabWidth = layout.getBounds__().width;
    layout.dispose__();
    if (styledText !== null) {
      var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [styledText]));
      averageCharWidth = gc.getFontMetrics__().getAverageCharWidth__();
      fixedPitch = gc.stringExtent__Ljava_lang_String_2("l").x == gc.stringExtent__Ljava_lang_String_2("W").x;
      gc.dispose__();
    }
    return;
  }
  public function setLineAlignment__III(startLine: int, count: int, alignment: int): void {
    if (lines === null)
      lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
    for (var i: int = startLine; i < startLine + count; i++) {
      if (lines[i] === null) {
        lines[i] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__, []));
      }
      lines[i].flags |= 2;
      lines[i].alignment = alignment;
    }
    return;
  }
  public function setLineBackground__IILorg_eclipse_swt_graphics_Color_2(startLine: int, count: int, background: Color): void {
    if (lines === null)
      lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
    for (var i: int = startLine; i < startLine + count; i++) {
      if (lines[i] === null) {
        lines[i] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__, []));
      }
      lines[i].flags |= 1;
      lines[i].background = background;
    }
    return;
  }
  public function setLineBullet__IILorg_eclipse_swt_custom_Bullet_2(startLine: int, count: int, bullet: Bullet): void {
    if (bulletsIndices !== null) {
      bulletsIndices = null;
      bullets = null;
    }
    if (bullets === null) {
      if (bullet === null)
        return;
      bullets = new JavaArray("[Lorg/eclipse/swt/custom/Bullet;").lengths(1);
      bullets[0] = bullet;
    }
    var index: int = 0;
    while (index < bullets.length) {
      if (bullet === bullets[index])
        break;
      index++;
    }
    if (bullet !== null) {
      if (index == bullets.length) {
        var newBulletsList: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/Bullet;").lengths(bullets.length + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bullets, 0, newBulletsList, 0, bullets.length);
        newBulletsList[index] = bullet;
        bullets = newBulletsList;
      }
      bullet.addIndices__II(startLine, count);
    } else {
      this.updateBullets__IIIZ(startLine, count, 0, false);
      styledText.redrawLinesBullet___3I(redrawLines);
      redrawLines = null;
    }
    return;
  }
  public function setLineIndent__III(startLine: int, count: int, indent: int): void {
    if (lines === null)
      lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
    for (var i: int = startLine; i < startLine + count; i++) {
      if (lines[i] === null) {
        lines[i] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__, []));
      }
      lines[i].flags |= 4;
      lines[i].indent = indent;
    }
    return;
  }
  public function setLineJustify__IIZ(startLine: int, count: int, justify: Boolean): void {
    if (lines === null)
      lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
    for (var i: int = startLine; i < startLine + count; i++) {
      if (lines[i] === null) {
        lines[i] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__, []));
      }
      lines[i].flags |= 8;
      lines[i].justify = justify;
    }
    return;
  }
  public function setLineSegments__II_3I(startLine: int, count: int, segments: JavaArray): void {
    if (lines === null)
      lines = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount);
    for (var i: int = startLine; i < startLine + count; i++) {
      if (lines[i] === null) {
        lines[i] = new StyledTextRenderer$LineInfo(new Arguments(org.eclipse.swt.custom.StyledTextRenderer$LineInfo.StyledTextRenderer$LineInfo__, []));
      }
      lines[i].flags |= 32;
      lines[i].segments = segments;
    }
    return;
  }
  public function setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(newRanges: JavaArray, newStyles: JavaArray): void {
    if (newStyles === null) {
      stylesSetCount = styleCount = 0;
      ranges = null;
      styles = null;
      stylesSet = null;
      hasLinks = false;
      return;
    }
    if (newRanges === null && true) {
      newRanges = new JavaArray("[I").lengths(newStyles.length << 1);
      var tmpStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(newStyles.length);
      if (stylesSet === null)
        stylesSet = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(4);
      for (var i: int = 0, j: int = 0; i < newStyles.length; i++) {
        var newStyle: StyleRange = newStyles[i];
        newRanges[j++] = newStyle.start;
        newRanges[j++] = newStyle.length;
        var index: int = 0;
        while (index < stylesSetCount) {
          if (stylesSet[index].similarTo__Lorg_eclipse_swt_custom_StyleRange_2(newStyle))
            break;
          index++;
        }
        if (index == stylesSetCount) {
          if (stylesSetCount == stylesSet.length) {
            var tmpStylesSet: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(stylesSetCount + 4);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(stylesSet, 0, tmpStylesSet, 0, stylesSetCount);
            stylesSet = tmpStylesSet;
          }
          stylesSet[stylesSetCount++] = newStyle;
        }
        tmpStyles[i] = stylesSet[index];
      }
      newStyles = tmpStyles;
    }
    if (styleCount == 0) {
      if (newRanges !== null) {
        ranges = new JavaArray("[I").lengths(newRanges.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(newRanges, 0, ranges, 0, ranges.length);
      }
      styles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(newStyles.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(newStyles, 0, styles, 0, styles.length);
      styleCount = newStyles.length;
      return;
    }
    if (newRanges !== null && ranges === null) {
      ranges = new JavaArray("[I").lengths(styles.length << 1);
      for (var i_1: int = 0, j_1: int = 0; i_1 < styleCount; i_1++) {
        ranges[j_1++] = styles[i_1].start;
        ranges[j_1++] = styles[i_1].length;
      }
    }
    if (newRanges === null && ranges !== null) {
      newRanges = new JavaArray("[I").lengths(newStyles.length << 1);
      for (var i_2: int = 0, j_2: int = 0; i_2 < newStyles.length; i_2++) {
        newRanges[j_2++] = newStyles[i_2].start;
        newRanges[j_2++] = newStyles[i_2].length;
      }
    }
    if (ranges !== null) {
      var rangeCount: int = styleCount << 1;
      var start: int = newRanges[0];
      var modifyStart: int = this.getRangeIndex__III(start, -1, rangeCount);
      var modifyEnd: int;
      var insert: Boolean = modifyStart == rangeCount;
      if (!insert) {
        var end: int = newRanges[newRanges.length - 2] + newRanges[newRanges.length - 1];
        modifyEnd = this.getRangeIndex__III(end, modifyStart - 1, rangeCount);
        insert = modifyStart == modifyEnd && ranges[modifyStart] >= end;
      }
      if (insert) {
        this.addMerge___3I_3Lorg_eclipse_swt_custom_StyleRange_2III(newRanges, newStyles, newRanges.length, modifyStart, modifyStart);
        return;
      }
      modifyEnd = modifyStart;
      var mergeRanges: JavaArray = new JavaArray("[I").lengths(6);
      var mergeStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(3);
      for (var i_3: int = 0; i_3 < newRanges.length; i_3 += 2) {
        var newStart: int = newRanges[i_3];
        var newEnd: int = newStart + newRanges[i_3 + 1];
        if (newStart == newEnd)
          continue;
        var modifyLast: int = 0;
        var mergeCount: int = 0;
        while (modifyEnd < rangeCount) {
          if (newStart >= ranges[modifyStart] + ranges[modifyStart + 1])
            modifyStart += 2;
          if (ranges[modifyEnd] + ranges[modifyEnd + 1] > newEnd)
            break;
          modifyEnd += 2;
        }
        if (ranges[modifyStart] < newStart && newStart < ranges[modifyStart] + ranges[modifyStart + 1]) {
          mergeStyles[mergeCount >> 1] = styles[modifyStart >> 1];
          mergeRanges[mergeCount] = ranges[modifyStart];
          mergeRanges[mergeCount + 1] = newStart - ranges[modifyStart];
          mergeCount += 2;
        }
        mergeStyles[mergeCount >> 1] = newStyles[i_3 >> 1];
        mergeRanges[mergeCount] = newStart;
        mergeRanges[mergeCount + 1] = newRanges[i_3 + 1];
        mergeCount += 2;
        if (modifyEnd < rangeCount && ranges[modifyEnd] < newEnd && newEnd < ranges[modifyEnd] + ranges[modifyEnd + 1]) {
          mergeStyles[mergeCount >> 1] = styles[modifyEnd >> 1];
          mergeRanges[mergeCount] = newEnd;
          mergeRanges[mergeCount + 1] = ranges[modifyEnd] + ranges[modifyEnd + 1] - newEnd;
          mergeCount += 2;
          modifyLast = 2;
        }
        var grow: int = this.addMerge___3I_3Lorg_eclipse_swt_custom_StyleRange_2III(mergeRanges, mergeStyles, mergeCount, modifyStart, modifyEnd + modifyLast);
        rangeCount += grow;
        modifyStart = modifyEnd += grow;
      }
    } else {
      var start_1: int = newStyles[0].start;
      var modifyStart_1: int = this.getRangeIndex__III(start_1, -1, styleCount);
      var modifyEnd_1: int;
      var insert_1: Boolean = modifyStart_1 == styleCount;
      if (!insert_1) {
        var end_1: int = newStyles[newStyles.length - 1].start + newStyles[newStyles.length - 1].length;
        modifyEnd_1 = this.getRangeIndex__III(end_1, modifyStart_1 - 1, styleCount);
        insert_1 = modifyStart_1 == modifyEnd_1 && styles[modifyStart_1].start >= end_1;
      }
      if (insert_1) {
        this.addMerge___3Lorg_eclipse_swt_custom_StyleRange_2III(newStyles, newStyles.length, modifyStart_1, modifyStart_1);
        return;
      }
      modifyEnd_1 = modifyStart_1;
      var mergeStyles_1: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(3);
      for (var i_4: int = 0; i_4 < newStyles.length; i_4++) {
        var newStyle_1: StyleRange = newStyles[i_4];
        var style: StyleRange;
        var newStart_1: int = newStyle_1.start;
        var newEnd_1: int = newStart_1 + newStyle_1.length;
        if (newStart_1 == newEnd_1)
          continue;
        var modifyLast_1: int = 0;
        var mergeCount_1: int = 0;
        while (modifyEnd_1 < styleCount) {
          if (newStart_1 >= styles[modifyStart_1].start + styles[modifyStart_1].length)
            modifyStart_1++;
          if (styles[modifyEnd_1].start + styles[modifyEnd_1].length > newEnd_1)
            break;
          modifyEnd_1++;
        }
        style = styles[modifyStart_1];
        if (style.start < newStart_1 && newStart_1 < style.start + style.length) {
          style = mergeStyles_1[mergeCount_1++] = StyleRange(style.clone__());
          style.length = newStart_1 - style.start;
        }
        mergeStyles_1[mergeCount_1++] = newStyle_1;
        if (modifyEnd_1 < styleCount) {
          style = styles[modifyEnd_1];
          if (style.start < newEnd_1 && newEnd_1 < style.start + style.length) {
            style = mergeStyles_1[mergeCount_1++] = StyleRange(style.clone__());
            style.length += style.start - newEnd_1;
            style.start = newEnd_1;
            modifyLast_1 = 1;
          }
        }
        var grow_1: int = this.addMerge___3Lorg_eclipse_swt_custom_StyleRange_2III(mergeStyles_1, mergeCount_1, modifyStart_1, modifyEnd_1 + modifyLast_1);
        modifyStart_1 = modifyEnd_1 += grow_1;
      }
    }
    return;
  }
  public function textChanging__Lorg_eclipse_swt_custom_TextChangingEvent_2(event: TextChangingEvent): void {
    var start: int = event.start;
    var newCharCount: int = event.newCharCount;
    var replaceCharCount: int = event.replaceCharCount;
    var newLineCount: int = event.newLineCount;
    var replaceLineCount: int = event.replaceLineCount;
    this.updateRanges__III(start, replaceCharCount, newCharCount);
    var startLine: int = content.getLineAtOffset__I(start);
    if (replaceCharCount == content.getCharCount__())
      lines = null;
    if (replaceLineCount == lineCount) {
      lineCount = newLineCount;
      lineWidth = new JavaArray("[I").lengths(lineCount);
      lineHeight = new JavaArray("[I").lengths(lineCount);
      this.reset__II(0, lineCount);
    } else {
      var delta: int = newLineCount - replaceLineCount;
      if (lineCount + delta > lineWidth.length) {
        var newWidths: JavaArray = new JavaArray("[I").lengths(lineCount + delta + 32);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lineWidth, 0, newWidths, 0, lineCount);
        lineWidth = newWidths;
        var newHeights: JavaArray = new JavaArray("[I").lengths(lineCount + delta + 32);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lineHeight, 0, newHeights, 0, lineCount);
        lineHeight = newHeights;
      }
      if (lines !== null) {
        if (lineCount + delta > lines.length) {
          var newLines: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyledTextRenderer$LineInfo;").lengths(lineCount + delta + 32);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines, 0, newLines, 0, lineCount);
          lines = newLines;
        }
      }
      var startIndex: int = startLine + replaceLineCount + 1;
      var endIndex: int = startLine + newLineCount + 1;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lineWidth, startIndex, lineWidth, endIndex, lineCount - startIndex);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lineHeight, startIndex, lineHeight, endIndex, lineCount - startIndex);
      for (var i: int = startLine; i < endIndex; i++) {
        lineWidth[i] = lineHeight[i] = -1;
      }
      for (var i_1: int = lineCount + delta; i_1 < lineCount; i_1++) {
        lineWidth[i_1] = lineHeight[i_1] = -1;
      }
      if (layouts !== null) {
        var layoutStartLine: int = startLine - topIndex;
        var layoutEndLine: int = layoutStartLine + replaceLineCount + 1;
        for (var i_2: int = layoutStartLine; i_2 < layoutEndLine; i_2++) {
          if (0 <= i_2 && i_2 < layouts.length) {
            if (layouts[i_2] !== null)
              layouts[i_2].dispose__();
            layouts[i_2] = null;
            if (bullets !== null && bulletsIndices !== null)
              bullets[i_2] = null;
          }
        }
        if (delta > 0) {
          for (var i_3: int = layouts.length - 1; i_3 >= layoutEndLine; i_3--) {
            if (0 <= i_3 && i_3 < layouts.length) {
              endIndex = i_3 + delta;
              if (0 <= endIndex && endIndex < layouts.length) {
                layouts[endIndex] = layouts[i_3];
                layouts[i_3] = null;
                if (bullets !== null && bulletsIndices !== null) {
                  bullets[endIndex] = bullets[i_3];
                  bulletsIndices[endIndex] = bulletsIndices[i_3];
                  bullets[i_3] = null;
                }
              } else {
                if (layouts[i_3] !== null)
                  layouts[i_3].dispose__();
                layouts[i_3] = null;
                if (bullets !== null && bulletsIndices !== null)
                  bullets[i_3] = null;
              }
            }
          }
        } else if (delta < 0) {
          for (var i_4: int = layoutEndLine; i_4 < layouts.length; i_4++) {
            if (0 <= i_4 && i_4 < layouts.length) {
              endIndex = i_4 + delta;
              if (0 <= endIndex && endIndex < layouts.length) {
                layouts[endIndex] = layouts[i_4];
                layouts[i_4] = null;
                if (bullets !== null && bulletsIndices !== null) {
                  bullets[endIndex] = bullets[i_4];
                  bulletsIndices[endIndex] = bulletsIndices[i_4];
                  bullets[i_4] = null;
                }
              } else {
                if (layouts[i_4] !== null)
                  layouts[i_4].dispose__();
                layouts[i_4] = null;
                if (bullets !== null && bulletsIndices !== null)
                  bullets[i_4] = null;
              }
            }
          }
        }
      }
      if (replaceLineCount != 0 || newLineCount != 0) {
        var startLineOffset: int = content.getOffsetAtLine__I(startLine);
        if (startLineOffset != start)
          startLine++;
        this.updateBullets__IIIZ(startLine, replaceLineCount, newLineCount, true);
        if (lines !== null) {
          startIndex = startLine + replaceLineCount;
          endIndex = startLine + newLineCount;
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines, startIndex, lines, endIndex, lineCount - startIndex);
          for (var i_5: int = startLine; i_5 < endIndex; i_5++) {
            lines[i_5] = null;
          }
          for (var i_6: int = lineCount + delta; i_6 < lineCount; i_6++) {
            lines[i_6] = null;
          }
        }
      }
      lineCount += delta;
      if (maxWidthLineIndex != -1 && startLine <= maxWidthLineIndex && maxWidthLineIndex <= startLine + replaceLineCount) {
        maxWidth = 0;
        maxWidthLineIndex = -1;
        for (var i_7: int = 0; i_7 < lineCount; i_7++) {
          if (lineWidth[i_7] > maxWidth) {
            maxWidth = lineWidth[i_7];
            maxWidthLineIndex = i_7;
          }
        }
      }
    }
    return;
  }
  public function updateBullets__IIIZ(startLine: int, replaceLineCount: int, newLineCount: int, update: Boolean): void {
    if (bullets === null)
      return;
    if (bulletsIndices !== null)
      return;
    for (var i: int = 0; i < bullets.length; i++) {
      var bullet: Bullet = bullets[i];
      var lines_1: JavaArray = bullet.removeIndices__IIIZ(startLine, replaceLineCount, newLineCount, update);
      if (lines_1 !== null) {
        if (redrawLines === null) {
          redrawLines = lines_1;
        } else {
          var newRedrawBullets: JavaArray = new JavaArray("[I").lengths(redrawLines.length + lines_1.length);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(redrawLines, 0, newRedrawBullets, 0, redrawLines.length);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(lines_1, 0, newRedrawBullets, redrawLines.length, lines_1.length);
          redrawLines = newRedrawBullets;
        }
      }
    }
    var removed: int = 0;
    for (var i_1: int = 0; i_1 < bullets.length; i_1++) {
      if (bullets[i_1].size__() == 0)
        removed++;
    }
    if (removed > 0) {
      if (removed == bullets.length) {
        bullets = null;
      } else {
        var newBulletsList: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/Bullet;").lengths(bullets.length - removed);
        for (var i_2: int = 0, j: int = 0; i_2 < bullets.length; i_2++) {
          var bullet_1: Bullet = bullets[i_2];
          if (bullet_1.size__() > 0)
            newBulletsList[j++] = bullet_1;
        }
        bullets = newBulletsList;
      }
    }
    return;
  }
  public function updateRanges__III(start: int, replaceCharCount: int, newCharCount: int): void {
    if (styleCount == 0 || (replaceCharCount == 0 && newCharCount == 0))
      return;
    if (ranges !== null) {
      var rangeCount: int = styleCount << 1;
      var modifyStart: int = this.getRangeIndex__III(start, -1, rangeCount);
      if (modifyStart == rangeCount)
        return;
      var end: int = start + replaceCharCount;
      var modifyEnd: int = this.getRangeIndex__III(end, modifyStart - 1, rangeCount);
      var offset: int = newCharCount - replaceCharCount;
      if (modifyStart == modifyEnd && ranges[modifyStart] < start && end < ranges[modifyEnd] + ranges[modifyEnd + 1]) {
        if (newCharCount == 0) {
          ranges[modifyStart + 1] -= replaceCharCount;
          modifyEnd += 2;
        } else {
          if (rangeCount + 2 > ranges.length) {
            var newRanges: JavaArray = new JavaArray("[I").lengths(ranges.length + (32 << 1));
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, 0, newRanges, 0, rangeCount);
            ranges = newRanges;
            var newStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.length + 32);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, newStyles, 0, styleCount);
            styles = newStyles;
          }
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, modifyStart + 2, ranges, modifyStart + 4, rangeCount - (modifyStart + 2));
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, (modifyStart + 2) >> 1, styles, (modifyStart + 4) >> 1, styleCount - ((modifyStart + 2) >> 1));
          ranges[modifyStart + 3] = ranges[modifyStart] + ranges[modifyStart + 1] - end;
          ranges[modifyStart + 2] = start + newCharCount;
          ranges[modifyStart + 1] = start - ranges[modifyStart];
          styles[(modifyStart >> 1) + 1] = styles[modifyStart >> 1];
          rangeCount += 2;
          styleCount++;
          modifyEnd += 4;
        }
        if (offset != 0) {
          for (var i: int = modifyEnd; i < rangeCount; i += 2) {
            ranges[i] += offset;
          }
        }
      } else {
        if (ranges[modifyStart] < start && start < ranges[modifyStart] + ranges[modifyStart + 1]) {
          ranges[modifyStart + 1] = start - ranges[modifyStart];
          modifyStart += 2;
        }
        if (modifyEnd < rangeCount && ranges[modifyEnd] < end && end < ranges[modifyEnd] + ranges[modifyEnd + 1]) {
          ranges[modifyEnd + 1] = ranges[modifyEnd] + ranges[modifyEnd + 1] - end;
          ranges[modifyEnd] = end;
        }
        if (offset != 0) {
          for (var i_1: int = modifyEnd; i_1 < rangeCount; i_1 += 2) {
            ranges[i_1] += offset;
          }
        }
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ranges, modifyEnd, ranges, modifyStart, rangeCount - modifyEnd);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd >> 1, styles, modifyStart >> 1, styleCount - (modifyEnd >> 1));
        styleCount -= (modifyEnd - modifyStart) >> 1;
      }
    } else {
      var modifyStart_1: int = this.getRangeIndex__III(start, -1, styleCount);
      if (modifyStart_1 == styleCount)
        return;
      var end_1: int = start + replaceCharCount;
      var modifyEnd_1: int = this.getRangeIndex__III(end_1, modifyStart_1 - 1, styleCount);
      var offset_1: int = newCharCount - replaceCharCount;
      if (modifyStart_1 == modifyEnd_1 && styles[modifyStart_1].start < start && end_1 < styles[modifyEnd_1].start + styles[modifyEnd_1].length) {
        if (newCharCount == 0) {
          styles[modifyStart_1].length -= replaceCharCount;
          modifyEnd_1++;
        } else {
          if (styleCount + 1 > styles.length) {
            var newStyles_1: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.length + 32);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, newStyles_1, 0, styleCount);
            styles = newStyles_1;
          }
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyStart_1 + 1, styles, modifyStart_1 + 2, styleCount - (modifyStart_1 + 1));
          styles[modifyStart_1 + 1] = StyleRange(styles[modifyStart_1].clone__());
          styles[modifyStart_1 + 1].length = styles[modifyStart_1].start + styles[modifyStart_1].length - end_1;
          styles[modifyStart_1 + 1].start = start + newCharCount;
          styles[modifyStart_1].length = start - styles[modifyStart_1].start;
          styleCount++;
          modifyEnd_1 += 2;
        }
        if (offset_1 != 0) {
          for (var i_2: int = modifyEnd_1; i_2 < styleCount; i_2++) {
            styles[i_2].start += offset_1;
          }
        }
      } else {
        if (styles[modifyStart_1].start < start && start < styles[modifyStart_1].start + styles[modifyStart_1].length) {
          styles[modifyStart_1].length = start - styles[modifyStart_1].start;
          modifyStart_1++;
        }
        if (modifyEnd_1 < styleCount && styles[modifyEnd_1].start < end_1 && end_1 < styles[modifyEnd_1].start + styles[modifyEnd_1].length) {
          styles[modifyEnd_1].length = styles[modifyEnd_1].start + styles[modifyEnd_1].length - end_1;
          styles[modifyEnd_1].start = end_1;
        }
        if (offset_1 != 0) {
          for (var i_3: int = modifyEnd_1; i_3 < styleCount; i_3++) {
            styles[i_3].start += offset_1;
          }
        }
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd_1, styles, modifyStart_1, styleCount - modifyEnd_1);
        styleCount -= modifyEnd_1 - modifyStart_1;
      }
    }
    return;
  }
}
}
