package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TypedListener;
import java.lang.Math__;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TableCursor extends Canvas {
  internal var table: Table;
  internal var row: TableItem = null;
  internal var column: TableColumn = null;
  internal var listener: Listener;
  internal var tableListener: Listener;
  internal var resizeListener: Listener;
  internal var disposeItemListener: Listener;
  internal var disposeColumnListener: Listener;
  internal var background: Color = null;
  internal var foreground: Color = null;
  public static const BACKGROUND: int = 27;
  public static const FOREGROUND: int = 26;
  public function TableCursor(parent: Table, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    table = parent;
    this.setBackground__Lorg_eclipse_swt_graphics_Color_2(null);
    this.setForeground__Lorg_eclipse_swt_graphics_Color_2(null);
    listener = new org.eclipse.swt.custom.TableCursor$1(this);
    var events: JavaArray = new JavaArray("[I").values(12, 15, 16, 1, 9, 31);
    for (var i: int = 0; i < events.length; i++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(events[i], listener);
    }
    tableListener = new org.eclipse.swt.custom.TableCursor$2(this);
    table.addListener__ILorg_eclipse_swt_widgets_Listener_2(15, tableListener);
    table.addListener__ILorg_eclipse_swt_widgets_Listener_2(3, tableListener);
    disposeItemListener = new org.eclipse.swt.custom.TableCursor$3(this);
    disposeColumnListener = new org.eclipse.swt.custom.TableCursor$4(this);
    resizeListener = new org.eclipse.swt.custom.TableCursor$5(this);
    var hBar: ScrollBar = table.getHorizontalBar__();
    if (hBar !== null) {
      hBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, resizeListener);
    }
    var vBar: ScrollBar = table.getVerticalBar__();
    if (vBar !== null) {
      vBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, resizeListener);
    }
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    table.removeListener__ILorg_eclipse_swt_widgets_Listener_2(15, tableListener);
    table.removeListener__ILorg_eclipse_swt_widgets_Listener_2(3, tableListener);
    this.unhookRowColumnListeners__();
    var hBar: ScrollBar = table.getHorizontalBar__();
    if (hBar !== null) {
      hBar.removeListener__ILorg_eclipse_swt_widgets_Listener_2(13, resizeListener);
    }
    var vBar: ScrollBar = table.getVerticalBar__();
    if (vBar !== null) {
      vBar.removeListener__ILorg_eclipse_swt_widgets_Listener_2(13, resizeListener);
    }
    return;
  }
  public function keyDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (row === null)
      return;
    switch (event.character) {
      case 13 :
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(14, new Event());
        return;
    }
    var rowIndex: int = table.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(row);
    var columnIndex: int = column === null ? 0 : table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column);
    switch (event.keyCode) {
      case 16777217 :
        this.setRowColumn__IIZ(Math__.max__II(0, rowIndex - 1), columnIndex, true);
        break;
      case 16777218 :
        this.setRowColumn__IIZ(Math__.min__II(rowIndex + 1, table.getItemCount__() - 1), columnIndex, true);
        break;
      case 16777219 :
      case 16777220 :
        {
          var columnCount: int = table.getColumnCount__();
          if (columnCount == 0)
            break;
          var order: JavaArray = table.getColumnOrder__();
          var index: int = 0;
          while (index < order.length) {
            if (order[index] == columnIndex)
              break;
            index++;
          }
          if (index == order.length)
            index = 0;
          var leadKey: int = (this.getStyle__() & 67108864) != 0 ? 16777220 : 16777219;
          if (event.keyCode == leadKey) {
            this.setRowColumn__IIZ(rowIndex, order[Math__.max__II(0, index - 1)], true);
          } else {
            this.setRowColumn__IIZ(rowIndex, order[Math__.min__II(columnCount - 1, index + 1)], true);
          }
          break;
        }
      case 16777223 :
        this.setRowColumn__IIZ(0, columnIndex, true);
        break;
      case 16777224 :
        {
          var i: int = table.getItemCount__() - 1;
          this.setRowColumn__IIZ(i, columnIndex, true);
          break;
        }
      case 16777221 :
        {
          var index_1: int = table.getTopIndex__();
          if (index_1 == rowIndex) {
            var rect: Rectangle = table.getClientArea__();
            var item: TableItem = table.getItem__I(index_1);
            var itemRect: Rectangle = item.getBounds__I(0);
            rect.height -= itemRect.y;
            var height_1: int = table.getItemHeight__();
            var page: int = Math__.max__II(1, int(rect.height / height_1));
            index_1 = Math__.max__II(0, index_1 - page + 1);
          }
          this.setRowColumn__IIZ(index_1, columnIndex, true);
          break;
        }
      case 16777222 :
        {
          var index_2: int = table.getTopIndex__();
          var rect_1: Rectangle = table.getClientArea__();
          var item_1: TableItem = table.getItem__I(index_2);
          var itemRect_1: Rectangle = item_1.getBounds__I(0);
          rect_1.height -= itemRect_1.y;
          var height_2: int = table.getItemHeight__();
          var page_1: int = Math__.max__II(1, int(rect_1.height / height_2));
          var end: int = table.getItemCount__() - 1;
          index_2 = Math__.min__II(end, index_2 + page_1 - 1);
          if (index_2 == rowIndex) {
            index_2 = Math__.min__II(end, index_2 + page_1 - 1);
          }
          this.setRowColumn__IIZ(index_2, columnIndex, true);
          break;
        }
    }
    return;
  }
  public function paint__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (row === null)
      return;
    var columnIndex: int = column === null ? 0 : table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column);
    var gc: GC = event.gc;
    var display_1: Display = this.getDisplay__();
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getForeground__());
    gc.fillRectangle__IIII(event.x, event.y, event.width, event.height);
    var x_1: int = 0;
    var size: Point = this.getSize__();
    var image: Image = row.getImage__I(columnIndex);
    if (image !== null) {
      var imageSize: Rectangle = image.getBounds__();
      var imageY: int = int((size.y - imageSize.height) / 2);
      gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(image, x_1, imageY);
      x_1 += imageSize.width;
    }
    var text: String = row.getText__I(columnIndex);
    if (Object(text).length__() > 0) {
      var bounds: Rectangle = row.getBounds__I(columnIndex);
      var extent: Point = gc.stringExtent__Ljava_lang_String_2(text);
      var platform: String = SWT.getPlatform__();
      if (Object("win32").equals__Ljava_lang_Object_2(platform)) {
        if (table.getColumnCount__() == 0 || columnIndex == 0) {
          x_1 += 2;
        } else {
          var alignmnent: int = column.getAlignment__();
          switch (alignmnent) {
            case 16384 :
              x_1 += 6;
              break;
            case 131072 :
              x_1 = bounds.width - extent.x - 6;
              break;
            case 16777216 :
              x_1 += int((bounds.width - x_1 - extent.x) / 2);
              break;
          }
        }
      } else {
        if (table.getColumnCount__() == 0) {
          x_1 += 5;
        } else {
          var alignmnent_1: int = column.getAlignment__();
          switch (alignmnent_1) {
            case 16384 :
              x_1 += 5;
              break;
            case 131072 :
              x_1 = bounds.width - extent.x - 2;
              break;
            case 16777216 :
              x_1 += int((bounds.width - x_1 - extent.x) / 2) + 2;
              break;
          }
        }
      }
      var textY: int = int((size.y - extent.y) / 2);
      gc.drawString__Ljava_lang_String_2II(text, x_1, textY);
    }
    if (this.isFocusControl__()) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(2));
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(display_1.getSystemColor__I(1));
      gc.drawFocus__IIII(0, 0, size.x, size.y);
    }
    return;
  }
  public function tableFocusIn__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (this.isDisposed__())
      return;
    if (this.isVisible__()) {
      if (row === null && column === null)
        return;
      this.setFocus__();
    }
    return;
  }
  public function tableMouseDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    if (this.isDisposed__() || !this.isVisible__())
      return;
    var pt: Point = new Point(event.x, event.y);
    var lineWidth: int = table.getLinesVisible__() ? table.getGridLineWidth__() : 0;
    var item: TableItem = table.getItem__Lorg_eclipse_swt_graphics_Point_2(pt);
    if ((table.getStyle__() & 65536) != 0) {
      if (item === null)
        return;
    } else {
      var start: int = item !== null ? table.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(item) : table.getTopIndex__();
      var end: int = table.getItemCount__();
      var clientRect: Rectangle = table.getClientArea__();
      for (var i: int = start; i < end; i++) {
        var nextItem: TableItem = table.getItem__I(i);
        var rect: Rectangle = nextItem.getBounds__I(0);
        if (pt.y >= rect.y && pt.y < rect.y + rect.height + lineWidth) {
          item = nextItem;
          break;
        }
        if (rect.y > clientRect.y + clientRect.height)
          return;
      }
      if (item === null)
        return;
    }
    var newColumn: TableColumn = null;
    var columnCount: int = table.getColumnCount__();
    if (columnCount == 0) {
      if ((table.getStyle__() & 65536) == 0) {
        var rect_1: Rectangle = item.getBounds__I(0);
        rect_1.width += lineWidth;
        rect_1.height += lineWidth;
        if (!rect_1.contains__Lorg_eclipse_swt_graphics_Point_2(pt))
          return;
      }
    } else {
      for (var i_1: int = 0; i_1 < columnCount; i_1++) {
        var rect_2: Rectangle = item.getBounds__I(i_1);
        rect_2.width += lineWidth;
        rect_2.height += lineWidth;
        if (rect_2.contains__Lorg_eclipse_swt_graphics_Point_2(pt)) {
          newColumn = table.getColumn__I(i_1);
          break;
        }
      }
      if (newColumn === null) {
        if ((table.getStyle__() & 65536) == 0)
          return;
        newColumn = table.getColumn__I(0);
      }
    }
    this.setRowColumn__Lorg_eclipse_swt_widgets_TableItem_2Lorg_eclipse_swt_widgets_TableColumn_2Z(item, newColumn, true);
    this.setFocus__();
    return;
  }
  public function setRowColumn__IIZ(row_1: int, column_1: int, notify: Boolean): void {
    var item: TableItem = row_1 == -1 ? null : table.getItem__I(row_1);
    var col: TableColumn = column_1 == -1 || table.getColumnCount__() == 0 ? null : table.getColumn__I(column_1);
    this.setRowColumn__Lorg_eclipse_swt_widgets_TableItem_2Lorg_eclipse_swt_widgets_TableColumn_2Z(item, col, notify);
  }
  public function setRowColumn__Lorg_eclipse_swt_widgets_TableItem_2Lorg_eclipse_swt_widgets_TableColumn_2Z(row_1: TableItem, column_1: TableColumn, notify: Boolean): void {
    if (this.row === row_1 && this.column === column_1) {
      return;
    }
    if (this.row !== null && this.row !== row_1) {
      this.row.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeItemListener);
      this.row = null;
    }
    if (this.column !== null && this.column !== column_1) {
      this.column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeColumnListener);
      this.column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(10, resizeListener);
      this.column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(11, resizeListener);
      this.column = null;
    }
    if (row_1 !== null) {
      if (this.row !== row_1) {
        this.row = row_1;
        row_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeItemListener);
        table.showItem__Lorg_eclipse_swt_widgets_TableItem_2(row_1);
      }
      if (this.column !== column_1 && column_1 !== null) {
        this.column = column_1;
        column_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeColumnListener);
        column_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(10, resizeListener);
        column_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, resizeListener);
        table.showColumn__Lorg_eclipse_swt_widgets_TableColumn_2(column_1);
      }
      var columnIndex: int = column_1 === null ? 0 : table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column_1);
      this.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(row_1.getBounds__I(columnIndex));
      this.redraw__();
      if (notify) {
        this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, new Event());
      }
    }
    return;
  }
  public override function setVisible__Z(visible: Boolean): void {
    this.checkWidget__();
    if (visible)
      this._resize__();
    super.setVisible__Z(visible);
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null) {
      SWT.error__I(4);
    }
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener_1);
    return;
  }
  public function _resize__(): void {
    if (row === null) {
      this.setBounds__IIII(-200, -200, 0, 0);
    } else {
      var columnIndex: int = column === null ? 0 : table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column);
      this.setBounds__Lorg_eclipse_swt_graphics_Rectangle_2(row.getBounds__I(columnIndex));
    }
    return;
  }
  public function getColumn__(): int {
    this.checkWidget__();
    return column === null ? 0 : table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column);
  }
  public override function getBackground__(): Color {
    this.checkWidget__();
    if (background === null) {
      return this.getDisplay__().getSystemColor__I(27);
    }
    return background;
  }
  public override function getForeground__(): Color {
    this.checkWidget__();
    if (foreground === null) {
      return this.getDisplay__().getSystemColor__I(26);
    }
    return foreground;
  }
  public function getRow__(): TableItem {
    this.checkWidget__();
    return row;
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    background = color;
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
    this.redraw__();
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    foreground = color;
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getForeground__());
    this.redraw__();
  }
  public function setSelection__II(row_1: int, column_1: int): void {
    this.checkWidget__();
    var columnCount: int = table.getColumnCount__();
    var maxColumnIndex: int = columnCount == 0 ? 0 : columnCount - 1;
    if (row_1 < 0 || row_1 >= table.getItemCount__() || column_1 < 0 || column_1 > maxColumnIndex)
      SWT.error__I(5);
    this.setRowColumn__IIZ(row_1, column_1, false);
  }
  public function setSelection__Lorg_eclipse_swt_widgets_TableItem_2I(row_1: TableItem, column_1: int): void {
    this.checkWidget__();
    var columnCount: int = table.getColumnCount__();
    var maxColumnIndex: int = columnCount == 0 ? 0 : columnCount - 1;
    if (row_1 === null || row_1.isDisposed__() || column_1 < 0 || column_1 > maxColumnIndex)
      SWT.error__I(5);
    this.setRowColumn__IIZ(table.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(row_1), column_1, false);
  }
  public function unhookRowColumnListeners__(): void {
    if (column !== null) {
      column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeColumnListener);
      column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(10, resizeListener);
      column.removeListener__ILorg_eclipse_swt_widgets_Listener_2(11, resizeListener);
      column = null;
    }
    if (row !== null) {
      row.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, disposeItemListener);
      row = null;
    }
    return;
  }
}
}
