package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.SWT;
import java.lang.System;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import java.lang.Math__;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Menu;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TableTree extends Composite {
  internal var table: Table;
  internal var items: JavaArray = EMPTY_ITEMS;
  internal var plusImage: Image;
  internal var minusImage: Image;
  internal var sizeImage: Image;
  internal var listener: Listener;
  internal var inDispose: Boolean = false;
  public static var EMPTY_ITEMS: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(0);
  public static var EMPTY_TEXTS: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(0);
  public static var EMPTY_IMAGES: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Image;").lengths(0);
  public static const ITEMID: String = "TableTreeItemID";
  public function TableTree(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, TableTree.checkStyle__I(style)]));
    table = new Table(this, style);
    var tableListener: Listener = new org.eclipse.swt.custom.TableTree$1(this);
    var tableEvents: JavaArray = new JavaArray("[I").values(3, 13, 14, 1);
    for (var i: int = 0; i < tableEvents.length; i++) {
      table.addListener__ILorg_eclipse_swt_widgets_Listener_2(tableEvents[i], tableListener);
    }
    listener = new org.eclipse.swt.custom.TableTree$2(this);
    var events: JavaArray = new JavaArray("[I").values(12, 11, 15);
    for (var i_1: int = 0; i_1 < events.length; i_1++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(events[i_1], listener);
    }
    return;
  }
  public function addItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(item: TableTreeItem, index: int): int {
    if (index < 0 || index > items.length)
      SWT.error__I(5);
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    newItems[index] = item;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index, newItems, index + 1, items.length - index);
    items = newItems;
    if (index == items.length - 1)
      return table.getItemCount__();
    else
      return table.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(items[index + 1].tableItem);
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
  }
  public function addTreeListener__Lorg_eclipse_swt_events_TreeListener_2(listener_1: TreeListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener_1);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(17, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(18, typedListener);
  }
  private static function checkStyle__I(style: int): int {
    var mask: int = 33554432 | 67108864;
    style = style & mask;
    return style;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return table.computeSize__IIZ(wHint, hHint, changed);
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    return table.computeTrim__IIII(x_1, y_1, width_1, height_1);
  }
  public function deselectAll__(): void {
    this.checkWidget__();
    table.deselectAll__();
  }
  public function expandItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): void {
    if (item === null)
      return;
    this.expandItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item.parentItem);
    if (!item.getVisible__())
      item.setVisible__Z(true);
    if (!item.expanded && item.items.length > 0) {
      item.setExpanded__Z(true);
      var event: Event = new Event();
      event.item = item;
      this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(17, event);
    }
    return;
  }
  public override function getBackground__(): Color {
    return table.getBackground__();
  }
  public override function getClientArea__(): Rectangle {
    return table.getClientArea__();
  }
  public override function getForeground__(): Color {
    return table.getForeground__();
  }
  public override function getFont__(): Font {
    return table.getFont__();
  }
  public function getItemCount__(): int {
    return items.length;
  }
  public function getItemHeight__(): int {
    this.checkWidget__();
    return table.getItemHeight__();
  }
  public function getItems__(): JavaArray {
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, items.length);
    return newItems;
  }
  public function getSelection__(): JavaArray {
    this.checkWidget__();
    var selection: JavaArray = table.getSelection__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(selection.length);
    for (var i: int = 0; i < selection.length; i++) {
      result[i] = TableTreeItem(selection[i].getData__Ljava_lang_String_2("TableTreeItemID"));
    }
    return result;
  }
  public function getSelectionCount__(): int {
    this.checkWidget__();
    return table.getSelectionCount__();
  }
  public override function getStyle__(): int {
    this.checkWidget__();
    return table.getStyle__();
  }
  public function getTable__(): Table {
    return table;
  }
  public function createImages__(): void {
    var itemHeight: int = sizeImage.getBounds__().height;
    var indent: int = Math__.min__II(6, int((itemHeight - 9) / 2));
    indent = Math__.max__II(0, indent);
    var size: int = Math__.max__II(10, itemHeight - 2 * indent);
    size = (int((size + 1) / 2)) * 2;
    var midpoint: int = indent + int(size / 2);
    var foreground_1: Color = this.getForeground__();
    var plusMinus: Color = this.getDisplay__().getSystemColor__I(18);
    var background_1: Color = this.getBackground__();
    var palette: PaletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(foreground_1.getRGB__(), background_1.getRGB__(), plusMinus.getRGB__())]));
    var imageData: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [itemHeight, itemHeight, 4, palette]));
    imageData.transparentPixel = 1;
    plusImage = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [this.getDisplay__(), imageData]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [plusImage]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background_1);
    gc.fillRectangle__IIII(0, 0, itemHeight, itemHeight);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(plusMinus);
    gc.drawRectangle__IIII(indent, indent, size, size);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground_1);
    gc.drawLine__IIII(midpoint, indent + 2, midpoint, indent + size - 2);
    gc.drawLine__IIII(indent + 2, midpoint, indent + size - 2, midpoint);
    gc.dispose__();
    palette = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(foreground_1.getRGB__(), background_1.getRGB__(), plusMinus.getRGB__())]));
    imageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [itemHeight, itemHeight, 4, palette]));
    imageData.transparentPixel = 1;
    minusImage = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [this.getDisplay__(), imageData]));
    gc = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [minusImage]));
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background_1);
    gc.fillRectangle__IIII(0, 0, itemHeight, itemHeight);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(plusMinus);
    gc.drawRectangle__IIII(indent, indent, size, size);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground_1);
    gc.drawLine__IIII(indent + 2, midpoint, indent + size - 2, midpoint);
    gc.dispose__();
  }
  public function getPlusImage__(): Image {
    if (plusImage === null)
      this.createImages__();
    return plusImage;
  }
  public function getMinusImage__(): Image {
    if (minusImage === null)
      this.createImages__();
    return minusImage;
  }
  public function indexOf__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): int {
    for (var i: int = 0; i < items.length; i++) {
      if (item === items[i])
        return i;
    }
    return -1;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, e);
    e.type = 0;
    inDispose = true;
    for (var i: int = 0; i < items.length; i++) {
      items[i].dispose__();
    }
    inDispose = false;
    if (plusImage !== null)
      plusImage.dispose__();
    if (minusImage !== null)
      minusImage.dispose__();
    if (sizeImage !== null)
      sizeImage.dispose__();
    plusImage = minusImage = sizeImage = null;
    return;
  }
  public function onResize__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    var size: Point = this.getSize__();
    table.setBounds__IIII(0, 0, size.x, size.y);
    return;
  }
  public function onSelection__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    var event: Event = new Event();
    var tableItem: TableItem = TableItem(e.item);
    var item: TableTreeItem = this.getItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem);
    event.item = item;
    if (e.type == 13 && e.detail == 32 && item !== null) {
      event.detail = 32;
      item.checked = tableItem.getChecked__();
    }
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(e.type, event);
    return;
  }
  public function getItem__I(index: int): TableTreeItem {
    this.checkWidget__();
    var count: int = items.length;
    if (!(0 <= index && index < count))
      SWT.error__I(6);
    return items[index];
  }
  public function getItem__Lorg_eclipse_swt_graphics_Point_2(point: Point): TableTreeItem {
    this.checkWidget__();
    var item: TableItem = table.getItem__Lorg_eclipse_swt_graphics_Point_2(point);
    if (item === null)
      return null;
    return this.getItem__Lorg_eclipse_swt_widgets_TableItem_2(item);
  }
  public function getItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem: TableItem): TableTreeItem {
    if (tableItem === null)
      return null;
    for (var i: int = 0; i < items.length; i++) {
      var item: TableTreeItem = items[i].getItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem);
      if (item !== null)
        return item;
    }
    return null;
  }
  public function onFocusIn__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    table.setFocus__();
  }
  public function onKeyDown__Lorg_eclipse_swt_widgets_Event_2(e: Event): void {
    var selection: JavaArray = this.getSelection__();
    if (selection.length == 0)
      return;
    var item: TableTreeItem = selection[0];
    var type: int = 0;
    if (e.keyCode == 16777220 || e.keyCode == 16777219) {
      var trailKey: int = (this.getStyle__() & 134217728) != 0 ? 16777219 : 16777220;
      if (e.keyCode == trailKey) {
        if (item.getItemCount__() == 0)
          return;
        if (item.getExpanded__()) {
          var newSelection: TableTreeItem = item.getItems__()[0];
          table.setSelection___3Lorg_eclipse_swt_widgets_TableItem_2(new JavaArray("[Lorg/eclipse/swt/widgets/TableItem;").values(newSelection.tableItem));
          this.showItem__Lorg_eclipse_swt_custom_TableTreeItem_2(newSelection);
          type = 13;
        } else {
          item.setExpanded__Z(true);
          type = 17;
        }
      } else {
        if (item.getExpanded__()) {
          item.setExpanded__Z(false);
          type = 18;
        } else {
          var parent_1: TableTreeItem = item.getParentItem__();
          if (parent_1 !== null) {
            var index: int = parent_1.indexOf__Lorg_eclipse_swt_custom_TableTreeItem_2(item);
            if (index != 0)
              return;
            table.setSelection___3Lorg_eclipse_swt_widgets_TableItem_2(new JavaArray("[Lorg/eclipse/swt/widgets/TableItem;").values(parent_1.tableItem));
            type = 13;
          }
        }
      }
    }
    if (e.character == 42) {
      item.expandAll__Z(true);
    }
    if (e.character == 45) {
      if (item.getExpanded__()) {
        item.setExpanded__Z(false);
        type = 18;
      }
    }
    if (e.character == 43) {
      if (item.getItemCount__() > 0 && !item.getExpanded__()) {
        item.setExpanded__Z(true);
        type = 17;
      }
    }
    if (type == 0)
      return;
    var event: Event = new Event();
    event.item = item;
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(type, event);
  }
  public function onMouseDown__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var items_1: JavaArray = table.getItems__();
    for (var i: int = 0; i < items_1.length; i++) {
      var rect: Rectangle = items_1[i].getImageBounds__I(0);
      if (rect.contains__II(event.x, event.y)) {
        var item: TableTreeItem = TableTreeItem(items_1[i].getData__Ljava_lang_String_2("TableTreeItemID"));
        event = new Event();
        event.item = item;
        item.setExpanded__Z(!item.getExpanded__());
        if (item.getExpanded__()) {
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(17, event);
        } else {
          this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(18, event);
        }
        return;
      }
    }
    return;
  }
  public function removeAll__(): void {
    this.checkWidget__();
    this.setRedraw__Z(false);
    for (var i: int = items.length - 1; i >= 0; i--) {
      items[i].dispose__();
    }
    items = EMPTY_ITEMS;
    this.setRedraw__Z(true);
    return;
  }
  public function removeItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): void {
    var index: int = 0;
    while (index < items.length && items[index] !== item)
      index++;
    if (index == items.length)
      return;
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, newItems, index, items.length - index - 1);
    items = newItems;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener_1: SelectionListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener_1);
  }
  public function removeTreeListener__Lorg_eclipse_swt_events_TreeListener_2(listener_1: TreeListener): void {
    this.checkWidget__();
    if (listener_1 === null)
      SWT.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(17, listener_1);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(18, listener_1);
  }
  public function selectAll__(): void {
    this.checkWidget__();
    table.selectAll__();
  }
  public override function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    table.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    if (sizeImage !== null) {
      var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [sizeImage]));
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getBackground__());
      var size: Rectangle = sizeImage.getBounds__();
      gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(size);
      gc.dispose__();
    }
    return;
  }
  public override function setEnabled__Z(enabled: Boolean): void {
    super.setEnabled__Z(enabled);
    table.setEnabled__Z(enabled);
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    table.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    return;
  }
  public override function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    super.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    table.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    return;
  }
  public override function setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1: Menu): void {
    super.setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1);
    table.setMenu__Lorg_eclipse_swt_widgets_Menu_2(menu_1);
    return;
  }
  public function setSelection___3Lorg_eclipse_swt_custom_TableTreeItem_2(items_1: JavaArray): void {
    this.checkWidget__();
    if (items_1 === null)
      SWT.error__I(4);
    var length: int = items_1.length;
    if (length == 0 || ((table.getStyle__() & 4) != 0 && length > 1)) {
      this.deselectAll__();
      return;
    }
    var tableItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TableItem;").lengths(length);
    for (var i: int = 0; i < length; i++) {
      if (items_1[i] === null)
        SWT.error__I(4);
      if (!items_1[i].getVisible__())
        this.expandItem__Lorg_eclipse_swt_custom_TableTreeItem_2(items_1[i]);
      tableItems[i] = items_1[i].tableItem;
    }
    table.setSelection___3Lorg_eclipse_swt_widgets_TableItem_2(tableItems);
    return;
  }
  public override function setToolTipText__Ljava_lang_String_2(string: String): void {
    super.setToolTipText__Ljava_lang_String_2(string);
    table.setToolTipText__Ljava_lang_String_2(string);
    return;
  }
  public function showItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): void {
    this.checkWidget__();
    if (item === null)
      SWT.error__I(4);
    if (!item.getVisible__())
      this.expandItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item);
    var tableItem: TableItem = item.tableItem;
    table.showItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem);
    return;
  }
  public function showSelection__(): void {
    this.checkWidget__();
    table.showSelection__();
    return;
  }
}
}
