package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TreeListener;
import java.lang.Runnable;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Control;
dynamic public class TableTreeEditor extends ControlEditor {
  internal var tableTree: TableTree;
  internal var item: TableTreeItem;
  internal var column: int = -1;
  internal var columnListener: ControlListener;
  internal var treeListener: TreeListener;
  public function TableTreeEditor(tableTree: TableTree) {
    super(tableTree.getTable__());
    this.tableTree = tableTree;
    treeListener = new TableTreeEditor$1(this);
    tableTree.addTreeListener__Lorg_eclipse_swt_events_TreeListener_2(treeListener);
    columnListener = new org.eclipse.swt.custom.TableTreeEditor$2(this);
    grabVertical = true;
    return;
  }
  public override function computeBounds__(): Rectangle {
    if (item === null || column == -1 || item.isDisposed__() || item.tableItem === null)
      return new Rectangle(0, 0, 0, 0);
    var cell: Rectangle = item.getBounds__I(column);
    var area: Rectangle = tableTree.getClientArea__();
    if (cell.x < area.x + area.width) {
      if (cell.x + cell.width > area.x + area.width) {
        cell.width = area.x + area.width - cell.x;
      }
    }
    var editorRect: Rectangle = new Rectangle(cell.x, cell.y, minimumWidth, minimumHeight);
    if (grabHorizontal) {
      editorRect.width = Math__.max__II(cell.width, minimumWidth);
    }
    if (grabVertical) {
      editorRect.height = Math__.max__II(cell.height, minimumHeight);
    }
    if (horizontalAlignment == 131072) {
      editorRect.x += cell.width - editorRect.width;
    } else if (horizontalAlignment == 16384) {
    } else {
      editorRect.x += int((cell.width - editorRect.width) / 2);
    }
    if (verticalAlignment == 1024) {
      editorRect.y += cell.height - editorRect.height;
    } else if (verticalAlignment == 128) {
    } else {
      editorRect.y += int((cell.height - editorRect.height) / 2);
    }
    return editorRect;
  }
  public override function dispose__(): void {
    if (tableTree !== null && !tableTree.isDisposed__()) {
      var table: Table = tableTree.getTable__();
      if (table !== null && !table.isDisposed__()) {
        if (this.column > -1 && this.column < table.getColumnCount__()) {
          var tableColumn: TableColumn = table.getColumn__I(this.column);
          tableColumn.removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
        }
      }
      if (treeListener !== null)
        tableTree.removeTreeListener__Lorg_eclipse_swt_events_TreeListener_2(treeListener);
    }
    treeListener = null;
    columnListener = null;
    tableTree = null;
    item = null;
    column = -1;
    super.dispose__();
    return;
  }
  public function getColumn__(): int {
    return column;
  }
  public function getItem__(): TableTreeItem {
    return item;
  }
  public function setColumn__I(column_1: int): void {
    var table: Table = tableTree.getTable__();
    var columnCount: int = table.getColumnCount__();
    if (columnCount == 0) {
      this.column = (column_1 == 0) ? 0 : -1;
      this.layout__();
      return;
    }
    if (this.column > -1 && this.column < columnCount) {
      var tableColumn: TableColumn = table.getColumn__I(this.column);
      tableColumn.removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
      this.column = -1;
    }
    if (column_1 < 0 || column_1 >= table.getColumnCount__())
      return;
    this.column = column_1;
    var tableColumn_1: TableColumn = table.getColumn__I(this.column);
    tableColumn_1.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
    this.layout__();
  }
  public function setItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item_1: TableTreeItem): void {
    this.item = item_1;
    this.layout__();
  }
  public function setEditor__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_custom_TableTreeItem_2I(editor_1: Control, item_1: TableTreeItem, column_1: int): void {
    this.setItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item_1);
    this.setColumn__I(column_1);
    this.setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1);
  }
  public override function layout__(): void {
    if (tableTree === null || tableTree.isDisposed__())
      return;
    if (item === null || item.isDisposed__())
      return;
    var table: Table = tableTree.getTable__();
    var columnCount: int = table.getColumnCount__();
    if (columnCount == 0 && column != 0)
      return;
    if (columnCount > 0 && (column < 0 || column >= columnCount))
      return;
    super.layout__();
  }
}
}
